/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActAssigneeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(TaskCreateListener.class);
    @Resource
    private BpmMsgPushService msgPushService;
    @Resource
    private DataPushService dataPushService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Resource
    SysActAssigneeMapper sysActAssigneeMapper;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Lazy
    @Resource
    private RepositoryService repositoryService;

    public void onEvent(ActivitiEvent activitiEvent) {
        String taskAssignee;
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String userId = (String)taskEntity.getVariable("startUser");
        if (HussarUtils.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
        String processInstanceId = taskEntity.getProcessInstanceId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            String userIdForDataPush;
            taskAssignee = this.getAssigneeByTaskId(taskEntity);
            String string = userIdForDataPush = HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee;
            if (HussarUtils.isNotEmpty((Object)userIdForDataPush)) {
                taskEntity.removeVariable("startUser");
            }
            DataPush dataPush = this.dataPush(taskEntity, historicProcessInstance);
            dataPush.setUserId(HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee);
            List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
            if (taskAssigneeMap.isEmpty()) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", userIdForDataPush);
                taskAssigneeMap.add(assigneeMap);
            }
            dataPush.setUserMaps(taskAssigneeMap);
            dataPush.setTaskType(taskEntity.getTaskType());
            List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(taskEntity.getId())));
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                dataPush.setCcUrl(((SysActCcTask)ccTasks.get(0)).getFormKey());
            } else {
                List ccFormKeyList;
                Map ccFormKeyMap;
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId());
                List ccElement = (List)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                String formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                dataPush.setCcUrl(formKey);
            }
            this.dataPushService.addDataPush(dataPush);
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                ArrayList<String> ccUsers = new ArrayList<String>();
                for (Object sysActCcTask : ccTasks) {
                    ccUsers.add(sysActCcTask.getReceiveUser());
                }
                dataPush.setUserId(String.join((CharSequence)",", ccUsers));
                dataPush.setCcMoment("0");
                dataPush.setStartDate((Date)((SysActCcTask)ccTasks.get(0)).getSendTime());
                this.dataPushService.addCcTask(dataPush);
            }
        }
        taskAssignee = this.getAssigneeByTaskId(taskEntity);
        if ("main_process_start".equals(Context.getCommandContext().getAttribute("startType"))) {
            ArrayList<String> assigneeList = new ArrayList<String>(Arrays.asList(taskAssignee.split(",")));
            if (HussarUtils.isNotEmpty((Object)userId)) {
                Iterator iter = assigneeList.iterator();
                while (iter.hasNext()) {
                    String item = (String)iter.next();
                    if (!item.equals(userId)) continue;
                    iter.remove();
                }
                taskAssignee = String.join((CharSequence)",", assigneeList);
            }
        }
        if (!"revoke".equals(Context.getCommandContext().getAttribute("taskSourceFlag")) && HussarUtils.isNotEmpty((Object)taskAssignee) && !"transfer".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            List<String> receiver = Arrays.asList(taskAssignee.split(","));
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(taskEntity.getProcessInstance().getProcessDefinitionKey());
            bpmActMsgDetail.setProcessName(taskEntity.getProcessInstance().getProcessDefinition().getName());
            bpmActMsgDetail.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
            bpmActMsgDetail.setTaskDefKey(taskEntity.getTaskDefinitionKey());
            bpmActMsgDetail.setTaskDefName(taskEntity.getName());
            bpmActMsgDetail.setReceive(receiver);
            ArrayList<String> contentTypeList = new ArrayList<String>();
            contentTypeList.add("defaultAssign");
            contentTypeList.add("conditionAssign");
            List list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)taskEntity.getProcessInstance().getProcessDefinitionKey())).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getTaskDefKey, (Object)taskEntity.getTaskDefinitionKey())).eq(SysActAssignee::getProcessVersion, (Object)taskEntity.getProcessDefinitionId().split(":")[1]));
            ArrayList<String> messageType = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)list)) {
                for (SysActAssignee sysActAssignee : list) {
                    messageType.add(sysActAssignee.getMessageType());
                }
            }
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
            if ("reject".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                bpmActMsgDetail.setSceneCode("reject");
            } else {
                bpmActMsgDetail.setSceneCode("todo");
            }
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
            }
            String processTitle = null;
            processTitle = HussarUtils.isEmpty((Object)historicProcessInstance) ? taskEntity.getProcessInstance().getProcessTitle() : historicProcessInstance.getProcessTitle();
            String dataDetail = null;
            dataDetail = HussarUtils.isEmpty((Object)historicProcessInstance) ? taskEntity.getProcessInstance().getDataDetail() : historicProcessInstance.getDataDetail();
            bpmActMsgDetail.setProcessTitle(processTitle);
            bpmActMsgDetail.setDataDetail(dataDetail);
            String formKey = taskEntity.getFormKey();
            String webFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("web"));
            String mobileFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("mobile"));
            bpmActMsgDetail.setWebFormAddress(webFormKey);
            bpmActMsgDetail.setMobileFormAddress(mobileFormKey);
            bpmActMsgDetail.setBusinessId(taskEntity.getProcessInstance().getBusinessKey());
            bpmActMsgDetail.setTaskId(taskEntity.getId());
            Model model = (Model)this.repositoryService.createModelQuery().modelKey(taskEntity.getProcessInstance().getProcessDefinitionKey()).singleResult();
            bpmActMsgDetail.setPortalAppId(HussarUtils.isEmpty((Object)model.getAppId()) ? null : String.valueOf(model.getAppId()));
            bpmActMsgDetail.setFormId(taskEntity.getFormId());
            bpmActMsgDetail.setProcessInstanceId(taskEntity.getProcessInstanceId());
            bpmActMsgDetail.setTabType("2");
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u521b\u5efa\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private DataPush dataPush(TaskEntity task, HistoricProcessInstance historicProcessInstance) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        } else {
            dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
            dataPush.setStartUserId((String)task.getVariable("sendUser"));
        }
        String processDefinitionId = task.getProcessDefinitionId();
        String processKey = processDefinitionId.split(":")[0];
        String processVersion = processDefinitionId.split(":")[1];
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(processDefinitionId);
        dataPush.setProcessKey(processKey);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser((String)task.getVariable("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(null);
        dataPush.setTaskDueTime(task.getDueDate());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)task.getVariable("todoConfiguration"));
        String processTitle = null;
        processTitle = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getProcessTitle() : historicProcessInstance.getProcessTitle();
        String dataDetail = null;
        dataDetail = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getDataDetail() : historicProcessInstance.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        dataPush.setComment(null);
        dataPush.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setTaskType(task.getTaskType());
        dataPush.setProcessVersion(processVersion);
        String processDefKey = null;
        processDefKey = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getProcessDefinitionKey() : historicProcessInstance.getProcessDefinitionKey();
        Model model = (Model)this.repositoryService.createModelQuery().modelKey(processDefKey).singleResult();
        dataPush.setAppId(String.valueOf(model.getAppId()));
        dataPush.setFormId(task.getFormId());
        return dataPush;
    }
}

