/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessCancleListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCancleListener.class);
    @Autowired
    private BpmMsgPushService msgPushService;
    @Lazy
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;

    public void onEvent(ActivitiEvent event) {
        ExecutionEntity entity = Context.getCommandContext().getExecutionEntityManager().findExecutionById(event.getProcessInstanceId());
        BpmnModel bm = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(entity.getProcessDefinitionId());
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(event.getProcessInstanceId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        map.put("processTitle", historicProcessInstance.getProcessTitle());
        map.put("dataDetail", historicProcessInstance.getDataDetail());
        map.put("formId", ((TaskEntity)entity.getTasks().get(0)).getFormId());
        map.put("taskName", entity.getCurrentActivityName());
        Process process = (Process)bm.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetNodeId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)entity.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, targetNodeId);
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesService.getOne((Wrapper)extendPropertiesWrapper);
        String formDetailKey = null;
        if (extendProperties != null) {
            formDetailKey = extendProperties.getFormDetailKey();
        }
        map.put("formDetailKey", formDetailKey);
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (historicProcessInstance.getSuperProcessInstanceId() == null) {
            if ("endProcess".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                this.endProcessMsgPush(map);
            } else {
                this.completeProcessMsgPush(map);
            }
        }
        new ProcessActionCmd(historicProcessInstance.getId(), historicProcessInstance.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        new ProcessNodeCmd(historicProcessInstance.getId(), historicProcessInstance.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5220\u9664\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void endProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("terminated");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void completeProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("complete");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void addMessage(Map<String, Object> map, BpmActMsgDetail bpmActMsgDetail) {
        bpmActMsgDetail.setProcessName(String.valueOf(map.get("processDefinitionName")));
        bpmActMsgDetail.setProcessDefinitionId(String.valueOf(map.get("processDefinitionId")));
        bpmActMsgDetail.setProcessKey(String.valueOf(map.get("processDefinitionId")).split(":")[0]);
        ArrayList<String> user = new ArrayList<String>();
        user.add(String.valueOf(map.get("starter")));
        bpmActMsgDetail.setReceive(user);
        bpmActMsgDetail.setProcessTitle(String.valueOf(map.get("processTitle")));
        bpmActMsgDetail.setDataDetail(String.valueOf(map.get("dataDetail")));
        String formDetailKey = String.valueOf(map.get("formDetailKey"));
        String webFormDetailAddress = String.valueOf(((Map)JSON.parseObject((String)formDetailKey, Map.class)).get("web"));
        String mobileFormDetailAddress = String.valueOf(((Map)JSON.parseObject((String)formDetailKey, Map.class)).get("mobile"));
        bpmActMsgDetail.setWebFormDetailAddress(webFormDetailAddress);
        bpmActMsgDetail.setMobileFormDetailAddress(mobileFormDetailAddress);
        bpmActMsgDetail.setBusinessId(String.valueOf(map.get("businessId")));
        Model model = (Model)this.repositoryService.createModelQuery().modelKey(String.valueOf(map.get("processDefinitionId")).split(":")[0]).singleResult();
        bpmActMsgDetail.setPortalAppId(String.valueOf(model.getAppId()));
        bpmActMsgDetail.setFormId(String.valueOf(map.get("formId")));
        bpmActMsgDetail.setProcessInstanceId(String.valueOf(map.get("processInsId")));
        bpmActMsgDetail.setTabType("0");
        bpmActMsgDetail.setTaskDefName(String.valueOf(map.get("taskName")));
    }
}

