/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.Date;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class TransferAddHistoryTaskCmd
implements Command<Void> {
    private ExecutionEntity executionEntity;
    private String comment;
    private Date startTime;
    private String userId;
    private String receiver;
    private String owner;
    private String parentTaskId;
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public TransferAddHistoryTaskCmd(ExecutionEntity executionEntity, String comment, Date startTime, String userId, String receiver, String parentTaskId, String owner) {
        this.executionEntity = executionEntity;
        this.comment = comment;
        this.startTime = startTime;
        this.userId = userId;
        this.receiver = receiver;
        this.parentTaskId = parentTaskId;
        this.owner = owner;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity task = this.getTask();
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setProcessDefinitionId(this.executionEntity.getProcessDefinitionId());
        taskEntity.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskEntity.setProcessInstanceId(this.executionEntity.getProcessInstanceId());
        taskEntity.setExecutionId(this.executionEntity.getId());
        taskEntity.setName(task.getName());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(this.executionEntity);
        taskEntity.setAssignee(this.userId);
        taskEntity.setFormKey(task.getFormKey());
        taskEntity.setTaskType("5");
        taskEntity.setParentTaskId(this.parentTaskId);
        taskEntity.setOwner(this.owner);
        taskEntity.setReceiver(this.receiver);
        taskEntity.setParentTaskId(task.getId());
        taskEntity.setVariableLocal("sendUser", (Object)this.userId);
        taskEntity.setVariableLocal("receiverId", (Object)this.receiver);
        taskEntity.setVariableLocal("todoConfiguration", task.getVariableLocal("todoConfiguration"));
        taskEntity.setVariableLocal("complete_from", (Object)task.getTaskDefinitionKey());
        taskEntity.setSubProcessKey(task.getSubProcessKey());
        taskEntity.setCycleCount(task.getCycleCount());
        taskEntity.setProcessCycleCount(task.getProcessCycleCount());
        commandContext.addAttribute("taskSourceFlag", (Object)"transfer");
        if (taskEntity.getRevision() == 0) {
            taskEntity.insert(taskEntity.getExecution());
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
            }
        } else {
            taskEntity.update();
        }
        taskEntity.fireEvent("create");
        taskEntity.fireEvent("start");
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > 1503) {
                eventMessage = eventMessage.substring(0, 1500) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(taskEntity.getId());
        dataPush.setTaskDefinitionName(taskEntity.getName());
        dataPush.setUserId(this.userId);
        dataPush.setBusinessKey(taskEntity.getProcessInstance().getBusinessKey());
        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(this.userId);
        dataPush.setStartDate(this.startTime);
        dataPush.setEndDate(new Date());
        dataPush.setUrl(taskEntity.getFormKey());
        dataPush.setDescription((String)task.getVariableLocal("todoConfiguration"));
        dataPush.setProcessName(this.executionEntity.getProcessDefinitionName());
        dataPush.setFormId(task.getFormId());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            dataPush.setComment(this.comment);
        }
        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
        dataPush.setTaskType("5");
        this.dataPushService.completeDataPush(dataPush);
        taskEntity.fireEvent("beforeComplete");
        taskEntity.setVariableLocal("taskSourceFlag", (Object)"transfer");
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "TransferHistory", false, new Date());
        taskEntity.fireEvent("complete");
        return null;
    }

    protected TaskEntity getTask() {
        List taskEntities = this.executionEntity.getTasks();
        List entityList = this.executionEntity.getExecutions();
        if (entityList != null && !entityList.isEmpty()) {
            this.executionEntity = (ExecutionEntity)entityList.get(0);
            entityList = this.executionEntity.getExecutions();
            if (entityList != null && !entityList.isEmpty()) {
                taskEntities = ((ExecutionEntity)this.executionEntity.getExecutions().get(0)).getTasks();
            }
            this.executionEntity = this.executionEntity.createExecution();
            this.executionEntity.setScope(false);
            this.executionEntity.setConcurrent(true);
            this.executionEntity.setActive(false);
        }
        TaskEntity task = (TaskEntity)taskEntities.get(0);
        for (int i = 1; i < taskEntities.size(); ++i) {
            if (!((TaskEntity)taskEntities.get(i)).getCreateTime().after(task.getCreateTime())) continue;
            task = (TaskEntity)taskEntities.get(i);
        }
        if (this.executionEntity.getVariable("sub_process_key") != null && task.getSubProcessKey() == null) {
            task.setSubProcessKey((String)this.executionEntity.getVariable("sub_process_key"));
        }
        if (this.executionEntity.getVariable("cycle_count") != null && task.getCycleCount() == null) {
            task.setCycleCount((Integer)this.executionEntity.getVariable("cycle_count"));
        }
        if (this.executionEntity.getVariable("process_cycle_count") != null && task.getProcessCycleCount() == null) {
            task.setProcessCycleCount((Integer)this.executionEntity.getVariable("process_cycle_count"));
        }
        return task;
    }
}

