/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.formdesign.visitor.AssemblyVariablesVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ProcessBinding;
import com.jxdinfo.hussar.workflow.outside.variable.service.GodAxeVariablesService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;

public class CommonCodeUtil {
    private static Boolean isStartAlone;
    private static ModelService modelService;
    private static RepositoryService repositoryService;
    private static ActivityRedisTimerService activityRedisTimerService;
    private static SysActProcessFileService sysActProcessFileService;

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (isStartAlone == null) {
            isStartAlone = "micro".equals(lcdpBpmProperties.getDeploymentModel());
        }
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        Map<String, Object> variable = new HashMap<String, Object>();
        if ("workflow-platform".equals(lcdpBpmProperties.getDeploymentModel())) {
            if ("base".equals(lcdpBpmProperties.getTenantType())) {
                try {
                    String url = "/hussarBpm/bpm/visitor/getVariable";
                    url = lcdpBpmProperties.getTenantCallAddress() + url;
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("beanId", beanId);
                    params.put("businessId", businessId);
                    String result = HttpClient.doGet((String)url, params);
                    variable = (Map)JSONObject.parseObject((String)result, HashMap.class);
                }
                catch (Exception e) {
                    return new HashMap<String, Object>();
                }
            }
        } else {
            if (!isStartAlone.booleanValue()) {
                AssemblyVariablesVisitor assemblyVariablesVisitor;
                try {
                    assemblyVariablesVisitor = (AssemblyVariablesVisitor)SpringContextHolder.getBean(AssemblyVariablesVisitor.class);
                }
                catch (Exception e) {
                    return new HashMap<String, Object>();
                }
                try {
                    WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(procDefId, null, null);
                    if (HussarUtils.isEmpty((Object)workFlow)) {
                        throw new PublicClientException("\u6d41\u7a0b\u5b9a\u4e49ID\u9519\u8bef");
                    }
                    String appId = workFlow.getAppId();
                    if (HussarUtils.isNotBlank((CharSequence)appId)) {
                        FlowModel data = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
                        FlowProps props = data.getProps();
                        ProcessBinding binding = props.getProcessBinding();
                        String mainTableName = "";
                        if (binding != null) {
                            mainTableName = binding.getMainTableName();
                        }
                        beanId = "GET /" + appId + "/" + mainTableName + "/FormQuery";
                    }
                    variable = assemblyVariablesVisitor.assemblyVariables(beanId, businessId);
                }
                catch (Exception e) {
                    return new HashMap<String, Object>();
                }
            }
            String serviceName = String.valueOf(modelService.getServiceName(procDefKey));
            try {
                GodAxeVariablesService godAxeVariablesService = (GodAxeVariablesService)SpringContextHolder.getBean(GodAxeVariablesService.class);
                variable = godAxeVariablesService.assemblyVariables(beanId, businessId, serviceName);
            }
            catch (Exception e) {
                throw new BpmException("\u4ece\u670d\u52a1" + serviceName + "\u83b7\u53d6\u53d8\u91cf\u5931\u8d25");
            }
        }
        CommonCodeUtil.handleVariables(variable);
        return variable;
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && HussarUtils.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)bm.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new BpmException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (HussarUtils.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    public static boolean isBindTable(Set<String> processDefinitionIdList) {
        if (HussarUtils.isEmpty(processDefinitionIdList)) {
            return false;
        }
        for (String procDefId : processDefinitionIdList) {
            WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(procDefId, null, null);
            String wfdFile = workFlow.getData();
            FlowModel parse = (FlowModel)JSONObject.parseObject((String)wfdFile, FlowModel.class);
            FlowProps props = parse.getProps();
            ProcessBinding processBinding = props.getProcessBinding();
            if (processBinding == null) {
                return false;
            }
            String mainTableName = processBinding.getMainTableName();
            String taskTableName = processBinding.getTaskTableName();
            String mainTableBusinessKey = processBinding.getMainTableBusinessKey();
            if (HussarUtils.isNotEmpty((Object)mainTableName) && HussarUtils.isNotEmpty((Object)taskTableName) && HussarUtils.isNotEmpty((Object)mainTableBusinessKey)) continue;
            return false;
        }
        return true;
    }

    private CommonCodeUtil() {
    }

    public static boolean isBackfill(Set<String> processDefinitionIdList) {
        if (HussarUtils.isEmpty(processDefinitionIdList)) {
            return false;
        }
        boolean isBackFill = false;
        for (String prodefId : processDefinitionIdList) {
            String isBackFillText;
            BpmnModel bm = repositoryService.getBpmnModel(prodefId);
            Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
            List isBackFillElement = (List)extensionElementList.get("isBackfill");
            if (!HussarUtils.isNotEmpty((Object)isBackFillElement) || !HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")) || !(isBackFill = Boolean.valueOf(isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue()).booleanValue())) continue;
            return isBackFill;
        }
        return isBackFill;
    }

    static {
        modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
        repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
        activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
        sysActProcessFileService = (SysActProcessFileService)SpringContextHolder.getBean(SysActProcessFileService.class);
    }
}

