/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExeListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendActivitiListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendFieldExtension;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.LineConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SubProcessModeVariable;
import com.jxdinfo.hussar.workflow.engine.flowmodel.TimeOutStrategy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;

public final class FormBpmnUtil {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");

    private FormBpmnUtil() {
    }

    public static GraphicInfo createGraphicInfo(FlowObject currentValue) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(Double.parseDouble(currentValue.getLeft().replace("px", "")));
        graphicInfo.setY(Double.parseDouble(currentValue.getTop().replace("px", "")));
        graphicInfo.setWidth(Double.parseDouble(currentValue.getWidth().replace("px", "")));
        graphicInfo.setHeight(Double.parseDouble(currentValue.getHeight().replace("px", "")));
        return graphicInfo;
    }

    public static void createSequence(List<FlowSequence> allMapSeq, List<FlowObject> element, String processKey, FlowElementsContainer process, BpmnModel bpmnModel) {
        for (FlowSequence formSequence : allMapSeq) {
            formSequence.setProcessKeyPath(processKey);
            FlowProps flowProps = formSequence.getProps();
            boolean isFlowDefault = flowProps.isFlowDefault();
            formSequence.setFlowDefault(isFlowDefault);
            formSequence.setName(flowProps.getFlowName());
            List<GraphicInfo> line = FormBpmnUtil.createFlowGraphicInfo(formSequence);
            SequenceFlow sequenceFlow = FormBpmnUtil.createSequenceFlow(formSequence, element);
            sequenceFlow.setDocumentation(flowProps.getFlowDescription());
            LineConfig lineConfig = formSequence.getLineConfig();
            if (lineConfig != null) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendSequenceflow");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute dxAttribute = new ExtensionAttribute();
                dxAttribute.setName("dx");
                dxAttribute.setValue(lineConfig.getDx());
                extensionElement.addAttribute(dxAttribute);
                ExtensionAttribute rotateAttribute = new ExtensionAttribute();
                rotateAttribute.setName("rotate");
                rotateAttribute.setValue(lineConfig.getRotate());
                extensionElement.addAttribute(rotateAttribute);
                ExtensionAttribute xAttribute = new ExtensionAttribute();
                xAttribute.setName("x");
                xAttribute.setValue(lineConfig.getX());
                extensionElement.addAttribute(xAttribute);
                ExtensionAttribute yAttribute = new ExtensionAttribute();
                yAttribute.setName("y");
                yAttribute.setValue(lineConfig.getY());
                extensionElement.addAttribute(yAttribute);
                ExtensionAttribute lineNameAttribute = new ExtensionAttribute();
                lineNameAttribute.setName("lineName");
                List list = lineConfig.getLineName();
                StringBuilder sb = new StringBuilder();
                if (list != null && !list.isEmpty()) {
                    for (String str : list) {
                        sb.append(str).append("/n");
                    }
                    lineNameAttribute.setValue(sb.toString());
                } else {
                    lineNameAttribute.setValue(null);
                }
                extensionElement.addAttribute(lineNameAttribute);
                ExtensionAttribute widthAttribute = new ExtensionAttribute();
                widthAttribute.setName("width");
                widthAttribute.setValue(lineConfig.getWidth());
                extensionElement.addAttribute(widthAttribute);
                ExtensionAttribute heightAttribute = new ExtensionAttribute();
                heightAttribute.setName("height");
                heightAttribute.setValue(lineConfig.getHeight());
                extensionElement.addAttribute(heightAttribute);
                sequenceFlow.addExtensionElement(extensionElement);
            }
            process.addFlowElement((FlowElement)sequenceFlow);
            bpmnModel.addFlowGraphicInfoList(formSequence.getNodeId(), line);
        }
    }

    public static List<GraphicInfo> createFlowGraphicInfo(FlowSequence currentValue) {
        ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
        for (FlowSequenceXy xy : currentValue.getPoints()) {
            GraphicInfo graphicInfo = new GraphicInfo();
            graphicInfo.setX(Double.parseDouble(xy.getX()));
            graphicInfo.setY(Double.parseDouble(xy.getY()));
            graphicInfoList.add(graphicInfo);
        }
        return graphicInfoList;
    }

    public static SequenceFlow createSequenceFlow(FlowSequence formSequence, List<FlowObject> element) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(formSequence.getId());
        flow.setName(formSequence.getName());
        flow.setSourceRef(FormBpmnUtil.getNodeId(formSequence.getStart().getKey(), element));
        flow.setTargetRef(FormBpmnUtil.getNodeId(formSequence.getEnd().getKey(), element));
        if (!formSequence.isFlowDefault()) {
            flow.setConditionExpression(formSequence.getProps().getBackFlowCondition());
        }
        return flow;
    }

    private static String getNodeId(String key, List<FlowObject> element) {
        String nodeId = key;
        for (FlowObject flowObject : element) {
            if (!key.equals(flowObject.getInstanceKey())) continue;
            nodeId = flowObject.getNodeId();
            break;
        }
        return nodeId;
    }

    public static void extendHandle(FlowObject flowObject, SubProcess subProcess, Map<String, String> map) {
        JSONArray assignmentNodes;
        FlowRecipients flowEndRecipients;
        JSONArray assignmentNodes2;
        FlowRecipients flowRecipients;
        JSONArray assignmentNodes3;
        String instanceMode = flowObject.getProps().getInstanceMode();
        subProcess.addExtensionElement(FormBpmnUtil.addExtensionElement("instanceMode", instanceMode));
        StringBuilder assignmentNodeValue = new StringBuilder();
        FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
        if (flowAssignment != null && HussarUtils.isNotEmpty((Object)(assignmentNodes3 = (JSONArray)flowAssignment.getParticipantConfigs()))) {
            for (int i = 0; i < assignmentNodes3.size(); ++i) {
                String markNode = assignmentNodes3.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        if ((flowRecipients = flowObject.getProps().getFlowRecipients()) != null && HussarUtils.isNotEmpty((Object)(assignmentNodes2 = (JSONArray)flowRecipients.getCarbonCopyConfigs()))) {
            for (int i = 0; i < assignmentNodes2.size(); ++i) {
                String markNode = assignmentNodes2.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        if ((flowEndRecipients = flowObject.getProps().getFlowEndRecipients()) != null && HussarUtils.isNotEmpty((Object)(assignmentNodes = (JSONArray)flowEndRecipients.getCarbonCopyConfigs()))) {
            for (int i = 0; i < assignmentNodes.size(); ++i) {
                String markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        String assignmentNode = assignmentNodeValue.toString().length() > 0 ? assignmentNodeValue.toString().substring(1) : "";
        subProcess.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNode));
        SubProcessModeVariable subProcessModeVariable = flowObject.getProps().getInstanceModeVariable();
        subProcess.addExtensionElement(FormBpmnUtil.addExtensionElement("subProcessVariableConfig", subProcessModeVariable == null ? "" : subProcessModeVariable.getVariable()));
        if (flowAssignment == null) {
            return;
        }
        String strTemp = flowAssignment.getDefaultBackCondtion();
        subProcess.addExtensionElement(FormBpmnUtil.addExtensionElement("defaultAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List judgeBackConditions = flowAssignment.getJudgeBackCondition();
        JSONObject jsonObject = new JSONObject(true);
        if (HussarUtils.isNotEmpty((Object)judgeBackConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObject.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            subProcess.addExtensionElement(FormBpmnUtil.addExtensionElement("conditionAssign", jsonObject.toJSONString()));
        }
    }

    public static void extendHandle(FlowObject flowObject, UserTask userTask) {
        String markNode;
        JSONObject ccJsonObject;
        JSONObject jsonObject = flowObject.getProps().getAssistFormAddress();
        if (jsonObject != null) {
            JSONObject object = new JSONObject();
            for (Object key : jsonObject.keySet()) {
                object.put((String)key, jsonObject.getJSONObject((String)key).get((Object)"url"));
            }
            String assistFromKey = JSON.toJSONString((Object)object);
            userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("assistFormKey", assistFromKey));
        }
        if ((ccJsonObject = flowObject.getProps().getCcFormAddress()) != null) {
            JSONObject object = new JSONObject();
            for (String key : ccJsonObject.keySet()) {
                object.put(key, ccJsonObject.getJSONObject(key).get((Object)"url"));
            }
            String ccFromKey = JSON.toJSONString((Object)object);
            userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("ccFormKey", ccFromKey));
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowObject.getProps().getTodoConfiguration().getModalValue()));
        JSONArray assignmentNodes = (JSONArray)flowObject.getProps().getFlowAssignment().getParticipantConfigs();
        StringBuilder assignmentNodeValue = new StringBuilder();
        if (HussarUtils.isNotEmpty((Object)assignmentNodes)) {
            for (int i = 0; i < assignmentNodes.size(); ++i) {
                markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assignmentNodes = (JSONArray)flowObject.getProps().getFlowRecipients().getCarbonCopyConfigs()))) {
            for (int i = 0; i < assignmentNodes.size(); ++i) {
                markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        if (flowObject.getProps().getFlowEndRecipients() != null && HussarUtils.isNotEmpty((Object)(assignmentNodes = (JSONArray)flowObject.getProps().getFlowEndRecipients().getCarbonCopyConfigs()))) {
            for (int i = 0; i < assignmentNodes.size(); ++i) {
                markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                assignmentNodeValue.append(",").append(markNode);
            }
        }
        String assignmentNode = assignmentNodeValue.toString().length() > 0 ? assignmentNodeValue.toString().substring(1) : "";
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNode));
        String skiprepetition = flowObject.getProps().getFlowSkipRepetition();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("skiprepetition", skiprepetition));
        String allowSetParticipant = flowObject.getProps().getAllowSetParticipant();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("allowSetParticipant", allowSetParticipant));
        String messageType = flowObject.getProps().getMessageType();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("messageType", messageType));
        TimeOutStrategy timeOutStrategy = flowObject.getProps().getTimeOutStrategy();
        if (HussarUtils.isNotEmpty((Object)timeOutStrategy) && !"unHandle".equals(timeOutStrategy.getTimeoutStrategyType()) && HussarUtils.isNotEmpty((Object)timeOutStrategy.getTimeoutStrategyType())) {
            if ("outInterface".equals(timeOutStrategy.getTimeoutStrategyType())) {
                String path = timeOutStrategy.getOutInterface();
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", path));
            } else if (!"".equals(timeOutStrategy.getTimeoutStrategyType())) {
                userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("TimeOutStrategy", timeOutStrategy.getTimeoutStrategyType()));
            }
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("currentdept", "false"));
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowStarter", "false"));
        Map formDetailAddress = flowObject.getProps().getFormDetailAddress();
        if (HussarUtils.isNotEmpty((Object)formDetailAddress)) {
            ((FlowPageMsg)formDetailAddress.get("web")).setFormAuth(null);
            ((FlowPageMsg)formDetailAddress.get("mobile")).setFormAuth(null);
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("flowFormDetailKey", JSONObject.toJSONString((Object)formDetailAddress)));
        Map assistFormDetailAddress = flowObject.getProps().getAssistFormDetailAddress();
        if (HussarUtils.isNotEmpty((Object)assistFormDetailAddress)) {
            ((FlowPageMsg)assistFormDetailAddress.get("web")).setFormAuth(null);
            ((FlowPageMsg)assistFormDetailAddress.get("mobile")).setFormAuth(null);
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("assistFlowFormDetailKey", JSONObject.toJSONString((Object)assistFormDetailAddress)));
        Map ccFormDetailAddress = flowObject.getProps().getCcFormDetailAddress();
        if (HussarUtils.isNotEmpty((Object)ccFormDetailAddress)) {
            ((FlowPageMsg)ccFormDetailAddress.get("web")).setFormAuth(null);
            ((FlowPageMsg)ccFormDetailAddress.get("mobile")).setFormAuth(null);
        }
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("ccFlowFormDetailKey", JSONObject.toJSONString((Object)ccFormDetailAddress)));
        String delayToAssign = flowObject.getProps().getDelayToAssign();
        userTask.addExtensionElement(FormBpmnUtil.addExtensionElement("delayToAssign", delayToAssign));
    }

    public static void assigneeInstall(FlowObject flowObject, Activity activity, Map<String, String> map) {
        FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
        if (flowAssignment == null) {
            return;
        }
        String strTemp = flowAssignment.getDefaultBackCondtion();
        activity.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
        List judgeBackConditions = flowAssignment.getJudgeBackCondition();
        JSONObject jsonObject = new JSONObject(true);
        if (HussarUtils.isNotEmpty((Object)judgeBackConditions)) {
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                jsonObject.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
            }
            activity.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionAssign", jsonObject.toJSONString()));
        }
    }

    public static void callActivityAssigneeInstall(FlowObject flowObject, CallActivity callActivity, Map<String, String> map) {
        FlowAssignment flowAssignment = flowObject.getProps().getFlowSelector();
        if (flowAssignment != null) {
            String defaultProcessKey = flowAssignment.getDefaultProcessKey();
            String defaultAssignee = flowAssignment.getDefaultBackCondtion();
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("defaultCallAssignee", FormBpmnUtil.getRealAssignee(defaultAssignee, map)));
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("defaultCallProcessKey", defaultProcessKey));
            List judgeBackConditions = flowAssignment.getJudgeBackCondition();
            JSONObject conditionCallProcessKey = new JSONObject(true);
            JSONObject conditionCallAssignee = new JSONObject(true);
            if (HussarUtils.isNotEmpty((Object)judgeBackConditions)) {
                for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                    if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                    conditionCallAssignee.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
                    conditionCallProcessKey.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getConditionProcessKey(), map));
                }
                callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("conditionCallAssign", conditionCallAssignee.toJSONString()));
                callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("conditionCallProcessKey", conditionCallProcessKey.toJSONString()));
            }
            JSONArray assignmentNodes = (JSONArray)flowObject.getProps().getFlowSelector().getParticipantConfigs();
            StringBuilder assignmentNodeValue = new StringBuilder();
            if (HussarUtils.isNotEmpty((Object)assignmentNodes)) {
                for (int i = 0; i < assignmentNodes.size(); ++i) {
                    String markNode = assignmentNodes.getJSONObject(i).getString("markedNode");
                    if (!HussarUtils.isNotEmpty((Object)markNode)) continue;
                    assignmentNodeValue.append(",").append(markNode);
                }
            }
            String assignmentNode = assignmentNodeValue.toString().length() > 0 ? assignmentNodeValue.toString().substring(1) : "";
            callActivity.addExtensionElement(FormBpmnUtil.addExtensionElement("assignmentnode", assignmentNode));
        }
    }

    private static String getRealAssignee(String assignee, Map<String, String> map) {
        if (assignee != null && assignee.contains("@{")) {
            String realAssignee = assignee;
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                String functionString = matcher.group();
                realAssignee = realAssignee.replace(functionString, map.get(functionString.substring(2, functionString.length() - 2)));
            }
            return realAssignee;
        }
        return assignee;
    }

    public static void ccInstall(FlowObject jsonObject, Activity activity, Map<String, String> map) {
        FlowRecipients flowEndRecipients;
        FlowRecipients flowRecipients = jsonObject.getProps().getFlowRecipients();
        if (flowRecipients != null) {
            String strTemp = flowRecipients.getDefaultCcCondtion();
            activity.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultCcAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
            List judgeCcConditions = flowRecipients.getJudgeCcCondition();
            JSONObject jsonObjectCc = new JSONObject(true);
            if (HussarUtils.isNotEmpty((Object)judgeCcConditions)) {
                for (JudgeBackCondition judgeBackCondition : judgeCcConditions) {
                    if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                    jsonObjectCc.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
                }
                activity.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionCcAssign", jsonObjectCc.toJSONString()));
            }
        }
        if ((flowEndRecipients = jsonObject.getProps().getFlowEndRecipients()) != null) {
            String strTemp = flowEndRecipients.getDefaultCcCondtion();
            activity.addAttribute(FormBpmnUtil.addExtensionAttribute("defaultCcEndAssign", FormBpmnUtil.getRealAssignee(strTemp, map)));
            List judgeCcConditions = flowEndRecipients.getJudgeCcCondition();
            JSONObject jsonObjectCc = new JSONObject(true);
            if (HussarUtils.isNotEmpty((Object)judgeCcConditions)) {
                for (JudgeBackCondition judgeBackCondition : judgeCcConditions) {
                    if (null == judgeBackCondition.getConditionBackExpression() || "".equals(judgeBackCondition.getConditionBackExpression().trim())) continue;
                    jsonObjectCc.put(judgeBackCondition.getConditionBackExpression(), (Object)FormBpmnUtil.getRealAssignee(judgeBackCondition.getJudgeSpellCondition(), map));
                }
                activity.addAttribute(FormBpmnUtil.addExtensionAttribute("conditionCcEndAssign", jsonObjectCc.toJSONString()));
            }
        }
    }

    public static void addTaskListener(UserTask userTask, FlowObject flowObject) {
        List taskListeners;
        ExtendTaskListener extendTaskListener;
        OriginalTaskListener originalTaskListener = flowObject.getProps().getOriginalTaskListener();
        if (HussarUtils.isNotEmpty((Object)originalTaskListener)) {
            ArrayList<ActivitiListener> taskListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalTaskListener.getTaskListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
                for (ExtendFieldExtension extendFieldExtension : extendActivitiListener.getFieldExtensions()) {
                    FieldExtension fileExtension = new FieldExtension();
                    fileExtension.setStringValue(extendFieldExtension.getStringValue());
                    fileExtension.setFieldName(extendFieldExtension.getFieldName());
                    fileExtension.setExpression(extendFieldExtension.getExpression());
                    fieldExtensionList.add(fileExtension);
                }
                activitiListener.setFieldExtensions(fieldExtensionList);
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                taskListeners2.add(activitiListener);
            }
            userTask.setTaskListeners(taskListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(extendTaskListener = flowObject.getProps().getTaskListener())) && HussarUtils.isNotEmpty((Object)(taskListeners = extendTaskListener.getTaskListener()))) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendTaskListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                userTask.addExtensionElement(extensionElement);
            }
        }
    }

    public static ExtensionElement addExtensionElement(String name, String value) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespacePrefix("extend");
        extensionElement.setNamespace("http://activiti.org/bpmn");
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(name);
        extensionAttribute.setValue(HussarUtils.isEmpty((Object)value) ? "" : value);
        extensionElement.addAttribute(extensionAttribute);
        return extensionElement;
    }

    public static ExtensionAttribute addExtensionAttribute(String name, String value) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setNamespacePrefix("extend");
        extensionAttribute.setNamespace("http://activiti.org/bpmn");
        extensionAttribute.setName(name);
        extensionAttribute.setValue(HussarUtils.isEmpty((Object)value) ? "" : value);
        return extensionAttribute;
    }

    public static void addExeListener(FlowElement userTask, List<FlowVariables> useVariables, List<String> pathIds, boolean flag) {
        ActivitiListener activitiListener;
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        boolean addStart = flag;
        boolean addEnd = flag;
        for (FlowVariables flowVariables : useVariables) {
            if (addStart && addEnd) break;
            if (pathIds.contains(flowVariables.getAction())) {
                addEnd = true;
                continue;
            }
            addStart = true;
        }
        if (addStart) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("start");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.workflow.engine.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        if (addEnd) {
            activitiListener = new ActivitiListener();
            activitiListener.setEvent("end");
            activitiListener.setImplementationType("class");
            activitiListener.setImplementation("com.jxdinfo.hussar.workflow.engine.bpm.listener.GodAxeDefaultListener");
            executionListeners.add(activitiListener);
        }
        userTask.setExecutionListeners(executionListeners);
    }

    public static void addExecutionListener(Activity activity, FlowObject flowObject) {
        List activityListeners;
        ExtendTaskListener extendActivityListener;
        OriginalTaskListener originalActivityListener = flowObject.getProps().getOriginalActivityListener();
        if (HussarUtils.isNotEmpty((Object)originalActivityListener)) {
            ArrayList<ActivitiListener> activityListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalActivityListener.getActivityListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
                for (ExtendFieldExtension extendFieldExtension : extendActivitiListener.getFieldExtensions()) {
                    FieldExtension fileExtension = new FieldExtension();
                    fileExtension.setStringValue(extendFieldExtension.getStringValue());
                    fileExtension.setFieldName(extendFieldExtension.getFieldName());
                    fileExtension.setExpression(extendFieldExtension.getExpression());
                    fieldExtensionList.add(fileExtension);
                }
                activitiListener.setFieldExtensions(fieldExtensionList);
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                activityListeners2.add(activitiListener);
            }
            List listeners = activity.getExecutionListeners();
            if (HussarUtils.isNotEmpty((Object)listeners)) {
                activityListeners2.addAll(listeners);
            }
            activity.setExecutionListeners(activityListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(extendActivityListener = flowObject.getProps().getActivityListener())) && HussarUtils.isNotEmpty((Object)(activityListeners = extendActivityListener.getActivityListener()))) {
            for (ExeListener exeListener : activityListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                activity.addExtensionElement(extensionElement);
            }
        }
    }

    public static void getFunctionMessage(FlowProps flowProps, Map<String, String> map, List<FlowVariables> functionUserVariables) {
        List flowFunctionConfigs;
        FlowRecipients flowEndRecipients;
        FlowRecipients flowRecipients;
        HashSet<String> functionIds = new HashSet<String>();
        FlowAssignment flowAssignment = flowProps.getFlowAssignment();
        if (HussarUtils.isNotEmpty((Object)flowAssignment)) {
            FormBpmnUtil.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
            if (HussarUtils.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                    FormBpmnUtil.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(flowRecipients = flowProps.getFlowRecipients()))) {
            FormBpmnUtil.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
            if (HussarUtils.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowRecipients.getJudgeCcCondition()) {
                    FormBpmnUtil.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(flowEndRecipients = flowProps.getFlowEndRecipients()))) {
            FormBpmnUtil.getFunctionIds(flowEndRecipients.getDefaultCcCondtion(), functionIds);
            if (HussarUtils.isNotEmpty((Object)flowEndRecipients.getJudgeCcCondition())) {
                for (JudgeBackCondition judgeBackCondition : flowEndRecipients.getJudgeCcCondition()) {
                    FormBpmnUtil.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(flowFunctionConfigs = flowProps.getFlowFunctionConfig()))) {
            for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                if (!functionIds.contains(flowFunctionConfig.getId())) continue;
                map.put(flowFunctionConfig.getId(), flowFunctionConfig.getValue());
                functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
            }
        }
    }

    private static void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (HussarUtils.isNotEmpty((Object)assignee) && assignee.contains("@{")) {
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }
}

