/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Autowired
    List<DataPushListener> dataPushListeners;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public boolean isDataPush() {
        return this.dataPushListeners.size() >= 2 && (this.dataPushListeners.size() != 2 || this.lcdpBpmProperties.isUseDatapush());
    }

    public void addDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.completeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.entrustTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferUserTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.rejectTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.revokeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.freeJumpTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUser(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteMultiTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(DataPush dataPush) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
            if (dataPush.getEndDate() != null) {
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(List<DataPush> dataPushList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            for (DataPush dataPush : dataPushList) {
                dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
                if (dataPush.getEndDate() == null) continue;
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(dataPushList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void readCcTask(DataPush dataPush) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.readCcTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteCcTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUrgeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void endProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.endProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.reTransferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(Task task, String comment, String userId, String mandator, String taskState, String taskType) {
        if (this.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState).setTaskType(taskType);
            this.completeDataPush(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee) {
        if (this.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            this.entrustDataPush(dataPush);
        }
    }

    public void transferDataPush(Task task, String userId, String consignee, String transferor) {
        if (this.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            dataPush.setTransferor(transferor);
            this.transferDataPush(dataPush);
        }
    }

    public void addUserDataPush(Task task, String userId) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessInsId(task.getProcessInstanceId());
        this.addUserDataPush(dataPush);
    }

    public void changeProcessStateDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.changeProcessState(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addStartProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addStartProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateStartProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.updateStartProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteStartProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteStartProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateBusinessInfo(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.updateBusinessInfo(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

