/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActFormAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysActFormAuthService")
public class SysActFormAuthServiceImpl
extends ServiceImpl<SysActFormAuthMapper, SysActFormAuth>
implements SysActFormAuthService {
    @Autowired
    private SysActFormAuthMapper sysActFormAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Resource
    private TaskService taskService;
    @Resource
    private RepositoryService repositoryService;

    public JSONArray initList(String formName, String processKey, String formType, String taskDefinitionKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formName), SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)processKey), SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)taskDefinitionKey), SysActFormAuth::getTaskDefinitionKey, (Object)taskDefinitionKey);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formState), SysActFormAuth::getFormState, (Object)formState);
        return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
    }

    public boolean saveOrUpdateAuth(JSONArray insertAuth) {
        List list = JSONObject.parseArray((String)insertAuth.toJSONString(), SysActFormAuth.class);
        return this.saveOrUpdateBatch(list);
    }

    public boolean removeAuth(String formName, String formType, String processKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getFormState, (Object)formState)).or()).isNull(SysActFormAuth::getFormState);
        });
        return this.remove((Wrapper)flowAuthWrapper);
    }

    public boolean copyAuth(String processKey, String oldProcessKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey));
        for (SysActFormAuth sysActFormAuth : list) {
            sysActFormAuth.setId(null);
            sysActFormAuth.setProcessKey(processKey);
        }
        return this.saveBatch(list);
    }

    public BpmResponseResult queryFormAuthConfigs(String formId, String taskId, String formType, String processKey) {
        List<Object> list = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            String processVersion = definitionModel.getVersion();
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(formId, formType, processKey, processVersion);
            jsonObject.put("isFirst", (Object)true);
        } else {
            String procDefId = this.taskEngineService.getProcessIdByTaskId(taskId).getMsg();
            String processVersion = procDefId.split(":")[1];
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)task)) {
                formType = "1";
                jsonObject.put("isFirst", (Object)false);
            }
            list = this.sysActFormAuthMapper.queryFormAuth(taskId, formType, processVersion);
            if ("2".equals(formType)) {
                jsonObject.put("isFirst", (Object)false);
                String taskDefinitionKey = task.getTaskDefinitionKey();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
                Process process = bpmnModel.getMainProcess();
                Collection flowElements = process.getFlowElements();
                for (FlowElement flowElement : flowElements) {
                    List startOut;
                    String firstUserTask;
                    if (!(flowElement instanceof StartEvent) || !taskDefinitionKey.equals(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef())) continue;
                    jsonObject.put("isFirst", (Object)true);
                    break;
                }
            }
        }
        jsonObject.put("data", (Object)JSONArray.parseArray((String)JSON.toJSONString(list)));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }
}

