/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.task.Task;

public class EntrustTaskAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;
    protected String owner;

    public EntrustTaskAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame, String owner) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
        this.owner = owner;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        List identityLinks = taskEntity.getCandidates();
        IdentityLinkEntity newIdentityLink = null;
        if (taskEntity.getAssignee() != null) {
            taskEntity.addCandidateUser(this.mandatary, this.userId, "2");
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
        } else {
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                if (HussarUtils.isNotEmpty((Object)this.owner) && HussarUtils.isNotEmpty((Object)identityLinkEntity.getMandator()) && identityLinkEntity.getMandator().equals(this.owner)) {
                    newIdentityLink = identityLinkEntity;
                    break;
                }
                if (!identityLinkEntity.getUserId().equals(this.userId) || !HussarUtils.isEmpty((Object)identityLinkEntity.getMandator())) continue;
                newIdentityLink = identityLinkEntity;
                break;
            }
            if (HussarUtils.isNotEmpty(newIdentityLink)) {
                if (HussarUtils.isEmpty((Object)newIdentityLink.getMandator())) {
                    Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(newIdentityLink, true);
                    taskEntity.addCandidateUser(this.mandatary, this.userId, "2");
                    this.dataPushService.transferDataPush((Task)taskEntity, this.userId, this.mandatary, this.userId);
                } else {
                    Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(newIdentityLink, true);
                    taskEntity.addCandidateUser(this.mandatary, newIdentityLink.getMandator(), "2");
                    this.dataPushService.transferDataPush((Task)taskEntity, newIdentityLink.getMandator(), this.mandatary, this.userId);
                }
            }
        }
        ArrayList<String> mandataryList = new ArrayList<String>();
        mandataryList.add(this.mandatary);
        this.messagePush(taskEntity, mandataryList);
        return null;
    }

    private void messagePush(TaskEntity taskEntity, List<String> users) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        bpmActMsgDetail.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        bpmActMsgDetail.setProcessName(taskEntity.getProcessInstance().getProcessDefinition().getName());
        bpmActMsgDetail.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        bpmActMsgDetail.setTaskDefKey(taskEntity.getTaskDefinitionKey());
        bpmActMsgDetail.setTaskDefName(taskEntity.getName());
        bpmActMsgDetail.setReceive(users);
        bpmActMsgDetail.setChannelType(null);
        bpmActMsgDetail.setSceneCode("todo");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskEntity.getProcessInstanceId()).singleResult();
        bpmActMsgDetail.setProcessTitle(historicProcessInstance.getProcessTitle());
        bpmActMsgDetail.setDataDetail(historicProcessInstance.getDataDetail());
        String formKey = taskEntity.getFormKey();
        String webFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("web"));
        String mobileFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("mobile"));
        bpmActMsgDetail.setWebFormAddress(webFormKey);
        bpmActMsgDetail.setMobileFormAddress(mobileFormKey);
        bpmActMsgDetail.setBusinessId(taskEntity.getProcessInstance().getBusinessKey());
        bpmActMsgDetail.setTaskId(taskEntity.getId());
        Model model = (Model)this.repositoryService.createModelQuery().modelKey(taskEntity.getProcessDefinitionId().split(":")[0]).singleResult();
        bpmActMsgDetail.setPortalAppId(model.getAppId());
        bpmActMsgDetail.setFormId(taskEntity.getFormId());
        bpmActMsgDetail.setProcessInstanceId(taskEntity.getProcessInstanceId());
        bpmActMsgDetail.setTabType("2");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }
}

