/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.vo.SysActUrgeTaskVo;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActUrgeTaskServiceImpl
extends HussarServiceImpl<SysActUrgeTaskMapper, SysActUrgeTask>
implements ISysActUrgeTaskService {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DataPushService dataPushService;
    @Resource
    private HistoryService historyService;
    private static final Logger logger = LoggerFactory.getLogger(SysActUrgeTaskServiceImpl.class);
    @Autowired
    private BpmMsgPushService msgPushService;
    @Resource
    private RepositoryService repositoryService;

    public ApiResponse<Page<SysActUrgeTaskVo>> query(Page<SysActUrgeTaskVo> pages, String userId, String processKey, String sendUser, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActUrgeTaskVo> sysActUrgeTasksVo = this.sysActUrgeTaskMapper.query(pages, userId, processKey, sendUser, start, end);
        if (sysActUrgeTasksVo != null && !sysActUrgeTasksVo.isEmpty()) {
            ArrayList users = new ArrayList();
            sysActUrgeTasksVo.forEach(sysActUrgeTask -> {
                users.add(sysActUrgeTask.getSendUser());
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTask.getOwner())) {
                    users.add(sysActUrgeTask.getOwner());
                }
            });
            Map map = this.iAssigneeChooseService.getUserListByUserId(users);
            for (SysActUrgeTaskVo sysActUrgeTaskVo : sysActUrgeTasksVo) {
                String userName = (String)map.get(sysActUrgeTaskVo.getSendUser());
                sysActUrgeTaskVo.setSendUserName(userName);
                String formKey = sysActUrgeTaskVo.getFormKey();
                if (HussarUtils.isNotEmpty((Object)sysActUrgeTaskVo.getOwner())) {
                    sysActUrgeTaskVo.setTaskId(sysActUrgeTaskVo.getTaskId() + ":" + sysActUrgeTaskVo.getOwner());
                    sysActUrgeTaskVo.setTaskName(sysActUrgeTaskVo.getTaskName() + "(" + (String)map.get(sysActUrgeTaskVo.getOwner()) + ")");
                }
                if (!HussarUtils.isNotEmpty((Object)formKey)) continue;
                JSONObject object = JSON.parseObject((String)formKey);
                sysActUrgeTaskVo.setWeb(object.getString("web"));
                sysActUrgeTaskVo.setMobile(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActUrgeTasksVo);
        return ApiResponse.success(pages);
    }

    public String urgeTask(String processInsId, String taskId, String userId) {
        if (HussarUtils.isEmpty((Object)processInsId)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessInsIdNull());
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessEndUrgeFail());
        }
        this.urgeTodoTask(processInstance, processInsId, taskId, userId);
        this.recursiveUrgeSubProcess(processInsId, userId);
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    public String saveByProcessInsIdOrBusinessId(String processInsId, String businessId, String userId) {
        ProcessInstance processInstance = null;
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        } else {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (processInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotProcessInstance());
        }
        this.urgeTodoTask(processInstance, processInstance.getProcessInstanceId(), null, userId);
        this.recursiveUrgeSubProcess(processInstance.getProcessInstanceId(), userId);
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    private void recursiveUrgeSubProcess(String processInsId, String userId) {
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInsId).list();
        for (ProcessInstance processInstance : processInstanceList) {
            this.urgeTodoTask(processInstance, processInstance.getProcessInstanceId(), null, userId);
            this.recursiveUrgeSubProcess(processInstance.getProcessInstanceId(), userId);
        }
    }

    private void urgeTodoTask(ProcessInstance processInstance, String processInsId, String taskId, String userId) {
        if (taskId != null) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).taskId(taskId)).singleResult();
            if (historicTaskInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            if (TaskType.isAssist((String)historicTaskInstance.getTaskType())) {
                throw new PublicClientException(this.bpmConstantProperties.getAssistTaskForbidUrge());
            }
        }
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).includeTaskLocalVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        int urgeTaskNum = 0;
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (Task task : tasks) {
            if (taskId != null && !taskId.equals(task.getCreateHistoryTaskId()) || taskId == null && task.getCreateHistoryTaskId() != null) continue;
            taskIds.add(Long.valueOf(task.getId()));
            ++urgeTaskNum;
            Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
            if (identityLinks.isEmpty()) continue;
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                Map map = task.getTaskLocalVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (taskId != null && urgeTaskNum == 0) {
            throw new PublicClientException(this.bpmConstantProperties.getUrgeFinishAssistTask());
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            this.sysActUrgeTaskMapper.updateRuTaskUrgeState(taskIds);
            HistoricProcessInstance hisProcInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            for (Task task : tasks) {
                BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
                Set users = this.getAssigneeByTaskId(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                bpmActMsgDetail.setProcessName(processInstance.getProcessDefinitionName());
                bpmActMsgDetail.setProcessKey(processInstance.getProcessDefinitionKey());
                bpmActMsgDetail.setProcessDefinitionId(processInstance.getProcessDefinitionId());
                bpmActMsgDetail.setTaskDefName(task.getName());
                bpmActMsgDetail.setTaskDefKey(task.getTaskDefinitionKey());
                bpmActMsgDetail.setReceive(new ArrayList(users));
                bpmActMsgDetail.setSceneCode("reminders");
                bpmActMsgDetail.setProcessTitle(hisProcInst.getProcessTitle());
                bpmActMsgDetail.setDataDetail(hisProcInst.getDataDetail());
                String formKey = task.getFormKey();
                String webFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("web"));
                String mobileFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("mobile"));
                bpmActMsgDetail.setWebFormAddress(webFormKey);
                bpmActMsgDetail.setMobileFormAddress(mobileFormKey);
                bpmActMsgDetail.setBusinessId(processInstance.getBusinessKey());
                bpmActMsgDetail.setTaskId(task.getId());
                Model model = (Model)this.repositoryService.createModelQuery().modelKey(processInstance.getProcessDefinitionKey()).singleResult();
                bpmActMsgDetail.setPortalAppId(model.getAppId());
                bpmActMsgDetail.setFormId(task.getFormId());
                bpmActMsgDetail.setProcessInstanceId(task.getProcessInstanceId());
                bpmActMsgDetail.setTabType("2");
                bpmActMsgDetailList.add(bpmActMsgDetail);
                if (users.isEmpty() || !this.dataPushService.isDataPush()) continue;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setUrgeUserId(userId);
                dataPush.setUrgeTime(new Date());
                this.dataPushService.addUrgeTask(dataPush);
            }
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
    }

    public String urgeTaskByTaskId(String taskId, String userId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "1");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(Long.parseLong(taskId));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Collection<IdentityLink> identityLinks = this.getAssigneeByTaskId(task.getId());
        if (!identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActUrgeTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(identityLink.getUserId());
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                sysActUrgeTask.setTaskState(identityLink.getTaskState());
                sysActUrgeTask.setOwner(identityLink.getMandator());
                Map map = task.getTaskLocalVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (!list.isEmpty()) {
            this.saveBatch(list);
            this.sysActUrgeTaskMapper.updateRuTaskUrgeState(taskIds);
            HistoricProcessInstance hisProcInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            Set users = this.getAssigneeByTaskId(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
            bpmActMsgDetail.setProcessName(processInstance.getProcessDefinitionName());
            bpmActMsgDetail.setProcessKey(processInstance.getProcessDefinitionKey());
            bpmActMsgDetail.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            bpmActMsgDetail.setTaskDefName(task.getName());
            bpmActMsgDetail.setTaskDefKey(task.getTaskDefinitionKey());
            bpmActMsgDetail.setReceive(new ArrayList(users));
            bpmActMsgDetail.setSceneCode("reminders");
            bpmActMsgDetail.setProcessTitle(hisProcInst.getProcessTitle());
            bpmActMsgDetail.setDataDetail(hisProcInst.getDataDetail());
            String formKey = task.getFormKey();
            String webFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("web"));
            String mobileFormKey = String.valueOf(((Map)JSON.parseObject((String)formKey, Map.class)).get("mobile"));
            bpmActMsgDetail.setWebFormAddress(webFormKey);
            bpmActMsgDetail.setMobileFormAddress(mobileFormKey);
            bpmActMsgDetail.setBusinessId(processInstance.getBusinessKey());
            bpmActMsgDetail.setTaskId(task.getId());
            Model model = (Model)this.repositoryService.createModelQuery().modelKey(processInstance.getProcessDefinitionKey()).singleResult();
            bpmActMsgDetail.setPortalAppId(model.getAppId());
            bpmActMsgDetail.setFormId(task.getFormId());
            bpmActMsgDetail.setProcessInstanceId(task.getProcessInstanceId());
            bpmActMsgDetail.setTabType("2");
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
            if (this.dataPushService.isDataPush()) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", identityLinks.stream().map(IdentityLink::getUserId).collect(Collectors.toSet())));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setUrgeUserId(userId);
                dataPush.setUrgeTime(new Date());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    private Collection<IdentityLink> getAssigneeByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }
}

