/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysFormHandleAuthService")
public class SysActHandleAuthServiceImpl
extends ServiceImpl<SysActHandleAuthMapper, SysActHandleAuth>
implements SysActHandleAuthService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ITaskEngineService taskEngineService;

    public BpmResponseResult queryHandleAuthConfigs(String processKey, String taskDefinitionKey, String processVersion, String taskId, String formType) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.fail((String)"");
        }
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (HussarUtils.isNotEmpty((Object)definitionModel)) {
                processVersion = definitionModel.getVersion();
            }
            list = this.sysActHandleAuthMapper.getHandleAuthWithoutRunning(processKey, processVersion);
        } else {
            String procDefId = this.taskEngineService.getProcessIdByTaskId(taskId).getMsg();
            processVersion = procDefId.split(":")[1];
            list = this.sysActHandleAuthMapper.getHandleAuthByTaskId(taskId, processVersion);
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            if (HussarUtils.isEmpty((Object)taskId) && ("EndProcess".equals(sysActHandleAuth.getHandleType()) || "EntrustTask".equals(sysActHandleAuth.getHandleType())) || ("2".equals(formType) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(formType) && !"Revoke".equals(sysActHandleAuth.getHandleType()))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)sysActHandleAuth.getProcessVersion());
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonObject.put("extendConfiguration", (Object)sysActHandleAuth.getExtendConfiguration());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.success((JSONArray)jsonArray);
    }
}

