/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActAssigneeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysActAssigneeService")
public class SysActAssigneeServiceImpl
extends HussarServiceImpl<SysActAssigneeMapper, SysActAssignee>
implements SysActAssigneeService {
    @Resource
    SysActAssigneeMapper sysActAssigneeMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;

    public Map<String, String> getAssignee(String procDefKey, String taskDefKey, int type, List<String> messageType, String processVersion) {
        List list;
        ArrayList<String> contentTypeList;
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return null;
        }
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        if (HussarUtils.isBlank((CharSequence)processVersion)) {
            List<ProcessDefinitionModel> list2 = this.processDefinitionsMapper.getProcessMainOrNew(procDefKey);
            processDefinitionModel = list2.get(0);
            processVersion = processDefinitionModel.getVersion();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList result = new ArrayList();
        if (type == 1) {
            contentTypeList = new ArrayList<String>();
            contentTypeList.add("defaultCcAssign");
            contentTypeList.add("conditionCcAssign");
            list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey)).eq(SysActAssignee::getProcessVersion, (Object)processVersion));
            if (HussarUtils.isNotEmpty((Object)list)) {
                result.addAll(list);
            }
        } else if (type == 2) {
            contentTypeList = new ArrayList();
            contentTypeList.add("defaultCallAssignee");
            contentTypeList.add("defaultCallProcessKey");
            contentTypeList.add("conditionCallAssign");
            contentTypeList.add("conditionCallProcessKey");
            list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey)).eq(SysActAssignee::getProcessVersion, (Object)processVersion));
            if (HussarUtils.isNotEmpty((Object)list)) {
                result.addAll(list);
            }
        } else if (type == 3) {
            contentTypeList = new ArrayList();
            contentTypeList.add("defaultCcEndAssign");
            contentTypeList.add("conditionCcEndAssign");
            list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey)).eq(SysActAssignee::getProcessVersion, (Object)processVersion));
            if (HussarUtils.isNotEmpty((Object)list)) {
                result.addAll(list);
            }
        } else {
            contentTypeList = new ArrayList();
            contentTypeList.add("defaultAssign");
            contentTypeList.add("conditionAssign");
            list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey)).eq(SysActAssignee::getProcessVersion, (Object)processVersion));
            if (HussarUtils.isNotEmpty((Object)list)) {
                result.addAll(list);
            }
            if (messageType != null && HussarUtils.isNotEmpty((Object)list)) {
                for (SysActAssignee sysActAssignee : list) {
                    messageType.add(sysActAssignee.getMessageType());
                }
            }
        }
        for (SysActAssignee modelAssignee : result) {
            map.put(modelAssignee.getContentType(), modelAssignee.getContent() == null ? "" : new String(modelAssignee.getContent(), StandardCharsets.UTF_8));
        }
        return map;
    }

    public Map<String, String> getCcEndAssignee(String procDefKey, String taskDefKey) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList result = new ArrayList();
        List defaultCcAssign = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getContentType, (Object)"defaultCcEndAssign")).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey));
        List conditionCcAssion = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getContentType, (Object)"conditionCcEndAssign")).eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey));
        if (HussarUtils.isNotEmpty((Object)defaultCcAssign)) {
            result.addAll(defaultCcAssign);
        }
        if (HussarUtils.isNotEmpty((Object)conditionCcAssion)) {
            result.addAll(conditionCcAssion);
        }
        for (SysActAssignee modelAssignee : result) {
            map.put(modelAssignee.getContentType(), modelAssignee.getContent() == null ? "" : new String(modelAssignee.getContent(), StandardCharsets.UTF_8));
        }
        return map;
    }

    public void delAssignee(String processKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)processKey);
        this.sysActAssigneeMapper.delete((Wrapper)queryWrapper);
    }

    public BpmResponseResult getAssigneeModel(String procDefKey, String taskDefKey, String version) {
        JSONArray json = new JSONArray();
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        if (HussarUtils.isBlank((CharSequence)version)) {
            List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(procDefKey);
            processDefinitionModel = list.get(0);
            version = processDefinitionModel.getVersion();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)procDefKey);
        queryWrapper.eq(SysActAssignee::getProcessVersion, (Object)version);
        ArrayList<String> list = new ArrayList<String>();
        list.add("assign_model");
        list.add("cc_assign_model");
        queryWrapper.in(SysActAssignee::getContentType, list);
        if (HussarUtils.isNotEmpty((Object)taskDefKey)) {
            queryWrapper.eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey);
        }
        List results = this.sysActAssigneeMapper.selectList((Wrapper)queryWrapper);
        for (SysActAssignee modelAssignee : results) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)modelAssignee.getContentType());
            jsonObject.put("taskDefKey", (Object)modelAssignee.getTaskDefKey());
            jsonObject.put("model", JSON.toJSON((Object)new String(modelAssignee.getContent(), StandardCharsets.UTF_8)));
            json.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public boolean copyAssignee(String processKey, String oldProcessKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)oldProcessKey));
        for (SysActAssignee sysActAssignee : list) {
            sysActAssignee.setId(null);
            sysActAssignee.setProcDefKey(processKey);
        }
        return this.saveBatch(list);
    }

    public BpmResponseResult getProcessAssignee(String procDefKey, String processVersion) {
        JSONArray json = new JSONArray();
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getContentType, (Object)"assign_model");
        ((LambdaQueryWrapper)ccQueryWrapper.eq(SysActAssignee::getProcDefKey, (Object)procDefKey)).eq(SysActAssignee::getContentType, (Object)"cc_assign_model");
        if (HussarUtils.isNotEmpty((Object)processVersion)) {
            queryWrapper.eq(SysActAssignee::getProcessVersion, (Object)processVersion);
            ccQueryWrapper.eq(SysActAssignee::getProcessVersion, (Object)processVersion);
        }
        list = this.sysActAssigneeMapper.selectList((Wrapper)queryWrapper);
        list.addAll(this.sysActAssigneeMapper.selectList((Wrapper)ccQueryWrapper));
        for (SysActAssignee sysAssignee : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("taskDefKey", (Object)sysAssignee.getTaskDefKey());
            jsonObject.put("model", JSON.toJSON((Object)new String(sysAssignee.getContent(), StandardCharsets.UTF_8)));
            jsonObject.put("type", (Object)sysAssignee.getContentType());
            json.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }
}

