/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    private DataPushService dataPushService;
    private static Logger logger = LogManager.getLogger(TaskCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String assignee = taskEntity.getAssignee();
        if (assignee == null) {
            HistoricTaskInstanceEntity historicTaskInstanceEntity = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(taskEntity.getId());
            assignee = historicTaskInstanceEntity.getAssignee();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)Long.valueOf(taskEntity.getProcessInstanceId()))).eq(SysActCcTask::getTaskDefKey, (Object)taskEntity.getTaskDefinitionKey())).eq(SysActCcTask::getReceiveUser, (Object)assignee);
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (sysActCcTask != null) {
            sysActCcTask.setEndTime(new Timestamp(System.currentTimeMillis()));
            sysActCcTask.setTaskState("1");
            this.sysActCcTaskMapper.updateById(sysActCcTask);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setUserId(assignee);
                dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
                dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                this.dataPushService.readCcTask(dataPush);
            }
        }
        if ("1".equals(taskEntity.getUrgeState())) {
            this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
        }
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

