/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.websocket.service;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/api/websocket/{sid}")
public class WebSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServer.class);
    private static ISysActUrgeTaskService sysActUrgeTaskService = (ISysActUrgeTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActUrgeTaskService.class);
    private static int onlineCount = 0;
    private static CopyOnWriteArraySet<WebSocketServer> webSocketSet = new CopyOnWriteArraySet();
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        this.sid = sid;
        WebSocketServer.addOnlineCount();
        logger.info("open\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid + ",\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a:" + WebSocketServer.getOnlineCount());
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        WebSocketServer.subOnlineCount();
        logger.info("close\u91ca\u653e\u7684sid\u4e3a\uff1a" + this.sid);
        logger.info("close\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff01\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a" + WebSocketServer.getOnlineCount());
    }

    @OnMessage
    public void onMessage(String dataJsonString, Session session) {
        JSONObject jsonObject = JSONObject.parseObject((String)dataJsonString);
        String userId = jsonObject.getString("userId");
        String type = jsonObject.getString("type");
        logger.info("onMessage\u6536\u5230\u6765\u81ea\u7a97\u53e3" + userId + "\u7684\u4fe1\u606f:userId===={},type======{}", (Object)userId, (Object)type);
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        Map<String, Map<String, Object>> userCount = WebSocketServer.getUserTodoAndUrgeCount(userIds);
        if (HussarUtils.isNotEmpty(userCount)) {
            for (WebSocketServer item : webSocketSet) {
                if (!item.sid.equals(userId)) continue;
                item.sendMessage(userCount.get(userId));
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.error("onError\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(Map data) {
        try {
            if (null != data) {
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonData = objectMapper.writeValueAsString((Object)data);
                this.session.getBasicRemote().sendText(jsonData);
            }
        }
        catch (Exception e) {
            logger.info("\u670d\u52a1\u5668\u4e3b\u52a8\u63a8\u52a8\u5ba2\u6237\u7aef\u6d88\u606f\u5f02\u5e38\uff1a========={}", (Object)e.getMessage());
        }
    }

    public static void sendInfo(Map data, @PathParam(value="sid") String sid) {
        logger.info("\u63a8\u9001\u6d88\u606f\u5230\u7a97\u53e3" + sid + "\uff0c\u63a8\u9001\u5185\u5bb9:" + data.toString());
        for (WebSocketServer item : webSocketSet) {
            if (sid == null || !item.sid.equals(sid)) continue;
            item.sendMessage(data);
        }
    }

    public static void workFlowTask() {
        if (sysActUrgeTaskService.isWebSocket().booleanValue()) {
            HashSet<String> userIdList = new HashSet<String>();
            for (WebSocketServer item : webSocketSet) {
                userIdList.add(item.sid);
            }
            Map<String, Map<String, Object>> userCountMap = WebSocketServer.getUserTodoAndUrgeCount(userIdList);
            if (HussarUtils.isNotEmpty(userCountMap)) {
                for (WebSocketServer item : webSocketSet) {
                    item.sendMessage(userCountMap.get(item.sid));
                }
            }
        }
    }

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }

    public static CopyOnWriteArraySet<WebSocketServer> getWebSocketSet() {
        return webSocketSet;
    }

    public static Map<String, Map<String, Object>> getUserTodoAndUrgeCount(Set<String> userIds) {
        if (HussarUtils.isNotEmpty(userIds)) {
            List todoTaskList = sysActUrgeTaskService.getTodoTaskCountByUser(userIds);
            List UrgeTaskList = sysActUrgeTaskService.getUrgeTaskCountByUser(userIds);
            HashMap<String, Map<String, Object>> userCount = new HashMap<String, Map<String, Object>>();
            for (Map todo : todoTaskList) {
                for (Map urge : UrgeTaskList) {
                    if (!todo.get("userId").equals(urge.get("userId"))) continue;
                    urge.put("pending", null == todo.get("pending") ? Integer.valueOf(0) : todo.get("pending"));
                    urge.put("reminder", null == urge.get("reminder") ? Integer.valueOf(0) : urge.get("reminder"));
                    userCount.put(String.valueOf(todo.get("userId")), urge);
                }
            }
            return userCount;
        }
        return null;
    }
}

