/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.variable.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dao.ProcessBetaMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.ProcessBetaService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessBetaServiceImpl
implements ProcessBetaService {
    @Resource
    private ProcessBetaMapper processBetaMapper;
    @Autowired
    private ProcessDiagramService processDiagramService;
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ModelService modelService;

    public IPage<ProcessInst> getProcessBetaList(Page<ProcessInst> page, ProcessListDto processListDto) {
        List<ProcessInst> instList = this.processBetaMapper.getListMySql(page, processListDto);
        HashSet<Long> procInstIds = new HashSet<Long>();
        for (ProcessInst processInst : instList) {
            procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
        }
        if (!instList.isEmpty()) {
            List<ProcessInstVo> nodeList = this.processBetaMapper.getNodeNames(procInstIds);
            HashMap<Long, Set> nodeMap = new HashMap<Long, Set>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = 0L;
                procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            for (ProcessInst processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.parseLong(processInst.getProcessInsId()));
                if (nodeNames != null && !nodeNames.isEmpty()) {
                    processInst.setNames(String.join((CharSequence)",", nodeNames));
                }
                if (processInst.getInstanceFlag() != null && !processInst.getInstanceFlag().equals("")) {
                    processInst.setInstanceFlag("1");
                    continue;
                }
                processInst.setInstanceFlag("0");
            }
        }
        page.setRecords(instList);
        return page;
    }

    public Map<String, Object> list(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        Map result = this.processDiagramService.list(processInsId, businessId, subProcessKey, cycleCount);
        JSONArray jsonArray = (JSONArray)result.get("data");
        for (Object json : jsonArray) {
            JSONArray nodeArray = (JSONArray)((JSONObject)json).get((Object)"subProcessTask");
            String activityId = (String)((JSONObject)json).get((Object)"activityId");
            if (nodeArray == null) continue;
            JSONObject instanceObject = new JSONObject();
            JSONArray newInstanceArray = new JSONArray();
            instanceObject.put("activityId", (Object)activityId);
            instanceObject.put("activityName", (Object)"\u5b9e\u4f8b1");
            instanceObject.put("subProcessTask", (Object)nodeArray);
            newInstanceArray.add((Object)instanceObject);
            ((JSONObject)json).put("subProcessTask", (Object)newInstanceArray);
        }
        return result;
    }

    public ApiResponse<JSONObject> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramService.getProcessInfoForProcessTesting(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONObject getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramService.getProcessInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramService.getProcessCompleteInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        return this.processDiagramService.getSubProcessRunningInfoForProcessTesting(processInsId, businessId);
    }

    public JSONObject getSubProcessRunningInfo(String processInsId, String businessId) {
        return this.processDiagramService.getSubProcessRunningInfo(processInsId, businessId);
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        return this.processDiagramService.subProcessList(supProcessInsId, businessId, taskDefinitionKey, page, size);
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        this.variableService.removeById((Serializable)((Object)processInstCode));
        return this.processInstService.deleteFinishedProcessInstance(processInstCode);
    }

    public ApiResponse<String> deleteProcessInstance(String processInsId) {
        this.variableService.removeById((Serializable)((Object)processInsId));
        String processDefinitionId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()).getProcessDefinitionId();
        ApiResponse result = this.processInstService.deleteProcessInstance(processInsId);
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processDefinitionId).list();
        if (HussarUtils.isEmpty((Object)processInstances)) {
            result = this.modelService.deleteModelWithVersionByProcessTesting(processDefinitionId);
        }
        return result;
    }
}

