/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtesting.util;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.workflow.engine.bpm.node.dto.NodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.node.service.NodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.node.vo.NodeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredInstanceVariableDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableHandler {
    private AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess;
    private Map<String, Map<String, List<NodeDto>>> mappingFromProcessOnlyIdToNodeMapping;
    private Map<String, String> mappingFromProcessOnlyIdToProcessKey;
    private Set<String> visitedNodeOnlyIdWithCompleteTask = new HashSet<String>();
    private Set<String> visitedNodeOnlyIdWithGenerateToDoTask = new HashSet<String>();
    private Set<String> visitedProcessOnlyId = new HashSet<String>();
    private Map<String, String> mappingFromBusinessIdToProcessOnlyId = new HashMap<String, String>();
    private NodeDto completingNode;
    @Autowired
    private VariableService variableService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SeqBuilder seqBuilder;

    public Map<String, Object> visit(String businessId, String nodeId, String processKey) {
        String processOnlyId = this.getProcessOnlyIdBy(businessId);
        List<NodeDto> currentNodes = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nodeId);
        if (nodeId.equals(this.completingNode.getKey())) {
            return this.visitMainProcessNodeWithCompleteTask(processKey, processOnlyId);
        }
        return this.visitMainProcessNodeWithGenerateToDoTask(currentNodes, processKey, processOnlyId);
    }

    private Map<String, Object> visitMainProcessNodeWithCompleteTask(String processKey, String processOnlyId) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.putAll(this.findNodeVariableBy(this.completingNode, processKey, processOnlyId));
        variable.putAll(this.findPathVariableBy(this.completingNode.getKey(), processKey, processOnlyId));
        return variable;
    }

    private Map<String, Object> visitMainProcessNodeWithGenerateToDoTask(List<NodeDto> currentNodes, String processKey, String processOnlyId) {
        for (NodeDto currentNode : currentNodes) {
            String nodeOnlyId = currentNode.getOnlyId();
            String completingNodeSeparate = this.completingNode.getSeparateVariable() == null ? "" : this.completingNode.getSeparateVariable().split(":")[0];
            String currentNodeSeparate = currentNode.getSeparateVariable() == null ? "" : currentNode.getSeparateVariable().split(":")[0];
            HashMap<String, Object> variable = new HashMap<String, Object>();
            if (this.completingNode.isInternalNode() && currentNode.isInternalNode()) {
                if (!completingNodeSeparate.equals(currentNodeSeparate)) continue;
                variable.putAll(this.findNodeVariableBy(currentNode, processKey, processOnlyId));
                return variable;
            }
            if (this.visitedNodeOnlyIdWithGenerateToDoTask.contains(nodeOnlyId)) continue;
            this.visitedNodeOnlyIdWithGenerateToDoTask.add(nodeOnlyId);
            variable.putAll(this.findNodeVariableBy(currentNode, processKey, processOnlyId));
            return variable;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> findExternalSubProcessNodeVariable(NodeDto node) {
        Map mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess = this.variableService.groupAllVariablesConfiguredInProcessByProcessOnlyId(this.allVariablesConfiguredInProcess);
        HashMap<String, Object> mappingFromNodeIdToCallActivityInfos = new HashMap<String, Object>();
        ArrayList<CallActivityInfo> list = new ArrayList<CallActivityInfo>();
        List bindingProcessOnlyIds = node.getBindingProcessOnlyIds();
        for (String bindingProcessOnlyId : bindingProcessOnlyIds) {
            AllVariablesConfiguredInProcessVo currentAllVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.get(bindingProcessOnlyId);
            String businessId = this.generateBusinessKey();
            CallActivityInfo callActivityInfo = new CallActivityInfo();
            callActivityInfo.setBusinessId(businessId);
            callActivityInfo.setVariable(this.findSubProcessVariableBy(currentAllVariablesConfiguredInProcess));
            callActivityInfo.setTesting(true);
            list.add(callActivityInfo);
            this.bindProcessOnlyIdToBusinessId(businessId, bindingProcessOnlyId);
        }
        mappingFromNodeIdToCallActivityInfos.put(node.getKey(), list);
        return mappingFromNodeIdToCallActivityInfos;
    }

    private String generateBusinessKey() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    public Map<String, Object> findSubProcessVariableBy(AllVariablesConfiguredInProcessVo currentAllVariablesConfiguredInProcess) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Map<String, List<NodeDto>> mappingFromNodeKeyToNode = this.mappingFromProcessOnlyIdToNodeMapping.get(currentAllVariablesConfiguredInProcess.getOnlyId());
        ArrayList firstNode = new ArrayList();
        mappingFromNodeKeyToNode.forEach((k, v) -> v.forEach(n -> {
            if (n.isFirstNode()) {
                firstNode.add(n);
            }
        }));
        List configuredInstanceVariables = currentAllVariablesConfiguredInProcess.getConfiguredInstanceVariables();
        for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
            if (!configuredInstanceVariable.isProcessVariable()) continue;
            variables.putAll(this.variableService.findVariablesBy(this.allVariablesConfiguredInProcess, currentAllVariablesConfiguredInProcess.getProcessKey(), currentAllVariablesConfiguredInProcess.getOnlyId(), null));
            break;
        }
        variables.putAll(currentAllVariablesConfiguredInProcess.getBindingVariablesFromMainProcess());
        variables.putAll(this.nodeService.findVariablesBy((NodeDto)firstNode.get(0)));
        return variables;
    }

    public Map<String, Object> findNodeVariableBy(NodeDto node, String processKey, String processOnlyId) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        variable.putAll(this.variableService.findVariablesBy(this.allVariablesConfiguredInProcess, processKey, processOnlyId, node.getKey()));
        variable.putAll(this.nodeService.findVariablesBy(node));
        return variable;
    }

    public Map<String, Object> findPathVariableBy(String nodeKey, String processKey, String processOnlyId) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        Map mappingFromInstanceKeyToConfiguredInstanceVariable = this.variableService.groupConfiguredInstanceVariableByInstanceKey(this.allVariablesConfiguredInProcess, processKey);
        if (mappingFromInstanceKeyToConfiguredInstanceVariable.get(nodeKey) != null) {
            List nextPaths = ((ConfiguredInstanceVariableDto)mappingFromInstanceKeyToConfiguredInstanceVariable.get(nodeKey)).getNextPathKeys();
            for (String nextPath : nextPaths) {
                variable.putAll(this.variableService.findVariablesBy(this.allVariablesConfiguredInProcess, processKey, processOnlyId, nextPath));
            }
        }
        return variable;
    }

    public void setAllVariablesConfiguredInProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        this.allVariablesConfiguredInProcess = allVariablesConfiguredInProcess;
    }

    public void setMappingFromProcessOnlyIdToProcessKey(List<NodeVo> processNodes) {
        this.mappingFromProcessOnlyIdToProcessKey = new HashMap<String, String>();
        processNodes.forEach(processNode -> this.mappingFromProcessOnlyIdToProcessKey.put(processNode.getOnlyId(), processNode.getProcessKey()));
    }

    public void setNodeMapping(List<NodeVo> processNodes) {
        Map<String, List<NodeVo>> mappingFromProcessOnlyIdToProcessNode = this.groupProcessNodeByProcessOnlyId(processNodes);
        this.mappingFromProcessOnlyIdToNodeMapping = new HashMap<String, Map<String, List<NodeDto>>>();
        for (Map.Entry<String, List<NodeVo>> item : mappingFromProcessOnlyIdToProcessNode.entrySet()) {
            NodeVo processNode = item.getValue().get(0);
            Map<String, List<NodeDto>> mappingFromNodeKeyToNode = this.groupNodeByNodeKey(processNode);
            this.mappingFromProcessOnlyIdToNodeMapping.put(item.getKey(), mappingFromNodeKeyToNode);
        }
    }

    private Map<String, List<NodeVo>> groupProcessNodeByProcessOnlyId(List<NodeVo> processNodes) {
        return processNodes.stream().collect(Collectors.groupingBy(processNode -> processNode.getOnlyId(), Collectors.toList()));
    }

    private Map<String, List<NodeDto>> groupNodeByNodeKey(NodeVo processNode) {
        List nodes = processNode.getNodes();
        return this.nodeService.groupNodeByKey(nodes);
    }

    public List<NodeDto> listNodesBy(String processOnlyId, String nodeKey) {
        return this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nodeKey);
    }

    public void bindProcessOnlyIdToBusinessId(String business, String processOnlyId) {
        this.mappingFromBusinessIdToProcessOnlyId.put(business, processOnlyId);
    }

    public void clearBind() {
        this.mappingFromBusinessIdToProcessOnlyId.clear();
    }

    public void clearVisitedNodeOnlyIdWithCompleteTask() {
        this.visitedNodeOnlyIdWithCompleteTask.clear();
    }

    public void clearVisitedNodeOnlyIdWithGenerateToDoTask() {
        this.visitedNodeOnlyIdWithGenerateToDoTask.clear();
    }

    public void clearVisitedProcessOnlyId() {
        this.visitedProcessOnlyId.clear();
    }

    public String getProcessOnlyIdBy(String businessId) {
        return this.mappingFromBusinessIdToProcessOnlyId.get(businessId);
    }

    public void setCompletingNode(NodeDto completingNode) {
        this.completingNode = completingNode;
    }
}

