/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtesting.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiProcinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiProcinst;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.node.dto.NodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.node.service.NodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.node.vo.NodeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processtesting.service.ProcessTestingService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtesting.util.VariableHandler;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ProcessTestingServiceImpl
implements ProcessTestingService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessTestingServiceImpl.class);
    private List<NodeVo> processNodes;
    private Map<String, Map<String, List<NodeDto>>> mappingFromProcessOnlyIdToNodeMapping;
    private Map<String, List<String>> mappingFromNodeOnlyIdToAssignee;
    private Map<String, List<NodeDto>> mappingFromProcessOnlyIdToNodes;
    private Map<String, List<String>> visitedAssigneeMap = new HashMap<String, List<String>>();
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SeqBuilder seqBuilder;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmActHiProcinstMapper bpmActHiProcinstMapper;
    @Autowired
    private VariableHandler variableHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<JSONObject> testProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, List<NodeVo> processNodes) {
        ApiResponse apiResponse;
        this.variableHandler.setAllVariablesConfiguredInProcess(allVariablesConfiguredInProcess);
        this.variableHandler.setNodeMapping(processNodes);
        this.variableHandler.setMappingFromProcessOnlyIdToProcessKey(processNodes);
        this.neatenNodes(processNodes);
        this.generateNodeAndAssigneeMapping();
        JSONArray startTask = null;
        String mainProcessBusinessKey = null;
        try {
            String mainProcessKey = allVariablesConfiguredInProcess.getProcessKey();
            String mainProcessOnlyId = allVariablesConfiguredInProcess.getOnlyId();
            mainProcessBusinessKey = this.generateBusinessKey();
            startTask = this.startTestProcessInstance(mainProcessOnlyId, mainProcessKey, mainProcessBusinessKey);
            this.circularlyCompleteTask(startTask);
            String mainProcessProcessInstanceId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
            JSONObject jsonObject = this.assembleResult(mainProcessProcessInstanceId, mainProcessBusinessKey);
            apiResponse = ApiResponse.success((Object)jsonObject);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            if (HussarUtils.isNotEmpty(startTask)) {
                String mainProcessProcessInstanceId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
                JSONObject jsonObject = this.assembleResult(mainProcessProcessInstanceId, mainProcessBusinessKey);
                apiResponse = ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)jsonObject, (String)e.getMessage());
            } else {
                apiResponse = ApiResponse.fail((String)e.getMessage());
            }
        }
        catch (PublicClientException c) {
            logger.error(c.getMessage());
            if (HussarUtils.isNotEmpty(startTask)) {
                String mainProcessProcessInstanceId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
                JSONObject jsonObject = this.assembleResult(mainProcessProcessInstanceId, mainProcessBusinessKey);
                apiResponse = ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)jsonObject, (String)c.getMessage());
            } else {
                apiResponse = ApiResponse.fail((String)c.getMessage());
            }
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)startTask)) {
                String mainProcessProcessInstanceId = (String)((JSONObject)startTask.get(0)).get((Object)"processInsId");
                this.saveVariable(allVariablesConfiguredInProcess, mainProcessProcessInstanceId);
            }
            this.variableHandler.clearBind();
            this.variableHandler.clearVisitedNodeOnlyIdWithCompleteTask();
            this.variableHandler.clearVisitedNodeOnlyIdWithGenerateToDoTask();
            this.variableHandler.clearVisitedProcessOnlyId();
            this.visitedAssigneeMap.clear();
        }
        return apiResponse;
    }

    private void generateNodeAndAssigneeMapping() {
        List<String> processOnlyIds = this.findProcessOnlyIds();
        this.mappingFromProcessOnlyIdToNodeMapping = new HashMap<String, Map<String, List<NodeDto>>>();
        this.mappingFromNodeOnlyIdToAssignee = new HashMap<String, List<String>>();
        for (String processOnlyId : processOnlyIds) {
            this.generateNodeMapping(processOnlyId);
            this.generateAssigneeMapping(processOnlyId);
        }
    }

    private List<String> findProcessOnlyIds() {
        ArrayList<String> processOnlyIds = new ArrayList<String>();
        this.processNodes.forEach(processNode -> processOnlyIds.add(processNode.getOnlyId()));
        return processOnlyIds;
    }

    private void generateNodeMapping(String processOnlyId) {
        List<NodeDto> nodes = this.mappingFromProcessOnlyIdToNodes.get(processOnlyId);
        Map mappingFromNodeKeyToNodes = this.nodeService.groupNodeByKey(nodes);
        this.mappingFromProcessOnlyIdToNodeMapping.put(processOnlyId, mappingFromNodeKeyToNodes);
    }

    private void generateAssigneeMapping(String processOnlyId) {
        List<NodeDto> nodes = this.mappingFromProcessOnlyIdToNodes.get(processOnlyId);
        this.mappingFromNodeOnlyIdToAssignee.putAll(this.nodeService.groupAssigneeByNodeOnlyId(nodes));
    }

    private Map<String, List<String>> groupOnlyIdByProcessKey() {
        return this.processNodes.stream().collect(Collectors.groupingBy(processNode -> processNode.getProcessKey(), Collectors.mapping(processNode -> processNode.getOnlyId(), Collectors.toList())));
    }

    private void neatenNodes(List<NodeVo> processNodes) {
        this.processNodes = processNodes;
        this.mappingFromProcessOnlyIdToNodes = this.nodeService.parse(processNodes);
    }

    private JSONArray startTestProcessInstance(String mainProcessOnlyId, String processKey, String businessKey) throws BpmException {
        NodeDto startNode = this.findStartNode(mainProcessOnlyId);
        String starter = this.findIdsFrom(startNode.getAssignees()).size() == 0 ? String.valueOf(BaseSecurityUtil.getUser().getId()) : this.findIdsFrom(startNode.getAssignees()).get(0);
        String processDefinitionId = this.processDefinitionsService.getLatestTestProcessDefinitionId(processKey);
        this.variableHandler.setCompletingNode(startNode);
        Map<String, Object> variable = this.variableHandler.findNodeVariableBy(startNode, processKey, mainProcessOnlyId);
        variable.putAll(this.variableHandler.findPathVariableBy(startNode.getKey(), processKey, mainProcessOnlyId));
        this.variableHandler.bindProcessOnlyIdToBusinessId(businessKey, mainProcessOnlyId);
        BpmResponseResult startResult = InstanceEngineService.startProcessInstanceById((String)processDefinitionId, (String)starter, (String)businessKey, variable);
        if ("1".equals(startResult.getCode())) {
            return startResult.getResult();
        }
        throw new BpmException(startResult.getMsg(), processKey);
    }

    private String generateBusinessKey() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    private NodeDto findStartNode(String mainProcessOnlyId) {
        if (HussarUtils.isNotEmpty(this.mappingFromProcessOnlyIdToNodes)) {
            List<NodeDto> processNodes = this.mappingFromProcessOnlyIdToNodes.get(mainProcessOnlyId);
            return processNodes.get(0);
        }
        return null;
    }

    private List<String> findIdsFrom(List<BpmTreeModel> bpmTreeModels) {
        ArrayList<String> Ids = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : bpmTreeModels) {
            Ids.add(bpmTreeModel.getId());
        }
        return Ids;
    }

    private void circularlyCompleteTask(JSONArray startTask) throws BpmException {
        JSONObject currentTask;
        ArrayDeque todoTaskQueue = new ArrayDeque();
        ArrayList<JSONObject> tasks = new ArrayList<JSONObject>();
        String startTaskId = (String)((JSONObject)startTask.get(0)).get((Object)"taskId");
        startTask.forEach(t -> {
            todoTaskQueue.add((JSONObject)t);
            tasks.add((JSONObject)t);
        });
        while (!todoTaskQueue.isEmpty() && !HussarUtils.isEmpty((Object)(currentTask = (JSONObject)todoTaskQueue.peek()).get((Object)"taskId"))) {
            String processInstanceId = (String)currentTask.get((Object)"processInsId");
            String taskId = (String)currentTask.get((Object)"taskId");
            String businessId = this.getBusinessIdBy(processInstanceId);
            String processOnlyId = this.variableHandler.getProcessOnlyIdBy(businessId);
            String nodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
            String assigneeId = this.findAssigneeIdBy(currentTask, processOnlyId);
            if (startTaskId.equals(taskId) && HussarUtils.isEmpty((Object)assigneeId)) {
                assigneeId = String.valueOf(BaseSecurityUtil.getUser().getId());
            }
            currentTask = this.findTask(tasks, assigneeId, processOnlyId, nodeKey);
            String currentTaskId = (String)currentTask.get((Object)"taskId");
            Map<String, Object> variable = this.findNodeVariable(currentTask, processOnlyId);
            variable.putAll(this.findPathVariable(currentTask, processOnlyId));
            JSONArray nextTask = this.completeTask(currentTaskId, assigneeId, variable);
            this.addAssigneeToVisitedMap(currentTask, processOnlyId, businessId, assigneeId);
            todoTaskQueue.clear();
            tasks.clear();
            nextTask.forEach(t -> {
                todoTaskQueue.add((JSONObject)t);
                tasks.add((JSONObject)t);
            });
        }
    }

    private String getBusinessIdBy(String processInstanceId) {
        return ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getBusinessKey();
    }

    private JSONObject findTask(List<JSONObject> tasks, String assigneeId, String processOnlyId, String nodeKey) throws BpmException {
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nodeKey).get(0);
        for (JSONObject task : tasks) {
            HashSet userIds;
            if (!nodeKey.equals(task.get((Object)"taskDefinitionKey")) || (userIds = (HashSet)task.get((Object)"userId")) == null || !userIds.contains(assigneeId)) continue;
            return task;
        }
        if (assigneeId == null && !currentNode.isCountersign()) {
            throw new BpmException("\u8282\u70b9 " + currentNode.getName() + " \u672a\u6307\u5b9a\u529e\u7406\u4eba", null);
        }
        if (assigneeId == null && currentNode.isCountersign()) {
            throw new BpmException("\u4f1a\u7b7e\u8282\u70b9 " + currentNode.getName() + " \u6307\u5b9a\u7684\u529e\u7406\u4eba\u6570\u91cf\u4e0d\u6ee1\u8db3\u901a\u8fc7\u8981\u6c42", null);
        }
        throw new BpmException("\u8282\u70b9 " + currentNode.getName() + " \u65e0\u529e\u7406\u6743\u9650", null);
    }

    private Map<String, Object> findNodeVariable(JSONObject currentTask, String processOnlyId) {
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String subProcessKey = ((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(currentTaskId)).singleResult()).getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            String separateVariable = subProcessKey.split(":")[1].trim();
            return this.findInternalSubProcessNodeVariable(currentTask, separateVariable, processOnlyId);
        }
        return this.findMainProcessNodeVariable(currentTask, processOnlyId);
    }

    private Map<String, Object> findPathVariable(JSONObject currentTask, String processOnlyId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processKey = this.findProcessKeyBy(currentTaskId);
        return this.variableHandler.findPathVariableBy(currentNodeKey, processKey, processOnlyId);
    }

    private Map<String, Object> findInternalSubProcessNodeVariable(JSONObject currentTask, String separateVariable, String processOnlyId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processKey = this.findProcessKeyBy(currentTaskId);
        List<NodeDto> currentNodes = this.variableHandler.listNodesBy(processOnlyId, currentNodeKey);
        for (NodeDto currentNode : currentNodes) {
            if (!separateVariable.equals(currentNode.getSeparateVariable())) continue;
            this.variableHandler.setCompletingNode(currentNode);
            return this.variableHandler.findNodeVariableBy(currentNode, processKey, processOnlyId);
        }
        return new HashMap<String, Object>();
    }

    private Map<String, Object> findMainProcessNodeVariable(JSONObject currentTask, String processOnlyId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String businessId = this.getBusinessIdBy(processInstanceId);
        String processKey = this.findProcessKeyBy(currentTaskId);
        NodeDto currentNode = this.variableHandler.listNodesBy(processOnlyId, currentNodeKey).get(0);
        this.variableHandler.setCompletingNode(currentNode);
        Map<String, Object> variable = this.variableHandler.findNodeVariableBy(currentNode, processKey, processOnlyId);
        variable.putAll(this.findNextNodeVariableIfNextNodeIsExternalOrInternalSubProcessNode(currentNode, processOnlyId, businessId));
        return variable;
    }

    private String findProcessKeyBy(String taskId) {
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        String processDefinitionId = taskInstance.getProcessDefinitionId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return processDefinition.getKey();
    }

    private Map<String, Object> findNextNodeVariableIfNextNodeIsExternalOrInternalSubProcessNode(NodeDto node, String processOnlyId, String businessId) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        List nextNodeKeys = node.getNextNodeKey();
        HashMap<String, Object> mappingFromNodeIdToCallActivityInfos = new HashMap<String, Object>();
        for (String nextNodeKey : nextNodeKeys) {
            NodeDto nextNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(nextNodeKey).get(0);
            if (!this.isExternalSubProcessNode(nextNode)) continue;
            mappingFromNodeIdToCallActivityInfos.putAll(this.variableHandler.findExternalSubProcessNodeVariable(nextNode));
        }
        variable.put("call_activity_info", mappingFromNodeIdToCallActivityInfos);
        return variable;
    }

    private boolean isExternalSubProcessNode(NodeDto node) {
        return "com.jxdinfo.workflow.CallActivity".equals(node.getType());
    }

    private String findAssigneeIdBy(JSONObject currentTask, String processOnlyId) {
        return this.findMainAndInternalSubProcessAssigneeIdBy(currentTask, processOnlyId);
    }

    private String findMainAndInternalSubProcessAssigneeIdBy(JSONObject currentTask, String processOnlyId) {
        String assigneeId = null;
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        String currentTaskId = (String)currentTask.get((Object)"taskId");
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String businessId = this.getBusinessIdBy(processInstanceId);
        String subProcessKey = ((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(currentTaskId)).singleResult()).getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            String separateVariable = subProcessKey.split(":")[1].trim();
            assigneeId = this.findInternalSubProcessAssigneeIdBy(currentNodeKey, separateVariable, processOnlyId, businessId);
        } else {
            assigneeId = this.findMainProcessAssigneeIdBy(currentNodeKey, processOnlyId, businessId);
        }
        this.updateStarter(currentTask, assigneeId);
        return assigneeId;
    }

    private String findInternalSubProcessAssigneeIdBy(String currentNodeKey, String separateVariable, String processOnlyId, String businessId) {
        String assigneeId = null;
        List<NodeDto> internalSubProcessNodes = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey);
        if (internalSubProcessNodes.size() == 1) {
            NodeDto internalSubProcessNode = internalSubProcessNodes.get(0);
            String currentNodeOnlyId = internalSubProcessNode.getOnlyId();
            assigneeId = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId) == null || this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).size() == 0 ? null : this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).get(0);
        } else {
            for (NodeDto internalSubProcessNode : internalSubProcessNodes) {
                if (!separateVariable.equals(internalSubProcessNode.getSeparateVariable())) continue;
                String currentNodeOnlyId = internalSubProcessNode.getOnlyId();
                assigneeId = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId) == null || this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).size() == 0 ? null : this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId).get(0);
            }
        }
        return assigneeId;
    }

    private String findMainProcessAssigneeIdBy(String currentNodeKey, String processOnlyId, String businessId) {
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey).get(0);
        String currentNodeOnlyId = currentNode.getOnlyId();
        String assigneeId = null;
        if (HussarUtils.isNotEmpty(this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId))) {
            List<Object> visitedAssigneeIds = null;
            String businessAndNodeTag = businessId + ":" + currentNodeOnlyId;
            visitedAssigneeIds = HussarUtils.isNotEmpty(this.visitedAssigneeMap.get(businessAndNodeTag)) ? this.visitedAssigneeMap.get(businessAndNodeTag) : new ArrayList();
            List<String> assigneeIds = this.mappingFromNodeOnlyIdToAssignee.get(currentNodeOnlyId);
            for (String assId : assigneeIds) {
                if (visitedAssigneeIds.contains(assId)) continue;
                assigneeId = assId;
                break;
            }
        }
        return assigneeId;
    }

    private void updateStarter(JSONObject currentTask, String assigneeId) {
        String processInstanceId = (String)currentTask.get((Object)"processInsId");
        String startUserId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getStartUserId();
        if (HussarUtils.isEmpty((Object)startUserId)) {
            BpmActHiProcinst bpmActHiProcinst = (BpmActHiProcinst)((Object)this.bpmActHiProcinstMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BpmActHiProcinst::getId, (Object)processInstanceId)));
            bpmActHiProcinst.setStartUserId(assigneeId);
            this.bpmActHiProcinstMapper.updateById((Object)bpmActHiProcinst);
        }
    }

    private JSONArray completeTask(String currentTaskId, String assigneeId, Map<String, Object> variable) throws BpmException {
        BpmResponseResult bpmResponseResult = TaskEngineService.completeTask((String)currentTaskId, (String)assigneeId, new HashMap(), null, (String)"", variable);
        if (!"1".equals(bpmResponseResult.getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        return bpmResponseResult.getResult();
    }

    private void addAssigneeToVisitedMap(JSONObject currentTask, String processOnlyId, String businessId, String assigneeId) {
        String currentNodeKey = (String)currentTask.get((Object)"taskDefinitionKey");
        NodeDto currentNode = this.mappingFromProcessOnlyIdToNodeMapping.get(processOnlyId).get(currentNodeKey).get(0);
        String currentNodeOnlyId = currentNode.getOnlyId();
        List<String> visitedAssigneeIds = null;
        String businessAndNodeTag = businessId + ":" + currentNodeOnlyId;
        visitedAssigneeIds = HussarUtils.isNotEmpty(this.visitedAssigneeMap.get(businessAndNodeTag)) ? this.visitedAssigneeMap.get(businessAndNodeTag) : new ArrayList<String>();
        visitedAssigneeIds.add(assigneeId);
        this.visitedAssigneeMap.put(businessAndNodeTag, visitedAssigneeIds);
    }

    private void saveVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String mainProcessProcessInstanceId) {
        this.variableService.saveVariable(allVariablesConfiguredInProcess, mainProcessProcessInstanceId);
    }

    private JSONObject assembleResult(String processInstanceId, String businessId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mainProcessInstanceId", (Object)processInstanceId);
        jsonObject.put("mainProcessBusinessId", (Object)businessId);
        return jsonObject;
    }
}

