/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.node.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.node.dto.NodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.node.service.NodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.node.vo.NodeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredInstanceVariableDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredVariableDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowElements;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SequenceSourceTarget;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ExpressionFactory;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeServiceImpl
implements NodeService {
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private static final String INCLUSIVE_GATEWAY = "com.jxdinfo.workflow.Inclusive";
    private static final String EXCLUSIVE_GATEWAY = "com.jxdinfo.workflow.Exclusive";
    private static final String HAS_LOOP_ERROR_MESSAGE = "\u6d41\u7a0b\u4e2d\u5b58\u5728\u95ed\u73af";
    @Autowired
    private SysActProcessFileService processFileService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private SeqBuilder seqBuilder;

    public ApiResponse<List<List<NodeVo>>> listNodeOnRunTimePathInMainAndExternalSubProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        ApiResponse apiResponse;
        try {
            ArrayList<List<NodeVo>> nodesInMainAndSubProcess = new ArrayList<List<NodeVo>>();
            String mainProcessDefinition = allVariablesConfiguredInProcess.getProcessDefinitionId();
            String processOnlyId = allVariablesConfiguredInProcess.getOnlyId();
            FlowModel mainFlowModel = this.getTestFlowModel(mainProcessDefinition);
            NodeVo nodesInMainProcess = new NodeVo(processOnlyId, mainFlowModel.getFlowIdentity(), null, mainProcessDefinition, mainFlowModel.getProps().getFlowName(), '1', this.listNodeOnRunTimePath(mainFlowModel, allVariablesConfiguredInProcess, mainProcessDefinition, processOnlyId));
            nodesInMainProcess.setUsedInRunTimePath(true);
            nodesInMainAndSubProcess.add(Collections.singletonList(nodesInMainProcess));
            ArrayList externalSubProcessDefIdAndOnlyIds = new ArrayList(this.variableService.findExternalSubProcessDefIdsAndOnlyIdsFrom(allVariablesConfiguredInProcess));
            HashMap<String, AllVariablesConfiguredInProcessVo> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess = new HashMap<String, AllVariablesConfiguredInProcessVo>(this.variableService.groupAllVariablesConfiguredInProcessByProcessOnlyId(allVariablesConfiguredInProcess));
            HashMap<String, List<String>> mappingFromProcessOnlyIdToNodeVariables = new HashMap<String, List<String>>();
            HashMap<String, String> mappingFromProcessOnlyIdToMainProcessOnlyId = new HashMap<String, String>();
            for (Map externalSubProcessDefIdAndOnlyId : externalSubProcessDefIdAndOnlyIds) {
                String externalSubProcessDefId = (String)externalSubProcessDefIdAndOnlyId.get("processDefinitionId");
                String externalSubProcessOnlyId = (String)externalSubProcessDefIdAndOnlyId.get("processOnlyId");
                List subProcessNodeVariableFromMainProcess = ((AllVariablesConfiguredInProcessVo)mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.get(externalSubProcessOnlyId)).getBindingNodeVariablesFromMainProcess();
                String bindingMainProcessOnlyId = ((AllVariablesConfiguredInProcessVo)mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.get(externalSubProcessOnlyId)).getBindingMainProcessOnlyId();
                mappingFromProcessOnlyIdToNodeVariables.put(externalSubProcessOnlyId, subProcessNodeVariableFromMainProcess);
                mappingFromProcessOnlyIdToMainProcessOnlyId.put(externalSubProcessOnlyId, bindingMainProcessOnlyId);
                FlowModel externalSubProcessFlowModel = this.getTestFlowModel(externalSubProcessDefId);
                NodeVo nodesInExternalSubProcess = new NodeVo(externalSubProcessOnlyId, externalSubProcessFlowModel.getFlowIdentity(), null, externalSubProcessDefId, externalSubProcessFlowModel.getProps().getFlowName(), '2', this.listNodeOnRunTimePath(externalSubProcessFlowModel, allVariablesConfiguredInProcess, externalSubProcessDefId, externalSubProcessOnlyId));
                nodesInMainAndSubProcess.add(Collections.singletonList(nodesInExternalSubProcess));
            }
            this.removeUselessNodeAndAdjustSubmitSourceInMainAndSubProcess(nodesInMainAndSubProcess);
            this.checkMainAndSubProcess(nodesInMainAndSubProcess);
            this.bindMainAndSubProcessParentId(nodesInMainAndSubProcess);
            this.setNodeVariablesAndMainProcessOnlyIdAtFirstNode(nodesInMainAndSubProcess, mappingFromProcessOnlyIdToNodeVariables, mappingFromProcessOnlyIdToMainProcessOnlyId);
            this.bindExternalSubProcess(nodesInMainAndSubProcess, mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess);
            List<List<NodeVo>> newNodesInMainAndSubProcess = this.deletUnUsedProcess(nodesInMainAndSubProcess);
            apiResponse = ApiResponse.success(newNodesInMainAndSubProcess);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    private FlowModel getTestFlowModel(String processDefinitionId) throws BpmException {
        WorkFlow workFlow = this.processFileService.getFileByProcessDefId(processDefinitionId, null, null);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        flowModel.setFlowIdentity(workFlow.getIdentity());
        return flowModel;
    }

    public List<NodeDto> listNodeOnRunTimePath(FlowModel flowModel, AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processDefinitionId, String processOnlyId) throws BpmException {
        HashMap mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap();
        HashMap<String, List<ConfiguredVariableDto>> configuredInstanceVariable = new HashMap<String, List<ConfiguredVariableDto>>();
        ArrayList<NodeDto> nodesOnRunTimePath = new ArrayList<NodeDto>();
        mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.putAll(this.variableService.parse(allVariablesConfiguredInProcess));
        if (HussarUtils.isNotEmpty(mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId))) {
            configuredInstanceVariable.putAll((Map)mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId));
        }
        ArrayList<FlowSequence> simulativeRunTimePath = new ArrayList<FlowSequence>(this.simulateRunTimePath(flowModel, configuredInstanceVariable));
        String startNodeKey = this.getStartNodeKey(flowModel);
        ArrayList<FlowObject> elementsInProcess = new ArrayList<FlowObject>(this.listElementsInProcess(flowModel));
        if (HussarUtils.isNotEmpty((Object)startNodeKey)) {
            nodesOnRunTimePath.addAll(this.assembleNodeByPath(simulativeRunTimePath, elementsInProcess, startNodeKey, processDefinitionId, flowModel, configuredInstanceVariable));
        }
        return nodesOnRunTimePath;
    }

    public List<NodeDto> listNodeOnRunTimePath(FlowModel flowModel, AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String separateVariable, String processDefinitionId, String processOnlyId) throws BpmException {
        HashMap mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap();
        HashMap<String, List<ConfiguredVariableDto>> configuredInstanceVariable = new HashMap<String, List<ConfiguredVariableDto>>();
        ArrayList<FlowSequence> simulativeRunTimePath = new ArrayList<FlowSequence>();
        ArrayList<FlowObject> elementsInProcess = new ArrayList<FlowObject>();
        ArrayList<NodeDto> nodesOnRunTimePath = new ArrayList<NodeDto>();
        mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.putAll(this.variableService.parse(allVariablesConfiguredInProcess));
        if (HussarUtils.isNotEmpty(mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId))) {
            configuredInstanceVariable.putAll((Map)mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId));
        }
        simulativeRunTimePath.addAll(this.simulateRunTimePath(flowModel, configuredInstanceVariable, separateVariable));
        String startNodeKey = this.getStartNodeKey(flowModel);
        elementsInProcess.addAll(this.listElementsInProcess(flowModel));
        if (HussarUtils.isNotEmpty((Object)startNodeKey)) {
            nodesOnRunTimePath.addAll(this.assembleNodeByPath(simulativeRunTimePath, elementsInProcess, startNodeKey, processDefinitionId, flowModel, configuredInstanceVariable));
        }
        nodesOnRunTimePath.forEach(n -> n.setSeparateVariable(separateVariable));
        return nodesOnRunTimePath;
    }

    private String getStartNodeKey(FlowModel flowModel) {
        String startNodeKey = null;
        FlowElements slots = flowModel.getSlots();
        List elementsInProcess = slots.getElement();
        for (FlowObject element : elementsInProcess) {
            String nodeKey = element.getInstanceKey();
            String nodeType = element.getName();
            if (!nodeType.equals("com.jxdinfo.workflow.Start")) continue;
            startNodeKey = nodeKey;
        }
        return startNodeKey;
    }

    public String findStartNodeKey(List<FlowObject> elements) {
        String startNodeKey = null;
        for (FlowObject element : elements) {
            String nodeKey = element.getInstanceKey();
            String nodeType = element.getName();
            if (!nodeType.equals("com.jxdinfo.workflow.Start")) continue;
            startNodeKey = nodeKey;
        }
        return startNodeKey;
    }

    private List<FlowSequence> simulateRunTimePath(FlowModel flowModel, Map<String, List<ConfiguredVariableDto>> configuredInstanceVariable) throws BpmException {
        ArrayList<String> inclusiveAndExclusiveGatewayKeys = new ArrayList<String>();
        ArrayList<FlowSequence> simulativeRunTimePath = new ArrayList<FlowSequence>();
        ArrayList<FlowObject> elementsInProcess = new ArrayList<FlowObject>(this.listElementsInProcess(flowModel));
        ArrayList<FlowSequence> pathsInProcess = new ArrayList<FlowSequence>(this.listPathsInProcess(flowModel));
        ArrayList<String> exclusiveGatewayKeys = new ArrayList<String>(this.findAllExclusiveGatewayKeysFrom(elementsInProcess));
        ArrayList<String> inclusiveGatewayKeys = new ArrayList<String>(this.findAllInclusiveGatewayKeysFrom(elementsInProcess));
        inclusiveAndExclusiveGatewayKeys.addAll(exclusiveGatewayKeys);
        inclusiveAndExclusiveGatewayKeys.addAll(inclusiveGatewayKeys);
        Map<String, List<String>> mappingFromPathKeyToLastUserNodeKeys = this.findMappingFromPathKeyToLastUserNodeKey(inclusiveAndExclusiveGatewayKeys, flowModel);
        HashMap<String, Map<String, Object>> pathVariable = new HashMap<String, Map<String, Object>>(this.assemblePathVariable(pathsInProcess, configuredInstanceVariable, mappingFromPathKeyToLastUserNodeKeys));
        simulativeRunTimePath.addAll(this.findRuntimePathBehindExclusiveGateway(pathsInProcess, exclusiveGatewayKeys, pathVariable));
        simulativeRunTimePath.addAll(this.findRuntimePathBehindInclusiveGateway(pathsInProcess, inclusiveGatewayKeys, pathVariable));
        simulativeRunTimePath.addAll(this.findRuntimePathExceptBehind(inclusiveAndExclusiveGatewayKeys, pathsInProcess));
        return simulativeRunTimePath;
    }

    private List<FlowSequence> simulateRunTimePath(FlowModel flowModel, Map<String, List<ConfiguredVariableDto>> configuredProcessVariableAndInstanceVariable, String separateVariable) throws BpmException {
        ArrayList<String> inclusiveGatewayKeys = new ArrayList<String>();
        ArrayList<String> exclusiveGatewayKeys = new ArrayList<String>();
        ArrayList<String> inclusiveAndExclusiveGatewayKeys = new ArrayList<String>();
        ArrayList<FlowSequence> simulativeRunTimePath = new ArrayList<FlowSequence>();
        HashMap<String, Map<String, Object>> pathVariable = new HashMap<String, Map<String, Object>>();
        ArrayList<FlowObject> elementsInProcess = new ArrayList<FlowObject>();
        ArrayList<FlowSequence> pathsInProcess = new ArrayList<FlowSequence>();
        String processKey = flowModel.getFlowIdentity();
        elementsInProcess.addAll(this.listElementsInProcess(flowModel));
        pathsInProcess.addAll(this.listPathsInProcess(flowModel));
        exclusiveGatewayKeys.addAll(this.findAllExclusiveGatewayKeysFrom(elementsInProcess));
        inclusiveGatewayKeys.addAll(this.findAllInclusiveGatewayKeysFrom(elementsInProcess));
        inclusiveAndExclusiveGatewayKeys.addAll(exclusiveGatewayKeys);
        inclusiveAndExclusiveGatewayKeys.addAll(inclusiveGatewayKeys);
        Map<String, List<String>> mappingFromPathKeyToLastUserNodeKeys = this.findMappingFromPathKeyToLastUserNodeKey(inclusiveAndExclusiveGatewayKeys, flowModel);
        pathVariable.putAll(this.assemblePathVariable(pathsInProcess, configuredProcessVariableAndInstanceVariable, mappingFromPathKeyToLastUserNodeKeys));
        simulativeRunTimePath.addAll(this.findRuntimePathBehindExclusiveGateway(pathsInProcess, exclusiveGatewayKeys, pathVariable, separateVariable));
        simulativeRunTimePath.addAll(this.findRuntimePathBehindInclusiveGateway(pathsInProcess, inclusiveGatewayKeys, pathVariable, separateVariable));
        simulativeRunTimePath.addAll(this.findRuntimePathExceptBehind(inclusiveAndExclusiveGatewayKeys, pathsInProcess));
        return simulativeRunTimePath;
    }

    List<FlowObject> listElementsInProcess(FlowModel flowModel) {
        FlowElements slots = flowModel.getSlots();
        List elements = slots.getElement();
        ArrayList<FlowObject> elementsInProcess = new ArrayList<FlowObject>(elements);
        return elementsInProcess;
    }

    List<FlowSequence> listPathsInProcess(FlowModel flowModel) {
        ArrayList<FlowSequence> pathsInProcess = new ArrayList<FlowSequence>();
        FlowElements slots = flowModel.getSlots();
        List paths = slots.getPath();
        pathsInProcess.addAll(paths);
        return pathsInProcess;
    }

    private List<String> findAllExclusiveGatewayKeysFrom(List<FlowObject> elementsInProcess) {
        ArrayList<String> exclusiveGatewayKeys = new ArrayList<String>();
        elementsInProcess.forEach(element -> {
            String nodeKey = element.getInstanceKey();
            String nodeName = element.getName();
            if (nodeName.equals(EXCLUSIVE_GATEWAY)) {
                exclusiveGatewayKeys.add(nodeKey);
            }
        });
        return exclusiveGatewayKeys;
    }

    private List<String> findAllInclusiveGatewayKeysFrom(List<FlowObject> elementsInProcess) {
        ArrayList<String> inclusiveGatewayKeys = new ArrayList<String>();
        elementsInProcess.forEach(element -> {
            String nodeKey = element.getInstanceKey();
            String nodeName = element.getName();
            if (nodeName.equals(INCLUSIVE_GATEWAY)) {
                inclusiveGatewayKeys.add(nodeKey);
            }
        });
        return inclusiveGatewayKeys;
    }

    private Map<String, List<String>> findMappingFromPathKeyToLastUserNodeKey(List<String> gatewayKeys, FlowModel flowModel) throws BpmException {
        HashMap<String, List<String>> mappingFromPathKeyToLastUserNodeKey = new HashMap<String, List<String>>();
        FlowElements slots = flowModel.getSlots();
        List elements = slots.getElement();
        List paths = slots.getPath();
        Map<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = this.groupStarNodeKeysByEndNodeKey(paths);
        Map<String, List<FlowObject>> mappingFromElementKeyToElement = this.groupElementByElementKey(elements);
        for (String gatewayKey : gatewayKeys) {
            List pathsBehindGateway = mappingFromElementKeyToElement.get(gatewayKey).get(0).getGoOutPathes();
            List<String> lastUserNodeKeys = this.findLastUserNodeKeysBeforeGateway(gatewayKey, mappingFromEndNodeKeyToStarNodeKeys, mappingFromElementKeyToElement, flowModel);
            if (!HussarUtils.isNotEmpty((Object)pathsBehindGateway)) continue;
            for (String pathBehindGateway : pathsBehindGateway) {
                mappingFromPathKeyToLastUserNodeKey.put(pathBehindGateway, lastUserNodeKeys);
            }
        }
        return mappingFromPathKeyToLastUserNodeKey;
    }

    private Map<String, List<String>> groupStarNodeKeysByEndNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = new HashMap<String, List<String>>();
        mappingFromEndNodeKeyToStarNodeKeys.putAll(paths.stream().collect(Collectors.groupingBy(path -> path.getEnd().getKey(), Collectors.mapping(path -> path.getStart().getKey(), Collectors.toList()))));
        return mappingFromEndNodeKeyToStarNodeKeys;
    }

    public Map<String, List<String>> groupEndNodeKeysByStartNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<String>> mappingFromStartNodeKeyToEndNodeKeys = new HashMap<String, List<String>>();
        mappingFromStartNodeKeyToEndNodeKeys.putAll(paths.stream().collect(Collectors.groupingBy(path -> path.getStart().getKey(), Collectors.mapping(path -> path.getEnd().getKey(), Collectors.toList()))));
        return mappingFromStartNodeKeyToEndNodeKeys;
    }

    public Map<String, List<String>> groupPathKeysByStartNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<String>> mappingFromStartNodeKeyToPathKeys = new HashMap<String, List<String>>(paths.stream().collect(Collectors.groupingBy(path -> path.getStart().getKey(), Collectors.mapping(FlowObject::getInstanceKey, Collectors.toList()))));
        return mappingFromStartNodeKeyToPathKeys;
    }

    public Map<String, List<FlowSequence>> groupPathsByPathKey(List<FlowSequence> paths) {
        HashMap<String, List<FlowSequence>> mappingFromPathKeyToPaths = new HashMap<String, List<FlowSequence>>(paths.stream().collect(Collectors.groupingBy(path -> path.getInstanceKey(), Collectors.toList())));
        return mappingFromPathKeyToPaths;
    }

    public Map<String, List<FlowSequence>> groupPathByStartNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPath = new HashMap<String, List<FlowSequence>>(paths.stream().collect(Collectors.groupingBy(path -> path.getStart().getKey(), Collectors.toList())));
        return mappingFromStartNodeKeyToPath;
    }

    private Map<String, List<FlowObject>> groupElementByElementKey(List<FlowObject> elements) {
        HashMap<String, List<FlowObject>> mappingFromElementKeyToElement = new HashMap<String, List<FlowObject>>();
        mappingFromElementKeyToElement.putAll(elements.stream().collect(Collectors.groupingBy(element -> element.getInstanceKey(), Collectors.toList())));
        return mappingFromElementKeyToElement;
    }

    private List<String> findLastUserNodeKeysBeforeGateway(String gatewayKey, Map<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys, Map<String, List<FlowObject>> mappingFromElementKeyToElement, FlowModel flowModel) throws BpmException {
        ArrayList<String> lastUserNodeKeys = new ArrayList<String>();
        Stack<String> elementKeyStack = new Stack<String>();
        ArrayList<String> beingVisited = new ArrayList<String>();
        ArrayList<String> hasBeenVisited = new ArrayList<String>();
        String currentElement = gatewayKey;
        elementKeyStack.push(currentElement);
        while (!elementKeyStack.isEmpty()) {
            currentElement = (String)elementKeyStack.peek();
            FlowObject element = mappingFromElementKeyToElement.get(currentElement).get(0);
            String elementType = element.getName();
            if ("com.jxdinfo.workflow.User".equals(elementType) || "com.jxdinfo.workflow.CallActivity".equals(elementType)) {
                lastUserNodeKeys.add(currentElement);
                beingVisited.remove(currentElement);
                hasBeenVisited.add(currentElement);
                elementKeyStack.pop();
                continue;
            }
            if (!beingVisited.contains(currentElement) && !hasBeenVisited.contains(currentElement)) {
                beingVisited.add(currentElement);
                continue;
            }
            if (!beingVisited.contains(currentElement)) continue;
            ArrayList neighborElementKeys = new ArrayList();
            ArrayList<String> hasBeenVisitedNeighbor = new ArrayList<String>();
            if (HussarUtils.isNotEmpty(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement))) {
                neighborElementKeys.addAll(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement));
            }
            for (String neighborElementKey : neighborElementKeys) {
                if (hasBeenVisited.contains(neighborElementKey)) {
                    hasBeenVisitedNeighbor.add(neighborElementKey);
                    continue;
                }
                if (beingVisited.contains(neighborElementKey)) {
                    logger.error(HAS_LOOP_ERROR_MESSAGE);
                    throw new BpmException(HAS_LOOP_ERROR_MESSAGE, String.valueOf(flowModel.getFlowIdentity()));
                }
                elementKeyStack.push(neighborElementKey);
                break;
            }
            if (hasBeenVisitedNeighbor.size() != neighborElementKeys.size()) continue;
            beingVisited.remove(currentElement);
            hasBeenVisited.add(currentElement);
            elementKeyStack.pop();
        }
        if (lastUserNodeKeys.size() == 0) {
            throw new BpmException("\u5728\u7f51\u5173 " + gatewayKey + " \u524d\u6ca1\u6709\u53d1\u73b0\u4eba\u5de5\u6d3b\u52a8\u8282\u70b9", String.valueOf(flowModel.getFlowIdentity()));
        }
        return lastUserNodeKeys;
    }

    private Map<String, Map<String, Object>> assemblePathVariable(List<FlowSequence> pathsInProcess, Map<String, List<ConfiguredVariableDto>> configureInstanceVariable, Map<String, List<String>> mappingFromPathKeyToLastUserNodeKeys) {
        HashMap<String, Map<String, Object>> pathVariable = new HashMap<String, Map<String, Object>>();
        for (FlowSequence path : pathsInProcess) {
            HashMap variable = new HashMap();
            String pathKey = path.getInstanceKey();
            if (HussarUtils.isEmpty(mappingFromPathKeyToLastUserNodeKeys.get(pathKey))) continue;
            String lastUserNodeKey = mappingFromPathKeyToLastUserNodeKeys.get(pathKey).get(0);
            ArrayList configuredPathVariables = new ArrayList();
            if (HussarUtils.isNotEmpty(configureInstanceVariable.get(lastUserNodeKey))) {
                configuredPathVariables.addAll(configureInstanceVariable.get(lastUserNodeKey));
            }
            if (HussarUtils.isNotEmpty(configureInstanceVariable.get(pathKey))) {
                configuredPathVariables.addAll(configureInstanceVariable.get(pathKey));
            }
            if (HussarUtils.isNotEmpty(configuredPathVariables)) {
                configuredPathVariables.forEach(o -> variable.put(o.getName(), o.getValue()));
            }
            pathVariable.put(pathKey, variable);
        }
        return pathVariable;
    }

    private List<FlowSequence> findRuntimePathBehindExclusiveGateway(List<FlowSequence> pathsInProcess, List<String> exclusiveGatewayKeys, Map<String, Map<String, Object>> pathVariable) {
        ArrayList<FlowSequence> runTimePathBehindExclusiveGateway = new ArrayList<FlowSequence>();
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(pathsInProcess));
        for (String exclusiveGatewayKey : exclusiveGatewayKeys) {
            List allPathsBehindSingleGateway = (List)mappingFromStartNodeKeyToPaths.get(exclusiveGatewayKey);
            runTimePathBehindExclusiveGateway.add(this.findRuntimePathBehindSingleExclusiveGateway(allPathsBehindSingleGateway, pathVariable));
        }
        return runTimePathBehindExclusiveGateway;
    }

    private List<FlowSequence> findRuntimePathBehindExclusiveGateway(List<FlowSequence> pathsInProcess, List<String> exclusiveGatewayKeys, Map<String, Map<String, Object>> pathVariable, String separateVariable) {
        ArrayList<FlowSequence> runTimePathBehindExclusiveGateway = new ArrayList<FlowSequence>();
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(pathsInProcess));
        for (String exclusiveGatewayKey : exclusiveGatewayKeys) {
            List allPathsBehindSingleGateway = (List)mappingFromStartNodeKeyToPaths.get(exclusiveGatewayKey);
            runTimePathBehindExclusiveGateway.add(this.findRuntimePathBehindSingleExclusiveGateway(allPathsBehindSingleGateway, pathVariable, separateVariable));
        }
        return runTimePathBehindExclusiveGateway;
    }

    private Map<String, List<FlowSequence>> groupPathsByStartNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        mappingFromStartNodeKeyToPaths.putAll(paths.stream().collect(Collectors.groupingBy(path -> path.getStart().getKey(), Collectors.toList())));
        return mappingFromStartNodeKeyToPaths;
    }

    private FlowSequence findRuntimePathBehindSingleExclusiveGateway(List<FlowSequence> paths, Map<String, Map<String, Object>> pathVariable) {
        FlowSequence defaultFlowSequence = null;
        FlowSequence conditionFLowSequenc = null;
        for (FlowSequence path : paths) {
            String pathKey = path.getInstanceKey();
            FlowProps props = path.getProps();
            if (props.isFlowDefault()) {
                defaultFlowSequence = path;
                continue;
            }
            String backFlowCondition = props.getBackFlowCondition();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.putAll(pathVariable.get(pathKey));
            if (!HussarUtils.isNotEmpty((Object)backFlowCondition) || !this.isConditionTrue(backFlowCondition, variable)) continue;
            conditionFLowSequenc = path;
            break;
        }
        if (HussarUtils.isNotEmpty(conditionFLowSequenc)) {
            return conditionFLowSequenc;
        }
        return defaultFlowSequence;
    }

    private FlowSequence findRuntimePathBehindSingleExclusiveGateway(List<FlowSequence> paths, Map<String, Map<String, Object>> pathVariable, String separateVariable) {
        FlowSequence defaultFlowSequence = null;
        FlowSequence conditionFLowSequenc = null;
        for (FlowSequence path : paths) {
            String pathKey = path.getInstanceKey();
            FlowProps props = path.getProps();
            if (props.isFlowDefault()) {
                defaultFlowSequence = path;
                continue;
            }
            String backFlowCondition = props.getBackFlowCondition();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.putAll(pathVariable.get(pathKey));
            if (separateVariable != null) {
                variable.put("sub_process_separate_variable", separateVariable);
            }
            if (!HussarUtils.isNotEmpty((Object)backFlowCondition) || !this.isConditionTrue(backFlowCondition, variable)) continue;
            conditionFLowSequenc = path;
            break;
        }
        if (HussarUtils.isNotEmpty(conditionFLowSequenc)) {
            return conditionFLowSequenc;
        }
        return defaultFlowSequence;
    }

    private List<FlowSequence> findRuntimePathBehindInclusiveGateway(List<FlowSequence> pathsInProcess, List<String> inclusiveGatewayKeys, Map<String, Map<String, Object>> pathVariable) {
        ArrayList<FlowSequence> runTimePathBehindInclusiveGateway = new ArrayList<FlowSequence>();
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(pathsInProcess));
        for (String inclusiveGatewayKey : inclusiveGatewayKeys) {
            List allPathsBehindSingleGateway = (List)mappingFromStartNodeKeyToPaths.get(inclusiveGatewayKey);
            runTimePathBehindInclusiveGateway.addAll(this.findRuntimePathBehindSingleInclusiveGateway(allPathsBehindSingleGateway, pathVariable));
        }
        return runTimePathBehindInclusiveGateway;
    }

    private List<FlowSequence> findRuntimePathBehindInclusiveGateway(List<FlowSequence> pathsInProcess, List<String> inclusiveGatewayKeys, Map<String, Map<String, Object>> pathVariable, String separateVariable) {
        ArrayList<FlowSequence> runTimePathBehindInclusiveGateway = new ArrayList<FlowSequence>();
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(pathsInProcess));
        for (String inclusiveGatewayKey : inclusiveGatewayKeys) {
            List allPathsBehindSingleGateway = (List)mappingFromStartNodeKeyToPaths.get(inclusiveGatewayKey);
            runTimePathBehindInclusiveGateway.addAll(this.findRuntimePathBehindSingleInclusiveGateway(allPathsBehindSingleGateway, pathVariable, separateVariable));
        }
        return runTimePathBehindInclusiveGateway;
    }

    private List<FlowSequence> findRuntimePathBehindSingleInclusiveGateway(List<FlowSequence> paths, Map<String, Map<String, Object>> pathVariable) {
        ArrayList<FlowSequence> runtimePath = new ArrayList<FlowSequence>();
        for (FlowSequence path : paths) {
            String pathKey = path.getInstanceKey();
            FlowProps props = path.getProps();
            String backFlowCondition = props.getBackFlowCondition();
            boolean flowDefault = props.isFlowDefault();
            HashMap<String, Object> variable = new HashMap<String, Object>(pathVariable.get(pathKey));
            if (!flowDefault && HussarUtils.isNotEmpty((Object)backFlowCondition)) {
                if (!this.isConditionTrue(backFlowCondition, variable)) continue;
                runtimePath.add(path);
                continue;
            }
            runtimePath.add(path);
        }
        return runtimePath;
    }

    private List<FlowSequence> findRuntimePathBehindSingleInclusiveGateway(List<FlowSequence> paths, Map<String, Map<String, Object>> pathVariable, String separateVariable) {
        ArrayList<FlowSequence> runtimePath = new ArrayList<FlowSequence>();
        for (FlowSequence path : paths) {
            String pathKey = path.getInstanceKey();
            FlowProps props = path.getProps();
            String backFlowCondition = props.getBackFlowCondition();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.putAll(pathVariable.get(pathKey));
            if (separateVariable != null) {
                variable.put("sub_process_separate_variable", separateVariable);
            }
            if (HussarUtils.isNotEmpty((Object)backFlowCondition)) {
                if (!this.isConditionTrue(backFlowCondition, variable)) continue;
                runtimePath.add(path);
                continue;
            }
            runtimePath.add(path);
        }
        return runtimePath;
    }

    private List<FlowSequence> findRuntimePathExceptBehind(List<String> nodeKeys, List<FlowSequence> paths) {
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        ArrayList<FlowSequence> cleanPaths = new ArrayList<FlowSequence>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(paths));
        for (String nodeKey : nodeKeys) {
            mappingFromStartNodeKeyToPaths.remove(nodeKey);
        }
        mappingFromStartNodeKeyToPaths.values().forEach(o -> cleanPaths.addAll((Collection<FlowSequence>)o));
        return cleanPaths;
    }

    private boolean isConditionTrue(String condition, Map<String, Object> pathVariable) {
        SimpleContext context = new SimpleContext();
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        pathVariable.forEach((arg_0, arg_1) -> NodeServiceImpl.lambda$isConditionTrue$15(condition, (ExpressionFactory)factory, context, arg_0, arg_1));
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, condition, Boolean.TYPE);
        return (Boolean)valueExpression.getValue((ELContext)context);
    }

    private List<NodeDto> assembleNodeByPath(List<FlowSequence> paths, List<FlowObject> elements, String startNodeKey, String processDefinitionId, FlowModel flowModel, Map<String, List<ConfiguredVariableDto>> configuredProcessVariableAndInstanceVariable) throws BpmException {
        HashMap<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths = new HashMap<String, List<FlowSequence>>();
        HashMap<String, List<FlowObject>> mappingFromNodeKeyToElements = new HashMap<String, List<FlowObject>>();
        ArrayList<NodeDto> nodesOnRunTimePath = new ArrayList<NodeDto>();
        mappingFromStartNodeKeyToPaths.putAll(this.groupPathsByStartNodeKey(paths));
        mappingFromNodeKeyToElements.putAll(this.groupElementsByNodeKey(elements));
        this.checkLoop(mappingFromStartNodeKeyToPaths, startNodeKey, flowModel);
        nodesOnRunTimePath.addAll(this.assembleNodeByGroupingPath(mappingFromStartNodeKeyToPaths, mappingFromNodeKeyToElements, startNodeKey, processDefinitionId, configuredProcessVariableAndInstanceVariable));
        return nodesOnRunTimePath;
    }

    private Map<String, List<FlowObject>> groupElementsByNodeKey(List<FlowObject> elements) {
        HashMap<String, List<FlowObject>> mappingFromNodeKeyToElements = new HashMap<String, List<FlowObject>>();
        mappingFromNodeKeyToElements.putAll(elements.stream().collect(Collectors.groupingBy(element -> element.getInstanceKey(), Collectors.toList())));
        return mappingFromNodeKeyToElements;
    }

    private void checkLoop(Map<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths, String startNodeKey, FlowModel flowModel) throws BpmException {
        Stack<String> nodeStack = new Stack<String>();
        HashSet<String> beingVisitedNodes = new HashSet<String>();
        HashSet<String> hasBeenVisitedNodes = new HashSet<String>();
        String currentNode = startNodeKey;
        nodeStack.push(currentNode);
        while (!nodeStack.isEmpty()) {
            currentNode = (String)nodeStack.peek();
            if (!beingVisitedNodes.contains(currentNode) && !hasBeenVisitedNodes.contains(currentNode)) {
                beingVisitedNodes.add(currentNode);
                continue;
            }
            if (!beingVisitedNodes.contains(currentNode)) continue;
            ArrayList neighborNodes = new ArrayList();
            HashSet<String> hasBeenVisitedNeighborNodes = new HashSet<String>();
            ArrayList paths = new ArrayList();
            if (HussarUtils.isNotEmpty(mappingFromStartNodeKeyToPaths.get(currentNode))) {
                paths.addAll(mappingFromStartNodeKeyToPaths.get(currentNode));
            }
            paths.forEach(path -> neighborNodes.add(path.getEnd().getKey()));
            for (String neighborNode : neighborNodes) {
                if (hasBeenVisitedNodes.contains(neighborNode)) {
                    hasBeenVisitedNeighborNodes.add(neighborNode);
                    continue;
                }
                if (beingVisitedNodes.contains(neighborNode)) {
                    logger.error(HAS_LOOP_ERROR_MESSAGE);
                    throw new BpmException(HAS_LOOP_ERROR_MESSAGE, String.valueOf(flowModel.getFlowIdentity()));
                }
                nodeStack.push(neighborNode);
                break;
            }
            if (hasBeenVisitedNeighborNodes.size() != neighborNodes.size()) continue;
            beingVisitedNodes.remove(currentNode);
            hasBeenVisitedNodes.add(currentNode);
            nodeStack.pop();
        }
    }

    private List<NodeDto> assembleNodeByGroupingPath(Map<String, List<FlowSequence>> mappingFromStartNodeKeyToPaths, Map<String, List<FlowObject>> mappingFromNodeKeyToElements, String startNodeKey, String processDefinitionId, Map<String, List<ConfiguredVariableDto>> configuredProcessVariableAndInstanceVariable) throws BpmException {
        LinkedHashMap<String, NodeDto> nodesMapOnRunTimePath = new LinkedHashMap<String, NodeDto>();
        ArrayList<NodeDto> nodesOnRunTimePath = new ArrayList<NodeDto>();
        ArrayDeque<String> elementQueue = new ArrayDeque<String>();
        String nodeKey = startNodeKey;
        FlowObject startElement = mappingFromNodeKeyToElements.get(startNodeKey).get(0);
        String startInstanceKey = startElement.getInstanceKey();
        String startNodeName = startElement.getProps().getFlowName();
        String startNodeType = startElement.getName();
        NodeDto startNode = new NodeDto(this.generateOnlyId(), startInstanceKey, startNodeName, startNodeType);
        ArrayList startNextNodeKeys = new ArrayList();
        if (HussarUtils.isNotEmpty(mappingFromStartNodeKeyToPaths.get(startInstanceKey))) {
            mappingFromStartNodeKeyToPaths.get(startInstanceKey).forEach(p -> startNextNodeKeys.add(p.getEnd().getKey()));
        }
        startNode.setNextNodeKey(startNextNodeKeys);
        String processKey = processDefinitionId.split(":")[0];
        if (startNextNodeKeys.size() > 1) {
            throw new BpmException("\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u662f\u591a\u4e2a\u4eba\u5de5\u8282\u70b9", processKey);
        }
        for (String startNextNodeKey : startNextNodeKeys) {
            FlowObject element = mappingFromNodeKeyToElements.get(startNextNodeKey).get(0);
            String type = element.getName();
            if (!"com.jxdinfo.workflow.User".equals(type)) {
                throw new BpmException("\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u662f\u975e\u4eba\u5de5\u8282\u70b9", processKey);
            }
            if (!element.getProps().getFlowCountersign().isCountersign()) continue;
            throw new BpmException("\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u662f\u4f1a\u7b7e\u8282\u70b9", processKey);
        }
        nodesOnRunTimePath.add(startNode);
        elementQueue.add(nodeKey);
        while (!elementQueue.isEmpty()) {
            nodeKey = (String)elementQueue.poll();
            ArrayList paths = new ArrayList();
            ArrayList elements = new ArrayList();
            if (HussarUtils.isNotEmpty(mappingFromStartNodeKeyToPaths.get(nodeKey))) {
                paths.addAll(mappingFromStartNodeKeyToPaths.get(nodeKey));
            }
            paths.forEach(path -> {
                SequenceSourceTarget endNode = path.getEnd();
                String endNodeKey = endNode.getKey();
                elements.addAll((Collection)mappingFromNodeKeyToElements.get(endNodeKey));
                elementQueue.add(endNodeKey);
            });
            for (FlowObject element : elements) {
                FlowAssignment flowSelector;
                String markedNode;
                FlowAssignment flowAssignment;
                JSONArray participantConfigs;
                FlowAssignment flowAssignment2;
                String instanceKey = element.getInstanceKey();
                String nodeName = element.getProps().getFlowName();
                String nodeType = element.getName();
                NodeDto currentNode = new NodeDto(this.generateOnlyId(), instanceKey, nodeName, nodeType);
                ArrayList nextNodeKeys = new ArrayList();
                if (HussarUtils.isNotEmpty(mappingFromStartNodeKeyToPaths.get(instanceKey))) {
                    mappingFromStartNodeKeyToPaths.get(instanceKey).forEach(p -> nextNodeKeys.add(p.getEnd().getKey()));
                }
                currentNode.setNextNodeKey(nextNodeKeys);
                String submitSourceNodeKey = nodeKey;
                HashMap<String, Object> variable = new HashMap<String, Object>();
                if (HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(instanceKey))) {
                    ArrayList configuredVariables = new ArrayList();
                    configuredVariables.addAll(configuredProcessVariableAndInstanceVariable.get(instanceKey));
                    for (ConfiguredVariableDto configuredVariable : configuredVariables) {
                        variable.put(configuredVariable.getName(), configuredVariable.getValue());
                        if (!"bpm_submit_source".equals(configuredVariable.getName())) continue;
                        submitSourceNodeKey = (String)configuredVariable.getValue();
                    }
                }
                currentNode.setSubmitSourceNodeKey(submitSourceNodeKey);
                if (HussarUtils.isNotEmpty((Object)element.getProps().getFlowCountersign())) {
                    MultiUser flowCountersign = element.getProps().getFlowCountersign();
                    currentNode.setCountersign(flowCountersign.isCountersign());
                    if ("radio".equals(flowCountersign.getCountersignType())) {
                        currentNode.setMultiType("0");
                        currentNode.setMultiFinishCondition(String.valueOf(flowCountersign.getCountersignNumByRatio()));
                    } else {
                        currentNode.setMultiType("1");
                        currentNode.setMultiFinishCondition(String.valueOf(flowCountersign.getCountersignNumByCount()));
                    }
                }
                if (HussarUtils.isNotEmpty((Object)element.getProps().getInstanceMode())) {
                    String instanceMode = element.getProps().getInstanceMode();
                    currentNode.setInstanceMode(instanceMode);
                    if ("variable".equals(instanceMode) && HussarUtils.isNotEmpty((Object)element.getProps().getUseVariables())) {
                        FlowVariables flowVariable = (FlowVariables)element.getProps().getUseVariables().get(0);
                        String variableName = flowVariable.getVariable();
                        if (HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(element.getInstanceKey()))) {
                            List<ConfiguredVariableDto> configuredVariables = configuredProcessVariableAndInstanceVariable.get(element.getInstanceKey());
                            for (ConfiguredVariableDto configuredVariable : configuredVariables) {
                                if (!configuredVariable.getName().equals(variableName)) continue;
                                currentNode.setSeparateVariable(String.valueOf(configuredVariable.getValue()));
                            }
                        }
                    }
                }
                if (HussarUtils.isNotEmpty((Object)element.getProps().getFlowAssignment()) && HussarUtils.isNotEmpty((Object)(flowAssignment2 = element.getProps().getFlowAssignment()).getDefaultBackCondtion())) {
                    String defaultBackCondtion = flowAssignment2.getDefaultBackCondtion();
                    if (defaultBackCondtion.contains("flow_starter_dept") || defaultBackCondtion.contains("flow_sameLevel_dept") || defaultBackCondtion.contains("flow_parent_dept")) {
                        currentNode.setNeedStarter(true);
                    }
                    if (defaultBackCondtion.contains("flow_submiter_dept") || defaultBackCondtion.contains("flow_submiter_sameLevel_dept") || defaultBackCondtion.contains("flow_submiter_parent_dept")) {
                        currentNode.setNeedSubmitter(true);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)element.getProps().getFlowAssignment()) && HussarUtils.isNotEmpty((Object)(flowAssignment2 = element.getProps().getFlowAssignment()).getJudgeBackCondition())) {
                    for (JudgeBackCondition judgeBackCondition : flowAssignment2.getJudgeBackCondition()) {
                        String judgeSpellCondition = judgeBackCondition.getJudgeSpellCondition();
                        if (judgeSpellCondition.contains("flow_starter_dept") || judgeSpellCondition.contains("flow_sameLevel_dept") || judgeSpellCondition.contains("flow_parent_dept")) {
                            currentNode.setNeedStarter(true);
                            break;
                        }
                        if (!judgeSpellCondition.contains("flow_submiter_dept") && !judgeSpellCondition.contains("flow_submiter_sameLevel_dept") && !judgeSpellCondition.contains("flow_submiter_parent_dept")) continue;
                        currentNode.setNeedSubmitter(true);
                        break;
                    }
                }
                HashSet<String> nodeVariable = new HashSet<String>();
                if (HussarUtils.isNotEmpty((Object)element.getProps().getFlowAssignment()) && HussarUtils.isNotEmpty((Object)(participantConfigs = (JSONArray)(flowAssignment = element.getProps().getFlowAssignment()).getParticipantConfigs()))) {
                    for (int i = 0; i < participantConfigs.size(); ++i) {
                        markedNode = participantConfigs.getJSONObject(0).getString("markedNode");
                        if (!HussarUtils.isNotEmpty((Object)markedNode)) continue;
                        nodeVariable.addAll(Arrays.asList(markedNode.split(",")));
                    }
                }
                if (HussarUtils.isNotEmpty((Object)element.getProps().getFlowSelector()) && HussarUtils.isNotEmpty((Object)(participantConfigs = (JSONArray)(flowSelector = element.getProps().getFlowSelector()).getParticipantConfigs()))) {
                    for (int i = 0; i < participantConfigs.size(); ++i) {
                        markedNode = participantConfigs.getJSONObject(0).getString("markedNode");
                        if (!HussarUtils.isNotEmpty((Object)markedNode)) continue;
                        nodeVariable.addAll(Arrays.asList(markedNode.split(",")));
                    }
                }
                currentNode.setNodeVariables(new ArrayList(nodeVariable));
                nodesMapOnRunTimePath.put(currentNode.getKey(), currentNode);
            }
        }
        nodesOnRunTimePath.addAll(nodesMapOnRunTimePath.values());
        return nodesOnRunTimePath;
    }

    private String generateOnlyId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    public ApiResponse<List<NodeVo>> listNodeOnRunTimePathInInternalSubProcessThatDoseNotOpenCountersign(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, NodeDto node, String processDefinitionId) {
        ApiResponse apiResponse;
        try {
            FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
            FlowModel internalSubProcessFlowModel = this.buildInternalSubProcessFlowModelByInternalSubProcessNodeKey(flowModel, node.getKey());
            String separateVariable = node.getSeparateVariable() == null ? "" : node.getSeparateVariable().split(",")[0];
            NodeVo nodesInInternalSubProcess = new NodeVo(node.getParentId() + ":" + this.generateOnlyId(), internalSubProcessFlowModel.getFlowIdentity(), "\u5b9e\u4f8b1", processDefinitionId, internalSubProcessFlowModel.getProps().getFlowName(), '1', this.listNodeOnRunTimePath(internalSubProcessFlowModel, allVariablesConfiguredInProcess, separateVariable, processDefinitionId, node.getParentId()));
            this.removeUselessNodeAndAdjustSubmitSourceInInternalSubProcess(nodesInInternalSubProcess, node);
            this.bindInternalSubProcessParentId(nodesInInternalSubProcess);
            nodesInInternalSubProcess.getNodes().forEach(n -> {
                n.setSeparateVariable(separateVariable);
                n.setInternalNode(true);
            });
            apiResponse = ApiResponse.success(Arrays.asList(nodesInInternalSubProcess));
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    private FlowModel buildInternalSubProcessFlowModelByInternalSubProcessNodeKey(FlowModel flowModel, String nodeKey) {
        FlowModel internalSubProcessFlowModel = new FlowModel();
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            String name = processElement.getName();
            if (!"com.jxdinfo.workflow.SubProcess".equals(name) || !processElement.getInstanceKey().equals(nodeKey)) continue;
            internalSubProcessFlowModel.setFlowIdentity(flowModel.getFlowIdentity());
            internalSubProcessFlowModel.setInstanceKey(processElement.getInstanceKey());
            FlowProps props = new FlowProps();
            props.setFlowName(flowModel.getProps().getFlowName());
            internalSubProcessFlowModel.setProps(props);
            FlowElements internalSubProcessSlots = processElement.getSlots();
            internalSubProcessFlowModel.setSlots(internalSubProcessSlots);
        }
        return internalSubProcessFlowModel;
    }

    private void setFirstNodeSubmitSource(String submitSourceNodeKey, List<NodeDto> nodes) {
        nodes.get(0).setSubmitSourceNodeKey(submitSourceNodeKey);
    }

    private void setFirstNodeTagInfo(List<NodeDto> nodes) {
        nodes.get(0).setNeedStarter(false);
        nodes.get(0).setNeedSubmitter(false);
        nodes.get(0).setNodeVariables(null);
    }

    public ApiResponse<List<NodeVo>> listNodeOnRunTimePathInInternalSubProcessThatOpenCountersign(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, NodeDto node, String processDefinitionId) {
        ApiResponse apiResponse;
        try {
            ArrayList<NodeVo> nodeVosInInternalSubProcess = new ArrayList<NodeVo>();
            FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
            FlowModel internalSubProcessFlowModel = this.buildInternalSubProcessFlowModelByInternalSubProcessNodeKey(flowModel, node.getKey());
            if (HussarUtils.isNotEmpty((Object)node.getSeparateVariable())) {
                String[] separateVariables = node.getSeparateVariable().split(",");
                int count = 0;
                for (String separateVari : separateVariables) {
                    NodeVo nodesInInternalSubProcess = new NodeVo(node.getParentId() + ":" + this.generateOnlyId(), internalSubProcessFlowModel.getFlowIdentity(), "\u5b9e\u4f8b" + ++count, processDefinitionId, internalSubProcessFlowModel.getProps().getFlowName(), '3', this.listNodeOnRunTimePath(internalSubProcessFlowModel, allVariablesConfiguredInProcess, separateVari, processDefinitionId, node.getParentId()));
                    nodeVosInInternalSubProcess.add(nodesInInternalSubProcess);
                }
                this.removeUselessNodeAndAdjustSubmitSourceInInternalSubProcess(nodeVosInInternalSubProcess, node);
                nodeVosInInternalSubProcess.forEach(ns -> ns.getNodes().forEach(n -> n.setInternalNode(true)));
                this.bindInternalSubProcessParentId(nodeVosInInternalSubProcess);
                apiResponse = ApiResponse.success(nodeVosInInternalSubProcess);
            } else {
                logger.error("\u672a\u914d\u7f6e\u5206\u9694\u53d8\u91cf");
                apiResponse = ApiResponse.fail((String)"\u672a\u914d\u7f6e\u5206\u9694\u53d8\u91cf");
            }
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    private void removeUselessNodeAndAdjustSubmitSourceInMainAndSubProcess(List<List<NodeVo>> nodesInMainAndSubProcess) {
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            NodeVo node = nodeInMainAndSubProcess.get(0);
            if (!HussarUtils.isNotEmpty((Object)node.getNodes())) continue;
            this.removeUselessNodeAndAdjustSubmitSourceAndNextNode(node.getNodes());
        }
    }

    private void removeUselessNodeAndAdjustSubmitSourceInInternalSubProcess(List<NodeVo> nodeVosInInternalSubProcess, NodeDto node) {
        for (NodeVo nodesInInternalSubProcess : nodeVosInInternalSubProcess) {
            if (!HussarUtils.isNotEmpty((Object)nodesInInternalSubProcess.getNodes())) continue;
            this.setFirstNodeSubmitSource(node.getSubmitSourceNodeKey(), nodesInInternalSubProcess.getNodes());
            this.setFirstNodeTagInfo(nodesInInternalSubProcess.getNodes());
            this.removeUselessNodeAndAdjustSubmitSourceAndNextNode(nodesInInternalSubProcess.getNodes());
        }
    }

    private void removeUselessNodeAndAdjustSubmitSourceInInternalSubProcess(NodeVo nodesInInternalSubProcess, NodeDto node) {
        if (HussarUtils.isNotEmpty((Object)nodesInInternalSubProcess.getNodes())) {
            this.setFirstNodeSubmitSource(node.getSubmitSourceNodeKey(), nodesInInternalSubProcess.getNodes());
            this.setFirstNodeTagInfo(nodesInInternalSubProcess.getNodes());
            this.removeUselessNodeAndAdjustSubmitSourceAndNextNode(nodesInInternalSubProcess.getNodes());
        }
    }

    private void removeUselessNodeAndAdjustSubmitSourceAndNextNode(List<NodeDto> nodes) {
        this.adjustNextNode(nodes);
        this.adjustSubmitSource(nodes);
        this.removeUselessNode(nodes);
    }

    private void bindExternalSubProcess(List<List<NodeVo>> nodesInMainAndSubProcess, Map<String, AllVariablesConfiguredInProcessVo> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess) {
        Map<String, List<NodeVo>> mappingFromProcessOnlyIdToProcessNodes = this.groupProcessNodeByProcessOnlyId(nodesInMainAndSubProcess);
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            NodeVo processNode = nodeInMainAndSubProcess.get(0);
            List nodes = processNode.getNodes();
            this.findExternalSubProcessNodeAndBindExternalSubProcessBy(nodes, mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess, mappingFromProcessOnlyIdToProcessNodes);
        }
    }

    private void findExternalSubProcessNodeAndBindExternalSubProcessBy(List<NodeDto> nodes, Map<String, AllVariablesConfiguredInProcessVo> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess, Map<String, List<NodeVo>> mappingFromProcessOnlyIdToProcessNodes) {
        nodes.forEach(node -> {
            if (this.isExternalSubProcessNode((NodeDto)node)) {
                String processOnlyId = node.getParentId().split(":")[0];
                String nodeKey = node.getKey();
                List configuredInstanceVariables = ((AllVariablesConfiguredInProcessVo)mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.get(processOnlyId)).getConfiguredInstanceVariables();
                ConfiguredInstanceVariableDto configuredInstanceVariable = this.variableService.findConfiguredInstanceVariableByNodeId(configuredInstanceVariables, nodeKey);
                this.bindExternalSubProcessOnlyIdAndExternalSubProcessNodeName((NodeDto)node, configuredInstanceVariable, mappingFromProcessOnlyIdToProcessNodes);
            }
        });
    }

    private boolean isExternalSubProcessNode(NodeDto node) {
        return "com.jxdinfo.workflow.CallActivity".equals(node.getType());
    }

    private void bindExternalSubProcessOnlyIdAndExternalSubProcessNodeName(NodeDto node, ConfiguredInstanceVariableDto configuredInstanceVariable, Map<String, List<NodeVo>> mappingFromProcessOnlyIdToProcessNodes) {
        List bindingSubProcessOnlyIds = configuredInstanceVariable.getBindingSubProcessOnlyIds();
        node.setBindingProcessOnlyIds(bindingSubProcessOnlyIds);
        if (HussarUtils.isNotEmpty((Object)bindingSubProcessOnlyIds)) {
            for (String bindingSubProcessOnlyId : bindingSubProcessOnlyIds) {
                List<NodeVo> externalSubProcessNodes = mappingFromProcessOnlyIdToProcessNodes.get(bindingSubProcessOnlyId);
                externalSubProcessNodes.forEach(o -> {
                    o.setProcessName(o.getProcessName() + "\uff08" + node.getName() + " \uff09");
                    o.setUsedInRunTimePath(true);
                });
            }
        }
    }

    private List<List<NodeVo>> deletUnUsedProcess(List<List<NodeVo>> nodesInMainAndSubProcess) {
        ArrayList<List<NodeVo>> newNodesInMainAndSubProcess = new ArrayList<List<NodeVo>>();
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            if (!nodeInMainAndSubProcess.get(0).isUsedInRunTimePath()) continue;
            newNodesInMainAndSubProcess.add(nodeInMainAndSubProcess);
        }
        return newNodesInMainAndSubProcess;
    }

    private void bindMainAndSubProcessParentId(List<List<NodeVo>> nodesInMainAndSubProcess) {
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            String parentId = nodeInMainAndSubProcess.get(0).getOnlyId();
            List nodes = nodeInMainAndSubProcess.get(0).getNodes();
            for (NodeDto node : nodes) {
                node.setParentId(parentId);
            }
        }
    }

    private void bindInternalSubProcessParentId(NodeVo nodeInMainAndSubProcess) {
        String parentId = nodeInMainAndSubProcess.getOnlyId();
        List nodes = nodeInMainAndSubProcess.getNodes();
        for (NodeDto node : nodes) {
            node.setParentId(parentId);
        }
    }

    private void bindInternalSubProcessParentId(List<NodeVo> nodesInMainAndSubProcess) {
        for (NodeVo nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            String parentId = nodeInMainAndSubProcess.getOnlyId();
            List nodes = nodeInMainAndSubProcess.getNodes();
            for (NodeDto node : nodes) {
                node.setParentId(parentId);
            }
        }
    }

    private void setNodeVariablesAndMainProcessOnlyIdAtFirstNode(List<List<NodeVo>> nodesInMainAndSubProcess, Map<String, List<String>> mappingFromProcessOnlyIdToNodeVariables, Map<String, String> mappingFromProcessOnlyIdToMainProcessOnlyId) {
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            String processOnlyId = nodeInMainAndSubProcess.get(0).getOnlyId();
            List nodes = nodeInMainAndSubProcess.get(0).getNodes();
            List<String> subProcessNodeVariablesFromMainProcess = mappingFromProcessOnlyIdToNodeVariables.get(processOnlyId);
            String bindingMainProcessOnlyId = mappingFromProcessOnlyIdToMainProcessOnlyId.get(processOnlyId);
            if (subProcessNodeVariablesFromMainProcess != null && subProcessNodeVariablesFromMainProcess.size() != 0) {
                ((NodeDto)nodes.get(0)).setNodeVariables(subProcessNodeVariablesFromMainProcess);
                ((NodeDto)nodes.get(0)).setMainProcessOnlyId(bindingMainProcessOnlyId);
                ((NodeDto)nodes.get(0)).setUseSubProcessNodeVariables(true);
            }
            ((NodeDto)nodes.get(0)).setFirstNode(true);
        }
    }

    private Map<String, List<NodeVo>> groupProcessNodeByProcessOnlyId(List<List<NodeVo>> nodesInMainAndSubProcess) {
        return nodesInMainAndSubProcess.stream().collect(Collectors.groupingBy(processNodes -> ((NodeVo)processNodes.get(0)).getOnlyId(), Collectors.mapping(processNodes -> (NodeVo)processNodes.get(0), Collectors.toList())));
    }

    private void checkMainAndSubProcess(List<List<NodeVo>> nodesInMainAndSubProcess) throws BpmException {
        for (List<NodeVo> nodeInMainAndSubProcess : nodesInMainAndSubProcess) {
            NodeVo node = nodeInMainAndSubProcess.get(0);
            if (!HussarUtils.isNotEmpty((Object)node.getNodes())) continue;
            this.checkFirstNode((NodeDto)node.getNodes().get(0), node.getProcessKey());
        }
    }

    private void checkFirstNode(NodeDto firstNode, String processKey) throws BpmException {
        if (this.isCountersign(firstNode)) {
            throw new BpmException("\u6d41\u7a0b\u7b2c\u4e00\u8282\u70b9\u4e0d\u80fd\u4e3a\u4f1a\u7b7e\u8282\u70b9", processKey);
        }
    }

    private boolean isCountersign(NodeDto node) {
        return node.isCountersign();
    }

    private void removeUselessNode(List<NodeDto> nodes) {
        nodes.removeIf(node -> !"com.jxdinfo.workflow.User".equals(node.getType()) && !"com.jxdinfo.workflow.CallActivity".equals(node.getType()) && !"com.jxdinfo.workflow.SubProcess".equals(node.getType()));
    }

    private void adjustNextNode(List<NodeDto> nodesNeedToAdjust) {
        Map<String, List<NodeDto>> mappingFromKeyToNode = this.groupNodeByKey(nodesNeedToAdjust);
        List nodeKeys = nodesNeedToAdjust.stream().map(NodeDto::getKey).collect(Collectors.toList());
        for (String nodeKey : nodeKeys) {
            List<String> nextNodeKey = this.getAppropriateNextNodeKey(nodeKey, mappingFromKeyToNode);
            mappingFromKeyToNode.get(nodeKey).get(0).setNextNodeKey(nextNodeKey);
        }
    }

    private void adjustSubmitSource(List<NodeDto> nodesNeedToAdjust) {
        Map<String, List<NodeDto>> mappingFromKeyToNode = this.groupNodeByKey(nodesNeedToAdjust);
        List nodeKeys = nodesNeedToAdjust.stream().map(NodeDto::getKey).collect(Collectors.toList());
        for (String nodeKey : nodeKeys) {
            String submitSourceNodeKey = this.getAppropriateSubmitSourceNodeKey(nodeKey, mappingFromKeyToNode);
            mappingFromKeyToNode.get(nodeKey).get(0).setSubmitSourceNodeKey(submitSourceNodeKey);
        }
    }

    public Map<String, List<NodeDto>> groupNodeByKey(List<NodeDto> nodes) {
        HashMap<String, List<NodeDto>> mappingFromNodeKeyToNodes = new HashMap<String, List<NodeDto>>();
        for (NodeDto node : nodes) {
            mappingFromNodeKeyToNodes.put(node.getKey(), Collections.singletonList(node));
            if (node.getNodes() == null) continue;
            mappingFromNodeKeyToNodes.putAll(this.groupInternalSubProcessNode(node.getNodes()));
        }
        return mappingFromNodeKeyToNodes;
    }

    private Map<String, List<NodeDto>> groupInternalSubProcessNode(List<NodeVo> internalSubProcessNodes) {
        HashMap<String, List<NodeDto>> mappingFromNodeKeyToNodes = new HashMap<String, List<NodeDto>>();
        for (NodeVo internalSubProcessNode : internalSubProcessNodes) {
            if (internalSubProcessNode.getNodes() == null) continue;
            List nodes = internalSubProcessNode.getNodes();
            for (NodeDto node : nodes) {
                if (mappingFromNodeKeyToNodes.get(node.getKey()) == null) {
                    ArrayList<NodeDto> tempNodes = new ArrayList<NodeDto>();
                    tempNodes.add(node);
                    mappingFromNodeKeyToNodes.put(node.getKey(), tempNodes);
                    continue;
                }
                ((List)mappingFromNodeKeyToNodes.get(node.getKey())).add(node);
            }
        }
        return mappingFromNodeKeyToNodes;
    }

    public Map<String, List<String>> groupAssigneeByNodeOnlyId(List<NodeDto> nodes) {
        HashMap<String, List<String>> mappingFromNodeKeyToAssigneesAfterRemoveDuplicates = new HashMap<String, List<String>>();
        nodes.forEach(node -> {
            mappingFromNodeKeyToAssigneesAfterRemoveDuplicates.put(node.getOnlyId(), this.findIdsFrom(node.getAssignees()));
            if (node.getNodes() != null) {
                mappingFromNodeKeyToAssigneesAfterRemoveDuplicates.putAll(this.groupInternalSubProcessAssigneeByNodeOnlyId(node.getNodes()));
            }
        });
        return mappingFromNodeKeyToAssigneesAfterRemoveDuplicates;
    }

    private Map<String, List<String>> groupInternalSubProcessAssigneeByNodeOnlyId(List<NodeVo> internalSubProcessNodes) {
        HashMap<String, List<String>> mappingFromNodeKeyToAssigneesAfterRemoveDuplicates = new HashMap<String, List<String>>();
        for (NodeVo internalSubProcessNode : internalSubProcessNodes) {
            if (internalSubProcessNode.getNodes() == null) continue;
            List nodes = internalSubProcessNode.getNodes();
            for (NodeDto node : nodes) {
                mappingFromNodeKeyToAssigneesAfterRemoveDuplicates.put(node.getOnlyId(), this.findIdsFrom(node.getAssignees()));
            }
        }
        return mappingFromNodeKeyToAssigneesAfterRemoveDuplicates;
    }

    private List<String> findIdsFrom(List<BpmTreeModel> bpmTreeModels) {
        ArrayList<String> Ids = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : bpmTreeModels) {
            Ids.add(bpmTreeModel.getId());
        }
        return Ids;
    }

    private List<String> getAppropriateNextNodeKey(String nodeKey, Map<String, List<NodeDto>> mappingFromKeyToNode) {
        ArrayList<String> appropriateNextNodeKeys = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(mappingFromKeyToNode.get(nodeKey))) {
            List nextNodeKeys = mappingFromKeyToNode.get(nodeKey).get(0).getNextNodeKey();
            for (String nextNodeKey : nextNodeKeys) {
                ArrayDeque<String> nextNodeKeyQueue = new ArrayDeque<String>();
                nextNodeKeyQueue.add(nextNodeKey);
                while (!nextNodeKeyQueue.isEmpty()) {
                    String currentNextNodeKey = (String)nextNodeKeyQueue.poll();
                    if (!HussarUtils.isNotEmpty(mappingFromKeyToNode.get(currentNextNodeKey))) continue;
                    NodeDto currentNextNode = mappingFromKeyToNode.get(currentNextNodeKey).get(0);
                    if ("com.jxdinfo.workflow.User".equals(currentNextNode.getType()) || "com.jxdinfo.workflow.CallActivity".equals(currentNextNode.getType()) || "com.jxdinfo.workflow.SubProcess".equals(currentNextNode.getType())) {
                        appropriateNextNodeKeys.add(currentNextNodeKey);
                        continue;
                    }
                    nextNodeKeyQueue.addAll(currentNextNode.getNextNodeKey());
                }
            }
        }
        return appropriateNextNodeKeys;
    }

    private String getAppropriateSubmitSourceNodeKey(String nodeKey, Map<String, List<NodeDto>> mappingFromKeyToNode) {
        if (HussarUtils.isNotEmpty(mappingFromKeyToNode.get(nodeKey))) {
            String submitSourceNodeKey = mappingFromKeyToNode.get(nodeKey).get(0).getSubmitSourceNodeKey();
            for (int i = 0; i < mappingFromKeyToNode.size(); ++i) {
                NodeDto submitSourceNode;
                if (HussarUtils.isNotEmpty(mappingFromKeyToNode.get(submitSourceNodeKey))) {
                    submitSourceNode = mappingFromKeyToNode.get(submitSourceNodeKey).get(0);
                    if ("com.jxdinfo.workflow.User".equals(submitSourceNode.getType()) || "com.jxdinfo.workflow.SubProcess".equals(submitSourceNode.getType())) {
                        return submitSourceNodeKey;
                    }
                } else {
                    return submitSourceNodeKey;
                }
                submitSourceNodeKey = submitSourceNode.getSubmitSourceNodeKey();
            }
        }
        return null;
    }

    public Map<String, Object> findVariablesBy(NodeDto node) {
        String separateVariable;
        Object starter;
        String submitter;
        String submitSourceNodeKey;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)node.getSubmitSourceNodeKey()) && HussarUtils.isNotEmpty((Object)(submitSourceNodeKey = node.getSubmitSourceNodeKey()))) {
            variables.put("bpm_submit_source", submitSourceNodeKey);
        }
        if (HussarUtils.isNotEmpty((Object)node.getSubmitter()) && HussarUtils.isNotEmpty((Object)(submitter = node.getSubmitter().getId()))) {
            variables.put("sendUser", submitter);
        }
        if (HussarUtils.isNotEmpty((Object)node.getStarter()) && HussarUtils.isNotEmpty((Object)(starter = node.getStarter().getId()))) {
            variables.put("startUser", starter);
        }
        if (HussarUtils.isNotEmpty((Object)node.getNodeVariables())) {
            for (String nodeVariable : node.getNodeVariables()) {
                List bpmTreeModels;
                String nodeVarAssignee = "";
                Map nodeVariablesAssignee = node.getNodeVariablesAssignee();
                if (HussarUtils.isNotEmpty((Object)nodeVariablesAssignee) && HussarUtils.isNotEmpty((Object)(bpmTreeModels = (List)nodeVariablesAssignee.get(nodeVariable)))) {
                    nodeVarAssignee = this.parseIdToTocommaSeparatedString(bpmTreeModels);
                }
                variables.put(nodeVariable, nodeVarAssignee);
            }
        }
        if (HussarUtils.isNotEmpty((Object)node.getSeparateVariable()) && (separateVariable = node.getSeparateVariable()) != null) {
            variables.put("sub_process_separate_variable", separateVariable);
        }
        if (node.isCountersign()) {
            if (HussarUtils.isNotEmpty((Object)node.getMultiType())) {
                variables.put("multi_type", node.getMultiType());
            }
            if (HussarUtils.isNotEmpty((Object)node.getMultiFinishCondition())) {
                variables.put("multi_finish_condition", node.getMultiFinishCondition());
            }
        }
        if (HussarUtils.isNotEmpty((Object)node.getSubmitSourceNodeKey()) && HussarUtils.isNotEmpty((Object)(submitSourceNodeKey = node.getSubmitSourceNodeKey()))) {
            variables.put("bpm_submit_source", submitSourceNodeKey);
        }
        if (HussarUtils.isNotEmpty((Object)node.getSubmitter()) && HussarUtils.isNotEmpty((Object)(submitter = node.getSubmitter().getId()))) {
            variables.put("userId", submitter);
        }
        return variables;
    }

    private String parseIdToTocommaSeparatedString(List<BpmTreeModel> bpmTreeModels) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (BpmTreeModel bpmTreeModel : bpmTreeModels) {
            stringJoiner.add(bpmTreeModel.getId());
        }
        return stringJoiner.toString();
    }

    public Map<String, List<NodeDto>> parse(List<NodeVo> processNodes) {
        HashMap<String, List<NodeDto>> mappingFromProcessOnlyIdToNodes = new HashMap<String, List<NodeDto>>();
        processNodes.forEach(processNode -> mappingFromProcessOnlyIdToNodes.put(processNode.getOnlyId(), processNode.getNodes() == null ? new ArrayList() : processNode.getNodes()));
        return mappingFromProcessOnlyIdToNodes;
    }

    private static /* synthetic */ void lambda$isConditionTrue$15(String condition, ExpressionFactory factory, SimpleContext context, String k, Object v) {
        if ("bpm_next_node".equals(k) && condition.contains("bpm_next_node")) {
            List<String> nextNodes = Arrays.asList(((String)v).split(","));
            HashMap appropriateBpmNextNodeMap = new HashMap();
            nextNodes.forEach(n -> {
                SimpleContext bpmNextNodeContext = new SimpleContext();
                if (n != null) {
                    bpmNextNodeContext.setVariable(k, factory.createValueExpression(n, n.getClass()));
                } else {
                    bpmNextNodeContext.setVariable(k, factory.createValueExpression(n, Object.class));
                }
                ValueExpression bpmNextNodeValueExpression = factory.createValueExpression((ELContext)bpmNextNodeContext, condition, Boolean.TYPE);
                if (((Boolean)bpmNextNodeValueExpression.getValue((ELContext)bpmNextNodeContext)).booleanValue()) {
                    if (n != null) {
                        context.setVariable(k, factory.createValueExpression(n, n.getClass()));
                    } else {
                        context.setVariable(k, factory.createValueExpression(n, Object.class));
                    }
                    appropriateBpmNextNodeMap.put(k, n);
                }
            });
            if (HussarUtils.isEmpty(appropriateBpmNextNodeMap.get(k))) {
                context.setVariable(k, factory.createValueExpression(null, Object.class));
            }
        } else if (v != null) {
            context.setVariable(k, factory.createValueExpression(v, v.getClass()));
        } else {
            context.setVariable(k, factory.createValueExpression(v, Object.class));
        }
    }
}

