/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class JumpNodeLeaveAddCcTaskCmd
implements Command<Void> {
    private ExecutionEntity execution;
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);

    public JumpNodeLeaveAddCcTaskCmd(ExecutionEntity execution) {
        this.execution = execution;
    }

    public Void execute(CommandContext commandContext) {
        this.addCcTask(commandContext);
        this.fireExecutionListener();
        return null;
    }

    private void addCcTask(CommandContext commandContext) {
        if ("revoke".equals(commandContext.getAttribute("taskSourceFlag"))) {
            return;
        }
        BpmnModel bm = commandContext.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(this.execution.getProcessDefinitionId());
        if (!(bm.getFlowElement(this.execution.getActivityId()) instanceof UserTask)) {
            return;
        }
        Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, (ActivityExecution)this.execution);
        List ccUserIds = (List)ccUserMap.get("ccUser");
        String ccSendUser = (String)ccUserMap.get("ccSendUser");
        if (!ccUserIds.isEmpty()) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            String subProcessKey;
            String processInsId = this.execution.getProcessInstanceId();
            String taskDefKey = this.execution.getCurrentActivityId();
            String string = subProcessKey = this.execution.getVariable("sub_process_key") == null ? null : (String)this.execution.getVariable("sub_process_key");
            if (ccUserIds.isEmpty()) {
                return;
            }
            List hisTaskList = commandContext.getTaskEntityManager().findAllHistoricTask(processInsId, taskDefKey, subProcessKey);
            if (hisTaskList.isEmpty()) {
                return;
            }
            hisTaskList.sort((o1, o2) -> o2.getEndTime().compareTo(o1.getEndTime()));
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            List<String> userIds = AnalyticalModelUtil.getMultiInstanceUser(hisTaskList);
            ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
            ExecutionEntity processInstance = this.execution.getProcessInstance();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            List ccElement = (List)bm.getFlowElement(historicTaskInstance.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            String todoConfiguration = null;
            ArrayList<String> variableName = new ArrayList<String>();
            variableName.add("todoConfiguration");
            List variableList = commandContext.getVariableInstanceEntityManager().findVariableInstancesByTaskAndNames(historicTaskInstance.getId(), variableName);
            if (HussarUtils.isNotEmpty((Object)variableList)) {
                todoConfiguration = ((VariableInstanceEntity)variableList.get(0)).getTextValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : ccUserIds) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(historicTaskInstance.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPushList.add(dataPush);
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(historicTaskInstance.getProcessInstanceId())));
                sysActCcTask.setProcName(processInstance.getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(historicTaskInstance.getId())));
                sysActCcTask.setTaskName(historicTaskInstance.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(ccSendUser);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(historicTaskInstance.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(this.execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setToDoConfig(todoConfiguration);
                HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(historicTaskInstance.getProcessInstanceId());
                sysActCcTask.setProcExtendStringExtra1(historicProcessInstance.getProcExtendStringExtra1());
                sysActCcTask.setProcExtendStringExtra2(historicProcessInstance.getProcExtendStringExtra2());
                sysActCcTask.setProcExtendStringExtra3(historicProcessInstance.getProcExtendStringExtra3());
                sysActCcTask.setProcExtendStringExtra4(historicProcessInstance.getProcExtendStringExtra4());
                sysActCcTask.setProcExtendStringExtra5(historicProcessInstance.getProcExtendStringExtra5());
                sysActCcTask.setProcExtendIntegerExtra1(historicProcessInstance.getProcExtendIntegerExtra1());
                sysActCcTask.setProcExtendIntegerExtra2(historicProcessInstance.getProcExtendIntegerExtra2());
                sysActCcTask.setProcExtendIntegerExtra3(historicProcessInstance.getProcExtendIntegerExtra3());
                sysActCcTask.setProcExtendIntegerExtra4(historicProcessInstance.getProcExtendIntegerExtra4());
                sysActCcTask.setProcExtendIntegerExtra5(historicProcessInstance.getProcExtendIntegerExtra5());
                if (userIds.contains(sysActCcTask.getReceiveUser())) {
                    sysActCcTask.setTaskState("1");
                    sysActCcTask.setEndTime(new Timestamp(historicTaskInstance.getEndTime().getTime()));
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                list.add(sysActCcTask);
            }
            this.dataPushService.addCcTask(dataPushList);
            if (!list.isEmpty()) {
                this.iSysActCcTaskService.saveBatch(list);
            }
        }
    }

    public void fireExecutionListener() {
        this.execution.setEventName("end");
        List executionListeners = this.execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)this.execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PublicClientException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }
}

