/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.variable.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.ProcessBetaService;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartSubProcessDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u6d4b\u8bd5\u8bb0\u5f55\u76f8\u5173\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/bpm/records"})
public class ProcessBetaController {
    @Autowired
    ProcessBetaService processBetaService;

    @ApiOperation(value="\u83b7\u53d6\u6d4b\u8bd5\u7248\u672c\u6d41\u7a0b\u4ea7\u751f\u7684\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", dataType="String", paramType="query", required=true)})
    @AuditLog(moduleName="\u6d41\u7a0b\u6d4b\u8bd5", eventDesc="\u5b9e\u4f8b\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getProcessBetaList"})
    ApiResponse<IPage<ProcessInst>> getProcessBetaList(Page<ProcessInst> page, ProcessListDto processListDto) {
        ApiResponse apiResponse = ApiResponse.success((Object)this.processBetaService.getProcessBetaList(page, processListDto));
        return apiResponse;
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868", notes="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868")
    @AuditLog(moduleName="\u6d41\u7a0b\u56fe\u67e5\u770b", eventDesc="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> list(FlowChartCommonDto flowChartCommonDto) {
        return ApiResponse.success((Object)this.processBetaService.list(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount()));
    }

    @GetMapping(value={"/getProcessDetail"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u56fe\u5c55\u793a", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONObject> getProcessDetail(FlowChartCommonDto flowChartCommonDto) {
        return this.processBetaService.getProcessInfoForProcessTesting(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount());
    }

    @GetMapping(value={"/getProcessCompleteDetail"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u56fe\u5c55\u793a", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u529e\u7406\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONArray> getProcessCompleteDetail(FlowChartCommonDto flowChartCommonDto) {
        return ApiResponse.success((Object)this.processBetaService.getProcessCompleteInfo(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount()));
    }

    @GetMapping(value={"/getSubProcessRunningInfo"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", notes="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f")
    @AuditLog(moduleName="\u6d41\u7a0b\u56fe\u5c55\u793a", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONObject> getSubProcessRunningInfo(FlowChartCommonDto flowChartCommonDto) {
        return this.processBetaService.getSubProcessRunningInfoForProcessTesting(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId());
    }

    @GetMapping(value={"/subProcessList"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5bf9\u5e94\u7684\u5916\u90e8\u6d41\u7a0b\u6570\u636e", notes="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5bf9\u5e94\u7684\u5916\u90e8\u6d41\u7a0b\u6570\u636e")
    @AuditLog(moduleName="\u6d41\u7a0b\u56fe\u5c55\u793a", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5bf9\u5e94\u7684\u5916\u90e8\u6d41\u7a0b\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> subProcessList(FlowChartSubProcessDto flowChartSubProcessDto) {
        return ApiResponse.success((Object)this.processBetaService.subProcessList(flowChartSubProcessDto.getSupProcessInsId(), flowChartSubProcessDto.getBusinessId(), flowChartSubProcessDto.getTaskDefinitionKey(), flowChartSubProcessDto.getPage(), flowChartSubProcessDto.getSize()));
    }

    @PostMapping(value={"/deleteProcessById"})
    @ApiOperation(value="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteProcessById(@RequestBody String processInsId) {
        return this.processBetaService.deleteProcessInstance(processInsId);
    }

    @PostMapping(value={"/deleteFinishedProcessById"})
    @ApiOperation(value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteFinishedProcessById(@RequestBody String processInsId) {
        return this.processBetaService.deleteFinishedProcessInstance(processInsId);
    }
}

