/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.model.TestVariable;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.ProcessBetaService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.engine.service.VariableApiService;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableWorkflowApiService
implements VariableApiService {
    @Autowired
    VariableService variableService;
    @Autowired
    ProcessBetaService processBetaService;

    public ApiResponse<AllVariablesConfiguredInProcessVo> getAllVariablesConfiguredInMainProcess(String processKey) {
        return this.variableService.getAllVariablesConfiguredInMainProcess(processKey);
    }

    public ApiResponse<JSONObject> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        return this.variableService.getAllVariablesConfiguredInSubProcessAndBindingInfo(configuredInstanceVariableQuery);
    }

    public IPage<ProcessInst> getProcessBetaList(Page<ProcessInst> page, ProcessListDto processListDto) {
        return this.processBetaService.getProcessBetaList(page, processListDto);
    }

    public Map<String, Object> list(FlowChartCommonDto flowChartCommonDto) {
        return this.processBetaService.list(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount());
    }

    public ApiResponse<JSONObject> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processBetaService.getProcessInfoForProcessTesting(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONObject getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processBetaService.getProcessInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processBetaService.getProcessCompleteInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        return this.processBetaService.getSubProcessRunningInfoForProcessTesting(processInsId, businessId);
    }

    public JSONObject getSubProcessRunningInfo(String processInsId, String businessId) {
        return this.processBetaService.getSubProcessRunningInfo(processInsId, businessId);
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        return this.processBetaService.subProcessList(supProcessInsId, businessId, taskDefinitionKey, page, size);
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        return this.processBetaService.deleteFinishedProcessInstance(processInstCode);
    }

    public ApiResponse<String> deleteProcessInstance(String processInsId) {
        return this.processBetaService.deleteProcessInstance(processInsId);
    }

    public ApiResponse<AllVariablesConfiguredInProcessVo> findVariableById(String processInsId) {
        TestVariable variable = (TestVariable)this.variableService.getById((Serializable)((Object)processInsId));
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo = new AllVariablesConfiguredInProcessVo();
        if (variable != null && variable.getVariable() != null && !variable.getVariable().equals("")) {
            allVariablesConfiguredInProcessVo = (AllVariablesConfiguredInProcessVo)JSONObject.parseObject((String)variable.getVariable(), AllVariablesConfiguredInProcessVo.class);
        }
        return ApiResponse.success((Object)allVariablesConfiguredInProcessVo);
    }
}

