/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.variable.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActReModelMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReModel;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dao.TestVariableMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredInstanceVariableDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.dto.ConfiguredVariableDto;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.model.TestVariable;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.service.VariableService;
import com.jxdinfo.hussar.workflow.engine.bpm.variable.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowElements;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableServiceImpl
extends HussarServiceImpl<TestVariableMapper, TestVariable>
implements VariableService {
    private static final Logger logger = LoggerFactory.getLogger(VariableServiceImpl.class);
    private static final String PROCESS_MODEL_ERROR_MESSAGE = "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728";
    private static final String HAS_LOOP_ERROR_MESSAGE = "\u6d41\u7a0b\u4e2d\u5b58\u5728\u95ed\u73af";
    private static final String HAS_CALL_PROCESS_LOOP_ERROR_MESSAGE = "\u6d41\u7a0b\u8c03\u7528\u5b58\u5728\u95ed\u73af";
    private static final char MAIN_PROCESS_TAG = '1';
    private static final char INTERNAL_SUB_PROCESS_TAG = '2';
    private static final char EXTERNAL_SUB_PROCESS_TAG = '2';
    @Autowired
    private SysActProcessFileService processFileService;
    @Autowired
    private BpmActReModelMapper processModelMapper;
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private SeqBuilder seqBuilder;

    public void saveVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String procInstId) {
        TestVariable testVariable = new TestVariable();
        testVariable.setId(Long.valueOf(procInstId).longValue());
        testVariable.setProcessKey(allVariablesConfiguredInProcess.getProcessKey());
        testVariable.setVariable(JSON.toJSONString((Object)allVariablesConfiguredInProcess));
        this.saveOrUpdate((BaseEntity)testVariable);
    }

    public ApiResponse<AllVariablesConfiguredInProcessVo> getAllVariablesConfiguredInMainProcess(String processKey) {
        ApiResponse apiResponse;
        try {
            String latestTestProcessDefinitionId = this.processDefinitionsService.getLatestTestProcessDefinitionId(processKey);
            AllVariablesConfiguredInProcessVo allVariablesConfiguredInMainProcess = this.getAllVariablesConfiguredInProcess(latestTestProcessDefinitionId);
            this.markAllVariablesConfiguredInProcessAsMainProcessVariable(allVariablesConfiguredInMainProcess);
            this.bindMainAndSubProcessParentId(allVariablesConfiguredInMainProcess);
            this.checkProcessCallLoop(latestTestProcessDefinitionId);
            this.assembleDefaultSubProcess(allVariablesConfiguredInMainProcess);
            apiResponse = ApiResponse.success((Object)allVariablesConfiguredInMainProcess);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    public AllVariablesConfiguredInProcessVo getAllVariablesConfiguredInSubProcess(String processKey) throws BpmException {
        String latestTestProcessDefinitionId = this.processDefinitionsService.getLatestTestProcessDefinitionId(processKey);
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInSubProcess = this.getAllVariablesConfiguredInProcess(latestTestProcessDefinitionId);
        this.markAllVariablesConfiguredInProcessAsSubProcessVariable(allVariablesConfiguredInSubProcess);
        this.bindMainAndSubProcessParentId(allVariablesConfiguredInSubProcess);
        return allVariablesConfiguredInSubProcess;
    }

    private AllVariablesConfiguredInProcessVo getAllVariablesConfiguredInProcess(String processDefinitionId) throws BpmException {
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess = new AllVariablesConfiguredInProcessVo();
        String processKey = processDefinitionId.split(":")[0];
        allVariablesConfiguredInProcess.setOnlyId(this.generateOnlyId());
        allVariablesConfiguredInProcess.setProcessKey(processKey);
        allVariablesConfiguredInProcess.setProcessDefinitionId(processDefinitionId);
        allVariablesConfiguredInProcess.setProcessName(this.getProcessName(processKey));
        allVariablesConfiguredInProcess.setConfiguredInstanceVariables(this.listConfiguredInstanceVariable(processDefinitionId));
        return allVariablesConfiguredInProcess;
    }

    private String generateOnlyId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    private String getProcessName(String processKey) throws BpmException {
        BpmActReModel processModel = (BpmActReModel)((Object)this.processModelMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BpmActReModel::getName}).eq(BpmActReModel::getKey, (Object)processKey)));
        if (HussarUtils.isNotEmpty((Object)((Object)processModel))) {
            return processModel.getName();
        }
        logger.error(PROCESS_MODEL_ERROR_MESSAGE);
        throw new BpmException(PROCESS_MODEL_ERROR_MESSAGE, String.valueOf(processKey));
    }

    public List<ConfiguredInstanceVariableDto> listConfiguredInstanceVariable(String processDefinitionId) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        FlowModel testFlowModel = this.getTestFlowModel(processDefinitionId);
        configuredInstanceVariables.addAll(this.listConfiguredInstanceVariable(testFlowModel));
        return configuredInstanceVariables;
    }

    private FlowModel getTestFlowModel(String processDefinitionId) throws BpmException {
        WorkFlow workFlow = this.processFileService.getFileByProcessDefId(processDefinitionId, null, null);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        flowModel.setFlowIdentity(workFlow.getIdentity());
        return flowModel;
    }

    public List<ConfiguredInstanceVariableDto> listConfiguredInstanceVariable(FlowModel flowModel) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredMainProcessInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        ArrayList<ConfiguredInstanceVariableDto> configuredInternalSubProcessInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        configuredMainProcessInstanceVariables.addAll(this.parse(flowModel));
        this.markAsMainProcessInstanceVariable(configuredMainProcessInstanceVariables);
        List<FlowModel> internalSubProcessFlowModels = this.buildInternalSubProcessFlowModel(flowModel);
        for (FlowModel internalSubProcessFlowModel : internalSubProcessFlowModels) {
            configuredInternalSubProcessInstanceVariables.addAll(this.parse(internalSubProcessFlowModel));
        }
        this.markAsInternalSubProcessInstanceVariable(configuredInternalSubProcessInstanceVariables);
        configuredMainProcessInstanceVariables.addAll(configuredInternalSubProcessInstanceVariables);
        return configuredMainProcessInstanceVariables;
    }

    private List<ConfiguredInstanceVariableDto> parse(FlowModel flowModel) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        ConfiguredInstanceVariableDto processVariable = this.getProcessVariable(flowModel);
        if (HussarUtils.isNotEmpty((Object)processVariable)) {
            processVariable.setOnlyId(this.generateOnlyId());
            processVariable.setProcessKey(flowModel.getFlowIdentity());
            processVariable.setProcessName(flowModel.getProps().getFlowName());
            configuredInstanceVariables.add(processVariable);
        }
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            ConfiguredInstanceVariableDto elementVariable = this.getElementVariable(processElement, flowModel);
            if (HussarUtils.isNotEmpty((Object)elementVariable)) {
                elementVariable.setOnlyId(this.generateOnlyId());
                elementVariable.setProcessKey(flowModel.getFlowIdentity());
                elementVariable.setProcessName(flowModel.getProps().getFlowName());
                elementVariable.setInstanceKey(processElement.getInstanceKey());
                elementVariable.setType(processElement.getName());
                elementVariable.setInstanceName(HussarUtils.isEmpty((Object)processElement.getProps().getFlowName()) ? "\u8282\u70b9\uff08" + processElement.getInstanceKey() + ")" : processElement.getProps().getFlowName() + "\uff08" + processElement.getInstanceKey() + ")");
                configuredInstanceVariables.add(elementVariable);
                continue;
            }
            if (!"com.jxdinfo.workflow.CallActivity".equals(processElement.getName()) || !HussarUtils.isEmpty((Object)elementVariable)) continue;
            elementVariable = new ConfiguredInstanceVariableDto();
            elementVariable.setOnlyId(this.generateOnlyId());
            elementVariable.setProcessKey(flowModel.getFlowIdentity());
            elementVariable.setProcessName(flowModel.getProps().getFlowName());
            elementVariable.setInstanceKey(processElement.getInstanceKey());
            elementVariable.setType(processElement.getName());
            elementVariable.setConfiguredVariables(new ArrayList());
            elementVariable.setInstanceName(HussarUtils.isEmpty((Object)processElement.getProps().getFlowName()) ? "\u8282\u70b9\uff08" + processElement.getInstanceKey() + ")" : processElement.getProps().getFlowName() + "\uff08" + processElement.getInstanceKey() + ")");
            configuredInstanceVariables.add(elementVariable);
        }
        List processPaths = processSlots.getPath();
        Map<String, List<FlowObject>> mappingFromElementKeyToElement = this.groupElementByElementKey(processElements);
        for (FlowSequence processPath : processPaths) {
            String startNodeKey = processPath.getStart().getKey();
            List gangedInstance = mappingFromElementKeyToElement.get(startNodeKey).get(0).getGoOutPathes();
            ConfiguredInstanceVariableDto pathVariable = this.getPathVariable(processPath);
            if (!HussarUtils.isNotEmpty((Object)pathVariable)) continue;
            pathVariable.setOnlyId(this.generateOnlyId());
            pathVariable.setProcessKey(flowModel.getFlowIdentity());
            pathVariable.setProcessName(flowModel.getProps().getFlowName());
            pathVariable.setInstanceKey(processPath.getInstanceKey());
            pathVariable.setType(processPath.getName());
            pathVariable.setGangedInstance(gangedInstance);
            pathVariable.setInstanceName(HussarUtils.isEmpty((Object)processPath.getProps().getFlowName()) ? "\u8fde\u7ebf\uff08" + processPath.getInstanceKey() + ")" : processPath.getProps().getFlowName() + "\uff08" + processPath.getInstanceKey() + ")");
            configuredInstanceVariables.add(pathVariable);
        }
        return configuredInstanceVariables;
    }

    private ConfiguredInstanceVariableDto getProcessVariable(FlowModel flowModel) {
        ArrayList<FlowVariables> processFlowVariablesList = new ArrayList<FlowVariables>();
        processFlowVariablesList.addAll(this.listProcessFlowVariables(flowModel));
        return this.wrapFlowVariables(processFlowVariablesList);
    }

    private List<FlowVariables> listProcessFlowVariables(FlowModel flowModel) {
        FlowProps processProps;
        ArrayList<FlowVariables> processFlowVariablesList = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)flowModel.getProps()) && HussarUtils.isNotEmpty((Object)(processProps = flowModel.getProps()).getUseVariables())) {
            processFlowVariablesList.addAll(processProps.getUseVariables());
        }
        return processFlowVariablesList;
    }

    private ConfiguredInstanceVariableDto getElementVariable(FlowObject element, FlowModel flowModel) throws BpmException {
        ArrayList<FlowVariables> elementFlowVariablesList = new ArrayList<FlowVariables>();
        elementFlowVariablesList.addAll(this.listElementFlowVariables(element, flowModel));
        ConfiguredInstanceVariableDto originalElementVariable = this.wrapFlowVariables(elementFlowVariablesList);
        ConfiguredInstanceVariableDto finalElementVariable = this.removePathVariableAndCarbonCopyVariableFormElementVariable(originalElementVariable);
        return finalElementVariable;
    }

    private List<FlowVariables> listElementFlowVariables(FlowObject element, FlowModel flowModel) throws BpmException {
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        List processPaths = processSlots.getPath();
        ArrayList<String> elementKeysWhereYouHaveToAddNextNodeVariables = new ArrayList<String>();
        elementKeysWhereYouHaveToAddNextNodeVariables.addAll(this.findElementKeysWhereYouHaveToAddNextNodeVariables(processPaths, processElements, flowModel));
        ArrayList<FlowVariables> elementFlowVariables = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)element.getProps())) {
            FlowProps elementProps = element.getProps();
            if (HussarUtils.isNotEmpty((Object)elementProps.getUseVariables())) {
                elementFlowVariables.addAll(elementProps.getUseVariables());
            }
            if (HussarUtils.isNotEmpty((Object)elementProps.getFlowFunctionConfig())) {
                for (FlowFunctionConfig flowFunctionConfig : elementProps.getFlowFunctionConfig()) {
                    if (!this.whetherFunctionAreConfigured(elementProps, flowFunctionConfig) || !HussarUtils.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                    elementFlowVariables.addAll(flowFunctionConfig.getUseVariables());
                }
            }
        }
        if (elementKeysWhereYouHaveToAddNextNodeVariables.contains(element.getInstanceKey())) {
            FlowVariables flowVariables = new FlowVariables();
            flowVariables.setVariable("bpm_next_node");
            flowVariables.setVarType("String");
            flowVariables.setAnnotation("\u4e0b\u4e00\u8282\u70b9\u6807\u8bc6");
            elementFlowVariables.add(flowVariables);
        }
        return elementFlowVariables;
    }

    private List<String> findElementKeysWhereYouHaveToAddNextNodeVariables(List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        ArrayList<String> elementKeys = new ArrayList<String>();
        ArrayList<String> gatewayKeysIncludeNextNodeVariable = new ArrayList<String>();
        gatewayKeysIncludeNextNodeVariable.addAll(this.findGatewayKeysIncludeNextNodeVariable(paths));
        elementKeys.addAll(this.findLastUserNodeKeysBeforeGateway(gatewayKeysIncludeNextNodeVariable, paths, elements, flowModel));
        return elementKeys;
    }

    private List<String> findGatewayKeysIncludeNextNodeVariable(List<FlowSequence> paths) {
        ArrayList<FlowSequence> pathsIncludeNextNodeVariable = new ArrayList<FlowSequence>();
        ArrayList<String> gatewayKeysIncludeNextNodeVariable = new ArrayList<String>();
        for (FlowSequence path : paths) {
            if (!this.isIncludeNextNodeVariable(path)) continue;
            pathsIncludeNextNodeVariable.add(path);
        }
        for (FlowSequence pathIncludeNextNodeVariable : pathsIncludeNextNodeVariable) {
            gatewayKeysIncludeNextNodeVariable.add(pathIncludeNextNodeVariable.getStart().getKey());
        }
        return gatewayKeysIncludeNextNodeVariable;
    }

    private boolean isIncludeNextNodeVariable(FlowSequence path) {
        FlowProps pathProps;
        if (HussarUtils.isNotEmpty((Object)path.getProps()) && HussarUtils.isNotEmpty((Object)(pathProps = path.getProps()).getBackFlowCondition())) {
            String backFlowCondition = pathProps.getBackFlowCondition();
            return backFlowCondition.contains("bpm_next_node");
        }
        return false;
    }

    private List<String> findLastUserNodeKeysBeforeGateway(List<String> gatewayKeysIncludeNextNodeVariable, List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        ArrayList<String> elementKeys = new ArrayList<String>();
        for (String gatewayKeyIncludeNextNodeVariable : gatewayKeysIncludeNextNodeVariable) {
            elementKeys.addAll(new HashSet<String>(this.findLastUserNodeKeysBeforeGateway(gatewayKeyIncludeNextNodeVariable, paths, elements, flowModel)));
        }
        return elementKeys;
    }

    private List<String> findLastUserNodeKeysBeforeGateway(String gatewayKey, List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        Map<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = this.groupStarNodeKeysByEndNodeKey(paths);
        Map<String, List<FlowObject>> mappingFromElementKeyToElement = this.groupElementByElementKey(elements);
        ArrayList<String> lastUserNodeKeys = new ArrayList<String>();
        Stack<String> elementKeyStack = new Stack<String>();
        ArrayList<String> beingVisited = new ArrayList<String>();
        ArrayList<String> hasBeenVisited = new ArrayList<String>();
        String currentElement = gatewayKey;
        elementKeyStack.push(currentElement);
        while (!elementKeyStack.isEmpty()) {
            currentElement = (String)elementKeyStack.peek();
            FlowObject element = mappingFromElementKeyToElement.get(currentElement).get(0);
            String elementType = element.getName();
            if ("com.jxdinfo.workflow.User".equals(elementType) || "com.jxdinfo.workflow.CallActivity".equals(elementType)) {
                lastUserNodeKeys.add(currentElement);
                beingVisited.remove(currentElement);
                hasBeenVisited.add(currentElement);
                elementKeyStack.pop();
                continue;
            }
            if (!beingVisited.contains(currentElement) && !hasBeenVisited.contains(currentElement)) {
                beingVisited.add(currentElement);
                continue;
            }
            if (!beingVisited.contains(currentElement)) continue;
            ArrayList neighborElementKeys = new ArrayList();
            ArrayList<String> hasBeenVisitedNeighbor = new ArrayList<String>();
            if (HussarUtils.isNotEmpty(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement))) {
                neighborElementKeys.addAll(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement));
            }
            for (String neighborElementKey : neighborElementKeys) {
                if (hasBeenVisited.contains(neighborElementKey)) {
                    hasBeenVisitedNeighbor.add(neighborElementKey);
                    continue;
                }
                if (beingVisited.contains(neighborElementKey)) {
                    logger.error(HAS_LOOP_ERROR_MESSAGE);
                    throw new BpmException(HAS_LOOP_ERROR_MESSAGE, String.valueOf(flowModel.getFlowIdentity()));
                }
                elementKeyStack.push(neighborElementKey);
                break;
            }
            if (hasBeenVisitedNeighbor.size() != neighborElementKeys.size()) continue;
            beingVisited.remove(currentElement);
            hasBeenVisited.add(currentElement);
            elementKeyStack.pop();
        }
        return lastUserNodeKeys;
    }

    private Map<String, List<String>> groupStarNodeKeysByEndNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = new HashMap<String, List<String>>();
        mappingFromEndNodeKeyToStarNodeKeys.putAll(paths.stream().collect(Collectors.groupingBy(path -> path.getEnd().getKey(), Collectors.mapping(path -> path.getStart().getKey(), Collectors.toList()))));
        return mappingFromEndNodeKeyToStarNodeKeys;
    }

    private Map<String, List<FlowObject>> groupElementByElementKey(List<FlowObject> elements) {
        HashMap<String, List<FlowObject>> mappingFromElementKeyToElement = new HashMap<String, List<FlowObject>>();
        mappingFromElementKeyToElement.putAll(elements.stream().collect(Collectors.groupingBy(element -> element.getInstanceKey(), Collectors.toList())));
        return mappingFromElementKeyToElement;
    }

    private boolean whetherFunctionAreConfigured(FlowProps elementProps, FlowFunctionConfig flowFunctionConfig) {
        boolean tag = false;
        if (HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment()) && HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment().getDefaultBackCondtion()) && elementProps.getFlowAssignment().getDefaultBackCondtion().contains(flowFunctionConfig.getId())) {
            tag = true;
        }
        if (HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment()) && HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment().getJudgeBackCondition())) {
            for (JudgeBackCondition judgeBackCondition : elementProps.getFlowAssignment().getJudgeBackCondition()) {
                String judgeSpellCondition = judgeBackCondition.getJudgeSpellCondition();
                if (!judgeSpellCondition.contains(flowFunctionConfig.getId())) continue;
                tag = true;
                break;
            }
        }
        return tag;
    }

    private ConfiguredInstanceVariableDto removePathVariableAndCarbonCopyVariableFormElementVariable(ConfiguredInstanceVariableDto elementVariable) {
        if (HussarUtils.isNotEmpty((Object)elementVariable)) {
            List originalConfiguredVariables = elementVariable.getConfiguredVariables();
            HashSet nestPathKeys = new HashSet();
            List finalConfiguredVariables = originalConfiguredVariables.stream().filter(o -> {
                if (HussarUtils.isNotEmpty((Object)o.getSource())) {
                    if (o.getSource().contains("hussar_path")) {
                        nestPathKeys.add(o.getSource());
                    }
                    return !o.getSource().contains("hussar_path") && !o.getSource().contains("carbonCopy");
                }
                return true;
            }).collect(Collectors.toList());
            ConfiguredInstanceVariableDto finalElementVariable = new ConfiguredInstanceVariableDto();
            finalElementVariable.setOnlyId(elementVariable.getOnlyId());
            finalElementVariable.setProcessKey(elementVariable.getProcessKey());
            finalElementVariable.setProcessName(elementVariable.getProcessName());
            finalElementVariable.setInstanceKey(elementVariable.getInstanceKey());
            finalElementVariable.setInstanceName(elementVariable.getInstanceName());
            finalElementVariable.setInstanceType(elementVariable.getInstanceType());
            finalElementVariable.setType(elementVariable.getType());
            finalElementVariable.setNextPathKeys(new ArrayList(nestPathKeys));
            finalElementVariable.setConfiguredVariables(finalConfiguredVariables);
            return finalElementVariable;
        }
        return null;
    }

    private ConfiguredInstanceVariableDto getPathVariable(FlowSequence path) {
        ArrayList<FlowVariables> pathFlowVariablesList = new ArrayList<FlowVariables>();
        pathFlowVariablesList.addAll(this.listPathFlowVariables(path));
        if (HussarUtils.isNotEmpty(pathFlowVariablesList)) {
            return this.wrapFlowVariables(pathFlowVariablesList);
        }
        return null;
    }

    private List<FlowVariables> listPathFlowVariables(FlowSequence path) {
        FlowProps pathProps;
        ArrayList<FlowVariables> pathFlowVariablesList = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)path.getProps()) && HussarUtils.isNotEmpty((Object)(pathProps = path.getProps()).getUseVariables())) {
            pathFlowVariablesList.addAll(pathProps.getUseVariables());
        }
        return pathFlowVariablesList;
    }

    private ConfiguredInstanceVariableDto wrapFlowVariables(List<FlowVariables> flowVariablesList) {
        ConfiguredInstanceVariableDto configuredInstanceInstanceVariable = new ConfiguredInstanceVariableDto();
        ArrayList<ConfiguredVariableDto> configuredVariables = new ArrayList<ConfiguredVariableDto>();
        for (FlowVariables flowVariables : flowVariablesList) {
            ConfiguredVariableDto configuredVariable = new ConfiguredVariableDto();
            configuredVariable.setOnlyId(this.generateOnlyId());
            configuredVariable.setName(flowVariables.getVariable());
            configuredVariable.setType(flowVariables.getVarType());
            configuredVariable.setSource(flowVariables.getAction());
            configuredVariable.setAnnotation(flowVariables.getAnnotation());
            configuredVariable.setGroupedType("general");
            if (HussarUtils.isNotEmpty((Object)flowVariables.getSlaveTableName())) {
                configuredVariable.setGroupedType("sublist");
            }
            if ("bpm_next_node".equals(flowVariables.getVariable())) {
                configuredVariable.setGroupedType("bpmNextNode");
            }
            configuredVariables.add(configuredVariable);
        }
        if (HussarUtils.isNotEmpty(configuredVariables)) {
            configuredInstanceInstanceVariable.setConfiguredVariables(configuredVariables);
            return configuredInstanceInstanceVariable;
        }
        return null;
    }

    private void markAsInternalSubProcessInstanceVariable(List<ConfiguredInstanceVariableDto> configuredInternalVariables) {
        for (ConfiguredInstanceVariableDto configuredInternalVariable : configuredInternalVariables) {
            configuredInternalVariable.setInstanceType('2');
        }
    }

    private void markAsMainProcessInstanceVariable(List<ConfiguredInstanceVariableDto> configuredInstanceVariables) {
        for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
            configuredInstanceVariable.setInstanceType('1');
        }
    }

    private List<FlowModel> buildInternalSubProcessFlowModel(FlowModel flowModel) {
        ArrayList<FlowModel> internalSubProcessFlowModels = new ArrayList<FlowModel>();
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            String name = processElement.getName();
            if (!"com.jxdinfo.workflow.SubProcess".equals(name)) continue;
            FlowModel internalSubProcessFlowModel = new FlowModel();
            internalSubProcessFlowModel.setFlowIdentity(flowModel.getFlowIdentity());
            internalSubProcessFlowModel.setInstanceKey(processElement.getInstanceKey());
            FlowProps props = new FlowProps();
            props.setFlowName(flowModel.getProps().getFlowName());
            internalSubProcessFlowModel.setProps(props);
            FlowElements internalSubProcessSlots = processElement.getSlots();
            internalSubProcessFlowModel.setSlots(internalSubProcessSlots);
            internalSubProcessFlowModels.add(internalSubProcessFlowModel);
        }
        return internalSubProcessFlowModels;
    }

    private void markAllVariablesConfiguredInProcessAsMainProcessVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        allVariablesConfiguredInProcess.setProcessType('1');
    }

    private void markAllVariablesConfiguredInProcessAsSubProcessVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        allVariablesConfiguredInProcess.setProcessType('2');
    }

    private void bindMainAndSubProcessParentId(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
        String parentId = allVariablesConfiguredInProcess.getOnlyId();
        configuredInstanceVariables.forEach(configuredInstanceVariable -> configuredInstanceVariable.setParentId(parentId));
    }

    private void checkProcessCallLoop(String processDefinitionId) throws BpmException {
        HashSet<String> beingVisitedProcessKeys = new HashSet<String>();
        HashSet<String> hasBeenVisitedProcessKeys = new HashSet<String>();
        Stack<String> processDefIdStack = new Stack<String>();
        processDefIdStack.push(processDefinitionId);
        while (!processDefIdStack.isEmpty()) {
            processDefinitionId = (String)processDefIdStack.peek();
            String processKey = processDefinitionId.split(":")[0];
            if (!beingVisitedProcessKeys.contains(processKey) && !hasBeenVisitedProcessKeys.contains(processKey)) {
                beingVisitedProcessKeys.add(processKey);
                continue;
            }
            if (!beingVisitedProcessKeys.contains(processKey)) continue;
            HashSet<String> neighborProcessDefIds = new HashSet<String>();
            HashSet<String> hasBeenVisitedNeighborProcessKeys = new HashSet<String>();
            FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
            neighborProcessDefIds.addAll(this.listExternalSubProcessDefId(flowModel));
            for (String neighborProcessDefId : neighborProcessDefIds) {
                String neighborProcessKey = neighborProcessDefId.split(":")[0];
                if (hasBeenVisitedProcessKeys.contains(neighborProcessKey)) {
                    hasBeenVisitedNeighborProcessKeys.add(neighborProcessKey);
                    continue;
                }
                if (beingVisitedProcessKeys.contains(neighborProcessKey)) {
                    logger.error(HAS_CALL_PROCESS_LOOP_ERROR_MESSAGE);
                    throw new BpmException(HAS_CALL_PROCESS_LOOP_ERROR_MESSAGE, String.valueOf(flowModel.getFlowIdentity()));
                }
                processDefIdStack.push(neighborProcessDefId);
                break;
            }
            if (hasBeenVisitedNeighborProcessKeys.size() != neighborProcessDefIds.size()) continue;
            beingVisitedProcessKeys.remove(processKey);
            hasBeenVisitedProcessKeys.add(processKey);
            processDefIdStack.pop();
        }
    }

    private List<String> listExternalSubProcessDefId(FlowModel flowModel) throws BpmException {
        ArrayList<String> externalSubProcessDefIds = new ArrayList<String>();
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            List judgeBackConditions;
            String name = processElement.getName();
            if (!"com.jxdinfo.workflow.CallActivity".equals(name)) continue;
            FlowProps elementProps = processElement.getProps();
            String defaultProcessKey = elementProps.getFlowSelector().getDefaultProcessKey();
            String defaultTestProcessDefinitionId = this.processDefinitionsService.getLatestTestProcessDefinitionId(defaultProcessKey);
            externalSubProcessDefIds.add(defaultTestProcessDefinitionId);
            if (!HussarUtils.isNotEmpty((Object)elementProps.getFlowSelector().getJudgeBackCondition()) || !HussarUtils.isNotEmpty((Object)(judgeBackConditions = elementProps.getFlowSelector().getJudgeBackCondition()))) continue;
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                String conditionProcessKey = judgeBackCondition.getConditionProcessKey();
                String conditionTestProcessDefinitionId = this.processDefinitionsService.getLatestTestProcessDefinitionId(conditionProcessKey);
                externalSubProcessDefIds.add(conditionTestProcessDefinitionId);
            }
        }
        return externalSubProcessDefIds;
    }

    private void assembleDefaultSubProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) throws BpmException {
        ArrayDeque<Object> allVariablesConfiguredInProcessQueue = new ArrayDeque<Object>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            AllVariablesConfiguredInProcessVo currentProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List configuredInstanceVariables = currentProcess.getConfiguredInstanceVariables();
            for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                if (!"com.jxdinfo.workflow.CallActivity".equals(configuredInstanceVariable.getType())) continue;
                ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery = new ConfiguredInstanceVariableQueryDto();
                configuredInstanceVariableQuery.setConfiguredInstanceVariable(configuredInstanceVariable);
                configuredInstanceVariableQuery.setProcessDefinitionId(currentProcess.getProcessDefinitionId());
                ApiResponse<JSONObject> apiResponse = this.getAllVariablesConfiguredInSubProcessAndBindingInfo(configuredInstanceVariableQuery);
                if (!HussarUtils.isNotEmpty((Object)apiResponse.getData())) continue;
                List subProcess = JSONArray.parseArray((String)JSONArray.toJSONString((Object)((JSONObject)apiResponse.getData()).get((Object)"allVariablesConfiguredInSubProcessList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).stream().map(v -> (AllVariablesConfiguredInProcessVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)v, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), AllVariablesConfiguredInProcessVo.class)).collect(Collectors.toList());
                List bindingInfos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)((JSONObject)apiResponse.getData()).get((Object)"bindingSubProcessOnlyIds"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).stream().map(v -> (String)JSONObject.parseObject((String)JSONObject.toJSONString((Object)v, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), String.class)).collect(Collectors.toList());
                if (configuredInstanceVariable.getBindingSubProcessOnlyIds() == null) {
                    configuredInstanceVariable.setBindingSubProcessOnlyIds(new ArrayList());
                }
                configuredInstanceVariable.getBindingSubProcessOnlyIds().addAll(bindingInfos);
                if (currentProcess.getAllVariablesConfiguredInExternalSubProcesses() == null) {
                    currentProcess.setAllVariablesConfiguredInExternalSubProcesses(new ArrayList());
                }
                currentProcess.getAllVariablesConfiguredInExternalSubProcesses().addAll(subProcess);
                allVariablesConfiguredInProcessQueue.addAll(subProcess);
            }
        }
    }

    public ApiResponse<JSONObject> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        ApiResponse apiResponse;
        try {
            ConfiguredInstanceVariableDto configuredInstanceVariable = configuredInstanceVariableQuery.getConfiguredInstanceVariable();
            String processDefinitionId = configuredInstanceVariableQuery.getProcessDefinitionId();
            String nodeKey = configuredInstanceVariable.getInstanceKey();
            String nodeName = configuredInstanceVariable.getInstanceName();
            String configuredInstanceVariableOnlyId = configuredInstanceVariable.getOnlyId();
            List<Map<String, Object>> variables = this.findExternalSubProcessNodeVariableBy(configuredInstanceVariable);
            ArrayList<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInSubProcessList = new ArrayList<AllVariablesConfiguredInProcessVo>();
            ArrayList<String> bindingSubProcessOnlyIds = new ArrayList<String>();
            for (Map<String, Object> variable : variables) {
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                Map<String, String> processMessage = AnalyticalModelUtil.getCallActivityProcessKey(bm, nodeKey, variable);
                List<String> nodeVariables = AnalyticalModelUtil.getCallActivityNodeVariables(bm, nodeKey, variable);
                String externalSubProcessKey = processMessage.get("processKey");
                if (!HussarUtils.isNotEmpty((Object)externalSubProcessKey)) continue;
                AllVariablesConfiguredInProcessVo allVariablesConfiguredInSubProcess = this.getAllVariablesConfiguredInSubProcess(externalSubProcessKey);
                allVariablesConfiguredInSubProcess.setBindingVariablesFromMainProcess(variable);
                allVariablesConfiguredInSubProcess.setBindingConfiguredInstanceVariableOnlyIdFromMainProcess(configuredInstanceVariableOnlyId);
                allVariablesConfiguredInSubProcess.setBindingConfiguredInstanceVariableKeyFromMainProcess(nodeKey);
                allVariablesConfiguredInSubProcess.setBindingNodeVariablesFromMainProcess(nodeVariables);
                allVariablesConfiguredInSubProcess.setBindingMainProcessDefinitionId(processDefinitionId);
                allVariablesConfiguredInSubProcess.setBindingMainProcessOnlyId(configuredInstanceVariable.getParentId());
                String processName = allVariablesConfiguredInSubProcess.getProcessName();
                allVariablesConfiguredInSubProcess.setProcessName(processName + "\uff08" + nodeName.split("\uff08")[0] + "\uff09");
                allVariablesConfiguredInSubProcessList.add(allVariablesConfiguredInSubProcess);
                bindingSubProcessOnlyIds.add(allVariablesConfiguredInSubProcess.getOnlyId());
            }
            JSONObject result = new JSONObject();
            result.put("allVariablesConfiguredInSubProcessList", allVariablesConfiguredInSubProcessList);
            result.put("bindingSubProcessOnlyIds", bindingSubProcessOnlyIds);
            apiResponse = ApiResponse.success((Object)result);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    public List<Map<String, Object>> findExternalSubProcessNodeVariableBy(ConfiguredInstanceVariableDto configuredInstanceVariable) {
        int numberOfProcessStarts = configuredInstanceVariable.getNumberOfProcessStarts();
        List configuredVariables = configuredInstanceVariable.getConfiguredVariables();
        ArrayList<Map<String, Object>> variables = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < numberOfProcessStarts; ++i) {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            for (ConfiguredVariableDto configuredVariable : configuredVariables) {
                String name = null;
                Object value = null;
                if ("sublist".equals(configuredVariable.getGroupedType())) {
                    name = String.valueOf(configuredVariable.getName());
                    int arrayLength = String.valueOf(configuredVariable.getValue()).split(",").length;
                    value = i < arrayLength ? String.valueOf(configuredVariable.getValue()).split(",")[i] : "";
                } else {
                    name = String.valueOf(configuredVariable.getName());
                    value = configuredVariable.getValue();
                }
                if ("".equals(value) && !"bpm_next_node".equals(name)) {
                    if ("Boolean".equals(configuredVariable.getType())) {
                        variable.put(name, false);
                        continue;
                    }
                    variable.put(name, null);
                    continue;
                }
                variable.put(name, value);
            }
            variables.add(variable);
        }
        return variables;
    }

    public Map<String, Map<String, List<ConfiguredVariableDto>>> parse(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        return new HashMap<String, Map<String, List<ConfiguredVariableDto>>>(this.levelOrderTraversalAllVariablesConfiguredInProcess(allVariablesConfiguredInProcess));
    }

    private Map<String, Map<String, List<ConfiguredVariableDto>>> levelOrderTraversalAllVariablesConfiguredInProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        HashMap<String, Map<String, List<ConfiguredVariableDto>>> mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap<String, Map<String, List<ConfiguredVariableDto>>>();
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
            if (HussarUtils.isNotEmpty((Object)configuredInstanceVariables)) {
                HashMap<String, List> mappingFromInstanceKeyToConfiguredVariables = new HashMap<String, List>();
                for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                    List configuredVariables;
                    if (!configuredInstanceVariable.isProcessVariable()) {
                        String instanceKey = configuredInstanceVariable.getInstanceKey();
                        configuredVariables = configuredInstanceVariable.getConfiguredVariables();
                        if (mappingFromInstanceKeyToConfiguredVariables.get(instanceKey) == null) {
                            mappingFromInstanceKeyToConfiguredVariables.put(instanceKey, configuredVariables);
                            continue;
                        }
                        ((List)mappingFromInstanceKeyToConfiguredVariables.get(instanceKey)).addAll(configuredVariables);
                        continue;
                    }
                    String processKey = configuredInstanceVariable.getProcessKey();
                    configuredVariables = configuredInstanceVariable.getConfiguredVariables();
                    if (mappingFromInstanceKeyToConfiguredVariables.get(processKey) == null) {
                        mappingFromInstanceKeyToConfiguredVariables.put(processKey, configuredVariables);
                        continue;
                    }
                    ((List)mappingFromInstanceKeyToConfiguredVariables.get(processKey)).addAll(configuredVariables);
                }
                mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.put(allVariablesConfiguredInProcess.getOnlyId(), mappingFromInstanceKeyToConfiguredVariables);
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses());
        }
        return mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable;
    }

    public Map<String, AllVariablesConfiguredInProcessVo> groupAllVariablesConfiguredInProcessByProcessOnlyId(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        HashMap<String, AllVariablesConfiguredInProcessVo> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess = new HashMap<String, AllVariablesConfiguredInProcessVo>();
        mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.put(allVariablesConfiguredInProcess.getOnlyId(), allVariablesConfiguredInProcess);
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List allVariablesConfiguredInExternalSubProcesses = allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses();
            if (allVariablesConfiguredInExternalSubProcesses == null) continue;
            allVariablesConfiguredInExternalSubProcesses.forEach(p -> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.put(p.getOnlyId(), (AllVariablesConfiguredInProcessVo)p));
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInExternalSubProcesses);
        }
        return mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess;
    }

    public Map<String, ConfiguredInstanceVariableDto> groupConfiguredInstanceVariableByInstanceKey(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processKey) {
        HashMap<String, ConfiguredInstanceVariableDto> mappingFromInstanceKeyToConfiguredInstanceVariable = new HashMap<String, ConfiguredInstanceVariableDto>();
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            if (allVariablesConfiguredInProcess.getProcessKey().equals(processKey)) {
                List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
                if (!HussarUtils.isNotEmpty((Object)configuredInstanceVariables)) break;
                for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                    mappingFromInstanceKeyToConfiguredInstanceVariable.put(configuredInstanceVariable.getInstanceKey(), configuredInstanceVariable);
                }
                break;
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses());
        }
        return mappingFromInstanceKeyToConfiguredInstanceVariable;
    }

    public List<Map<String, String>> findExternalSubProcessDefIdsAndOnlyIdsFrom(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        ArrayList<Map<String, String>> externalSubProcessDefIdAndOnlyIds = new ArrayList<Map<String, String>>();
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List allVariablesConfiguredInExternalSubProcesses = allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses();
            if (!HussarUtils.isNotEmpty((Object)allVariablesConfiguredInExternalSubProcesses)) continue;
            for (AllVariablesConfiguredInProcessVo allVariablesConfiguredInExternalSubProcesse : allVariablesConfiguredInExternalSubProcesses) {
                HashMap<String, String> processInfos = new HashMap<String, String>();
                processInfos.put("processDefinitionId", allVariablesConfiguredInExternalSubProcesse.getProcessDefinitionId());
                processInfos.put("processOnlyId", allVariablesConfiguredInExternalSubProcesse.getOnlyId());
                externalSubProcessDefIdAndOnlyIds.add(processInfos);
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInExternalSubProcesses);
        }
        return externalSubProcessDefIdAndOnlyIds;
    }

    public Map<String, Object> findVariablesBy(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processKey, String processOnlyId, String nodeId) {
        HashMap<String, Map<String, List<ConfiguredVariableDto>>> mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap<String, Map<String, List<ConfiguredVariableDto>>>();
        HashMap configuredProcessVariableAndInstanceVariable = new HashMap();
        ArrayList configuredVariable = new ArrayList();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.putAll(this.parse(allVariablesConfiguredInProcess));
        if (HussarUtils.isNotEmpty(mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId))) {
            configuredProcessVariableAndInstanceVariable.putAll((Map)mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId));
        }
        if (processKey != null && HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(processKey))) {
            configuredVariable.addAll((Collection)configuredProcessVariableAndInstanceVariable.get(processKey));
        }
        if (nodeId != null && HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(nodeId))) {
            configuredVariable.addAll((Collection)configuredProcessVariableAndInstanceVariable.get(nodeId));
        }
        configuredVariable.forEach(v -> {
            if ("".equals(v.getValue()) && !"bpm_next_node".equals(v.getName())) {
                if ("Boolean".equals(v.getType())) {
                    variable.put(v.getName(), false);
                } else {
                    variable.put(v.getName(), null);
                }
            } else {
                variable.put(v.getName(), v.getValue());
            }
        });
        return variable;
    }

    public ConfiguredInstanceVariableDto findConfiguredInstanceVariableByNodeId(List<ConfiguredInstanceVariableDto> configuredInstanceVariables, String nodeKey) {
        for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
            if (!configuredInstanceVariable.getInstanceKey().equals(nodeKey)) continue;
            return configuredInstanceVariable;
        }
        return null;
    }
}

