/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        if (HussarUtils.isEmpty((Object)flowTaskQueryModel.getDateTime())) {
            flowTaskQueryModel.setDateTime(new Date());
        }
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setSuspensionState(String.valueOf(flowTask.getSuspensionState()));
            taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            taskManagerQueryVo.setProcExtendStringExtra1(flowTask.getProcExtendStringExtra1());
            taskManagerQueryVo.setProcExtendStringExtra2(flowTask.getProcExtendStringExtra2());
            taskManagerQueryVo.setProcExtendStringExtra3(flowTask.getProcExtendStringExtra3());
            taskManagerQueryVo.setProcExtendStringExtra4(flowTask.getProcExtendStringExtra4());
            taskManagerQueryVo.setProcExtendStringExtra5(flowTask.getProcExtendStringExtra5());
            taskManagerQueryVo.setProcExtendIntegerExtra1(flowTask.getProcExtendIntegerExtra1());
            taskManagerQueryVo.setProcExtendIntegerExtra2(flowTask.getProcExtendIntegerExtra2());
            taskManagerQueryVo.setProcExtendIntegerExtra3(flowTask.getProcExtendIntegerExtra3());
            taskManagerQueryVo.setProcExtendIntegerExtra4(flowTask.getProcExtendIntegerExtra4());
            taskManagerQueryVo.setProcExtendIntegerExtra5(flowTask.getProcExtendIntegerExtra5());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            if (flowTask.getTaskVariableMap() != null) {
                taskManagerQueryVo.setMessage((String)flowTask.getTaskVariableMap().get("todoConfiguration"));
                taskManagerQueryVo.setTaskSourceFlag((String)flowTask.getTaskVariableMap().get("taskSourceFlag"));
                taskManagerQueryVo.setSendUser((String)flowTask.getTaskVariableMap().get("sendUser"));
            }
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getProcessStartUserId()));
            resultData.add(taskManagerQueryVo);
        }
        Map map = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(map.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator2.next()).getSendUser()) == null ? "" : (String)map.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(map.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)map.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(map.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)map.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setProcessStartUserName(map.get(taskManagerQueryVo.getProcessStartUserId()) == null ? "" : (String)map.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null);
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTaskSourceFlag((String)taskVariables.get("taskSourceFlag"));
                taskManagerQueryVo.setProcExtendStringExtra1(flowTask.getProcExtendStringExtra1());
                taskManagerQueryVo.setProcExtendStringExtra2(flowTask.getProcExtendStringExtra2());
                taskManagerQueryVo.setProcExtendStringExtra3(flowTask.getProcExtendStringExtra3());
                taskManagerQueryVo.setProcExtendStringExtra4(flowTask.getProcExtendStringExtra4());
                taskManagerQueryVo.setProcExtendStringExtra5(flowTask.getProcExtendStringExtra5());
                taskManagerQueryVo.setProcExtendIntegerExtra1(flowTask.getProcExtendIntegerExtra1());
                taskManagerQueryVo.setProcExtendIntegerExtra2(flowTask.getProcExtendIntegerExtra2());
                taskManagerQueryVo.setProcExtendIntegerExtra3(flowTask.getProcExtendIntegerExtra3());
                taskManagerQueryVo.setProcExtendIntegerExtra4(flowTask.getProcExtendIntegerExtra4());
                taskManagerQueryVo.setProcExtendIntegerExtra5(flowTask.getProcExtendIntegerExtra5());
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : "\u5df2\u5b8c\u6210";
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser((String)taskVariables.get("sendUser"));
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(taskVariables.get("sendUser")));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                String message = HussarUtils.isNotEmpty((Object)flowTask.getTodoConfiguration()) ? flowTask.getTodoConfiguration() : (taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString());
                taskManagerQueryVo.setMessage(message);
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }
}

