/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bpm.common.BpmExtendCondition;
import com.jxdinfo.hussar.workflow.manage.util.ExtendConditionsUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final ITaskEngineService taskEngineService;
    private final RepositoryService repositoryService;
    private final IFlowTaskService flowTaskService;
    private static final Logger logger = LoggerFactory.getLogger(FlowEventsServiceImpl.class);
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;
    @Autowired
    private InstanceEngineMapper instanceEngineMapper;

    public FlowEventsServiceImpl(TaskService taskService, ITaskEngineService iTaskEngineService, RuntimeService runtimeService, RepositoryService repositoryService, IFlowTaskService flowTaskService) {
        this.taskService = taskService;
        this.taskEngineService = iTaskEngineService;
        this.repositoryService = repositoryService;
        this.flowTaskService = flowTaskService;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, TaskManageQueryDto taskManageQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        Date startBegin = null;
        Date startEnd = null;
        try {
            start = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getStartTime()) ? formatter.parse(taskManageQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getEndTime()) ? formatter.parse(taskManageQueryDto.getEndTime()) : null;
            startBegin = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getProcessStartBeginTime()) ? formatter.parse(taskManageQueryDto.getProcessStartBeginTime()) : null;
            startEnd = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getProcessStartEndTime()) ? formatter.parse(taskManageQueryDto.getProcessStartEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List bpmExtendConditions = taskManageQueryDto.getBpmExtendConditions();
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(taskManageQueryDto.getUserId(), taskManageQueryDto.getProcessKey(), taskManageQueryDto.getTaskDefinitionKey());
        flowTaskQueryModel.setProcessKeys(taskManageQueryDto.getProcessKeys());
        flowTaskQueryModel.setTodoConfiguration(taskManageQueryDto.getMessage());
        flowTaskQueryModel.setSendUserId(taskManageQueryDto.getSendUserId());
        flowTaskQueryModel.setStartUserId(taskManageQueryDto.getStartUserId());
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        flowTaskQueryModel.setProcessStartBeginTime(startBegin);
        flowTaskQueryModel.setProcessStartEndTime(startEnd);
        flowTaskQueryModel.setTaskDefinitionName(taskManageQueryDto.getTaskDefinitionName());
        StringBuilder stringBuilder = new StringBuilder();
        if (bpmExtendConditions != null) {
            for (BpmExtendCondition bpmExtendConditions1 : bpmExtendConditions) {
                String s;
                String name;
                if (bpmExtendConditions1.getConditionType().equals("IS_NULL") || bpmExtendConditions1.getConditionType().equals("IS_NOT_NULL")) {
                    stringBuilder.append(" and A.");
                    name = ExtendConditionsUtils.conditionsNameChange((String)bpmExtendConditions1.getParamName());
                    stringBuilder.append(name);
                    s = ExtendConditionsUtils.conditionsTypeChange((String)bpmExtendConditions1.getConditionType(), (String)bpmExtendConditions1.getConditionValue());
                    stringBuilder.append(s);
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)bpmExtendConditions1.getConditionValue())) continue;
                stringBuilder.append(" and A.");
                name = ExtendConditionsUtils.conditionsNameChange((String)bpmExtendConditions1.getParamName());
                stringBuilder.append(name);
                s = ExtendConditionsUtils.conditionsTypeChange((String)bpmExtendConditions1.getConditionType(), (String)bpmExtendConditions1.getConditionValue());
                stringBuilder.append(s);
            }
            flowTaskQueryModel.setFinalExtendConditions(stringBuilder.toString());
        }
        return this.flowTaskService.todoList(pages, flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.todoList(pages, flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, TaskManageQueryDto taskManageQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        Date startBegin = null;
        Date startEnd = null;
        Date finishStart = null;
        Date finishEnd = null;
        try {
            start = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getStartTime()) ? formatter.parse(taskManageQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getEndTime()) ? formatter.parse(taskManageQueryDto.getEndTime()) : null;
            startBegin = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getProcessStartBeginTime()) ? formatter.parse(taskManageQueryDto.getProcessStartBeginTime()) : null;
            startEnd = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getProcessStartEndTime()) ? formatter.parse(taskManageQueryDto.getProcessStartEndTime()) : null;
            finishStart = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getFinishStartTime()) ? formatter.parse(taskManageQueryDto.getFinishStartTime()) : null;
            finishEnd = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getFinishEndTime()) ? formatter.parse(taskManageQueryDto.getFinishEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List processKeys = taskManageQueryDto.getProcessKeys();
        List bpmExtendConditions = taskManageQueryDto.getBpmExtendConditions();
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(taskManageQueryDto.getUserId(), taskManageQueryDto.getProcessKey(), taskManageQueryDto.getTaskDefinitionKey());
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(taskManageQueryDto.getMessage());
        flowTaskQueryModel.setSendUserId(taskManageQueryDto.getSendUserId());
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        flowTaskQueryModel.setStartUserId(taskManageQueryDto.getStartUserId());
        flowTaskQueryModel.setProcessStartBeginTime(startBegin);
        flowTaskQueryModel.setProcessStartEndTime(startEnd);
        flowTaskQueryModel.setFinishStartTime(finishStart);
        flowTaskQueryModel.setFinishEndTime(finishEnd);
        flowTaskQueryModel.setTaskDefinitionName(taskManageQueryDto.getTaskDefinitionName());
        StringBuilder stringBuilder = new StringBuilder();
        if (bpmExtendConditions != null) {
            for (BpmExtendCondition bpmExtendConditions1 : bpmExtendConditions) {
                String s;
                String name;
                if (bpmExtendConditions1.getConditionType().equals("IS_NULL") || bpmExtendConditions1.getConditionType().equals("IS_NOT_NULL")) {
                    stringBuilder.append(" and aht.");
                    name = ExtendConditionsUtils.conditionsNameChange((String)bpmExtendConditions1.getParamName());
                    stringBuilder.append(name);
                    s = ExtendConditionsUtils.conditionsTypeChange((String)bpmExtendConditions1.getConditionType(), (String)bpmExtendConditions1.getConditionValue());
                    stringBuilder.append(s);
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)bpmExtendConditions1.getConditionValue())) continue;
                stringBuilder.append(" and aht.");
                name = ExtendConditionsUtils.conditionsNameChange((String)bpmExtendConditions1.getParamName());
                stringBuilder.append(name);
                s = ExtendConditionsUtils.conditionsTypeChange((String)bpmExtendConditions1.getConditionType(), (String)bpmExtendConditions1.getConditionValue());
                stringBuilder.append(s);
            }
            flowTaskQueryModel.setFinalExtendConditions(stringBuilder.toString());
        }
        return this.flowTaskService.doneList(pages, flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.doneList(pages, flowTaskQueryModel);
    }

    public JSONArray flowType() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (ProcessDefinition tmp : definitions) {
                String mainProcess = this.instanceEngineMapper.getProcess(tmp.getId());
                if ("3".equals(mainProcess)) continue;
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.getKey());
                tmpMap.put("name", tmp.getName());
                jsonArray.add(tmpMap);
            }
        }
        return jsonArray;
    }

    public ApiResponse<String> revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            throw new PublicClientException(check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            throw new PublicClientException((String)check.getResult().get(1));
        }
        BpmResponseResult bpmResponseResult = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (bpmResponseResult.getCode().equals("0")) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        return ApiResponse.success((String)bpmResponseResult.getMsg());
    }

    public ApiResponse<String> urgeTask(String processInsId, String userId) {
        return ApiResponse.success((String)this.urgeTaskService.urgeTask(processInsId, null, userId));
    }
}

