/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.SubProcessInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ExtendSubProcessActivityBehavior
extends SubProcessActivityBehavior {
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void execute(ActivityExecution execution) {
        HistoricActivityInstanceEntity historicActivityInstance;
        Object parentLoopCounter = execution.getParent().getVariableLocal("loopCounter");
        int loopCounter = parentLoopCounter == null ? 0 : (Integer)parentLoopCounter;
        Map subProcessRejectAppointMsg = (Map)Context.getCommandContext().getAttribute("subProcessRejectAppointMsg");
        String appointMsg = null;
        if (subProcessRejectAppointMsg != null) {
            appointMsg = (String)subProcessRejectAppointMsg.get(execution.getCurrentActivityId());
        }
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        List instanceModeNode = (List)element.getExtensionElements().get("instanceMode");
        String instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)instanceModeNode.get(0)).getAttributes().get("instanceMode")).get(0)).getValue();
        boolean startByAssignee = instanceMode.equals("assignee");
        PvmActivity activity = execution.getActivity();
        ActivityImpl initialActivity = (ActivityImpl)activity.getProperty("initial");
        if (initialActivity == null) {
            throw new ActivitiException("No initial activity found for subprocess " + execution.getActivity().getId());
        }
        String firstNodeId = ((PvmTransition)initialActivity.getOutgoingTransitions().get(0)).getDestination().getId();
        List<SubProcessInfo> subProcessInfos = new ArrayList();
        if (parentLoopCounter == null) {
            if (!startByAssignee) {
                List subProcessVariableConfigNode = (List)element.getExtensionElements().get("subProcessVariableConfig");
                String subProcessVariableConfig = ((ExtensionAttribute)((List)((ExtensionElement)subProcessVariableConfigNode.get(0)).getAttributes().get("subProcessVariableConfig")).get(0)).getValue();
                String subProcessVariable = execution.getVariable(subProcessVariableConfig) == null ? "" : String.valueOf(execution.getVariable(subProcessVariableConfig));
                SubProcessInfo subProcessInfo = new SubProcessInfo();
                subProcessInfo.setSubProcessSeparateVariable(subProcessVariable.split(",")[0]);
                subProcessInfos.add(subProcessInfo);
            } else {
                Object oldAppointMessage;
                List historicTaskInstances;
                List<String> user = null;
                if (appointMsg != null && HussarUtils.isNotEmpty((Object)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).taskDefinitionKey(firstNodeId)).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list())) && HussarUtils.isNotEmpty(oldAppointMessage = ((HistoricTaskInstance)historicTaskInstances.get(0)).getTaskLocalVariables().get("old_appoint_assignee"))) {
                    Object oldAppointAssigneeMap;
                    Object oldAppointObject;
                    user = oldAppointMessage instanceof HashMap ? (HussarUtils.isNotEmpty(oldAppointObject = (oldAppointAssigneeMap = (Map)oldAppointMessage).get(firstNodeId)) ? (oldAppointObject instanceof List ? (List<String>)oldAppointObject : Arrays.asList(String.valueOf(oldAppointObject).split(","))) : null) : (oldAppointMessage instanceof List ? (List<String>)oldAppointMessage : Arrays.asList(String.valueOf(oldAppointMessage).split(",")));
                }
                if (HussarUtils.isEmpty(user)) {
                    user = AnalyticalModelUtil.getConfigUser(bm, execution, false, null);
                }
                SubProcessInfo subProcessInfo = new SubProcessInfo();
                subProcessInfo.setAssignee(user);
                subProcessInfo.setSubProcessSeparateVariable("");
                subProcessInfos.add(subProcessInfo);
            }
            Context.getCommandContext().addAttribute("subProcessStartInfo" + execution.getCurrentActivityId(), subProcessInfos);
            this.subProcessCreateListener((ExecutionEntity)execution, appointMsg != null);
        }
        if (HussarUtils.isEmpty(subProcessInfos = (List)Context.getCommandContext().getAttribute("subProcessStartInfo" + execution.getCurrentActivityId()))) {
            throw new PublicClientException("\u6d41\u7a0b\u8fd0\u8f6c\u5230" + execution.getCurrentActivityName() + "\u65f6\u5b50\u6d41\u7a0b\u542f\u52a8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7981\u6b62\u64cd\u4f5c");
        }
        List list = historyService.createHistoricActivityInstanceQuery().processInstanceId(execution.getProcessInstanceId()).activityId(activity.getId()).list();
        HashMap<String, String> subProcessKeyMap = new HashMap<String, String>();
        int num = 0;
        Integer cycleCount = 1;
        for (HistoricActivityInstance historicActivityInstance2 : list) {
            String oldSubProcessKey = historicActivityInstance2.getSubProcessKey();
            if (oldSubProcessKey == null) continue;
            subProcessKeyMap.put(oldSubProcessKey.split(":")[1], oldSubProcessKey);
            int oldLoopCounter = Integer.valueOf(oldSubProcessKey.split(":")[2]);
            if (oldLoopCounter >= num) {
                num = oldLoopCounter + 1;
            }
            Integer oldCycleCount = historicActivityInstance2.getCycleCount();
            if (cycleCount > oldCycleCount) continue;
            cycleCount = oldCycleCount + 1;
        }
        SubProcessInfo subProcessInfo = (SubProcessInfo)subProcessInfos.get(loopCounter);
        execution.setVariableLocal("sub_process_separate_variable", (Object)subProcessInfo.getSubProcessSeparateVariable());
        String subProcessKey = (String)subProcessKeyMap.get(subProcessInfo.getSubProcessSeparateVariable());
        if (subProcessKey == null) {
            int addNum = 0;
            for (int i = 0; i < loopCounter; ++i) {
                if (subProcessKeyMap.keySet().contains(((SubProcessInfo)subProcessInfos.get(i)).getSubProcessSeparateVariable())) continue;
                ++addNum;
            }
            subProcessKey = activity.getId() + ":" + subProcessInfo.getSubProcessSeparateVariable() + ":" + (num + addNum);
            if (parentLoopCounter == null) {
                subProcessKey = activity.getId() + "::" + (num + addNum);
            }
        }
        ExecutionEntity parent = (ExecutionEntity)execution.getParent();
        if (parentLoopCounter != null && loopCounter == 0) {
            parent = parent.getParent();
        }
        if (parentLoopCounter != null) {
            historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance(parent);
            historicActivityInstance.setSubProcessKey(subProcessKey);
            if (HussarUtils.isNotEmpty((Object)subProcessInfo.getSubProcessName())) {
                historicActivityInstance.setSubProcessName(subProcessInfo.getSubProcessName());
            }
            historicActivityInstance.setCycleCount(cycleCount);
        } else {
            historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
            historicActivityInstance.setSubProcessKey(subProcessKey);
            if (HussarUtils.isNotEmpty((Object)subProcessInfo.getSubProcessName())) {
                historicActivityInstance.setSubProcessName(subProcessInfo.getSubProcessName());
            }
            historicActivityInstance.setCycleCount(cycleCount);
        }
        execution.setVariableLocal("sub_process_key", (Object)subProcessKey);
        execution.setVariableLocal("cycle_count", (Object)cycleCount);
        String firstAssignee = null;
        if (HussarUtils.isNotEmpty((Object)subProcessInfo.getAssignee())) {
            HashMap<String, List> appointMap = new HashMap<String, List>();
            appointMap.put(firstNodeId, subProcessInfo.getAssignee());
            firstAssignee = String.join((CharSequence)",", subProcessInfo.getAssignee());
            execution.setVariableLocal("appoint_assignee", appointMap);
        }
        this.initializeDataObjects(execution, activity);
        if (initialActivity.getActivityBehavior() != null && initialActivity.getActivityBehavior() instanceof NoneStartEventActivityBehavior) {
            ((ExecutionEntity)execution).setActivity(initialActivity);
            Context.getCommandContext().getHistoryManager().recordActivityStart((ExecutionEntity)execution);
        }
        execution.executeActivity((PvmActivity)initialActivity);
        ArrayList<TaskEntity> tasks = new ArrayList<TaskEntity>();
        this.getSubProcessStartTasks((ExecutionEntity)execution, tasks);
        for (TaskEntity taskEntity : tasks) {
            if (!firstNodeId.equals(taskEntity.getTaskDefinitionKey()) || firstAssignee == null) continue;
            taskEntity.setVariableLocal("old_appoint_assignee", (Object)firstAssignee);
        }
    }

    private void getSubProcessStartTasks(ExecutionEntity execution, List<TaskEntity> taskEntities) {
        if (execution.getTasks() != null) {
            taskEntities.addAll(execution.getTasks());
        }
        if (execution.getExecutions() != null) {
            for (ExecutionEntity entity : execution.getExecutions()) {
                this.getSubProcessStartTasks(entity, taskEntities);
            }
        }
    }

    public void lastExecutionEnded(ActivityExecution execution) {
        Map dataObjectVars;
        ScopeUtil.createEventScopeExecution((ExecutionEntity)((ExecutionEntity)execution));
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        ExecutionEntity activityExecution = new ExecutionEntity();
        if (execution.getParent() != null) {
            activityExecution = execution.getParent();
            activityExecution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
        }
        if (activityExecution.getParent() != null) {
            activityExecution = activityExecution.getParent();
            activityExecution.setVariableLocal("all_prev_node", (Object)("'" + ((ExecutionEntity)execution).getActivityId() + "'"));
        }
        if ((dataObjectVars = ((ActivityImpl)execution.getActivity()).getVariables()) != null) {
            execution.removeVariablesLocal(dataObjectVars.keySet());
        }
        this.bpmnActivityBehavior.performDefaultOutgoingBehavior(execution);
    }

    public void leave(ActivityExecution execution) {
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        super.leave(execution);
    }

    protected void initializeDataObjects(ActivityExecution execution, PvmActivity activity) {
        Map dataObjectVars = ((ActivityImpl)activity).getVariables();
        if (dataObjectVars != null) {
            execution.setVariablesLocal(dataObjectVars);
        }
    }

    private void subProcessCreateListener(ExecutionEntity execution, boolean isOldSubProcessInfo) {
        if (isOldSubProcessInfo) {
            execution.setEventName("subProcessStartWithOldInfo");
        } else {
            execution.setEventName("subProcessStart");
        }
        List executionListeners = execution.getActivity().getExecutionListeners("subProcessStart");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PublicClientException(bpmConstantProperties.getErrorExecutionListener());
            }
        }
    }
}

