/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    private static final String TEST_TEMPORARY_PROCESS_ERROR_MESSAGE = "\u6d4b\u8bd5\u548c\u4e34\u65f6\u6d41\u7a0b\u4e0d\u5b58\u5728";
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page) {
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName);
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public String getStartProcessDefinitionId(String processKey) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public List<String> getProcessDefinitionId(String processKey, Integer version) {
        return this.processDefinitionsMapper.getProcessDefinitionId(processKey, version);
    }

    public ApiResponse<String> setMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0) + this.processDefinitionsMapper.setMain(id, 1);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        if ((num += this.processDefinitionsMapper.setModelMain(id)) != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, id)) {
                return ApiResponse.success((String)BpmEnum.SET_SUCCESS.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.SET_FAIL.getMessage());
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getNotDeleteTheOnlyProcessDefinition(), Boolean.valueOf(false));
        }
    }

    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        return num;
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, id, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, processDefinition.getId())) {
                return ApiResponse.success((String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public List<ProcessDefinitionModel> getProcessMainOrNew(String processKey) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(processKey);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        newList.add(list.get(0));
        return newList;
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public int setVersionTest(String processDefinitionId) {
        return this.processDefinitionsMapper.setVersionTest(processDefinitionId);
    }

    public String getProcessDefinitionIdByDeploymentId(Long deploymentId) {
        return this.processDefinitionsMapper.getProcessDefinitionIdByDeploymentId(deploymentId);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId);
        this.processDefinitionsMapper.updateExecution(defId, processInsId);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public int getLatestTestProcessVersion(String processKey) throws BpmException {
        List<Integer> testProcessVersions = this.processDefinitionsMapper.listTestProcessVersionThatOrderByAsc(processKey);
        if (HussarUtils.isNotEmpty(testProcessVersions)) {
            return testProcessVersions.get(0);
        }
        throw new BpmException("${" + processKey + "}\u672a\u53d1\u5e03\u6d4b\u8bd5\u7248\u672c", String.valueOf(processKey));
    }

    public int getLowestVersion(String processKey) throws BpmException {
        List<Integer> allTemporaryAndTestVersion = this.processDefinitionsMapper.listAllTemporaryAndTestVersion(processKey);
        if (HussarUtils.isNotEmpty(allTemporaryAndTestVersion)) {
            return allTemporaryAndTestVersion.get(0);
        }
        throw new BpmException(TEST_TEMPORARY_PROCESS_ERROR_MESSAGE, String.valueOf(processKey));
    }

    public String getLatestTestProcessDefinitionId(String processKey) throws BpmException {
        List<String> testProcessDefinitionIds = this.processDefinitionsMapper.listTestProcessDefinitionId(processKey);
        if (HussarUtils.isNotEmpty(testProcessDefinitionIds)) {
            return testProcessDefinitionIds.get(0);
        }
        throw new BpmException("${" + processKey + "}\u672a\u53d1\u5e03\u6d4b\u8bd5\u7248\u672c", String.valueOf(processKey));
    }

    public boolean hasTemporaryAndTestVersion(String processKey) {
        try {
            this.getLowestVersion(processKey);
            return true;
        }
        catch (BpmException e) {
            return false;
        }
    }

    public boolean hasTestProcessVersion(String processKey) {
        try {
            this.getLatestTestProcessVersion(processKey);
            return true;
        }
        catch (BpmException e) {
            return false;
        }
    }

    public boolean isTestProcess(String processDefinitionId) {
        boolean testProcess = false;
        String mainProcessTag = this.processDefinitionsMapper.getMainProcessTag(processDefinitionId);
        if (mainProcessTag != null && mainProcessTag.equals("3")) {
            testProcess = true;
        }
        return testProcess;
    }
}

