/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmExceptionPushUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.message.ExceptionMessageParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
public class BpmGlobalExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(BpmGlobalExceptionHandler.class);
    private final BpmConstantProperties bpmConstantProperties;

    public BpmGlobalExceptionHandler(BpmConstantProperties bpmConstantProperties) {
        this.bpmConstantProperties = bpmConstantProperties;
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    public ApiResponse<Object> credentials(PropertyNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = new BpmException(BpmExceptionCodeEnum.PROPERTY_NOT_FOUND);
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    public ApiResponse<Object> credentials(ActivitiIllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = e.getMessage().contains(" null") ? new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL) : new BpmException(e.getMessage());
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    public ApiResponse<Object> credentials(ActivitiTaskAlreadyClaimedException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = new BpmException(BpmExceptionCodeEnum.TASK_ALREADY_CLAIMED);
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiException.class})
    public ApiResponse<Object> credentials(ActivitiException e, HttpServletRequest request, HttpServletResponse response) {
        BpmException bpmException;
        this.doResponse(response);
        if (e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessDefinitionEntity")) {
            bpmException = new BpmException(BpmExceptionCodeEnum.MODEL_IS_SUSPENDED);
        } else if (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessDefinitionEntity")) {
            bpmException = new BpmException(BpmExceptionCodeEnum.MODEL_IS_SUSPENDED);
        } else if (e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessInstance")) {
            bpmException = new BpmException(BpmExceptionCodeEnum.PROCESS_INS_IS_SUSPENDED);
        } else if (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessInstance")) {
            bpmException = new BpmException(BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_ACTIVE);
        } else if (e.getMessage().startsWith("Process instance is still running, cannot delete historic process instance")) {
            bpmException = new BpmException(BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_NOT_END);
        } else if ("Cannot claim a suspended task".equals(e.getMessage()) || "\u4efb\u52a1\u5df2\u6302\u8d77\uff01".equals(e.getMessage())) {
            BpmExceptionMessageParam bpmExceptionMessageParam = BpmExceptionMessageParam.convertExceptionMessageParam((ExceptionMessageParam)e.getMessageParam());
            bpmException = new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED, bpmExceptionMessageParam);
        } else if (e.getMessage().startsWith("No outgoing sequence flow of")) {
            BpmExceptionMessageParam bpmExceptionMessageParam = BpmExceptionMessageParam.convertExceptionMessageParam((ExceptionMessageParam)e.getMessageParam());
            bpmException = new BpmException(BpmExceptionCodeEnum.NO_OUT_GOING_SEQUENCE, bpmExceptionMessageParam);
        } else if (e.getMessage().startsWith("Exception while invoking TaskListener:")) {
            BpmExceptionMessageParam bpmExceptionMessageParam = BpmExceptionMessageParam.convertExceptionMessageParam((ExceptionMessageParam)e.getMessageParam());
            bpmException = new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_TASK_LISTENER, bpmExceptionMessageParam);
        } else {
            bpmException = new BpmException(e.getMessage());
        }
        BpmExceptionPushUtil.pushExceptionMessage(bpmException);
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    public ApiResponse<Object> credentials(ActivitiObjectNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        BpmException bpmException = e.getMessage().startsWith("Cannot find task with id ") ? new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND) : (e.getMessage().startsWith("Cannot find process definition for id ") || e.getMessage().startsWith("no deployed process definition found with id") ? new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND) : (e.getMessage().startsWith("Cannot find processInstance for id") || e.getMessage().startsWith("No process instance found for id") || e.getMessage().startsWith("No historic process instance found with id") ? new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND) : new BpmException(e.getMessage())));
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={BpmException.class})
    public ApiResponse<Object> credentials(BpmException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("BpmException\uff1a", (Throwable)e);
        BpmExceptionPushUtil.pushExceptionMessage(e);
        StackTraceElement stackTraceElement = e.getStackTrace()[0];
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        sb.append("\u5f02\u5e38\u7c7b\u540d\uff1a").append(stackTraceElement.getClassName());
        sb.append("\u5f02\u5e38\u65b9\u6cd5\u540d\uff1a").append(stackTraceElement.getMethodName());
        sb.append(";\u5f02\u5e38\u6587\u4ef6\u540d\uff1a").append(stackTraceElement.getFileName());
        sb.append("\u5f02\u5e38\u884c\u6570\uff1a").append(stackTraceElement.getLineNumber());
        sb.append("\u8bf7\u6c42\u8def\u5f84\uff1a").append(request.getRequestURL()).append(";");
        HashMap map = new HashMap(request.getParameterMap());
        map.remove("tenantCipher");
        for (Map.Entry k : map.entrySet()) {
            String[] message = (String[])k.getValue();
            if (message.length == 0) {
                map.put(k.getKey(), null);
                continue;
            }
            if (message.length != 1) continue;
            map.put(k.getKey(), message[0]);
        }
        if (ToolUtil.isNotEmpty(map)) {
            sb.append("\u8bf7\u6c42\u53c2\u6570\uff1a").append(JSONObject.toJSONString(map)).append(";");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("userId", HttpKit.getIp());
        info.put("userAccount", HttpKit.getIp());
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        info.put("tenantId", request.getParameter("tenantId"));
        info.put("tenantCipher", request.getParameter("tenantCipher"));
        InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog(info, sb.toString()));
        return this.fail(e);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(PublicClientException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        BpmException bpmException = new BpmException(e.getReason());
        return this.fail(bpmException);
    }

    private void doResponse(HttpServletResponse response) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }

    ApiResponse<Object> fail(BpmException e) {
        return ApiResponse.fail((int)e.getExceptionCode(), (String)(e.getMessage() + BpmExceptionPushUtil.getSuccessSendExceptionMessagePleaseWait(e)));
    }
}

