/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigneemanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.dto.BatchDeptDto;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.dto.BatchRoleDto;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.dto.BatchRoleUserDto;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.dto.BatchUserDto;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.model.BpmUserData;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.service.BpmUserDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.constant.CallStateEnum;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.constant.ChangeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.constant.InterfaceTypeEnum;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.dto.GetCallRecordDto;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmOrgan;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmRoles;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysBpmUserRole;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.model.SysInterfaceChangeRecord;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmOrganService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmRolesService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmUserRoleService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysInterfaceChangeRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
@HussarTokenDs
public class BpmUserDataDataServiceImpl
implements BpmUserDataService {
    private static final Logger logger = LoggerFactory.getLogger(BpmUserDataDataServiceImpl.class);
    private static final String FAIL_MESSAGE = "\u7528\u6237\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff1a";
    @Autowired
    private SysBpmOrganService sysBpmOrganService;
    @Autowired
    private SysBpmRolesService sysBpmRolesService;
    @Autowired
    private SysBpmUserRoleService sysBpmUserRoleService;
    @Autowired
    private SysInterfaceChangeRecordService sysInterfaceChangeRecordService;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;

    public String batchAddUser(List<BatchUserDto> batchUserDtoList) {
        String failMessage = null;
        try {
            ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
            for (BatchUserDto batchUserDto : batchUserDtoList) {
                SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
                sysBpmOrgan.setOrganId(batchUserDto.getUserId());
                sysBpmOrgan.setOrganName(batchUserDto.getUserName());
                sysBpmOrgan.setParentId(batchUserDto.getDeptId());
                sysBpmOrgan.setSort(batchUserDto.getOrder());
                sysBpmOrgan.seteMail(batchUserDto.getEmail());
                sysBpmOrgan.setMobile(batchUserDto.getMobile());
                sysBpmOrgan.setUserAccount(batchUserDto.getUserAccount());
                sysBpmOrgan.setIsMain(Integer.valueOf(HussarUtils.isNotEmpty((Object)batchUserDto.getIsMain()) ? batchUserDto.getIsMain() : 1));
                sysBpmOrgan.setSecurityLevel(Integer.valueOf(3));
                sysBpmOrgan.setOrganType("user");
                sysBpmOrgans.add(sysBpmOrgan);
            }
            this.sysBpmOrganService.saveBatch(sysBpmOrgans);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.USER.ordinal(), ChangeTypeEnum.ADD.ordinal(), batchUserDtoList);
        return failMessage;
    }

    public String batchUpdateUser(List<BatchUserDto> batchUserDtoList) {
        String failMessage = null;
        try {
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(SysBpmOrgan::getOrganId, (Collection)batchUserDtoList.stream().map(BatchUserDto::getUserId).collect(Collectors.toList()));
            this.sysBpmOrganService.remove((Wrapper)queryWrapper1);
            ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
            for (BatchUserDto batchUserDto : batchUserDtoList) {
                SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
                sysBpmOrgan.setOrganId(batchUserDto.getUserId());
                sysBpmOrgan.setOrganName(batchUserDto.getUserName());
                sysBpmOrgan.setParentId(batchUserDto.getDeptId());
                sysBpmOrgan.setSort(batchUserDto.getOrder());
                sysBpmOrgan.seteMail(batchUserDto.getEmail());
                sysBpmOrgan.setMobile(batchUserDto.getMobile());
                sysBpmOrgan.setIsMain(Integer.valueOf(HussarUtils.isNotEmpty((Object)batchUserDto.getIsMain()) ? batchUserDto.getIsMain() : 1));
                sysBpmOrgan.setUserAccount(batchUserDto.getUserAccount());
                sysBpmOrgan.setSecurityLevel(Integer.valueOf(3));
                sysBpmOrgan.setOrganType("user");
                sysBpmOrgans.add(sysBpmOrgan);
            }
            this.sysBpmOrganService.saveBatch(sysBpmOrgans);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.USER.ordinal(), ChangeTypeEnum.UPDATE.ordinal(), batchUserDtoList);
        return failMessage;
    }

    public String batchDeleteUser(List<String> userIds) {
        String failMessage = null;
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysBpmOrgan::getOrganId, userIds);
            this.sysBpmOrganService.remove((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.USER.ordinal(), ChangeTypeEnum.DELETE.ordinal(), userIds);
        return failMessage;
    }

    public String batchAddDept(List<BatchDeptDto> batchDeptDtoList) {
        String failMessage = null;
        try {
            ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
            for (BatchDeptDto batchDeptDto : batchDeptDtoList) {
                SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
                sysBpmOrgan.setOrganId(batchDeptDto.getDeptId());
                sysBpmOrgan.setOrganName(batchDeptDto.getDeptName());
                sysBpmOrgan.setParentId(batchDeptDto.getParentId());
                sysBpmOrgan.setSort(Integer.valueOf(batchDeptDto.getOrder()));
                sysBpmOrgan.setIsMain(Integer.valueOf(1));
                sysBpmOrgan.setOrganType("organ");
                sysBpmOrgans.add(sysBpmOrgan);
            }
            this.sysBpmOrganService.saveBatch(sysBpmOrgans);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.DEPT.ordinal(), ChangeTypeEnum.ADD.ordinal(), batchDeptDtoList);
        return failMessage;
    }

    public String batchUpdateDept(List<BatchDeptDto> batchDeptDtoList) {
        String failMessage = null;
        try {
            List oldSysBpmOrganList = this.sysBpmOrganService.list((Wrapper)new LambdaQueryWrapper().in(SysBpmOrgan::getOrganId, (Collection)batchDeptDtoList.stream().map(BatchDeptDto::getDeptId).collect(Collectors.toList())));
            Map map = oldSysBpmOrganList.stream().collect(Collectors.toMap(SysBpmOrgan::getOrganId, Function.identity()));
            ArrayList<SysBpmOrgan> sysBpmOrganList = new ArrayList<SysBpmOrgan>();
            for (BatchDeptDto batchDeptDto : batchDeptDtoList) {
                SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
                SysBpmOrgan oldSysBpmOrgan = (SysBpmOrgan)map.get(batchDeptDto.getDeptId());
                BeanUtils.copyProperties((Object)oldSysBpmOrgan, (Object)sysBpmOrgan);
                sysBpmOrgan.setOrganName(batchDeptDto.getDeptName());
                sysBpmOrgan.setOrganId(batchDeptDto.getDeptId());
                sysBpmOrgan.setParentId(batchDeptDto.getParentId());
                sysBpmOrgan.setSort(Integer.valueOf(batchDeptDto.getOrder()));
                sysBpmOrganList.add(sysBpmOrgan);
            }
            this.sysBpmOrganService.updateBatchById(sysBpmOrganList);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.DEPT.ordinal(), ChangeTypeEnum.UPDATE.ordinal(), batchDeptDtoList);
        return failMessage;
    }

    public String batchDeleteDept(List<String> deptIds) {
        String failMessage = null;
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysBpmOrgan::getOrganId, deptIds);
            this.sysBpmOrganService.remove((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.DEPT.ordinal(), ChangeTypeEnum.DELETE.ordinal(), deptIds);
        return failMessage;
    }

    public String batchAddRole(List<BatchRoleDto> batchRoleDtoList) {
        String failMessage = null;
        try {
            ArrayList<SysBpmRoles> sysBpmRolesList = new ArrayList<SysBpmRoles>();
            int des = 1;
            List lastSysBpmRolesList = this.sysBpmRolesService.list((Wrapper)new LambdaQueryWrapper().orderByDesc(SysBpmRoles::getDes));
            SysBpmRoles lastSysBpmRoles = null;
            if (HussarUtils.isNotEmpty((Object)lastSysBpmRolesList)) {
                lastSysBpmRoles = (SysBpmRoles)lastSysBpmRolesList.get(0);
            }
            if (HussarUtils.isNotEmpty(lastSysBpmRoles)) {
                des = lastSysBpmRoles.getDes() + 1;
            }
            for (BatchRoleDto batchRoleDto : batchRoleDtoList) {
                SysBpmRoles sysBpmRoles = new SysBpmRoles();
                sysBpmRoles.setRoleId(batchRoleDto.getRoleId());
                sysBpmRoles.setRoleName(batchRoleDto.getRoleName());
                sysBpmRoles.setParentId(batchRoleDto.getParentId());
                sysBpmRoles.setRoleType(batchRoleDto.getRoleType());
                sysBpmRoles.setDes(Integer.valueOf(des++));
                sysBpmRolesList.add(sysBpmRoles);
            }
            this.sysBpmRolesService.saveBatch(sysBpmRolesList);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.ROLE.ordinal(), ChangeTypeEnum.ADD.ordinal(), batchRoleDtoList);
        return failMessage;
    }

    public String batchUpdateRole(List<BatchRoleDto> batchRoleDtoList) {
        String failMessage = null;
        try {
            List oldSysBpmRolesList = this.sysBpmRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysBpmRoles::getRoleId, (Collection)batchRoleDtoList.stream().map(BatchRoleDto::getRoleId).collect(Collectors.toList())));
            Map map = oldSysBpmRolesList.stream().collect(Collectors.toMap(SysBpmRoles::getRoleId, Function.identity()));
            ArrayList<SysBpmRoles> sysBpmRoleList = new ArrayList<SysBpmRoles>();
            for (BatchRoleDto batchRoleDto : batchRoleDtoList) {
                SysBpmRoles sysBpmRoles = new SysBpmRoles();
                SysBpmRoles oldSysBpmRoles = (SysBpmRoles)map.get(batchRoleDto.getRoleId());
                BeanUtils.copyProperties((Object)oldSysBpmRoles, (Object)sysBpmRoles);
                sysBpmRoles.setRoleName(batchRoleDto.getRoleName());
                sysBpmRoleList.add(sysBpmRoles);
            }
            this.sysBpmRolesService.updateBatchById(sysBpmRoleList);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.ROLE.ordinal(), ChangeTypeEnum.UPDATE.ordinal(), batchRoleDtoList);
        return failMessage;
    }

    public String batchDeleteRole(List<String> roleIds) {
        String failMessage = null;
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysBpmRoles::getRoleId, roleIds);
            this.sysBpmRolesService.remove((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.ROLE.ordinal(), ChangeTypeEnum.DELETE.ordinal(), roleIds);
        return failMessage;
    }

    public String batchDeleteRoleUser(List<BatchRoleUserDto> batchRoleUserDtoList) {
        String failMessage = null;
        try {
            for (BatchRoleUserDto batchRoleUserDto : batchRoleUserDtoList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(SysBpmUserRole::getUserId, (Object)batchRoleUserDto.getUserId())).eq(SysBpmUserRole::getGrantedRole, (Object)batchRoleUserDto.getRoleId());
                this.sysBpmUserRoleService.remove((Wrapper)queryWrapper);
            }
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.RELATION.ordinal(), ChangeTypeEnum.DELETE.ordinal(), batchRoleUserDtoList);
        return failMessage;
    }

    public String batchAddRoleUser(List<BatchRoleUserDto> batchRoleUserDtoList) {
        String failMessage = null;
        try {
            ArrayList<SysBpmUserRole> sysBpmUserRoles = new ArrayList<SysBpmUserRole>();
            for (BatchRoleUserDto batchRoleUserDto : batchRoleUserDtoList) {
                SysBpmUserRole sysBpmUserRole = new SysBpmUserRole();
                sysBpmUserRole.setUserId(batchRoleUserDto.getUserId());
                sysBpmUserRole.setGrantedRole(batchRoleUserDto.getRoleId());
                sysBpmUserRoles.add(sysBpmUserRole);
            }
            this.sysBpmUserRoleService.saveBatch(sysBpmUserRoles);
        }
        catch (Exception e) {
            failMessage = e.getMessage();
            logger.error(FAIL_MESSAGE, (Throwable)e);
        }
        this.saveCallRecord(HussarUtils.isEmpty((Object)failMessage), InterfaceTypeEnum.RELATION.ordinal(), ChangeTypeEnum.ADD.ordinal(), batchRoleUserDtoList);
        return failMessage;
    }

    public Page<SysInterfaceChangeRecord> callList(Page<SysInterfaceChangeRecord> pages, GetCallRecordDto getCallRecordDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ge(HussarUtils.isNotEmpty((Object)getCallRecordDto.getStartTime()), SysInterfaceChangeRecord::getCallDate, (Object)getCallRecordDto.getStartTime());
        queryWrapper.le(HussarUtils.isNotEmpty((Object)getCallRecordDto.getEndTime()), SysInterfaceChangeRecord::getCallDate, (Object)getCallRecordDto.getEndTime());
        queryWrapper.eq(HussarUtils.isNotEmpty((Object)getCallRecordDto.getCallState()), SysInterfaceChangeRecord::getCallState, (Object)getCallRecordDto.getCallState());
        queryWrapper.eq(HussarUtils.isNotEmpty((Object)getCallRecordDto.getChangeType()), SysInterfaceChangeRecord::getChangeType, (Object)getCallRecordDto.getChangeType());
        queryWrapper.eq(HussarUtils.isNotEmpty((Object)getCallRecordDto.getInterfaceType()), SysInterfaceChangeRecord::getInterfaceType, (Object)getCallRecordDto.getInterfaceType());
        return (Page)this.sysInterfaceChangeRecordService.page(pages, (Wrapper)queryWrapper);
    }

    public Map<String, String> getRoleNames(List<String> roleIds) {
        List list = this.sysBpmRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysBpmRoles::getRoleId, roleIds));
        HashMap<String, String> map = new HashMap<String, String>();
        list.forEach(sysBpmRole -> map.put(sysBpmRole.getRoleId(), sysBpmRole.getRoleName()));
        return map;
    }

    private void saveBpmOrganOfUser(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getUserId(), bpmUserData.getUserName(), bpmUserData.getDeptId(), bpmUserData.getOrder());
            SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
            sysBpmOrgan.setOrganId(bpmUserData.getUserId());
            sysBpmOrgan.setOrganName(bpmUserData.getUserName());
            sysBpmOrgan.setParentId(bpmUserData.getDeptId());
            sysBpmOrgan.setSort(Integer.valueOf(Integer.parseInt(bpmUserData.getOrder())));
            sysBpmOrgan.seteMail(bpmUserData.getEmail());
            sysBpmOrgan.setMobile(bpmUserData.getMobile());
            sysBpmOrgan.setIsMain(Integer.valueOf(Integer.parseInt(bpmUserData.getIsMain())));
            sysBpmOrgan.setUserAccount(bpmUserData.getUserAccount());
            sysBpmOrgan.setSecurityLevel(Integer.valueOf(3));
            sysBpmOrgan.setOrganType("user");
            sysBpmOrgans.add(sysBpmOrgan);
            System.out.println(sysBpmOrgan);
        }
        this.sysBpmOrganService.saveBatch(sysBpmOrgans);
    }

    private void saveBpmOrganOfDept(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmOrgan> sysBpmOrgans = new ArrayList<SysBpmOrgan>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getDeptId(), bpmUserData.getDeptName(), bpmUserData.getParentId(), bpmUserData.getOrder());
            SysBpmOrgan sysBpmOrgan = new SysBpmOrgan();
            sysBpmOrgan.setOrganId(bpmUserData.getDeptId());
            sysBpmOrgan.setOrganName(bpmUserData.getDeptName());
            sysBpmOrgan.setParentId(bpmUserData.getParentId());
            sysBpmOrgan.setSort(Integer.valueOf(Integer.parseInt(bpmUserData.getOrder())));
            sysBpmOrgan.setIsMain(Integer.valueOf(1));
            sysBpmOrgan.setOrganType("organ");
            sysBpmOrgans.add(sysBpmOrgan);
            System.out.println(sysBpmOrgan);
        }
        this.sysBpmOrganService.saveBatch(sysBpmOrgans);
    }

    private void saveBpmRoles(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmRoles> sysBpmRolesList = new ArrayList<SysBpmRoles>();
        int des = 1;
        List lastSysBpmRolesList = this.sysBpmRolesService.list((Wrapper)new LambdaQueryWrapper().orderByDesc(SysBpmRoles::getDes));
        SysBpmRoles lastSysBpmRoles = null;
        if (HussarUtils.isNotEmpty((Object)lastSysBpmRolesList)) {
            lastSysBpmRoles = (SysBpmRoles)lastSysBpmRolesList.get(0);
        }
        if (HussarUtils.isNotEmpty(lastSysBpmRoles) && HussarUtils.isNotEmpty((Object)lastSysBpmRoles.getDes())) {
            des = lastSysBpmRoles.getDes() + 1;
        }
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), String.valueOf(bpmUserData.getRoleId()), bpmUserData.getRoleName(), bpmUserData.getParentId());
            SysBpmRoles sysBpmRoles = new SysBpmRoles();
            sysBpmRoles.setRoleId(bpmUserData.getRoleId());
            sysBpmRoles.setRoleName(bpmUserData.getRoleName());
            sysBpmRoles.setParentId(bpmUserData.getParentId());
            sysBpmRoles.setRoleType(bpmUserData.getRoleType());
            sysBpmRoles.setDes(Integer.valueOf(des++));
            sysBpmRolesList.add(sysBpmRoles);
            System.out.println(sysBpmRoles);
        }
        this.sysBpmRolesService.saveBatch(sysBpmRolesList);
    }

    private void saveBpmUserRole(List<BpmUserData> bpmUserDataList) {
        ArrayList<SysBpmUserRole> sysBpmUserRoles = new ArrayList<SysBpmUserRole>();
        for (BpmUserData bpmUserData : bpmUserDataList) {
            this.checkImportData(bpmUserData.getSheet(), bpmUserData.getRoleId(), bpmUserData.getUserId());
            SysBpmUserRole sysBpmUserRole = new SysBpmUserRole();
            sysBpmUserRole.setUserId(bpmUserData.getUserId());
            sysBpmUserRole.setGrantedRole(bpmUserData.getRoleId());
            sysBpmUserRoles.add(sysBpmUserRole);
            System.out.println(sysBpmUserRole);
        }
        this.sysBpmUserRoleService.saveBatch(sysBpmUserRoles);
    }

    private void checkImportData(String sheetName, CharSequence ... data) {
        if (HussarUtils.isAnyBlank((CharSequence[])data)) {
            throw new HussarException("Sheet[" + sheetName + "]\u4e2d\u5b58\u5728\u6570\u636e\u4e3a\u7a7a\u6761\u76ee\uff01");
        }
    }

    private void saveCallRecord(boolean isSuccess, int interfaceType, int changeType, Object dataDetail) {
        try {
            SysInterfaceChangeRecord record = new SysInterfaceChangeRecord();
            record.setCallDate(new Date());
            record.setInterfaceType(Integer.valueOf(interfaceType));
            record.setChangeType(Integer.valueOf(changeType));
            record.setDataDetail(JSON.toJSONString((Object)dataDetail));
            record.setCallState(Integer.valueOf(isSuccess ? CallStateEnum.SUCCESS.ordinal() : CallStateEnum.FAIL.ordinal()));
            this.sysInterfaceChangeRecordService.save((Object)record);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8c03\u7528\u8bb0\u5f55\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

