/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigneemanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.assigeemanage.service.AssigneeManageService;
import dm.jdbc.util.StringUtil;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.LinkedList;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bpm/assigneeManage"})
public class AssigneeManageController {
    private static final Logger logger = LoggerFactory.getLogger(AssigneeManageController.class);
    @Autowired
    private AssigneeManageService assigneeManageService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @PostMapping(value={"/excelImport"})
    @ApiOperation(value="Excel\u5bfc\u5165\u7528\u6237\u6570\u636e", notes="Excel\u5bfc\u5165\u7528\u6237\u6570\u636e")
    ApiResponse<?> importExcelUserData(MultipartFile file) {
        try {
            this.assigneeManageService.saveUserData(file.getInputStream());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6a21\u677f\u6587\u4ef6\u4e0b\u8f7d", notes="\u6a21\u677f\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/fileDownload"})
    public void fileDownload(HttpServletResponse response) throws IOException {
        InputStream inputStream = null;
        LinkedList<Byte> list = new LinkedList<Byte>();
        OutputStream outputStream = null;
        try {
            int len;
            inputStream = this.getClass().getResourceAsStream("/workflowImportTemplate.xlsx");
            if (HussarUtils.isEmpty((Object)inputStream)) {
                throw new HussarException(this.bpmConstantProperties.getTemplateFileNotFound());
            }
            outputStream = response.getOutputStream();
            byte[] buff = new byte[1024];
            response.setCharacterEncoding("UTF-8");
            String fileName = URLEncoder.encode("workflowImportTemplate.xlsx", "UTF-8");
            response.addHeader("Content-disposition", "attachment;filename=" + fileName + ";filename*=utf-8''" + fileName);
            response.addHeader("Content-Type", "application/x-msdownload;charset=utf-8");
            while ((len = inputStream.read(buff)) != -1) {
                for (int i = 0; i < len; ++i) {
                    list.add(buff[i]);
                }
            }
            byte[] bytes = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bytes[i] = (Byte)list.get(i);
            }
            String base64 = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
            byte[] newBytes = Base64.decodeBase64((String)base64);
            for (int i = 0; i < newBytes.length; ++i) {
                if (newBytes[i] >= 0) continue;
                int n = i;
                newBytes[n] = (byte)(newBytes[n] + 256);
            }
            response.setContentLength(newBytes.length);
            outputStream.write(newBytes);
            response.flushBuffer();
            outputStream.flush();
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u6570\u636e")
    ApiResponse<?> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        if (StringUtil.isNotEmpty((String)getListDto.getUserName())) {
            getListDto.setUserName(getListDto.getUserName().replace("%", "\\%").replace("_", "\\_"));
        }
        return ApiResponse.success((Object)this.assigneeManageService.queryList(page, getListDto));
    }

    @GetMapping(value={"/deptTree"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentId", value="\u7236\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u8282\u70b9id", required=false, paramType="query")})
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u6811", notes="\u83b7\u53d6\u90e8\u95e8\u6811")
    ApiResponse<?> deptTree(String parentId, String id) {
        return ApiResponse.success((Object)this.assigneeManageService.deptTree(parentId, id));
    }

    @GetMapping(value={"/searchOrganization"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u90e8\u95e8", notes="\u6a21\u7cca\u67e5\u8be2\u90e8\u95e8")
    ApiResponse<?> queryDept(@ApiParam(value="\u5206\u9875\u53c2\u6570") Page pageInfo, @ApiParam(value="\u90e8\u95e8\u540d\u79f0") String name) {
        name = name.replace("%", "\\%").replace("_", "\\_");
        pageInfo.setRecords(this.assigneeManageService.queryDept(name));
        pageInfo.setTotal((long)pageInfo.getRecords().size());
        return ApiResponse.success((Object)pageInfo);
    }

    @GetMapping(value={"/roleTree"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6811", notes="\u83b7\u53d6\u89d2\u8272\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentId", value="\u7236\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u8282\u70b9id", required=false, paramType="query")})
    ApiResponse<?> roleTree(@RequestParam String parentId, @RequestParam String id) {
        return ApiResponse.success((Object)this.assigneeManageService.roleTree(parentId, id));
    }

    @GetMapping(value={"/queryRoleTreeByRoleName"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u89d2\u8272\u6811", notes="\u6a21\u7cca\u67e5\u8be2\u89d2\u8272\u6811")
    public ApiResponse<?> queryRole(@ApiParam(value="\u5206\u9875\u53c2\u6570") Page<AssigneeManageInfoVo> pageInfo, @ApiParam(value="\u89d2\u8272\u540d\u79f0") String name) {
        name = name.replace("%", "\\%").replace("_", "\\_");
        pageInfo.setRecords(this.assigneeManageService.queryRole(name));
        pageInfo.setTotal((long)pageInfo.getRecords().size());
        return ApiResponse.success(pageInfo);
    }

    @GetMapping(value={"/queryPlatformModel"})
    @ApiOperation(value="\u83b7\u53d6\u5e73\u53f0\u4f7f\u7528\u6a21\u5f0f", notes="\u83b7\u53d6\u5e73\u53f0\u4f7f\u7528\u6a21\u5f0f")
    public ApiResponse<?> queryPlatformModel() {
        return ApiResponse.success((Object)this.assigneeManageService.queryPlatformModel(), (String)"");
    }
}

