/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.engine.task.TaskStateType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class ProcessDiagramServiceImpl
implements ProcessDiagramService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    private static final String FINISH_STATE = "finish";
    private static final String COMPLETE_STATE = "complete";
    private static final String NEXT_STATE = "next";
    private static final String SUSPENDED_STATE = "suspend";
    private static final String OVER_TIME_STATE = "overtime";
    private static final String LINE_NAME = "lineName";
    private static final String COUNT = "count";

    public JSONObject getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        List<String> idList;
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONObject();
            }
        }
        if (HussarUtils.isEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()))) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        boolean suspended = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        List<Object> lineList = new ArrayList();
        if (taskList.isEmpty()) {
            idList = this.queryPreActivitiesByTaskIdFinished(processInsId, subProcessKey, cycleCount, false);
        } else {
            ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            suspended = instance.isSuspended();
            idList = this.queryFinishNode(processInsId, bpmnModel, subProcessKey, cycleCount, false);
        }
        ArrayList<String> runningNode = new ArrayList<String>();
        HashMap<String, String> nodeState = new HashMap<String, String>();
        List list = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInsId).list();
        if (!list.isEmpty()) {
            HashMap node = new HashMap();
            for (HistoricProcessInstance historicProcessInstance : list) {
                if (historicProcessInstance.getEndTime() != null || node.containsKey(historicProcessInstance.getMainActId())) continue;
                node.put(historicProcessInstance.getMainActId(), historicProcessInstance);
            }
            for (HistoricProcessInstance value : node.values()) {
                runningNode.add(value.getMainActId());
                nodeState.put(value.getMainActId(), "main_reject".equals(value.getCompleteType()) ? "reject" : COMPLETE_STATE);
            }
        }
        for (Object task : taskList) {
            runningNode.add(task.getTaskDefinitionKey());
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), OVER_TIME_STATE);
                continue;
            }
            String completeType = TaskSourceFlag.isReject((String)task.getCompleteType()) ? "reject" : COMPLETE_STATE;
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().subProcessKey(subProcessKey).cycleCount(cycleCount).activityType("receiveTask").list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            runningNode.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, subProcessKey, false);
        if (sysActHiLines != null && !sysActHiLines.isEmpty()) {
            lineList = sysActHiLines.stream().map(SysActHiLine::getLineId).collect(Collectors.toList());
        }
        Process process = bpmnModel.getMainProcess();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Map extensionElementsNode = process.getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String height = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            if (graphicInfo.getX() > Double.parseDouble(width)) {
                width = String.valueOf(graphicInfo.getX());
            }
            object.put("y", (Object)graphicInfo.getY());
            if (graphicInfo.getY() + 100.0 > Double.parseDouble(height)) {
                height = String.valueOf(graphicInfo.getY() + 100.0);
            }
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInstance.getId());
            if (runningNode.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)SUSPENDED_STATE);
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                }
            } else if (idList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)NEXT_STATE);
            }
            if (flowElement instanceof SubProcess) {
                object.put("subProcessElements", (Object)this.getSubProcessMsg((SubProcess)flowElement, bpmnModel, processInsId));
            }
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put(LINE_NAME, null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if (LINE_NAME.equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put(LINE_NAME, (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)NEXT_STATE);
                }
                jsonArray.add((Object)obj);
            }
        }
        jsonObject.put("width", (Object)width);
        jsonObject.put("height", (Object)height);
        jsonObject.put("data", (Object)jsonArray);
        return jsonObject;
    }

    private JSONArray getSubProcessMsg(SubProcess subProcess, BpmnModel bpmnModel, String processInsId) {
        JSONArray jsonArray = new JSONArray();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInsId);
            object.put("state", (Object)NEXT_STATE);
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put(LINE_NAME, null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if (LINE_NAME.equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put(LINE_NAME, (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                obj.put("state", (Object)NEXT_STATE);
                jsonArray.add((Object)obj);
            }
        }
        return jsonArray;
    }

    public JSONObject getSubProcessRunningInfo(String processInsId, String businessId) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONObject();
            }
        }
        if (HussarUtils.isEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()))) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        List<String> subProcessKeys = this.taskEngineMapper.getAllSubProcessKey(Long.parseLong(processInsId));
        boolean suspended = false;
        ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (instance != null) {
            suspended = instance.isSuspended();
        }
        List allTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).list();
        HashMap<Object, List> taskListMap = new HashMap<Object, List>();
        for (Task task : allTasks) {
            String subProcessKey = task.getSubProcessKey();
            if (subProcessKey == null) continue;
            List taskList = taskListMap.getOrDefault(subProcessKey, new ArrayList());
            taskList.add(task);
            taskListMap.put(subProcessKey, taskList);
        }
        List allHistoricActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("receiveTask").list();
        HashMap<String, List> historicActivityInstancesMap = new HashMap<String, List>();
        for (HistoricActivityInstance historicActivityInstance : allHistoricActivityInstances) {
            String subProcessKey = historicActivityInstance.getSubProcessKey();
            if (subProcessKey == null) continue;
            List historicActivityInstances = historicActivityInstancesMap.getOrDefault(subProcessKey, new ArrayList());
            historicActivityInstances.add(historicActivityInstance);
            historicActivityInstancesMap.put(subProcessKey, historicActivityInstances);
        }
        ArrayList<String> userList = new ArrayList<String>();
        List hisLists = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        HashMap<String, List> hisListMap = new HashMap<String, List>();
        for (HistoricTaskInstance historicTaskInstance : hisLists) {
            String subProcessKey;
            if (TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner())) {
                userList.add(historicTaskInstance.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
                userList.add(historicTaskInstance.getAssignee());
            }
            if ((subProcessKey = historicTaskInstance.getSubProcessKey()) == null) continue;
            List hisList = hisListMap.getOrDefault(subProcessKey, new ArrayList());
            hisList.add(historicTaskInstance);
            hisListMap.put(subProcessKey, hisList);
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        JSONObject result = new JSONObject(true);
        for (String subProcessKey : subProcessKeys) {
            Object task22;
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            List tasks = taskListMap.getOrDefault(subProcessKey, new ArrayList());
            List<Object> lineList = new ArrayList();
            List<String> idList = tasks.isEmpty() ? this.queryPreActivitiesByTaskIdFinished(processInsId, subProcessKey, null, true) : this.queryFinishNode(processInsId, bpmnModel, subProcessKey, null, true);
            ArrayList<String> runningNode = new ArrayList<String>();
            HashMap<String, String> nodeState = new HashMap<String, String>();
            for (Object task22 : tasks) {
                runningNode.add(task22.getTaskDefinitionKey());
                if (HussarUtils.isNotEmpty((Object)task22.getDueDate()) && task22.getDueDate().getTime() < System.currentTimeMillis()) {
                    nodeState.put(task22.getTaskDefinitionKey(), OVER_TIME_STATE);
                    continue;
                }
                String completeType = TaskSourceFlag.isReject((String)task22.getCompleteType()) ? "reject" : COMPLETE_STATE;
                nodeState.put(task22.getTaskDefinitionKey(), completeType);
            }
            List historicActivityInstances = historicActivityInstancesMap.getOrDefault(subProcessKey, new ArrayList());
            task22 = historicActivityInstances.iterator();
            while (task22.hasNext()) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)task22.next();
                runningNode.add(historicActivityInstance.getActivityId());
            }
            List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, subProcessKey, true);
            if (sysActHiLines != null && !sysActHiLines.isEmpty()) {
                lineList = sysActHiLines.stream().map(SysActHiLine::getLineId).collect(Collectors.toList());
            }
            JSONArray subProcessInfo = new JSONArray();
            for (FlowElement flowElement : subProcess.getFlowElements()) {
                if (!(flowElement instanceof FlowNode)) continue;
                FlowNode flowNode = (FlowNode)flowElement;
                JSONObject object = new JSONObject();
                String flowNodeId = flowNode.getId();
                object.put("id", (Object)flowNodeId);
                object.put("name", (Object)flowNode.getName());
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("type", (Object)this.getNodeType(flowNode));
                object.put("processInsId", (Object)processInsId);
                if (runningNode.contains(flowNodeId)) {
                    if (suspended) {
                        object.put("state", (Object)SUSPENDED_STATE);
                    } else {
                        object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                    }
                } else if (idList.contains(flowNodeId)) {
                    object.put("state", (Object)FINISH_STATE);
                } else {
                    object.put("state", (Object)NEXT_STATE);
                }
                subProcessInfo.add((Object)object);
                for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                    List graphicInfoList;
                    Map maps;
                    List extendFlowNameElement;
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)sequenceFlow.getId());
                    obj.put("name", (Object)sequenceFlow.getName());
                    obj.put("type", (Object)"sequenceFlow");
                    obj.put("dx", null);
                    obj.put("rotate", null);
                    obj.put(LINE_NAME, null);
                    obj.put("x", null);
                    obj.put("y", null);
                    obj.put("height", null);
                    obj.put("width", null);
                    Map stringListMap = sequenceFlow.getExtensionElements();
                    if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                        for (Map.Entry map : maps.entrySet()) {
                            if (LINE_NAME.equals(map.getKey())) {
                                String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                                String[] lineNames = lineNamesStr.split("/n");
                                obj.put(LINE_NAME, (Object)lineNames);
                                continue;
                            }
                            if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                                obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                                continue;
                            }
                            obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                        }
                    }
                    if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                        int[] xPoints = new int[graphicInfoList.size()];
                        Object yPoints = new int[graphicInfoList.size()];
                        for (int i = 1; i < graphicInfoList.size(); ++i) {
                            GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                            GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                            if (i == 1) {
                                xPoints[0] = (int)previousGraphicInfo.getX();
                                yPoints[0] = (int)previousGraphicInfo.getY();
                            }
                            xPoints[i] = (int)gi.getX();
                            yPoints[i] = (int)gi.getY();
                        }
                        obj.put("xPoints", (Object)xPoints);
                        obj.put("yPoints", yPoints);
                    }
                    if (lineList.contains(sequenceFlow.getId())) {
                        obj.put("state", (Object)FINISH_STATE);
                    } else {
                        obj.put("state", (Object)NEXT_STATE);
                    }
                    subProcessInfo.add((Object)obj);
                }
            }
            jsonObject.put("subProcessInfo", (Object)subProcessInfo);
            JSONArray subProcessCompleteInfo = new JSONArray();
            Collection flowElements = ((SubProcess)bpmnModel.getFlowElement(taskDefinitionKey)).getFlowElements();
            List hisList = hisListMap.getOrDefault(subProcessKey, new ArrayList());
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.valueOf(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getMessage());
            }
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof SequenceFlow) continue;
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
                JSONObject object = new JSONObject();
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("id", (Object)flowElement.getId());
                List taskList = null;
                if (tasks != null && !tasks.isEmpty()) {
                    taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                }
                if (taskList != null && !taskList.isEmpty()) {
                    ArrayList<String> taskIds = new ArrayList<String>();
                    for (Task task3 : taskList) {
                        taskIds.add(String.valueOf(task3.getId()));
                    }
                    List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    List<IdentityLink> user = this.getIdentityLinkByTaskId(taskIds);
                    List ts = taskList.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                    object.put("complete_type", (Object)((Task)ts.get(0)).getCompleteType());
                    if (!user.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(user));
                        object.put("assignee", (Object)assignee);
                    } else {
                        object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                    }
                    object.put("state", (Object)COMPLETE_STATE);
                    if (!nowHisActivitList.isEmpty()) {
                        nowHisActivitList.sort((o1, o2) -> {
                            if (!o1.getStartTime().equals(o2.getStartTime())) {
                                return o1.getStartTime().compareTo(o2.getStartTime());
                            }
                            if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                                return o2.getEndTime().compareTo(new Date(0L));
                            }
                            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                                return new Date(0L).compareTo(o1.getEndTime());
                            }
                            if (o1.getEndTime().equals(o2.getEndTime())) {
                                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                            }
                            return o1.getEndTime().compareTo(o2.getEndTime());
                        });
                        JSONArray json = new JSONArray();
                        for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                            JSONObject o = new JSONObject();
                            String nowUser = historicActivityInstance.getAssignee() != null ? (TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                            String comment = (String)taskComment.get(historicActivityInstance.getId());
                            o.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullComment() : comment));
                            o.put("assignee", (Object)nowUser);
                            o.put("endTime", (Object)historicActivityInstance.getEndTime());
                            o.put("startTime", (Object)historicActivityInstance.getStartTime());
                            o.put("taskType", (Object)historicActivityInstance.getTaskType());
                            json.add((Object)o);
                        }
                        object.put("completeInfo", (Object)json);
                    }
                } else {
                    object.put("state", (Object)FINISH_STATE);
                    List hisActivitList = null;
                    if (HussarUtils.isNotEmpty((Object)hisList)) {
                        hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                    }
                    if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                    hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                        String comment;
                        JSONObject o = new JSONObject();
                        String user = "";
                        if (historicActivityInstance.getAssignee() != null) {
                            user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                        }
                        if (StringUtils.isEmpty((CharSequence)user)) {
                            user = this.bpmConstantProperties.getNullComplete();
                        }
                        o.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o.put("assignee", (Object)user);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o.put("taskType", (Object)historicActivityInstance.getTaskType());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
                subProcessCompleteInfo.add((Object)object);
            }
            jsonObject.put("subProcessInfo", (Object)subProcessInfo);
            jsonObject.put("subProcessCompleteInfo", (Object)subProcessCompleteInfo);
            result.put(subProcessKey, (Object)jsonObject);
        }
        return result;
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return new JSONArray();
            }
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return new JSONArray();
        }
        String processDefinitionId = processInstance.getProcessDefinitionId();
        int version = Integer.parseInt(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinitionId));
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        ArrayList userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            hisList.stream().forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (HistoricTaskInstance hisTask : hisList) {
            if (hisTask.getEndTime() == null) continue;
            hisTaskIds.add(Long.valueOf(hisTask.getId()));
        }
        List<Object> commentsMap = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        HashMap<String, String> taskComment = new HashMap<String, String>();
        for (TaskCommentVO taskCommentVO : commentsMap) {
            taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getMessage());
        }
        for (ActivityImpl activityImpl : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activityImpl.getWidth());
            object.put("height", (Object)activityImpl.getHeight());
            object.put("x", (Object)activityImpl.getX());
            object.put("y", (Object)activityImpl.getY());
            object.put("id", (Object)activityImpl.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                ArrayList<String> taskIds = new ArrayList<String>();
                for (Task task : taskList) {
                    taskIds.add(String.valueOf(task.getId()));
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                List<IdentityLink> user = this.getIdentityLinkByTaskId(taskIds);
                List ts = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                object.put("complete_type", (Object)((Task)ts.get(0)).getCompleteType());
                if (!user.isEmpty()) {
                    String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(user));
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)COMPLETE_STATE);
                if (!nowHisActivitList.isEmpty()) {
                    nowHisActivitList.sort((o1, o2) -> {
                        if (!o1.getStartTime().equals(o2.getStartTime())) {
                            return o1.getStartTime().compareTo(o2.getStartTime());
                        }
                        if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        if (o1.getEndTime() == null && o2.getEndTime() != null) {
                            return o2.getEndTime().compareTo(new Date(0L));
                        }
                        if (o1.getEndTime() != null && o2.getEndTime() == null) {
                            return new Date(0L).compareTo(o1.getEndTime());
                        }
                        if (o1.getEndTime().equals(o2.getEndTime())) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        return o1.getEndTime().compareTo(o2.getEndTime());
                    });
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        JSONObject o3 = new JSONObject();
                        String nowUser = historicActivityInstance.getAssignee() != null ? (TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                        String comment = (String)taskComment.get(historicActivityInstance.getId());
                        o3.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o3.put("assignee", (Object)nowUser);
                        o3.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o3.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o3.put("taskType", (Object)historicActivityInstance.getTaskType());
                        json.add((Object)o3);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o4 = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? (String)finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + (String)finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = this.bpmConstantProperties.getNullComplete();
                    }
                    o4.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                    o4.put("assignee", (Object)user);
                    o4.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o4.put("startTime", (Object)historicActivityInstance.getStartTime());
                    o4.put("taskType", (Object)historicActivityInstance.getTaskType());
                    json.add((Object)o4);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    public Map<String, Object> list(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTrace(processInsId, subProcessKey, cycleCount);
        result.put(COUNT, obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> microAppList(String processInsId, String businessId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return result;
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTraceByMicroApp(processInsId);
        result.put(COUNT, obj.getResult().size());
        result.put("data", obj.getResult());
        return result;
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        List<ProcessInst> instList;
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        if (HussarUtils.isEmpty((Object)supProcessInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                supProcessInsId = instance.getId();
            } else {
                return new HashMap<String, Object>();
            }
        }
        if (!(instList = this.processInstMapper.getCallActivityProcessInstList((Page<ProcessInst>)pages, Long.parseLong(supProcessInsId), taskDefinitionKey)).isEmpty()) {
            HashSet<Long> procInstIds = new HashSet<Long>();
            for (ProcessInst processInst : instList) {
                procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
            }
            List<ProcessInstVo> nodeList = this.processInstMapper.getNodeNames(procInstIds);
            HashMap<Long, Set> nodeMap = new HashMap<Long, Set>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            for (ProcessInst processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.valueOf(processInst.getProcessInsId()));
                if (nodeNames == null || nodeNames.isEmpty()) continue;
                processInst.setNames(String.join((CharSequence)",", nodeNames));
            }
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(COUNT, pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (!allGraphicInfos.isEmpty()) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = HussarUtils.isNotEmpty((Object)((UserTask)flowNode).getLoopCharacteristics()) ? "multiUserTask" : "userTask";
        } else if (flowNode instanceof ServiceTask) {
            type = "serviceTask";
        } else if (flowNode instanceof ReceiveTask) {
            type = "receiveTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private List<String> queryPreActivitiesByTaskIdFinished(String processInsId, String subProcessKey, Integer cycleCount, boolean needWithOutMain) {
        ArrayList<String> idList = new ArrayList<String>();
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            if (needWithOutMain) {
                historicActivityInstanceQuery.subProcessKeyWithOutMain(subProcessKey);
            } else {
                historicActivityInstanceQuery.subProcessKey(subProcessKey);
            }
        }
        List list = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.processInstanceId(processInsId).finished().cycleCount(cycleCount).orderByHistoricActivityInstanceEndTime().asc()).list();
        for (HistoricActivityInstance his : list) {
            idList.add(his.getActivityId());
        }
        return idList;
    }

    private List<String> queryFinishNode(String processInsId, BpmnModel bpmnModel, String subProcessKey, Integer cycleCount, boolean needWithOutMain) {
        ArrayList<String> idList = new ArrayList<String>();
        HistoricActivityInstanceQuery historicActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            if (needWithOutMain) {
                historicActivityInstanceQuery.subProcessKeyWithOutMain(subProcessKey);
            } else {
                historicActivityInstanceQuery.subProcessKey(subProcessKey);
            }
        }
        List historicActivityInstances = historicActivityInstanceQuery.processInstanceId(processInsId).finished().cycleCount(cycleCount).list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            if (bpmnModel.getFlowElement(historicActivityInstance.getActivityId()) == null) continue;
            idList.add(historicActivityInstance.getActivityId());
        }
        return idList;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(List<String> taskIds) {
        ArrayList<IdentityLink> result = new ArrayList<IdentityLink>();
        for (String taskId : taskIds) {
            List identityLinkList = this.taskService.getIdentityLinksType(taskId);
            result.addAll(identityLinkList);
        }
        return result;
    }
}

