/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.mqdatapush.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.mqdatapush.service.IMqDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.DataPushUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.Map;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqDataPush
implements IMqDataPush {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger LOGGER = LoggerFactory.getLogger(DataPushUtil.class);

    public void mqDataPush(Map<String, Object> paramMap) {
        try {
            LOGGER.info("mq\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            System.out.println("mq\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            System.out.println(JSON.toJSONString(paramMap));
            LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(paramMap));
            Long start = System.currentTimeMillis();
            this.rocketMQTemplate.syncSendOrderly(lcdpBpmProperties.getMqTopic() + ":" + lcdpBpmProperties.getMqTag(), paramMap, this.getMqSequence(paramMap.get("processInstanceId").toString()));
            Long end = System.currentTimeMillis();
            LOGGER.info("mq\u6570\u636e\u63a8\u9001\u7ed3\u675f");
            System.out.println("mq\u6570\u636e\u63a8\u9001\u7ed3\u675f");
            LOGGER.info("mq\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "ms");
            System.out.println("mq\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "ms");
        }
        catch (Exception e) {
            throw new BpmException("mq\u6d88\u606f\u63a8\u9001\u5f02\u5e38");
        }
    }

    public String getMqSequence(String processInstanceId) {
        Long procInstId = Long.valueOf(processInstanceId);
        return String.valueOf(Math.abs(procInstId.hashCode()) % 4);
    }
}

