/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActReModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.dao.MonitorReportMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.dto.MonitorReportDto;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.dto.MonitorReportStepDto;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.dto.MonitorReportTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.service.IMonitorReportService;
import com.jxdinfo.hussar.workflow.engine.bpm.monitorReport.vo.ReportVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorReportServiceImpl
extends ServiceImpl<MonitorReportMapper, MonitorReportDto>
implements IMonitorReportService {
    @Resource
    MonitorReportMapper monitorReportMapper;
    @Autowired
    DynamicDatasourceService dynamicDatasourceService;
    @Resource
    private BpmActReModelMapper bpmActReModelMapper;
    private static final String URL_PREFIX_MYSQL_HEAD = "MYSQL";
    private static final String URL_PREFIX_OSCAR_HEAD = "OSCAR";
    private static final String URL_PREFIX_ORACLE_HEAD = "ORACLE";
    private static final String URL_PREFIX_DM_HEAD = "DM";
    private static final String URL_PREFIX_PGSQL_HEAD = "POSTGRESQL";
    private static final String URL_PREFIX_SQLSERVER_HEAD = "SQLSERVER";
    private static final String URL_PREFIX_KINGBASE_HEAD = "KINGBASE8";
    private static final String[] MONTH_STR = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};

    public IPage<MonitorReportDto> queryMonitorReportList(Page<MonitorReportDto> page, String processKey) {
        Date date = new Date();
        List<MonitorReportDto> list = this.monitorReportMapper.queryMonitorReportList(page, processKey, date);
        ArrayList<String> processKeyList = new ArrayList<String>();
        if (HussarUtils.isEmpty(list)) {
            return page.setRecords(null);
        }
        for (MonitorReportDto monitorReportDto : list) {
            processKeyList.add(monitorReportDto.getProcessKey());
        }
        Map<Object, Object> map = new HashMap();
        switch (this.getDataBase()) {
            case "MYSQL": {
                map = this.monitorReportMapper.queryOverdueTimeListMysql(processKeyList, date);
                break;
            }
            case "DM": {
                map = this.monitorReportMapper.queryOverdueTimeListDm(processKeyList, date);
            }
        }
        for (MonitorReportDto monitorReportDto : list) {
            switch (this.getDataBase()) {
                case "MYSQL": {
                    monitorReportDto.setOverdueTime(this.getRealTime(JSONObject.parseObject((String)JSON.toJSONString((Object)map.get(monitorReportDto.getProcessKey()))).get((Object)"overdueTime").toString()).doubleValue());
                    break;
                }
                case "DM": {
                    monitorReportDto.setOverdueTime(this.getRealTime(JSONObject.parseObject((String)JSON.toJSONString((Object)map.get(monitorReportDto.getProcessKey()))).get((Object)"OVERDUETIME").toString()).doubleValue());
                }
            }
        }
        return page.setRecords(list);
    }

    public IPage<MonitorReportStepDto> queryMonitorReportDetailList(Page<MonitorReportStepDto> page, String processKey, String listType) {
        Date date = new Date();
        List<Object> list = new ArrayList();
        switch (this.getDataBase()) {
            case "DM": {
                list = this.monitorReportMapper.queryMonitorReportDetailListByDm(page, processKey, listType, date);
                break;
            }
            case "MYSQL": {
                list = this.monitorReportMapper.queryMonitorReportDetailListByMysql(page, processKey, listType, date);
            }
        }
        String metaInfo = this.bpmActReModelMapper.getMetaInfo(processKey);
        String description = "";
        if (HussarUtils.isNotEmpty((Object)metaInfo)) {
            JSONObject jsonObject = JSON.parseObject((String)metaInfo);
            description = jsonObject.getString("description");
        }
        for (MonitorReportStepDto monitorReportStepDto : list) {
            if (HussarUtils.isNotEmpty((Object)description)) {
                monitorReportStepDto.setDescription(description);
            }
            monitorReportStepDto.setOverdueTime(this.getRealTime(monitorReportStepDto.getOverdueTime().toString()));
        }
        return page.setRecords(list);
    }

    public IPage<MonitorReportTaskDto> queryMonitorReportTaskList(Page<MonitorReportTaskDto> page, String processInstanceId, String listType) {
        Date date = new Date();
        List<MonitorReportTaskDto> list = this.monitorReportMapper.queryMonitorReportTaskList(page, processInstanceId, listType, date);
        if (HussarUtils.isEmpty(list)) {
            return page.setRecords(null);
        }
        String metaInfo = this.bpmActReModelMapper.getMetaInfo(list.get(0).getProcessKey());
        String description = "";
        if (HussarUtils.isNotEmpty((Object)metaInfo)) {
            JSONObject jsonObject = JSON.parseObject((String)metaInfo);
            description = jsonObject.getString("description");
        }
        for (MonitorReportTaskDto monitorReportTaskDto : list) {
            if (HussarUtils.isNotEmpty((Object)description)) {
                monitorReportTaskDto.setDescription(description);
            }
            monitorReportTaskDto.setOverdueTime(this.getRealTime(monitorReportTaskDto.getOverdueTime().toString()));
        }
        return page.setRecords(list);
    }

    public String getDataBase() {
        ItemDataSource dataSource = this.dynamicDatasourceService.getCurrentDatasource();
        return dataSource.getDbType().name();
    }

    public Double getRealTime(String time) {
        Double minuteDouble = Double.valueOf(time);
        int minute = minuteDouble.intValue();
        int halfOfHour = (minute + 30 - 1) / 30;
        Double hour = (double)halfOfHour / 2.0;
        return hour;
    }

    public JSONObject queryDoneTaskReport(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BpmException("\u4eba\u5458id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LocalDate currentDate = LocalDate.now();
        int year = currentDate.getYear();
        int month = currentDate.getMonthValue();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(month == 12 ? year : year - 1, month == 12 ? 1 : month, 1, 0, 0, 0, 0, ZoneId.systemDefault());
        Date minDateTime = Date.from(zonedDateTime.toInstant());
        List<ReportVo> doneTask = this.monitorReportMapper.queryDoneTaskReport(userId, minDateTime);
        List<ReportVo> doneTaskNotice = this.monitorReportMapper.queryDoneTaskNoticeReport(userId, minDateTime);
        if (doneTask.isEmpty() && doneTaskNotice.isEmpty()) {
            return new JSONObject();
        }
        Map<String, Long> doneTaskReport = Stream.concat(doneTask.stream(), doneTaskNotice.stream()).collect(Collectors.toMap(ReportVo::getReportTime, ReportVo::getReportNumber, Long::sum));
        JSONObject dateRows = new JSONObject(true);
        for (int i = year * 12 + month - 12; i < year * 12 + month; ++i) {
            String yearAndMonth = i / 12 + "-" + MONTH_STR[i % 12];
            dateRows.put(yearAndMonth, (Object)doneTaskReport.getOrDefault(yearAndMonth, 0L));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("total", (Object)doneTaskReport.values().stream().mapToLong(Long::valueOf).sum());
        jsonObject.put("dataRows", (Object)dateRows);
        return jsonObject;
    }

    public JSONObject queryProcessStartReport(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BpmException("\u4eba\u5458id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LocalDate currentDate = LocalDate.now();
        int year = currentDate.getYear();
        int month = currentDate.getMonthValue();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(month == 12 ? year : year - 1, month == 12 ? 1 : month, 1, 0, 0, 0, 0, ZoneId.systemDefault());
        Date minDateTime = Date.from(zonedDateTime.toInstant());
        List<ReportVo> processStart = this.monitorReportMapper.queryProcessStartReport(userId, minDateTime);
        Map<String, Long> processStartReport = processStart.stream().collect(Collectors.toMap(ReportVo::getReportTime, ReportVo::getReportNumber, Long::sum));
        JSONObject dateRows = new JSONObject(true);
        for (int i = year * 12 + month - 12; i < year * 12 + month; ++i) {
            String yearAndMonth = i / 12 + "-" + MONTH_STR[i % 12];
            dateRows.put(yearAndMonth, (Object)processStartReport.getOrDefault(yearAndMonth, 0L));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("total", (Object)processStartReport.values().stream().mapToLong(Long::valueOf).sum());
        jsonObject.put("dataRows", (Object)dateRows);
        return jsonObject;
    }
}

