/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.dao.SysActInterfaceLogMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory.InterfaceLogFactory;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory.LogType;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.model.SysActInterfaceLog;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.service.ISysUserService;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class InterfaceLogTaskFactory {
    @Value(value="${hussar.bpm.interface-log:false}")
    private boolean isInterfaceLogging;
    private static boolean interfaceLogging;
    private static SysActInterfaceLogMapper sysActInterfaceLogMapper;
    private static ISysUserService iSysUserService;
    private static Logger logger;

    @PostConstruct
    public void init() {
        interfaceLogging = this.isInterfaceLogging;
    }

    public static TimerTask bussinessLog(final Map<String, String> map, final String bussinessName, final String className, final String methodName, final String msg, final String type, final String levelEvent) {
        return new TimerTask(){

            @Override
            public void run() {
                SysActInterfaceLog sysActLog = InterfaceLogFactory.createSysSecurityLog(LogType.BUSSINESS, map, bussinessName, className, methodName, msg, LogType.SUCCESS.getMessage(), type, levelEvent);
                try {
                    InterfaceLogTaskFactory.insertSecurityLog(sysActLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exceptionLog(final Map<String, String> info, final String msg) {
        return new TimerTask(){

            @Override
            public void run() {
                SysActInterfaceLog sysActLog = InterfaceLogFactory.createExceptionLogLog(info, msg);
                try {
                    InterfaceLogTaskFactory.insertSecurityLog(sysActLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u5f02\u5e38\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    private static void insertSecurityLog(SysActInterfaceLog sysActLog) {
        if (interfaceLogging) {
            SysUser sysUser = sysActInterfaceLogMapper.getSysUser();
            sysActLog.setUserAccount(sysUser.getUserAccount());
            sysActLog.setUserId(sysUser.getUserId());
            sysActLog.setUserName(sysUser.getUserName());
            sysActLog.setLogId(IdWorker.get32UUID());
            sysActInterfaceLogMapper.insert(sysActLog);
        }
    }

    static {
        sysActInterfaceLogMapper = (SysActInterfaceLogMapper)SpringContextHolder.getBean(SysActInterfaceLogMapper.class);
        iSysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
        logger = LoggerFactory.getLogger(InterfaceLogTaskFactory.class);
    }
}

