/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.factory.LogType;
import com.jxdinfo.hussar.workflow.engine.bpm.interfacelog.model.SysActInterfaceLog;
import java.util.Date;
import java.util.Map;

public class InterfaceLogFactory {
    public static SysActInterfaceLog createSysSecurityLog(LogType logType, Map<String, String> map, String bussinessName, String className, String methodName, String msg, String succeed, String type, String levelEvent) {
        String params;
        SysActInterfaceLog sysActLog = new SysActInterfaceLog();
        sysActLog.setLogType(type);
        sysActLog.setLogTypeName(logType.getMessage());
        sysActLog.setSessionId(map.get("sessionId"));
        sysActLog.setLocaladdr(map.get("localIp"));
        sysActLog.setLocalport(map.get("localPort"));
        sysActLog.setLocalhost(map.get("localHost"));
        sysActLog.setRemoteaddr(map.get("ip"));
        sysActLog.setRemoteport(map.get("port"));
        sysActLog.setRemotehost(map.get("host"));
        sysActLog.setLevelEvent(levelEvent);
        sysActLog.setResourceAlias(msg);
        sysActLog.setState(succeed);
        sysActLog.setUserId(map.get("userId") == null ? "" : map.get("userId"));
        sysActLog.setUserAccount(map.get("userAccount") == null ? "" : map.get("userAccount"));
        sysActLog.setUserName(map.get("userName") == null ? "" : map.get("userName"));
        sysActLog.setCorporationId(map.get("tenantId") == null ? "" : map.get("tenantId"));
        sysActLog.setLogTime(new Date());
        StringBuilder content = new StringBuilder();
        content.append("\u7c7b\u540d:").append(className).append(";").append("\n");
        content.append("\u65b9\u6cd5\u540d:").append(methodName).append(";").append("\n");
        String lineNumber = map.get("lineNumber");
        if (ToolUtil.isNotEmpty((Object)lineNumber)) {
            content.append("\u4ee3\u7801\u884c\u6570:").append(lineNumber).append(";").append("\n");
        }
        if (ToolUtil.isNotEmpty((Object)(params = map.get("params")))) {
            content.append("\u8bf7\u6c42\u53c2\u6570").append(params).append(";").append("\n");
        }
        content.append("\u64cd\u4f5c\u63cf\u8ff0:").append(bussinessName).append(";").append("\n");
        if (ToolUtil.isNotEmpty((Object)msg)) {
            content.append("\u5177\u4f53\u64cd\u4f5c:").append(msg).append(";").append("\n");
        }
        sysActLog.setLogContent(content.toString());
        return sysActLog;
    }

    public static SysActInterfaceLog createExceptionLogLog(Map<String, String> info, String msg) {
        SysActInterfaceLog sysActLog = new SysActInterfaceLog();
        sysActLog.setLogType("\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        sysActLog.setLogTypeName(LogType.EXCEPTION.getMessage());
        sysActLog.setSessionId(info.get("sessionId"));
        sysActLog.setLocaladdr(info.get("localIp"));
        sysActLog.setLocalport(info.get("localPort"));
        sysActLog.setLocalhost(info.get("localHost"));
        sysActLog.setRemoteaddr(info.get("ip"));
        sysActLog.setRemoteport(info.get("port"));
        sysActLog.setRemotehost(info.get("host"));
        sysActLog.setLevelEvent(LogType.SYSTEM.getMessage());
        sysActLog.setResourceAlias("\u7cfb\u7edf\u5f02\u5e38");
        sysActLog.setState(LogType.FAIL.getMessage());
        sysActLog.setUserId(info.get("userId") == null ? "" : info.get("userId"));
        sysActLog.setUserAccount(info.get("userAccount") == null ? "" : info.get("userAccount"));
        sysActLog.setUserName(info.get("userName") == null ? "" : info.get("userName"));
        sysActLog.setCorporationId(info.get("tenantId") == null ? "" : info.get("tenantId"));
        sysActLog.setLogTime(new Date());
        sysActLog.setLogContent(msg);
        return sysActLog;
    }
}

