/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SubProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.UnexpectedException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryActivity;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;

public class ProcessEndCmd
extends AddAttributeCmd<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private RuntimeService runtimeService = (RuntimeService)SpringContextHolder.getApplicationContext().getBean(RuntimeService.class);
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private String comment;
    private String instanceId;
    private String type;
    private boolean isMainEndProcess;
    private String processDefinitionId;
    private String businessId;

    public ProcessEndCmd(String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = true;
    }

    public ProcessEndCmd(String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type, boolean isMainEndProcess) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public ProcessEndCmd(String taskId, String userId, String mandator, String comment, String instanceId, String businessId, String processDefinitionId, String type, boolean isMainEndProcess) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.businessId = businessId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public Void execute(CommandContext commandContext) {
        List<HistoricActivityInstance> list;
        this.addAttribute(commandContext);
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(this.instanceId);
        this.addExecutionAttribute(processInstance);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(this.processDefinitionId);
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            List taskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(this.instanceId)).list().stream().map(TaskInfo::getId).collect(Collectors.toList());
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.instanceId).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(this.instanceId);
            dataPush.setUserId(this.userId);
            dataPush.setComment(this.comment);
            dataPush.setConsignor(this.mandator);
            dataPush.setTaskId(this.taskId);
            dataPush.setTaskIds(taskIds);
            dataPush.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());
            dataPush.setProcessKey(historicProcessInstance.getProcessDefinitionKey());
            dataPush.setEndDate(new Date());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            this.dataPushService.endProcess(dataPush);
        }
        if (!(list = BpmHistoryActivity.getRunningActivity(this.instanceId)).isEmpty()) {
            HistoricProcessInstanceEntity historicProcessInstance;
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                TaskEngineServiceImpl.getCallRejectList().add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                new ProcessEndCmd(this.userId, this.mandator, this.comment, historicActivityInstance.getCalledProcessInstanceId(), this.businessId, this.processDefinitionId, this.type, false).addExecutionAttribute(this.type, false).execute(commandContext);
                TaskEngineServiceImpl.getCallRejectList().remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new BpmException(BpmExceptionCodeEnum.END_NODE_NOT_FOUND);
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(historicActivityInstance.getProcessDefinitionId());
            String procInsId = list.get(0).getProcessInstanceId();
            List executions = this.runtimeService.createExecutionQuery().processInstanceId(procInsId).list();
            executions.removeIf(execution -> execution.getSubProcessKey() == null);
            for (Execution execution2 : executions) {
                String subProcessKey = execution2.getSubProcessKey();
                String nodeId = subProcessKey.split(":")[0];
                TaskEngineServiceImpl.getSubProcessRejectList().add(procInsId + nodeId);
                new SubProcessEndCmd(this.taskId, bm, this.userId, this.mandator, this.comment, procInsId, subProcessKey, this.type, this.isMainEndProcess).execute(commandContext);
                TaskEngineServiceImpl.getSubProcessRejectList().remove(procInsId + nodeId);
            }
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findChildExecutionsByProcessInstanceId(procInsId).get(0);
            while (executionEntity.getExecutions() != null && !executionEntity.getExecutions().isEmpty()) {
                executionEntity = (ExecutionEntity)executionEntity.getExecutions().get(0);
            }
            ParallelJumpTaskCmd parallelJumpTaskCmd = new ParallelJumpTaskCmd(this.taskId, this.userId, this.mandator, executionEntity.getId(), new JumpModel(0).setJumpTo(destinationActivity.getId()), this.comment, null, new HashMap<String, Object>(), currentActivity);
            if ("endProcess".equals(this.type)) {
                parallelJumpTaskCmd.setProcessEventType("process_end");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_end");
                }
            }
            if ("revokeProcess".equals(this.type)) {
                parallelJumpTaskCmd.setProcessEventType("process_revoke");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_revoke");
                }
            }
            parallelJumpTaskCmd.execute(commandContext);
            if ("revokeProcess".equals(this.type)) {
                historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.instanceId);
                historicProcessInstance.setDeleteReason("revokeProcess");
            } else if ("endProcess".equals(this.type)) {
                historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.instanceId);
                historicProcessInstance.setDeleteReason("endProcess");
            }
            return null;
        }
        return null;
    }

    public ProcessEndCmd addExecutionAttribute(String taskSourceFlag, boolean isMain) {
        this.addExecutionAttribute((ExecutionEntity execution) -> {
            String executionTaskSourceFlag;
            if (TaskSourceFlag.END.contains(taskSourceFlag)) {
                executionTaskSourceFlag = isMain ? taskSourceFlag : "main_end";
            } else if (TaskSourceFlag.isReject((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_reject";
            } else if (TaskSourceFlag.isRevoke((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_revoke";
            } else if (TaskSourceFlag.isFreeJump((String)taskSourceFlag)) {
                executionTaskSourceFlag = "sub_end_jump";
            } else {
                throw new UnexpectedException("\u672a\u77e5\u7684\u529e\u7406\u65b9\u5f0f\uff01");
            }
            execution.addTempVariable("taskSourceFlag", (Object)executionTaskSourceFlag);
        });
        return this;
    }
}

