/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Date;
import java.util.List;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class AssistTaskRevokeCmd
extends NeedsActiveTaskCmd<Task> {
    protected TaskEngineServiceImpl taskEngineService = (TaskEngineServiceImpl)SpringContextHolder.getApplicationContext().getBean(TaskEngineServiceImpl.class);
    protected BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    protected ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);
    protected String comment;
    protected String userId;
    protected String revokeId;
    protected String taskType;

    protected Task execute(CommandContext commandContext, TaskEntity taskEntity) {
        try {
            if ("6".equals(this.taskType)) {
                Date now = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
                HistoricTaskInstanceEntity historicTaskInstanceEntity = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(this.revokeId);
                TaskEntity task = new TaskEntity();
                task.setExecutionId(historicTaskInstanceEntity.getExecutionId());
                task.setParentTaskId(historicTaskInstanceEntity.getParentTaskId());
                task.setTaskType(this.taskType);
                task.setProcessDefinitionId(historicTaskInstanceEntity.getProcessDefinitionId());
                task.setTaskDefinitionKey(historicTaskInstanceEntity.getTaskDefinitionKey());
                task.setProcessInstanceId(historicTaskInstanceEntity.getProcessInstanceId());
                task.setSubProcessKey(historicTaskInstanceEntity.getSubProcessKey());
                task.setSendUser(historicTaskInstanceEntity.getSendUser());
                task.setFormKey(historicTaskInstanceEntity.getFormKey());
                task.setCompleteType("assist");
                task.setProcessKey(historicTaskInstanceEntity.getProcessKey());
                task.setProcessName(historicTaskInstanceEntity.getProcessName());
                task.setBusinessKey(historicTaskInstanceEntity.getBusinessKey());
                task.setFormId(historicTaskInstanceEntity.getFormId());
                task.setTenantId(historicTaskInstanceEntity.getTenantId());
                task.setName(historicTaskInstanceEntity.getName());
                task.setTenantId(historicTaskInstanceEntity.getTenantId());
                task.setCreateTime(now);
                task.setCreateHistoryTaskId(historicTaskInstanceEntity.getCreateHistoryTaskId());
                task.setTodoConfiguration(historicTaskInstanceEntity.getTodoConfiguration());
                task.insert(taskEntity.getExecution());
                task.addCandidateUser(this.userId, null, null, historicTaskInstanceEntity.getSendUser());
                task.fireEvent("create");
                task.fireEvent("start");
                task.fireEvent("assignment");
                commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(this.revokeId);
                this.taskEngineService.dataPushRevoke((HistoricTaskInstance)historicTaskInstanceEntity, this.comment, this.userId, "revoke");
                taskEntity.setIgnored("assisted_locks");
                return task;
            }
            List taskEntityList = commandContext.getTaskEntityManager().findTasksByParentTaskId(taskEntity.getId());
            for (Task task : taskEntityList) {
                TaskEntity entity = (TaskEntity)task;
                commandContext.getTaskEntityManager().deleteTask(entity, "", true);
                this.taskEngineService.taskCenterDataPush(task, this.comment, this.userId, "revoke");
            }
            commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(this.revokeId);
            taskEntity.setIgnored(null);
            this.taskEngineService.taskCenterDataPush((Task)taskEntity, this.comment, this.userId, "start_assist");
        }
        catch (RuntimeException e) {
            throw new BpmException(this.bpmConstantProperties.getAssistRevokeError());
        }
        return null;
    }

    public AssistTaskRevokeCmd(String taskId, String userId, String comment, String revokeId, String taskType) {
        super(taskId);
        this.comment = comment;
        this.userId = userId;
        this.revokeId = revokeId;
        this.taskType = taskType;
    }
}

