/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public abstract class AddAttributeCmd<T>
implements Command<T> {
    protected Consumer<CommandContext> addAttribute;
    protected Consumer<ExecutionEntity> addExecutionAttribute;

    protected void addAttribute(CommandContext commandContext) {
        if (this.addAttribute != null) {
            this.addAttribute.accept(commandContext);
        }
    }

    protected void addExecutionAttribute(ExecutionEntity execution) {
        if (this.addExecutionAttribute != null) {
            this.addExecutionAttribute.accept(execution.getProcessInstance());
        }
    }

    public AddAttributeCmd<T> addAttribute(Consumer<CommandContext> addAttribute) {
        this.addAttribute = this.addAttribute == null ? addAttribute : this.addAttribute.andThen(addAttribute);
        return this;
    }

    public AddAttributeCmd<T> addExecutionAttribute(Consumer<ExecutionEntity> addExecutionAttribute) {
        this.addExecutionAttribute = this.addExecutionAttribute == null ? addExecutionAttribute : this.addExecutionAttribute.andThen(addExecutionAttribute);
        return this;
    }

    public AddAttributeCmd<T> addSendUser(String sendUser) {
        this.addAttribute((CommandContext commandContext) -> commandContext.addAttribute("sendUser", (Object)sendUser));
        return this;
    }

    public AddAttributeCmd<T> addAttribute(Map<String, Object> variable) {
        if (HussarUtils.isNotEmpty(variable)) {
            String bpmNextNode = (String)variable.remove("bpm_next_node");
            this.addAttribute((CommandContext commandContext) -> commandContext.addAttribute("bpm_next_node", (Object)bpmNextNode));
        }
        return this;
    }

    public AddAttributeCmd<T> addExecutionAttribute(Map<String, Object> variable, String taskSourceFlag) {
        Object callActivityInfo;
        Map<String, Object> assignee;
        HashMap<String, Object> extendInfo = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(variable)) {
            assignee = this.getAppointAssignee(variable);
            callActivityInfo = variable.remove("call_activity_info");
            extendInfo.put("bakOne", variable.remove("bakOne"));
            extendInfo.put("bakTwo", variable.remove("bakTwo"));
            extendInfo.put("bakThree", variable.remove("bakThree"));
            extendInfo.put("bakFour", variable.remove("bakFour"));
            extendInfo.put("bakFive", variable.remove("bakFive"));
            extendInfo.put("bakSix", variable.remove("bakSix"));
        } else {
            assignee = null;
            callActivityInfo = null;
        }
        this.addExecutionAttribute((ExecutionEntity execution) -> {
            if (assignee != null) {
                execution.addTempVariable("appoint_assignee", (Object)assignee);
            }
            execution.addTempVariable("extend_info", (Object)extendInfo);
            BpmAttribute.addCallActivityInfo((ActivityExecution)execution, callActivityInfo);
            execution.addTempVariable("taskSourceFlag", (Object)taskSourceFlag);
        });
        return this;
    }

    private Map<String, Object> getAppointAssignee(Map<String, Object> variable) {
        HashMap<String, Object> appointAssignee = (HashMap<String, Object>)variable.remove("appoint_assignee");
        Object rejectAppointAssignee = variable.remove("reject_appoint_assignee");
        if (HussarUtils.isNotEmpty((Object)appointAssignee)) {
            appointAssignee.replaceAll((k, v) -> v instanceof String ? (HussarUtils.isEmpty((Object)v) ? null : new ArrayList<String>(Arrays.asList(((String)v).split(",")))) : (HussarUtils.isEmpty((Object)v) ? null : v));
        }
        if (HussarUtils.isNotEmpty((Object)rejectAppointAssignee)) {
            if (appointAssignee == null) {
                appointAssignee = new HashMap<String, Object>();
            }
            appointAssignee.put("static_appoint_assignee", rejectAppointAssignee instanceof String ? (HussarUtils.isEmpty((Object)rejectAppointAssignee) ? null : new ArrayList<String>(Arrays.asList(((String)rejectAppointAssignee).split(",")))) : (HussarUtils.isEmpty((Object)rejectAppointAssignee) ? null : rejectAppointAssignee));
        }
        return appointAssignee;
    }
}

