/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiProcinstMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuIdentitylinkMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiTaskinstService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuTaskService;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assist.service.IAssistService;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AssistTaskRevokeAuthenticationCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AssistTaskRevokeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteLeapTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustTaskAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.PreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RejectReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SignalCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompletePrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskJumpPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskRejectCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TransferAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UnPreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UpdateHisProcessVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UpdateHisTaskVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.SecurityLevelVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.TaskAssigneeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.DataPushUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@HussarTransactional
public class TaskEngineServiceImpl
implements ITaskEngineService {
    private static Logger logger = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    private static final String TASK_NOT_FOUND = "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01";
    private static final String PREVIOUS_NODE_NOT_FOUND = "\u4e0a\u4e00\u8282\u70b9\u672a\u627e\u5230\uff01";
    public static final String CALL_REJECT_PREFIX = "main_process_";
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private IAssistService assistService;
    @Resource
    private ICandidateUserService candidateUserService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private IBpmConfigService bpmConfigService;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private IBpmActRuTaskService bpmActRuTaskService;
    @Resource
    private BpmActHiProcinstMapper bpmActHiProcinstMapper;
    @Resource
    private IBpmActHiTaskinstService bpmActHiTaskinstService;
    @Autowired
    private ProcessDiagramService processDiagramService;
    @Resource
    private BpmActRuIdentitylinkMapper bpmActRuIdentitylinkMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    protected static List<String> CALL_REJECT_LIST = new ArrayList<String>();
    protected static List<String> SUB_PROCESS_REJECT_LIST = new ArrayList<String>();

    public static List<String> getCallRejectList() {
        return CALL_REJECT_LIST;
    }

    public static List<String> getSubProcessRejectList() {
        return SUB_PROCESS_REJECT_LIST;
    }

    public Task getTask(String taskId, String state) {
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_ID_NULL);
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).queryChildTask()).singleResult();
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        return task;
    }

    public Task getTaskWithOutCheckSuspended(String taskId, String state) {
        Task task;
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_ID_NULL);
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).queryChildTask();
        if ("2".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeProcessVariables();
        }
        if ((task = (Task)taskQuery.singleResult()) == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        return task;
    }

    public ApiResponse<Map<String, Object>> queryTask(String taskId) {
        String message;
        if ((taskId = RealTaskId.getRealTaskId(taskId)) == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String sendUser = historicTaskInstance.getSendUser();
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
        }
        Map finalUsers = new HashMap();
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set<String> users = this.getAssigneeByTaskId(taskId);
            if (HussarUtils.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (!userIds.isEmpty()) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
            }
        }
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        HashMap taskVariables = new HashMap();
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", historicTaskInstance.getTaskSourceFlag());
        String string = message = historicTaskInstance.getTodoConfiguration() != null ? historicTaskInstance.getTodoConfiguration() : "";
        if (HussarUtils.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("taskType", historicTaskInstance.getTaskType());
        map.put("formKey", historicTaskInstance.getFormKey());
        SysActExtendProperties sysActExtendProperties = this.iSysActExtendPropertiesService.queryList(historicTaskInstance.getTaskDefinitionKey(), historicTaskInstance.getProcessDefinitionId());
        if (sysActExtendProperties != null) {
            if ("assist_complete".equals(historicTaskInstance.getTaskSourceFlag())) {
                map.put("formDetailKey", sysActExtendProperties.getAssistFormDetailKey());
            } else {
                map.put("formDetailKey", sysActExtendProperties.getFormDetailKey());
            }
        } else {
            map.put("formDetailKey", null);
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(suspensionState == null ? null : Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setBusinessList(HussarUtils.isNotEmpty(businessList) ? businessList : null);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page(1L, 10L), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, List<String> businessIds) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setBusinessIds(businessIds);
        return this.flowTaskService.todoList(new Page(1L, 10L), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return this.flowTaskService.todoList(new Page(1L, 10L), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 10L), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey, String procInsState, String processInstanceId, Boolean isLatest, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processDefinitionKey, definitionKey, procInsState, processInstanceId, isLatest);
        return this.flowTaskService.doneList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return this.flowTaskService.doneList(new Page((long)flowTaskQueryModel.getPage().intValue(), (long)flowTaskQueryModel.getSize().intValue()), flowTaskQueryModel);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCount(String userId) {
        List<FlowTask> userTask = this.taskEngineMapper.getUserTask(userId);
        ArrayList userMapList = new ArrayList();
        for (FlowTask flowTask : userTask) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("PROCESSNAME", flowTask.getProcessDefinitionName());
            userMap.put("PROCESSKEY", flowTask.getProcessKey());
            userMap.put("COUNTNUM", flowTask.getCountNum());
            userMapList.add(userMap);
        }
        return ApiResponse.success(userMapList);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCountByNode(String userId) {
        List<FlowTask> userTaskByNodeList = this.taskEngineMapper.getUserTaskByNode(userId);
        ArrayList userTaskMapList = new ArrayList();
        for (FlowTask flowTask : userTaskByNodeList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TASK_DEF_KEY_", flowTask.getTaskDefinitionKey());
            map.put("PROCESSKEY", flowTask.getProcessKey());
            map.put("PROCESSNAME", flowTask.getProcessDefinitionName());
            map.put("NAME_", flowTask.getTaskName());
            map.put("COUNTNUM", flowTask.getCountNum());
            userTaskMapList.add(map);
        }
        return ApiResponse.success(userTaskMapList);
    }

    public BpmResponseResult queryToDoList(FlowTaskDto flowTaskDto) {
        Page pages = flowTaskDto.getPage() != null && flowTaskDto.getSize() != null ? new Page(flowTaskDto.getPage().longValue(), flowTaskDto.getSize().longValue()) : new Page(1L, 10L);
        FlowTaskQueryModel flowTaskQueryModel = this.buildFlowTaskQueryModel(flowTaskDto);
        IPage todoList = (IPage)this.flowTaskService.todoList(pages, flowTaskQueryModel).getData();
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)todoList.getRecords());
        jsonObject.put("count", (Object)todoList.getTotal());
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    private FlowTaskQueryModel buildFlowTaskQueryModel(FlowTaskDto flowTaskDto) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(flowTaskDto.getUserId()).setProcessKey(flowTaskDto.getProcessKey()).setDefinitionKey(flowTaskDto.getDefinitionKey()).setProcessKeys(flowTaskDto.getProcessKeys()).setBusinessIds(flowTaskDto.getBusinessIds()).setTodoConfiguration(flowTaskDto.getTodoConfiguration()).setSendUserId(flowTaskDto.getSendUserId()).setStartTime(flowTaskDto.getStartTime()).setEndTime(flowTaskDto.getEndTime()).setTaskState(flowTaskDto.getTaskState()).setTaskType(flowTaskDto.getTaskType()).setAssistInitiator(flowTaskDto.getAssistInitiator()).setDefinitionKey(flowTaskDto.getTaskDefKey()).setMandator(flowTaskDto.getMandator()).setFinishStartTime(flowTaskDto.getFinishStartTime()).setFinishEndTime(flowTaskDto.getFinishEndTime()).setProcessStartUserId(flowTaskDto.getProcessStartUserId()).setProcessStartUserName(flowTaskDto.getProcessStartUserName()).setAuditState(flowTaskDto.getAuditState()).setClassify(flowTaskDto.getClassify());
        flowTaskQueryModel.setBakOne(flowTaskDto.getBakOne());
        flowTaskQueryModel.setBakTwo(flowTaskDto.getBakTwo());
        flowTaskQueryModel.setBakThree(flowTaskDto.getBakThree());
        flowTaskQueryModel.setBakFour(flowTaskDto.getBakFour());
        flowTaskQueryModel.setBakFive(flowTaskDto.getBakFive());
        flowTaskQueryModel.setBakSix(flowTaskDto.getBakSix());
        return flowTaskQueryModel;
    }

    public BpmResponseResult queryDoneList(FlowTaskDto flowTaskDto) {
        Page pages = flowTaskDto.getPage() != null && flowTaskDto.getSize() != null ? new Page(flowTaskDto.getPage().longValue(), flowTaskDto.getSize().longValue()) : new Page(1L, 10L);
        FlowTaskQueryModel flowTaskQueryModel = this.buildFlowTaskQueryModel(flowTaskDto);
        IPage doneList = (IPage)this.flowTaskService.doneList(pages, flowTaskQueryModel).getData();
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)doneList.getRecords());
        jsonObject.put("count", (Object)doneList.getTotal());
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public BpmResponseResult getProcNodeName(String processDefinitionKey) {
        return InstallResult.success((JSONArray)this.flowTaskService.getProcNodeName(processDefinitionKey));
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        this.taskService.claim(taskId, userId);
        this.claimDataPush(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        this.taskService.unclaim(taskId);
        this.claimDataPush(taskId, null);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator, isAuditAuthority));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, null, mandator, map);
        this.completeDataPush((Task)task, "", userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, "", userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            Map<String, List<String>> appointAssignee = this.getAppointAssignee(null, assigneeMap, null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, null, mandator, newMap);
        this.completeDataPush((Task)task, "", userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, "", userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            Map<String, List<String>> appointAssignee = this.getAppointAssignee(null, assigneeMap, null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, comment, mandator, newMap);
        this.completeDataPush((Task)task, comment, userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            Map<String, List<String>> appointAssignee = this.getAppointAssignee(null, assigneeMap, null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, comment, mandator, newMap);
        this.completeDataPush((Task)task, comment, userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, comment, mandator, map);
        this.completeDataPush((Task)task, comment, userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        boolean hasSubProcessInfo = false;
        if (map != null) {
            newMap.putAll(map);
            if (map.containsKey("call_activity_info")) {
                hasSubProcessInfo = true;
            }
        }
        if (!hasSubProcessInfo) {
            String[] subs = subProcesses.split(",");
            JSONArray jsonArray = new JSONArray();
            for (String sub : subs) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("businessId", (Object)"");
                jsonObject.put("processKey", (Object)sub);
                jsonObject.put("userId", (Object)"");
                jsonArray.add((Object)jsonObject);
            }
            newMap.put("call_activity_info", jsonArray);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, comment, mandator, newMap);
        this.completeDataPush((Task)task, comment, userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private TaskEntity taskComplete(String taskId, String userId, String comment, String mandator, Map<String, Object> newMap) {
        return (TaskEntity)this.processEngine.getManagementService().executeCommand(new TaskCompleteCmd(taskId, userId, mandator, comment, newMap).addSendUser(HussarUtils.isEmpty((Object)mandator) ? userId : mandator).addAttribute(newMap).addExecutionAttribute(newMap, "complete"));
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            Map<String, List<String>> appointAssignee = this.getAppointAssignee(null, assigneeMap, null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator).isAuditAuthority(isAuditAuthority))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskEntity task = this.taskComplete(taskId, userId, comment, mandator, newMap);
        this.completeDataPush((Task)task, comment, userId, mandator, taskState);
        this.completeTodoDataPush((Task)task, userId);
        this.taskCenterDataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(TaskCompleteDto taskCompleteDto, boolean isAuditAuthority) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        Map<String, List<String>> appointAssignee;
        String taskId = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getTaskId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        taskId = taskCompleteDto.getTaskId();
        String userId = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        userId = taskCompleteDto.getUserId();
        HashMap<String, String> assigneeMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getAppointAssignee())) {
            assigneeMap = taskCompleteDto.getAppointAssignee();
        }
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getAssigneeMap())) {
            assigneeMap = (Map)JSON.parseObject((String)taskCompleteDto.getAssigneeMap(), HashMap.class);
        }
        HashMap<String, List<String>> groupCountersignAppointAssignee = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getGroupCountersignAppointAssignee())) {
            groupCountersignAppointAssignee = taskCompleteDto.getGroupCountersignAppointAssignee();
        }
        Set users = null;
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getUsers())) {
            users = (Set)JSON.parseObject((String)taskCompleteDto.getUsers(), Set.class);
        }
        Map map = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getMap())) {
            map = (Map)JSON.parseObject((String)taskCompleteDto.getMap(), HashMap.class);
        }
        String comment = "";
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getComment())) {
            comment = taskCompleteDto.getComment();
        }
        boolean flag = taskCompleteDto.getIsNotAdd();
        Boolean notNeedCheckAssignee = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getNotNeedCheckAssignee())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        notNeedCheckAssignee = taskCompleteDto.getNotNeedCheckAssignee();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(appointAssignee = this.getAppointAssignee(null, assigneeMap, groupCountersignAppointAssignee))) {
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator).isAuditAuthority(isAuditAuthority))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand(new TaskCompleteCmd(taskId, userId, mandator, comment, newMap, notNeedCheckAssignee, flag).addSendUser(HussarUtils.isEmpty((Object)mandator) ? userId : mandator).addAttribute(newMap).addExecutionAttribute(newMap, "complete"));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        this.completeTodoDataPush(task, userId);
        this.taskCenterDataPush(task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private Map<String, List<String>> getAppointAssignee(String assignees, Map<String, String> assigneeMap, Map<String, List<String>> groupCountersignAppointAssignee) {
        HashMap<String, List<String>> appointAssignee = new HashMap<String, List<String>>();
        if (HussarUtils.isNotEmpty((Object)assignees)) {
            List<String> assigneeList = Arrays.asList(assignees.split(","));
            appointAssignee.put("static_appoint_assignee", assigneeList);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            for (String key : assigneeMap.keySet()) {
                if (!HussarUtils.isNotEmpty((Object)assigneeMap.get(key))) continue;
                List<String> assigneeList = Arrays.asList(assigneeMap.get(key).split(","));
                appointAssignee.put(key, assigneeList);
            }
        }
        if (HussarUtils.isNotEmpty(groupCountersignAppointAssignee)) {
            appointAssignee.putAll(groupCountersignAppointAssignee);
        }
        return appointAssignee;
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String comment = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)task.getJumpInfo());
        if (!jumpInfo.getJumpFrom().isEmpty()) {
            HistoricTaskInstance historicTaskInstance;
            List comments;
            String rejectTask = (String)jumpInfo.getJumpFrom().get(0);
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(rejectTask)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (HussarUtils.isNotEmpty((Object)historicTaskInstanceList) && HussarUtils.isNotEmpty((Object)(comments = this.taskService.getTaskComments((historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceList.get(0)).getId(), "complete")))) {
                comment = ((Comment)comments.get(0)).getFullMessage();
            }
        }
        json.add((Object)comment);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult setTimeoutPeriod(String taskId, String timeout1) {
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date timeDate = new Date();
        if (timeout1 != null && !"".equals(timeout1)) {
            try {
                Date timeOutDate = sdf.parse(timeout1);
                if (timeOutDate.after(timeDate)) {
                    Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                    if (task != null) {
                        String str;
                        Set<String> assignees;
                        Date t1 = task.getDueDate();
                        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                        TimeOutModel timeOutModel = new TimeOutModel();
                        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                        String timeOutStrategy = null;
                        if (t1 == null) {
                            assignees = this.getAssigneeByTaskId(taskId);
                            str = String.join((CharSequence)",", assignees);
                            timeOutModel.setAssignee(str);
                            timeOutModel.setCreateTime(task.getCreateTime());
                            timeOutModel.setDueTime(timeOutDate);
                            timeOutModel.setTaskId(Long.valueOf(taskId));
                        } else {
                            this.activityRedisTimerService.delTimeOutModel(taskId);
                            assignees = this.getAssigneeByTaskId(taskId);
                            str = String.join((CharSequence)",", assignees);
                            timeOutModel.setAssignee(str);
                            timeOutModel.setCreateTime(task.getCreateTime());
                            timeOutModel.setDueTime(timeOutDate);
                            timeOutModel.setTaskId(Long.valueOf(taskId));
                        }
                        FlowElement element = bm.getFlowElement(task.getTaskDefinitionKey());
                        List timeOutElement = (List)element.getExtensionElements().get("TimeOutStrategy");
                        if (HussarUtils.isNotEmpty((Object)timeOutElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
                            timeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                        }
                        if (timeOutStrategy != null) {
                            timeOutModel.setTimeOutType(timeOutStrategy);
                            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("name", task.getName());
                                map.put("processInsId", task.getProcessInstanceId());
                                map.put("processDefinitionId", task.getProcessDefinitionId());
                                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                                map.put("formKey", task.getFormKey());
                                map.put("businessId", processInstance.getBusinessKey());
                                String processKey = processInstance.getProcessDefinitionKey();
                                ArrayList<String> processKeys = new ArrayList<String>();
                                processKeys.add(processKey);
                                Map modelNames = this.modelService.selectModelNames(processKeys);
                                String value = (String)modelNames.get(processKey);
                                map.put("processName", (String)map.get(value));
                                map.put("todoConfiguration", task.getTodoConfiguration());
                                map.put("sendUser", task.getSendUser());
                                timeOutModel.setMap(JSON.toJSONString(map));
                            }
                            this.activityRedisTimerService.addTimeOutModel(timeOutModel);
                        }
                        this.taskService.setDueDate(taskId, timeOutDate);
                        return InstallResult.getResult((String)"1", (String)"success", null);
                    }
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return InstallResult.getResult((String)"0", (String)"\u8bbe\u7f6e\u7684\u8d85\u65f6\u65f6\u95f4\u5df2\u8fc7\u5f53\u524d\u65f6\u95f4", null);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, null, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userId, assigneeMap, users, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Task task = (Task)this.processEngine.getManagementService().executeCommand(new CompleteLeapTaskCmd(taskId, mandator, userId, comment, newMap, isSubmit).addSendUser(userId).addAttribute(newMap).addExecutionAttribute(newMap, "complete_leap"));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        this.completeTodoDataPush(task, userId);
        this.taskCenterDataPush(task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeLeapTask(TaskCompleteDto taskCompleteDto) {
        Map<String, List<String>> appointAssignee;
        String taskId = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getTaskId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        taskId = taskCompleteDto.getTaskId();
        String userId = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        userId = taskCompleteDto.getUserId();
        HashMap<String, String> assigneeMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getAppointAssignee())) {
            assigneeMap = taskCompleteDto.getAppointAssignee();
        }
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getAssigneeMap())) {
            assigneeMap = (Map)JSON.parseObject((String)taskCompleteDto.getAssigneeMap(), HashMap.class);
        }
        HashMap<String, List<String>> groupCountersignAppointAssignee = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getGroupCountersignAppointAssignee())) {
            groupCountersignAppointAssignee = taskCompleteDto.getGroupCountersignAppointAssignee();
        }
        Set users = null;
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getUsers())) {
            users = (Set)JSON.parseObject((String)taskCompleteDto.getUsers(), Set.class);
        }
        Map map = new HashMap();
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getMap())) {
            map = (Map)JSON.parseObject((String)taskCompleteDto.getMap(), HashMap.class);
        }
        String comment = "";
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getComment())) {
            comment = taskCompleteDto.getComment();
        }
        boolean isSubmit = false;
        if (HussarUtils.isNotEmpty((Object)taskCompleteDto.getIsSubmit())) {
            isSubmit = taskCompleteDto.getIsSubmit();
        }
        boolean flag = taskCompleteDto.getIsNotAdd();
        Boolean notNeedCheckAssignee = null;
        if (!HussarUtils.isNotEmpty((Object)taskCompleteDto.getNotNeedCheckAssignee())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        notNeedCheckAssignee = taskCompleteDto.getNotNeedCheckAssignee();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userId, mandator));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(appointAssignee = this.getAppointAssignee(null, assigneeMap, groupCountersignAppointAssignee))) {
            newMap.put("appoint_assignee", appointAssignee);
        }
        Task task = (Task)this.processEngine.getManagementService().executeCommand(new CompleteLeapTaskCmd(taskId, mandator, userId, comment, newMap, isSubmit, flag, notNeedCheckAssignee).addSendUser(userId).addAttribute(newMap).addExecutionAttribute(newMap, "complete_leap"));
        this.completeDataPush(task, comment, userId, mandator, taskState);
        this.completeTodoDataPush(task, userId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean canRejectToMainProcess, boolean isSubmit, Map<String, Object> map, String rejectActivityId, boolean isAuditAuthority) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, null, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getTargetIds(), task.getTaskDefinitionKey(), "reject", task.getName()));
        boolean needReject = false;
        String rejectTaskId = "";
        if (HussarUtils.isNotEmpty((Object)json)) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject object = json.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(taskRejectModel.getTargetIds()) || !HussarUtils.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(task.getProcessInstanceId()) || taskRejectModel.getSubProcessFirst()) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(rejectTaskId, userId, comment, assignees, canRejectToMainProcess, isSubmit, taskRejectModel.getMap(), rejectActivityId, false);
        }
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        String taskId = taskRejectDto.getTaskId();
        String userId = taskRejectDto.getUserId();
        boolean isAuditAuthority = taskRejectDto.isAuditAuthority();
        String assignees = taskRejectDto.getAssignees();
        Map assigneeMap = taskRejectDto.getAssigneeMap();
        Map groupCountersignAppointAssignee = taskRejectDto.getGroupCountersignAppointAssignee();
        String comment = taskRejectDto.getComment();
        boolean isSubmit = taskRejectDto.getIsSubmit();
        boolean canRejectToMainProcess = taskRejectDto.isCanRejectToMainProcess();
        String rejectActivityId = taskRejectDto.getRejectActivityId();
        Map map = taskRejectDto.getVariable();
        if (HussarUtils.isEmpty((Object)map)) {
            map = (Map)JSON.parseObject((String)taskRejectDto.getMap(), HashMap.class);
        }
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, null, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setGroupCountersignAppointAssignee(groupCountersignAppointAssignee);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getTargetIds(), task.getTaskDefinitionKey(), "reject", task.getName()));
        boolean needReject = false;
        String rejectTaskId = "";
        if (HussarUtils.isNotEmpty((Object)json)) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject object = json.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(taskRejectModel.getTargetIds()) || !HussarUtils.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(task.getProcessInstanceId()) || taskRejectModel.getSubProcessFirst()) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(taskRejectDto);
        }
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
            this.taskCenterDataPush(task, comment, userId, "reject");
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getRejectNode(String taskId, boolean isSubmit, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        String targetNodeId = null;
        Task task = this.getTask(taskId, "2");
        String allPrevNode = task.getAllPrevNode();
        if (allPrevNode == null) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String completeFrom = historicProcessInstance.getCompleteFrom();
            if (completeFrom != null) {
                targetNodeId = String.join((CharSequence)",", () -> Arrays.stream(completeFrom.split(",")).map(str -> CALL_REJECT_PREFIX + str).iterator());
            }
        } else {
            targetNodeId = allPrevNode;
        }
        JSONArray jsonArray = new JSONArray();
        targetNodeId = this.checkRejectActivityId(task, targetNodeId, task.getTaskDefinitionKey());
        String processInstanceId = task.getProcessInstanceId();
        String subProcessKey = task.getSubProcessKey();
        if (!isSubmit) {
            HashMap appointAssignee = null;
            if (HussarUtils.isNotEmpty(map)) {
                try {
                    appointAssignee = (HashMap)map.get("appoint_assignee");
                }
                catch (Exception e) {
                    throw new HussarException("\u53d8\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            }
            if (appointAssignee == null) {
                appointAssignee = new HashMap();
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            for (String nodeId : targetNodeId.split(",")) {
                List historicTaskInstances;
                Process process;
                if (appointAssignee.containsKey(nodeId)) continue;
                List<String> appointAssigneeList = this.getLastAppoint(processInstanceId, subProcessKey, nodeId);
                if (HussarUtils.isNotEmpty(appointAssigneeList)) {
                    process = bm.getMainProcess();
                    HashMap<String, Object> nodes = new HashMap<String, Object>();
                    FlowElement flowElement = process.getFlowElement(nodeId);
                    String nodeName = flowElement.getName();
                    nodes.put("taskDefinitionKey", nodeId);
                    nodes.put("taskDefinitionName", nodeName);
                    nodes.put("assignee", appointAssigneeList);
                    jsonArray.add(nodes);
                    continue;
                }
                process = bm.getMainProcess();
                HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
                ArrayList<Object> assigneeList = new ArrayList();
                HashMap<String, Object> assigneeMap = new HashMap<String, Object>();
                assigneeMap.put("bpm_submit_source", task.getTaskDefinitionKey());
                assigneeMap.put("userId", null);
                List<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), assigneeMap, task);
                assigneeList = new ArrayList<String>(users);
                if (HussarUtils.isEmpty(assigneeList) && HussarUtils.isNotEmpty((Object)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByTaskCreateTime()).asc()).listPage(0, 1))) && !historicTaskInstances.isEmpty() && nodeId.equals(((HistoricTaskInstance)historicTaskInstances.get(0)).getTaskDefinitionKey())) {
                    assigneeList.add(((HistoricTaskInstance)historicTaskInstances.get(0)).getAssignee());
                }
                FlowElement flowElement = process.getFlowElement(nodeId);
                String nodeName = flowElement.getName();
                nodeInfo.put("taskDefinitionKey", nodeId);
                nodeInfo.put("taskDefinitionName", nodeName);
                nodeInfo.put("assignee", assigneeList);
                jsonArray.add(nodeInfo);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (isSubmit) {
            String[] targetNodeIds;
            String subProcessKeyCondition = subProcessKey;
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            Process process = bm.getMainProcess();
            if (process.getFlowElement((targetNodeIds = targetNodeId.split(","))[0]) != null) {
                subProcessKeyCondition = null;
            }
            for (String nodeId : targetNodeIds) {
                HashMap<String, Object> nodeMap = new HashMap<String, Object>();
                List<String> assignee = this.getTaskCommitUser(processInstanceId, nodeId, subProcessKeyCondition);
                if (HussarUtils.isNotEmpty(assignee)) {
                    nodeMap.put("assignee", assignee);
                } else {
                    List<Object> assigneeList = new ArrayList();
                    HashMap<String, Object> assigneeMap = new HashMap<String, Object>();
                    assigneeMap.put("bpm_submit_source", task.getTaskDefinitionKey());
                    assigneeMap.put("userId", null);
                    assigneeList = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), assigneeMap, task);
                    nodeMap.put("assignee", assigneeList);
                }
                FlowElement flowElement = process.getFlowElement(nodeId);
                String nodeName = flowElement.getName();
                nodeMap.put("taskDefinitionKey", nodeId);
                nodeMap.put("taskDefinitionName", nodeName);
                jsonArray.add(nodeMap);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)"error", null);
    }

    private List<String> getLastAppoint(String procInstId, String subProcessKey, String taskDefKey) {
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(procInstId)).list();
        if (historicTaskInstanceList.isEmpty()) {
            return null;
        }
        HistoricTaskInstance firstEndTask = historicTaskInstanceList.stream().filter(task -> Objects.equals(subProcessKey, task.getSubProcessKey()) && Objects.equals(taskDefKey, task.getTaskDefinitionKey()) && TaskSourceFlag.NORMAL_COMPLETE.contains(task.getCompleteType())).findFirst().orElse(null);
        if (firstEndTask != null) {
            return firstEndTask.getAppointAssignee() == null ? null : JSONArray.parseArray((String)firstEndTask.getAppointAssignee(), String.class);
        }
        return null;
    }

    public BpmResponseResult getPreviousNodeAssignee(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult((String)"0", (String)TASK_NOT_FOUND, null);
        }
        String backActivityId = task.getAllPrevNode();
        if (HussarUtils.isEmpty((Object)backActivityId)) {
            return InstallResult.getResult((String)"0", (String)PREVIOUS_NODE_NOT_FOUND, null);
        }
        ArrayList list = new ArrayList();
        ArrayList<String> assignee = new ArrayList<String>();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            Date start = historicTaskInstance.getStartTime();
            for (HistoricTaskInstance taskInstance : hisTaskList) {
                if (!start.before(taskInstance.getEndTime())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("assignee", taskInstance.getAssignee());
                map.put("taskId", taskInstance.getId());
                list.add(map);
                taskIds.add(Long.parseLong(taskInstance.getId()));
                assignee.add(taskInstance.getAssignee());
            }
        }
        List<TaskCommentVO> comments = this.taskEngineMapper.getTaskComments(taskIds);
        HashMap<String, String> commentMap = new HashMap<String, String>();
        for (TaskCommentVO commentVO : comments) {
            commentMap.put(commentVO.getTaskId(), commentVO.getMessage());
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(assignee);
        for (Map map : list) {
            map.put("assigneeName", finalUsers.get(map.get("assignee")));
            map.put("comments", commentMap.get(map.get("taskId")) == null ? "" : (String)commentMap.get(map.get("taskId")));
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(list)));
    }

    private List<String> getTaskCommitUser(String processInsId, String backActivityId, String subProcessKey) {
        List hisTaskList;
        HashSet assignees = new HashSet();
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            backActivityId = backActivityId.substring(CALL_REJECT_PREFIX.length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().subProcessKeyWithOutMain(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && !hisTaskList.isEmpty()) {
            CommonCodeUtil.getLastCompleted(hisTaskList, assignees);
            if (assignees.isEmpty()) {
                return this.getLastAppoint(processInsId, subProcessKey, backActivityId);
            }
        } else {
            return this.getLastAppoint(processInsId, subProcessKey, backActivityId);
        }
        return new ArrayList<String>(assignees);
    }

    private String checkRejectActivityId(Task task, String backActivityId, String rejectActivityId) {
        BpmnModel bm;
        if (HussarUtils.isEmpty((Object)backActivityId)) {
            throw new PublicClientException(this.bpmConstantProperties.getUnableLastNodeInformation());
        }
        if (!backActivityId.contains(",")) {
            return backActivityId;
        }
        HashSet<String> backActivityIdSet = new HashSet<String>(Arrays.asList(backActivityId.split(",")));
        if (backActivityIdSet.size() == 1) {
            return (String)backActivityIdSet.iterator().next();
        }
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (this.canRejectToAnyNode(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        FlowNode flowNode = (FlowNode)bm.getFlowElement(rejectActivityId);
        if ((flowNode = this.getGateway(flowNode, bm)) == null) {
            throw new PublicClientException(this.bpmConstantProperties.getUnableLastNodeInformation());
        }
        HashSet<String> nodeIdSet = new HashSet<String>();
        this.getAllFlowNodeFromPerGateWay(flowNode, bm, nodeIdSet);
        backActivityIdSet.retainAll(nodeIdSet);
        if (this.canRejectToAnyNode(bm, rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        throw new PublicClientException(this.bpmConstantProperties.getUnableLastNodeInformation());
    }

    private FlowNode getGateway(FlowNode node, BpmnModel bm) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway) {
                return flowNode;
            }
            if ((flowNode = this.getGateway(flowNode, bm)) == null) continue;
            return flowNode;
        }
        return null;
    }

    private void getAllFlowNodeFromPerGateWay(FlowNode node, BpmnModel bm, Set<String> nodeIdSet) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof StartEvent) continue;
            nodeIdSet.add(flowNode.getId());
            this.getAllFlowNodeFromPerGateWay(flowNode, bm, nodeIdSet);
        }
    }

    public boolean canRejectToAnyNode(BpmnModel bm, String taskDefinitionKey, String targetNodeIds) {
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        targetNodeIds = targetNodeIds.replace(CALL_REJECT_PREFIX, "");
        Process process = bm.getMainProcess();
        boolean isAllMainNode = true;
        boolean isAllSubProcessNode = true;
        for (String targetNodeId : targetNodeIds.split(",")) {
            if (process.getFlowElement(targetNodeId) != null) {
                isAllSubProcessNode = false;
            } else {
                isAllMainNode = false;
            }
            if (isAllMainNode || isAllSubProcessNode) continue;
            return false;
        }
        FlowNode userTask = (FlowNode)bm.getFlowElement(taskDefinitionKey);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(taskDefinitionKey);
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        for (List list : lists) {
            boolean listContain = false;
            for (String targetNode : targetNodes) {
                if (!list.contains(targetNode)) continue;
                if (listContain) {
                    return false;
                }
                listContain = true;
            }
        }
        return true;
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = bm.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
        }
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, null, Boolean.valueOf(true), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setCanRejectToMainProcess(true);
        if (isSubProcessFirst) {
            taskRejectModel.setSubProcessFirst(true);
            taskRejectModel.setFirst(false);
        }
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), true, taskRejectModel.getStartUserId(), taskRejectModel.getFirstNodeId(), task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        String taskId = taskRejectDto.getTaskId();
        String userId = taskRejectDto.getUserId();
        String comment = taskRejectDto.getComment();
        boolean isSubmit = taskRejectDto.getIsSubmit();
        boolean isAuditAuthority = taskRejectDto.isAuditAuthority();
        String assignees = taskRejectDto.getAssignees();
        Map assigneeMap = taskRejectDto.getAssigneeMap();
        Map groupCountersignAppointAssignee = taskRejectDto.getGroupCountersignAppointAssignee();
        boolean isSubProcessFirst = taskRejectDto.getIsSubProcessFirst();
        Map map = taskRejectDto.getVariable();
        if (HussarUtils.isEmpty((Object)map)) {
            map = (Map)JSON.parseObject((String)taskRejectDto.getMap(), HashMap.class);
        }
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new BpmException(this.bpmConstantProperties.getProcessNotStart());
        }
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, null, Boolean.valueOf(true), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setGroupCountersignAppointAssignee(groupCountersignAppointAssignee);
        taskRejectModel.setCanRejectToMainProcess(true);
        if (isSubProcessFirst) {
            taskRejectModel.setSubProcessFirst(true);
            taskRejectModel.setFirst(false);
        }
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(task, comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
            if (taskRejectModel.getJumpType() == 2) {
                List taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
                if (HussarUtils.isNotEmpty((Object)taskList)) {
                    for (Task t : taskList) {
                        List identityLinks;
                        String assignee = t.getAssignee();
                        if (HussarUtils.isEmpty((Object)assignee) && HussarUtils.isNotEmpty((Object)(identityLinks = this.taskService.getIdentityLinksForTask(t.getId())))) {
                            assignee = ((IdentityLink)identityLinks.get(0)).getUserId();
                        }
                        this.taskCenterDataPush(t, comment, assignee, "multiReject");
                    }
                }
            } else {
                this.taskCenterDataPush(task, comment, userId, "reject");
            }
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), true, taskRejectModel.getStartUserId(), taskRejectModel.getFirstNodeId(), task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, backActivityId, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(true);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(taskRejectModel.getTask(), comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
            this.taskCenterDataPush(task, comment, userId, "reject");
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), backActivityId, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        String taskId = taskRejectDto.getTaskId();
        String userId = taskRejectDto.getUserId();
        boolean isAuditAuthority = taskRejectDto.isAuditAuthority();
        boolean isSubmit = taskRejectDto.getIsSubmit();
        String comment = taskRejectDto.getComment();
        String assignees = taskRejectDto.getAssignees();
        Map groupCountersignAppointAssignee = taskRejectDto.getGroupCountersignAppointAssignee();
        Map assigneeMap = taskRejectDto.getAssigneeMap();
        Map map = taskRejectDto.getVariable();
        if (HussarUtils.isEmpty((Object)map)) {
            map = (Map)JSON.parseObject((String)taskRejectDto.getMap(), HashMap.class);
        }
        String backActivityId = taskRejectDto.getBackActivityId();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, backActivityId, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setGroupCountersignAppointAssignee(groupCountersignAppointAssignee);
        taskRejectModel.setCanRejectToMainProcess(true);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "reject"));
        Task task = taskRejectModel.getTask();
        this.rejectDataPush(taskRejectModel.getTask(), comment, userId, mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), backActivityId, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean isGetMainProcess) {
        Task task;
        taskId = RealTaskId.getRealTaskId(taskId);
        try {
            task = this.getTaskWithOutCheckSuspended(taskId, "0");
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)new JSONArray());
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            HistoricProcessInstance processInstance;
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey())).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            hisList.removeIf(historicTaskInstance -> "skip".equals(historicTaskInstance.getTaskSourceFlag()));
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").subProcessKey(task.getSubProcessKey()).finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("subProcess").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            FlowNode userTask = (FlowNode)bm.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            if (isGetMainProcess && task.getSubProcessKey() != null) {
                String taskDefKey = task.getSubProcessKey().split(":")[0];
                FlowNode subProcess = (FlowNode)bm.getFlowElement(taskDefKey);
                ids = new HashSet();
                ids.add(taskDefKey);
                lists = new ArrayList();
                if (subProcess == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllHisNodeList(bm, subProcess.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, false);
            }
            if ((isGetMainProcess && task.getSubProcessKey() != null || task.getSubProcessKey() == null) && HussarUtils.isNotEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getSuperProcessInstanceId())) {
                hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
                hisList.removeIf(historicTaskInstance -> "skip".equals(historicTaskInstance.getTaskSourceFlag()));
                if (!hisList.isEmpty()) {
                    bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                    hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                    list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                    String taskDefinitionKey = "";
                    for (HistoricActivityInstance historicActivityInstance : list) {
                        if (HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                            hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                        }
                        if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                        taskDefinitionKey = historicActivityInstance.getActivityId();
                    }
                    list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("subProcess").finished().list();
                    for (HistoricActivityInstance historicActivityInstance : list) {
                        if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                    hisTaskDefinitionKey.remove(taskDefinitionKey);
                    userTask = (FlowNode)bm.getFlowElement(taskDefinitionKey);
                    ids = new HashSet();
                    ids.add(taskDefinitionKey);
                    lists = new ArrayList();
                    if (userTask == null) {
                        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                    }
                    this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                    finalList = this.getFinalList(lists);
                    this.updateJsonResult(bm, json, finalList, true);
                }
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult queryJumpNode(String taskId, boolean isGetMainProcess) {
        Task task;
        JSONArray json = new JSONArray();
        taskId = RealTaskId.getRealTaskId(taskId);
        try {
            task = this.getTaskWithOutCheckSuspended(taskId, "0");
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            JSONObject object;
            String subProcessNodeId = null;
            if (bm.getMainProcess().getFlowElement(task.getTaskDefinitionKey()) == null) {
                for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                    if (!(flowElement instanceof SubProcess) || ((SubProcess)flowElement).getFlowElement(task.getTaskDefinitionKey()) == null) continue;
                    subProcessNodeId = flowElement.getId();
                    for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                        if (!(element instanceof UserTask)) continue;
                        object = new JSONObject();
                        object.put("id", (Object)element.getId());
                        object.put("name", (Object)element.getName());
                        json.add((Object)object);
                    }
                }
            }
            if (subProcessNodeId == null || isGetMainProcess) {
                for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                    if (subProcessNodeId != null && subProcessNodeId.equals(flowElement.getId()) || !(flowElement instanceof UserTask) && !(flowElement instanceof SubProcess) && !(flowElement instanceof CallActivity)) continue;
                    JSONObject object2 = new JSONObject();
                    object2.put("id", (Object)flowElement.getId());
                    object2.put("name", (Object)flowElement.getName());
                    json.add((Object)object2);
                }
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().callProcInstId(task.getProcessInstanceId()).singleResult();
                if (historicActivityInstance != null) {
                    BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicActivityInstance.getProcessDefinitionId());
                    for (FlowElement flowElement : bpmnModel.getMainProcess().getFlowElements()) {
                        if (historicActivityInstance.getActivityId().equals(flowElement.getId()) || !(flowElement instanceof UserTask) && !(flowElement instanceof SubProcess) && !(flowElement instanceof CallActivity)) continue;
                        object = new JSONObject();
                        object.put("id", (Object)(CALL_REJECT_PREFIX + flowElement.getId()));
                        object.put("name", (Object)("\u4e3b\u6d41\u7a0b" + flowElement.getName()));
                        json.add((Object)object);
                    }
                }
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = bm.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? CALL_REJECT_PREFIX : "";
        String namePreFix = isRejectMain ? "\u4e3b\u6d41\u7a0b" : "";
        for (String id : finalList) {
            FlowElement flowElement = bm.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private String getTaskCommitUser(String processInsId, String backActivityId) {
        List hisTaskList;
        HashSet assignees = new HashSet();
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            backActivityId = backActivityId.substring(CALL_REJECT_PREFIX.length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list()) != null && !hisTaskList.isEmpty()) {
            CommonCodeUtil.getLastCompleted(hisTaskList, assignees);
        }
        return String.join((CharSequence)",", assignees);
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        this.taskService.delegateTask(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        String owner = realTaskId.getMandatary();
        if (HussarUtils.isEmpty((Object)realTaskId.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        if (HussarUtils.isEmpty((Object)userId) || HussarUtils.isEmpty((Object)mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        if (!this.auditAuthority(userId, realTaskId.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityTransferTask(), null);
        }
        if (userId.equals(mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoTransferTaskOneself(), null);
        }
        Task task = this.getTask(realTaskId.getTaskId(), "1");
        if (TaskType.isAssist((String)task.getTaskType())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAssistTaskWithErrorHandle(), null);
        }
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        this.processEngine.getManagementService().executeCommand((Command)new EntrustTaskAssigneeCmd(realTaskId.getTaskId(), userId, mandatary, false, false, owner));
        this.processEngine.getManagementService().executeCommand((Command)new TransferAddHistoryTaskCmd(execution, "", new Date(), userId, mandatary, realTaskId.getTaskId(), owner == null ? userId : owner));
        this.activityRedisTimerService.updateTimeOutModel(realTaskId.getTaskId(), mandatary, userId, 0);
        SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
        sysActUrgeTask.setReceiveUser(mandatary);
        this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(realTaskId.getTaskId()))).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        this.entrustDataPush(task, userId, mandatary, "", task.getCreateTime(), new Date(), "entrust", "entrust");
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary, int state) {
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId))) || HussarUtils.isEmpty((Object)mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "0");
        if (TaskType.isAssist((String)task.getTaskType())) {
            this.assistService.assistTaskAddAssignee(taskId, mandatary, state == 1);
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        if (state != 0 && mandatary.contains(",") && this.isMulti(task) == 2) {
            return InstallResult.getResult((String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), (String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", mandatary, state == 0, false));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            String[] receiveUsers = mandatary.split(",");
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : receiveUsers) {
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(urgeTask.getTaskId());
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            if (state == 1) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, mandatary);
        }
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, null, state);
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        this.entrustDataPush(task, null, mandatary, "", task.getCreateTime(), new Date(), "add", "entrust");
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        String taskId = taskEntrustDto.getTaskId();
        String userId = taskEntrustDto.getUserId();
        String mandatary = taskEntrustDto.getMandatary();
        String comment = taskEntrustDto.getComment();
        if (HussarUtils.isEmpty((Object)comment)) {
            return this.entrustTask(taskId, userId, mandatary);
        }
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        String owner = realTaskId.getMandatary();
        if (HussarUtils.isEmpty((Object)realTaskId.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        if (HussarUtils.isEmpty((Object)userId) || HussarUtils.isEmpty((Object)mandatary)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        if (!this.auditAuthority(userId, realTaskId.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityTransferTask(), null);
        }
        if (userId.equals(mandatary)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        Task task = this.getTask(realTaskId.getTaskId(), "0");
        if (TaskType.isAssist((String)task.getTaskType())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAssistTaskWithErrorHandle(), null);
        }
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        if (!this.auditAuthority(mandatary, realTaskId.getTaskId())) {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustTaskAssigneeCmd(realTaskId.getTaskId(), userId, mandatary, false, false, owner));
            this.processEngine.getManagementService().executeCommand((Command)new TransferAddHistoryTaskCmd(execution, comment, new Date(), userId, mandatary, realTaskId.getTaskId(), owner == null ? userId : owner));
            this.activityRedisTimerService.updateTimeOutModel(realTaskId.getTaskId(), mandatary, userId, 0);
            SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
            sysActUrgeTask.setReceiveUser(mandatary);
            this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(realTaskId.getTaskId()))).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        } else {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustTaskAssigneeCmd(realTaskId.getTaskId(), userId, mandatary, false, true, owner));
            this.processEngine.getManagementService().executeCommand((Command)new TransferAddHistoryTaskCmd(execution, comment, new Date(), userId, null, realTaskId.getTaskId(), owner == null ? userId : owner));
            this.activityRedisTimerService.updateTimeOutModel(realTaskId.getTaskId(), null, userId, 0);
            this.sysActUrgeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(realTaskId.getTaskId()))).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        this.entrustDataPush(task, userId, mandatary, comment, task.getCreateTime(), new Date(), "entrust", "entrust");
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult freeJump(String taskId, String targetTaskDefinitionKey, String userId, String assignees, Map<String, String> assigneeMap, boolean canRejectToMainProcess, boolean isSubmit, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        Task task = this.getTask(taskId, "1");
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, targetTaskDefinitionKey, Boolean.valueOf(false), map);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addAttribute(map).addExecutionAttribute(map, "freejump"));
        this.freeJumpDataPush(taskRejectModel.getTask(), comment, userId, taskRejectModel.getAllAffectedTaskIds(), mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
            this.taskCenterDataPush(task, comment, userId, "freejump");
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getTask().getProcessDefinitionId(), taskRejectModel.getTask().getTaskDefinitionKey(), taskRejectModel.getTask().getSubProcessKey(), taskRejectModel.getMap()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult freeJump(TaskFreeJumpDto taskFreeJumpDto) {
        String taskId = taskFreeJumpDto.getTaskId();
        String activityId = taskFreeJumpDto.getActivityId();
        String userId = taskFreeJumpDto.getUserId();
        String assignees = taskFreeJumpDto.getAssignees();
        Map assigneeMap = taskFreeJumpDto.getAssigneeMap();
        Map groupCountersignAppointAssignee = taskFreeJumpDto.getGroupCountersignAppointAssignee();
        List activityIds = taskFreeJumpDto.getActivityIds();
        boolean canRejectToMainProcess = true;
        boolean isSubmit = taskFreeJumpDto.getIsSubmit();
        String comment = taskFreeJumpDto.getComment();
        Map map = taskFreeJumpDto.getMap();
        boolean isAuditAuthority = taskFreeJumpDto.getIsAuditAuthority();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, isAuditAuthority));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = null;
        if (activityId != null && !"".equals(activityId)) {
            taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, activityId, Boolean.valueOf(false), map);
        } else {
            String strActivity = String.join((CharSequence)",", activityIds);
            taskRejectModel = new TaskRejectModel(userId, mandator, comment, isSubmit, taskId, strActivity, Boolean.valueOf(false), map);
        }
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setGroupCountersignAppointAssignee(groupCountersignAppointAssignee);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addAttribute(map).addExecutionAttribute(map, "freejump"));
        this.freeJumpDataPush(taskRejectModel.getTask(), comment, userId, taskRejectModel.getAllAffectedTaskIds(), mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(taskRejectModel.getTask(), userId);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getTask().getProcessDefinitionId(), taskRejectModel.getTask().getTaskDefinitionKey(), taskRejectModel.getTask().getSubProcessKey(), taskRejectModel.getMap()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public void jumpForAddPreNode(String taskId, String nodeId, String userId, String assignees) {
        Task task = this.getTask(taskId, "1");
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskJumpPrepareCmd(taskId, userId, mandator, true));
        mandator = prepareReturn.getMandator();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, mandator, null, false, taskId, nodeId, Boolean.valueOf(false), null);
        taskRejectModel.setAssignees(assignees);
        taskRejectModel.setCanRejectToMainProcess(true);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        this.freeJumpDataPush(taskRejectModel.getTask(), null, userId, taskRejectModel.getAllAffectedTaskIds(), mandator, taskState);
        if (taskRejectModel.getJumpType() != 3) {
            this.completeTodoDataPush(task, userId);
            this.taskCenterDataPush(task, null, userId, "appendJump");
        }
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        taskId = RealTaskId.getRealTaskId(taskId);
        if (assigneeList == null || assigneeList.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "0");
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = bm.getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        Map newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType, variableMap));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : assigneeList) {
                String newTaskId = (String)newTaskIdMap.get(receiveUser);
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, String.join((CharSequence)",", assigneeList));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String userIds) {
        int num;
        taskId = RealTaskId.getRealTaskId(taskId);
        if (HussarUtils.isEmpty((Object)userIds)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "0");
        if (TaskType.isAssist((String)task.getTaskType())) {
            this.assistService.assistTaskAddAssignee(taskId, userIds, false);
        }
        if ((num = this.isMulti(task)) != 2) {
            this.entrustTask(taskId, userIds, 0);
        } else {
            List list;
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(userIds.split(",")));
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!HussarUtils.isNotEmpty((Object)runningTask.getAssignee())) continue;
                users.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = bm.getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            Map newTaskIdMap = null;
            if (HussarUtils.isNotEmpty(users)) {
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), users, dueTime, outTimeType, variableMap));
            }
            if ((list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)))) != null && !list.isEmpty()) {
                String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
                HashSet<String> set = new HashSet<String>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    set.add(((SysActUrgeTask)list.get(i)).getReceiveUser());
                    if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                    list.remove(i);
                }
                String[] receiveUsers = userIds.split(",");
                ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
                for (String receiveUser : receiveUsers) {
                    String newTaskId;
                    if (set.contains(receiveUser) || (newTaskId = (String)newTaskIdMap.get(receiveUser)) == null) continue;
                    for (SysActUrgeTask urgeTask : list) {
                        SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                        saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                        saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                        saveUrgeTask.setProcName(urgeTask.getProcName());
                        saveUrgeTask.setTaskName(urgeTask.getTaskName());
                        saveUrgeTask.setSendUser(urgeTask.getSendUser());
                        saveUrgeTask.setReceiveUser(receiveUser);
                        saveUrgeTask.setSendTime(urgeTask.getSendTime());
                        saveUrgeTask.setFormKey(urgeTask.getFormKey());
                        saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                        saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                        saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                        saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                        saveList.add(saveUrgeTask);
                    }
                }
                this.sysActUrgeTaskService.saveBatch(saveList);
                this.addUrgeTask(task, userIds);
            }
        }
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        taskId = RealTaskId.getRealTaskId(taskId);
        if (HussarUtils.isEmpty((Object)users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            Task task = this.getTask(taskId, "0");
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        } else {
            if (businessId == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (tasks.isEmpty()) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(((Task)tasks.get(0)).getProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getModifyParticipantsSuccess(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        List<BpmTreeModel> users = AnalyticalModelUtil.getNextCandidateUserWithParent(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), map, task);
        for (BpmTreeModel bpmTreeModel : users) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)bpmTreeModel.getId());
            jsonObject.put("name", (Object)bpmTreeModel.getLabel());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        if (HussarUtils.isNotEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, map);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            List<Object> users = new ArrayList();
            try {
                users = AnalyticalModelUtil.getNextCandidateUserWithParent(null, processDefinitionId, bpmnModel, nodeId, null, map, null);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            for (BpmTreeModel bpmTreeModel : users) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)bpmTreeModel.getId());
                jsonObject.put("name", (Object)bpmTreeModel.getLabel());
                jsonArray.add((Object)jsonObject);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public BpmResponseResult queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        HashMap<String, Object> assigneeVariable = new HashMap();
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
        }
        List<String> users = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), nodeAssigneeQueryDto.getUserId(), assigneeVariable);
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty(users)) {
            List bpmTreeModels = this.iAssigneeChooseService.queryAssigneeAndDept(users, nodeAssigneeQueryDto.getOrganName());
            jsonArray.addAll((Collection)bpmTreeModels);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNodeAssigneeListByPage(Page<BpmTreeModel> page, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        List<Object> users = new ArrayList();
        HashMap<String, Object> assigneeVariable = new HashMap();
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
        }
        users = this.queryNodeAssigneeWithParent(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), nodeAssigneeQueryDto.getUserId(), assigneeVariable);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", new ArrayList());
        jsonObject.put("count", (Object)0);
        if ("user".equals(nodeAssigneeQueryDto.getType()) || HussarUtils.isNotEmpty(users)) {
            if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getId()) && "user".equals(nodeAssigneeQueryDto.getType())) {
                BpmTreeModel bpmTreeModel = new BpmTreeModel();
                bpmTreeModel.setId(nodeAssigneeQueryDto.getId());
                users.add(bpmTreeModel);
            }
            Page result = this.iAssigneeChooseService.queryNodeAssigneeListWithParentByPage(page, users, nodeAssigneeQueryDto);
            jsonObject.put("data", (Object)result.getRecords());
            jsonObject.put("count", (Object)result.getTotal());
        }
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public BpmResponseResult getTaskVariable(String taskId) {
        List<Variables> variableList = this.taskEngineMapper.getTaskVariables(HussarUtils.isNotEmpty((Object)taskId) ? Long.valueOf(Long.parseLong(taskId)) : null);
        Map<Object, Object> map = new HashMap();
        if (!HussarUtils.isNotEmpty(variableList)) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        map = this.traverseVariables(variableList);
        map.put("taskId", taskId);
        ArrayList<Map<Object, Object>> taskVarList = new ArrayList<Map<Object, Object>>();
        taskVarList.add(map);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(taskVarList);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getProcessVariable(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        Map<Object, Object> map = new HashMap();
        ArrayList varList = new ArrayList();
        JSONArray jsonArray = new JSONArray();
        List<Variables> variableList = this.taskEngineMapper.getProcessVariables(Long.parseLong(processInsId));
        map = this.traverseVariables(variableList);
        varList.add(map);
        jsonArray.addAll(varList);
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByTaskCreateTime()).asc()).list();
        for (HistoricTaskInstance historicTaskInstance : taskList) {
            BpmResponseResult result = this.getTaskVariable(historicTaskInstance.getId());
            Object obj = result.getResult().get(0);
            jsonArray.add(obj);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public Map<String, Object> traverseVariables(List<Variables> variableList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Variables variables : variableList) {
            if (map.containsKey(variables.getName())) continue;
            if ("string".equals(variables.getVariableType()) || "json".equals(variables.getVariableType()) || "uuid".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getTextValue());
                continue;
            }
            if ("integer".equals(variables.getVariableType()) || "boolean".equals(variables.getVariableType()) || "date".equals(variables.getVariableType()) || "long".equals(variables.getVariableType()) || "short".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getLongValue());
                continue;
            }
            if ("double".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getDoubleValue());
                continue;
            }
            if ("serializable".equals(variables.getVariableType()) || "bytes".equals(variables.getVariableType())) {
                byte[] bytes = variables.getBytes();
                Object obj = null;
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(bis);
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_FORMAT_TRANSFER);
                }
                finally {
                    try {
                        bis.close();
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                String str = "[" + jsonString + "]";
                JSONArray objects = JSONArray.parseArray((String)str);
                map.put(variables.getName(), objects);
                continue;
            }
            map.put(variables.getName(), "");
        }
        return map;
    }

    public BpmResponseResult updateTaskVariable(String taskId, List<Map<String, Object>> variableList) {
        try {
            if (HussarUtils.isNotEmpty(variableList)) {
                for (Map<String, Object> map : variableList) {
                    Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                    if (task != null) {
                        this.taskService.setVariables(taskId, map);
                        continue;
                    }
                    this.processEngine.getManagementService().executeCommand((Command)new UpdateHisTaskVariableCmd(taskId, map));
                }
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessUpdate(), null);
            }
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
        }
    }

    public BpmResponseResult updateProcessVariable(String processInsId, String businessKey, List<Map<String, Object>> variableList) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            for (Map<String, Object> variableMap : variableList) {
                List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
                if (executionList.size() > 0) {
                    this.runtimeService.setVariables(processInsId, variableMap);
                    continue;
                }
                this.processEngine.getManagementService().executeCommand((Command)new UpdateHisProcessVariableCmd(processInsId, variableMap));
            }
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
        }
    }

    public BpmResponseResult getCommentByTaskId(List<String> taskIds) {
        try {
            JSONArray jsonArray = new JSONArray();
            List<Long> longTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<TaskCommentVO> taskComments = this.taskEngineMapper.getTaskComments(longTaskIds);
            jsonArray.addAll(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_QUERY);
        }
    }

    public BpmResponseResult getComments(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            List taskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
            JSONArray jsonArray = new JSONArray();
            List<TaskCommentVO> processComments = this.taskEngineMapper.getProcessComments(Long.parseLong(processInsId));
            jsonArray.add(processComments);
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (HistoricTaskInstance taskInstance : taskInstanceList) {
                taskIds.add(Long.parseLong(taskInstance.getId()));
            }
            List<TaskCommentVO> taskComments = this.taskEngineMapper.getTaskComments(taskIds);
            jsonArray.add(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_QUERY);
        }
    }

    public BpmResponseResult deleteComment(String taskId) {
        try {
            this.taskEngineMapper.deleteComment(HussarUtils.isNotEmpty((Object)taskId) ? Long.valueOf(Long.parseLong(taskId)) : null);
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_DELETE);
        }
    }

    public String getProcessInsId(String businessKey) {
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    private List<String> queryNodeAssignee(String processKey, String taskId, String nodeId, String userId, Map<String, Object> assigneeVariable) {
        if (HussarUtils.isNotEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            BpmnModel bm;
            Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", task.getTaskDefinitionKey());
            if (assigneeVariable != null) {
                map.putAll(assigneeVariable);
            }
            if ((bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())) == null) {
                throw new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND);
            }
            map.put("userId", userId);
            List<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), map, task);
            return users;
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                throw new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", taskDefinitionKey);
            map.put("userId", userId);
            if (assigneeVariable != null) {
                map.putAll(assigneeVariable);
            }
            List<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, null, map, null);
            return users;
        }
        throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
    }

    private List<BpmTreeModel> queryNodeAssigneeWithParent(String processKey, String taskId, String nodeId, String userId, Map<String, Object> assigneeVariable) {
        if (HussarUtils.isNotEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            BpmnModel bm;
            Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", task.getTaskDefinitionKey());
            if (assigneeVariable != null) {
                map.putAll(assigneeVariable);
            }
            if ((bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())) == null) {
                throw new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND);
            }
            map.put("userId", userId);
            List<BpmTreeModel> users = AnalyticalModelUtil.getNextCandidateUserWithParent(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), map, task);
            return users;
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                throw new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", taskDefinitionKey);
            map.put("userId", userId);
            if (assigneeVariable != null) {
                map.putAll(assigneeVariable);
            }
            List<BpmTreeModel> users = AnalyticalModelUtil.getNextCandidateUserWithParent(null, processDefinitionId, bpmnModel, nodeId, null, map, null);
            return users;
        }
        throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
    }

    public BpmResponseResult queryAllAssignee(String procDefinitionKey, String taskDefinitionKey) {
        Object users;
        JSONObject jsonObject;
        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(procDefinitionKey, null);
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        ArrayList<String> userIds = new ArrayList<String>();
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, new HashMap<String, Object>(), null);
                userIds.addAll((Collection<String>)users);
                jsonObject.put("assignee", users);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
                isContain = true;
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)flowElement.getId());
                jsonObject2.put("name", (Object)flowElement.getName());
                List<String> users2 = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, new HashMap<String, Object>(), null);
                userIds.addAll(users2);
                jsonObject2.put("assignee", users2);
                jsonArray.add((Object)jsonObject2);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        Map userMap = this.iAssigneeChooseService.getUserListByUserId(userIds);
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            users = jsonObject.getJSONArray("assignee");
            ArrayList user = new ArrayList();
            for (int j = 0; j < users.size(); ++j) {
                String userId = users.getString(j);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", userId);
                map.put("userName", (String)userMap.get(userId));
                user.add(map);
            }
            jsonObject.put("assignee", user);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public ApiResponse<Map<String, Object>> queryHistoryActByTaskId(String taskId, String processInsId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInsId;
        if (newProcessInstanceId == null) {
            Task task = this.getTask(taskId, "0");
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && !list.isEmpty()) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endTime = simpleDateFormat.format(historyIns.getEndTime());
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("endTime", (Object)(historyIns.getEndTime() == null ? null : endTime));
                    json.add((Object)object);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", list != null ? list.size() : 0);
            result.put("data", (Integer)json);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<JSONObject> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        JSONObject object = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            object.put("processDefinitionId", (Object)this.processDefinitionsService.getStartProcessDefinitionId(processKey, null));
        } else {
            Task task = this.getTask(taskId, "0");
            object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult queryTaskIdByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        JSONArray array = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            HashSet<String> assigneeIds = new HashSet<String>();
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInsId", (Object)task.getProcessInstanceId());
                Set<String> ids = this.getAssigneeByTaskId(task.getId());
                ArrayList<String> idList = new ArrayList<String>(ids);
                assigneeIds.addAll(idList);
                jsonObject.put("assignee", idList);
                jsonObject.put("startTime", (Object)task.getCreateTime());
                jsonObject.put("suspensionState", (Object)(((TaskEntity)task).getSuspensionState() + ""));
                jsonObject.put("sendUser", (Object)task.getSendUser());
                assigneeIds.add(task.getSendUser());
                jsonObject.put("timeoutState", (Object)"0");
                if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                    Long dueTime = task.getDueDate().getTime();
                    Long nowTime = System.currentTimeMillis();
                    if (dueTime <= nowTime) {
                        jsonObject.put("timeoutState", (Object)"1");
                    }
                }
                jsonObject.put("dueDate", (Object)task.getDueDate());
                if ("".equals(task.getAssignee()) || task.getAssignee() == null) {
                    jsonObject.put("formKey", (Object)task.getFormKey());
                } else {
                    jsonObject.put("formDetailKey", (Object)task.getFormKey());
                }
                json.add((Object)jsonObject);
            }
            ArrayList list = new ArrayList(assigneeIds);
            Map userList = this.iAssigneeChooseService.getUserListByUserId(list);
            for (Object o : json) {
                JSONObject jsonObject = (JSONObject)o;
                List idList = (List)jsonObject.get((Object)"assignee");
                ArrayList<TaskAssigneeVo> taskAssigneeVos = new ArrayList<TaskAssigneeVo>();
                if (idList.size() > 0) {
                    for (int i = 0; i < idList.size(); ++i) {
                        String id = (String)idList.get(i);
                        TaskAssigneeVo taskAssigneeVo = new TaskAssigneeVo();
                        taskAssigneeVo.setUserId(Long.valueOf(Long.parseLong(id)));
                        taskAssigneeVo.setUserName((String)userList.get(id));
                        taskAssigneeVos.add(taskAssigneeVo);
                    }
                    jsonObject.put("assignee", taskAssigneeVos);
                }
                String sendUser = jsonObject.getString("sendUser");
                jsonObject.put("sendUserName", userList.get(sendUser));
                array.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)array);
    }

    public BpmResponseResult queryTaskByBusinessIdAndProcessInsId(String businessId, String processInsId) {
        Map<String, String> nodeMap;
        List<Map<String, String>> nodeMapList;
        Map subProcess;
        String subProcessVariable;
        HashMap<String, Object> subProcessMap;
        String subProcessNodeId;
        String[] subProcessKeyMessage;
        HashMap<String, Object> map;
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = null;
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
            }
        } else {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        processInsId = historicProcessInstance.getId();
        List taskEntities = new ArrayList();
        List historicProcessInstanceEntities = new ArrayList();
        List historicCallActivityEntities = new ArrayList();
        taskEntities = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        historicProcessInstanceEntities = this.historyService.createHistoricActivityInstanceQuery().activityType("receiveTask").unfinished().processInstanceId(processInsId).list();
        historicCallActivityEntities = this.historyService.createHistoricActivityInstanceQuery().activityType("callActivity").unfinished().processInstanceId(processInsId).list();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        JSONArray result = new JSONArray();
        HashMap<String, Object> message = new HashMap<String, Object>();
        result.add(message);
        message.put("processInsId", processInsId);
        message.put("businessId", historicProcessInstance.getBusinessKey());
        message.put("startTime", historicProcessInstance.getStartTime());
        message.put("startUser", historicProcessInstance.getStartUserId());
        String processKey = historicProcessInstance.getProcessDefinitionId().split(":")[0];
        message.put("processKey", processKey);
        if (historicProcessInstance.getEndTime() != null) {
            message.put("endTime", historicProcessInstance.getEndTime());
        }
        if (historicProcessInstance.getDueDate() != null) {
            message.put("dueTime", historicProcessInstance.getDueDate());
        }
        HashMap nodeMessageMap = new HashMap();
        ArrayList nodeMessages = new ArrayList();
        message.put("nodeInfo", nodeMessages);
        List taskIds = taskEntities.stream().map(task -> Long.valueOf(task.getId())).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, taskIds);
        List list = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
        HashMap<String, List> taskUserMap = new HashMap<String, List>();
        HashSet<String> userIds = new HashSet<String>();
        for (BpmActRuIdentitylink bpmActRuIdentitylink : list) {
            taskUserMap.computeIfAbsent(String.valueOf(bpmActRuIdentitylink.getTaskId()), k -> new ArrayList()).add(bpmActRuIdentitylink.getUserId());
            userIds.add(bpmActRuIdentitylink.getUserId());
        }
        Map assigneeMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIds));
        for (Task taskEntity : taskEntities) {
            HashMap<String, String> userMap;
            ArrayList assignee;
            List taskUser;
            List tasks;
            boolean isMultiSubProcess;
            if (taskEntity.getSubProcessKey() == null) {
                map = (HashMap<String, Object>)nodeMessageMap.get(taskEntity.getTaskDefinitionKey());
                List tasks2 = new ArrayList();
                if (map == null) {
                    map = new HashMap();
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("taskDefinitionName", taskEntity.getName());
                    map.put("type", "task");
                    map.put("tasks", tasks2);
                    nodeMessageMap.put(taskEntity.getTaskDefinitionKey(), map);
                } else {
                    tasks2 = (List)map.get("tasks");
                }
                HashMap<String, Object> stringMap2 = new HashMap<String, Object>();
                stringMap2.put("taskId", taskEntity.getId());
                stringMap2.put("startTime", taskEntity.getCreateTime());
                stringMap2.put("formKey", taskEntity.getFormKey());
                List taskUser2 = taskUserMap.getOrDefault(taskEntity.getId(), new ArrayList());
                ArrayList assignee2 = new ArrayList();
                for (String user : taskUser2) {
                    HashMap<String, String> userMap2 = new HashMap<String, String>();
                    userMap2.put("userId", user);
                    userMap2.put("userName", (String)assigneeMap.get(user));
                    assignee2.add(userMap2);
                }
                stringMap2.put("assignee", assignee2);
                tasks2.add(stringMap2);
                continue;
            }
            subProcessKeyMessage = taskEntity.getSubProcessKey().split(":");
            subProcessNodeId = subProcessKeyMessage[0];
            subProcessMap = (HashMap<String, Object>)nodeMessageMap.get(subProcessNodeId);
            boolean bl = isMultiSubProcess = !"".equals(subProcessKeyMessage[1]);
            if (subProcessMap == null) {
                subProcessMap = new HashMap<String, Object>();
                subProcessMap.put("taskDefinitionKey", subProcessNodeId);
                subProcessMap.put("taskDefinitionName", bpmnModel.getFlowElement(subProcessNodeId).getName());
                subProcessMap.put("type", isMultiSubProcess ? "multiSubProcess" : "subProcess");
            }
            if (isMultiSubProcess) {
                subProcessVariable = subProcessKeyMessage[1];
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                nodeMap = null;
                for (Map map2 : nodeMapList) {
                    if (!map2.get("taskDefinitionKey").equals(taskEntity.getTaskDefinitionKey())) continue;
                    nodeMap = map2;
                    break;
                }
                tasks = new ArrayList();
                if (nodeMap == null) {
                    nodeMap = new HashMap();
                    nodeMap.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    nodeMap.put("taskDefinitionName", taskEntity.getName());
                    nodeMap.put("type", "task");
                    nodeMap.put("tasks", (String)((Object)tasks));
                    nodeMapList.add(nodeMap);
                } else {
                    tasks = (List)nodeMap.get("tasks");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("taskId", taskEntity.getId());
                hashMap.put("startTime", taskEntity.getCreateTime());
                hashMap.put("formKey", taskEntity.getFormKey());
                taskUser = taskUserMap.getOrDefault(taskEntity.getId(), new ArrayList());
                assignee = new ArrayList();
                for (String user : taskUser) {
                    userMap = new HashMap<String, String>();
                    userMap.put("userId", user);
                    userMap.put("userName", (String)assigneeMap.get(user));
                    assignee.add(userMap);
                }
                hashMap.put("assignee", taskUser);
                tasks.add(hashMap);
                subProcessMap.put("subProcess", subProcess);
            } else {
                subProcessVariable = "";
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (ArrayList)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                subProcessMap.put("subProcess", subProcess);
                nodeMap = null;
                for (Map map3 : nodeMapList) {
                    if (!map3.get("taskDefinitionKey").equals(taskEntity.getTaskDefinitionKey())) continue;
                    nodeMap = map3;
                    break;
                }
                tasks = new ArrayList();
                if (nodeMap == null) {
                    nodeMap = new HashMap();
                    nodeMap.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    nodeMap.put("taskDefinitionName", taskEntity.getName());
                    nodeMap.put("type", "task");
                    nodeMap.put("tasks", (String)((Object)tasks));
                    nodeMapList.add(nodeMap);
                } else {
                    tasks = (List)nodeMap.get("tasks");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("taskId", taskEntity.getId());
                hashMap.put("startTime", taskEntity.getCreateTime());
                hashMap.put("formKey", taskEntity.getFormKey());
                taskUser = taskUserMap.getOrDefault(taskEntity.getId(), new ArrayList());
                assignee = new ArrayList();
                for (String user : taskUser) {
                    userMap = new HashMap();
                    userMap.put("userId", user);
                    userMap.put("userName", (String)assigneeMap.get(user));
                    assignee.add(userMap);
                }
                hashMap.put("assignee", assignee);
                tasks.add(hashMap);
            }
            nodeMessageMap.put(subProcessNodeId, subProcessMap);
        }
        for (HistoricActivityInstance historicActivityInstance : historicProcessInstanceEntities) {
            boolean isMultiSubProcess;
            if (historicActivityInstance.getSubProcessKey() == null) {
                map = new HashMap<String, Object>();
                map.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                map.put("taskDefinitionName", historicActivityInstance.getActivityName());
                map.put("type", "receiveTask");
                map.put("executionId", historicActivityInstance.getExecutionId());
                map.put("startTime", historicActivityInstance.getStartTime());
                nodeMessageMap.put(historicActivityInstance.getActivityId(), map);
                continue;
            }
            subProcessKeyMessage = historicActivityInstance.getSubProcessKey().split(":");
            subProcessNodeId = subProcessKeyMessage[0];
            subProcessMap = (Map)nodeMessageMap.get(subProcessNodeId);
            boolean bl = isMultiSubProcess = !"".equals(subProcessKeyMessage[1]);
            if (subProcessMap == null) {
                subProcessMap = new HashMap();
                subProcessMap.put("taskDefinitionKey", subProcessNodeId);
                subProcessMap.put("taskDefinitionName", bpmnModel.getFlowElement(subProcessNodeId).getName());
                subProcessMap.put("type", isMultiSubProcess ? "multiSubProcess" : "subProcess");
            }
            if (isMultiSubProcess) {
                subProcessVariable = subProcessKeyMessage[1];
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                nodeMap = new HashMap<String, String>();
                nodeMap.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                nodeMap.put("taskDefinitionName", historicActivityInstance.getActivityName());
                nodeMap.put("type", "receiveTask");
                nodeMap.put("executionId", historicActivityInstance.getExecutionId());
                nodeMap.put("startTime", (String)((Object)historicActivityInstance.getStartTime()));
                nodeMapList.add(nodeMap);
                subProcessMap.put("subProcess", subProcess);
            } else {
                subProcessVariable = "";
                subProcess = subProcessMap.getOrDefault("subProcess", new HashMap());
                nodeMapList = (List)subProcess.get(subProcessVariable);
                if (nodeMapList == null) {
                    nodeMapList = new ArrayList();
                    subProcess.put(subProcessVariable, nodeMapList);
                }
                subProcessMap.put("subProcess", subProcess);
                nodeMap = new HashMap();
                nodeMap.put("taskDefinitionKey", historicActivityInstance.getActivityId());
                nodeMap.put("taskDefinitionName", historicActivityInstance.getActivityName());
                nodeMap.put("type", "receiveTask");
                nodeMap.put("executionId", historicActivityInstance.getExecutionId());
                nodeMap.put("startTime", (String)((Object)historicActivityInstance.getStartTime()));
                nodeMapList.add(nodeMap);
            }
            nodeMessageMap.put(subProcessNodeId, subProcessMap);
        }
        for (HistoricActivityInstance historicActivityInstance : historicCallActivityEntities) {
            map = new HashMap();
            map.put("taskDefinitionKey", historicActivityInstance.getActivityId());
            map.put("taskDefinitionName", historicActivityInstance.getActivityName());
            map.put("type", "callActivity");
            map.put("startTime", historicActivityInstance.getStartTime());
            nodeMessageMap.put(historicActivityInstance.getActivityId(), map);
        }
        nodeMessages.addAll(nodeMessageMap.values());
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)result);
    }

    private BpmResponseResult queryNextNode(String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        UserTask userTask;
        Task task;
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task1 = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)task1)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        try {
            task = this.getTaskWithOutCheckSuspended(taskId, "0");
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)new JSONArray());
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        if (isGetRevokeNode) {
            JumpInfo jumpInfo = null;
            if (TaskSourceFlag.isReject((String)task.getCompleteType())) {
                jumpInfo = JumpInfo.toJumpInfo((String)task.getJumpInfo());
            }
            if (HussarUtils.isNotEmpty(jumpInfo) && HussarUtils.isNotEmpty((Object)jumpInfo.getJumpFrom()) && jumpInfo.getJumpTo() != null && jumpInfo.getJumpTo().contains(task.getTaskDefinitionKey())) {
                List nodeId = jumpInfo.getJumpFrom();
                for (String id : nodeId) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)id);
                    FlowElement flowElement = bm.getFlowElement(id);
                    if (flowElement instanceof UserTask) {
                        jsonObject.put("type", (Object)"userTask");
                        jsonObject.put("allowSetParticipant", (Object)"true");
                    } else if (flowElement instanceof CallActivity) {
                        jsonObject.put("type", (Object)"callActivity");
                    }
                    jsonObject.put("mustCheck", (Object)true);
                    jsonObject.put("relatedNodes", new ArrayList());
                    jsonObject.put("name", (Object)flowElement.getName());
                    jsonArray.add((Object)jsonObject);
                }
                if (isGetWithGroup) {
                    JSONArray group = new JSONArray();
                    group.add((Object)jsonArray);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("data", (Object)group);
                    jsonObject.put("mustCheckGroups", new ArrayList());
                    JSONArray result = new JSONArray();
                    result.add((Object)jsonObject);
                    return InstallResult.getResult((String)"1", (String)"success", (JSONArray)result);
                }
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
        }
        if ((userTask = (UserTask)bm.getFlowElement(task.getTaskDefinitionKey())) == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (bm.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        if (task.getSubProcessKey() != null) {
            resultMap.put("sub_process_separate_variable", task.getSubProcessKey().split(":")[1]);
        }
        if (lineCondition != null) {
            resultMap.putAll(lineCondition);
        }
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        this.getUserTaskByCondition(jsonArray, bm, sequenceFlows, 0, userTask.getId(), HussarUtils.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
        if (isGetWithGroup) {
            JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
            JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)result);
            jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
        } else {
            JSONArray result = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                result.add((Object)jsonArray.getJSONObject(i));
            }
            jsonArray = result;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private JSONArray getNextNodeGroupMessage(String firstNode, Map<String, SimpleGroupMessage> simpleGroupMessages) {
        ArrayList<SimpleGroupMessage> simpleGroupMessageList = new ArrayList<SimpleGroupMessage>();
        SimpleGroupMessage simpleGroupMessage = simpleGroupMessages.get(firstNode);
        simpleGroupMessageList.add(simpleGroupMessage);
        int i = 0;
        while (i < simpleGroupMessageList.size()) {
            SimpleGroupMessage groupMessage = (SimpleGroupMessage)simpleGroupMessageList.get(i);
            if (!groupMessage.childGroupIds.isEmpty()) {
                simpleGroupMessageList.remove(i);
                List<String> childIds = groupMessage.childGroupIds.get(0);
                groupMessage.childGroupIds.remove(0);
                for (String childId : childIds) {
                    SimpleGroupMessage child = simpleGroupMessages.get(childId);
                    SimpleGroupMessage simpleGroupMessage1 = new SimpleGroupMessage();
                    simpleGroupMessage1.groupId = groupMessage.groupId;
                    simpleGroupMessage1.childGroupIds = new ArrayList<List<String>>(groupMessage.childGroupIds);
                    simpleGroupMessage1.childGroupIds.addAll(child.childGroupIds);
                    simpleGroupMessage1.jsonObjects = new ArrayList<JSONObject>(groupMessage.jsonObjects);
                    simpleGroupMessage1.jsonObjects.addAll(child.jsonObjects);
                    simpleGroupMessageList.add(simpleGroupMessage1);
                }
                continue;
            }
            ++i;
        }
        JSONArray result = new JSONArray();
        for (SimpleGroupMessage groupMessage : simpleGroupMessageList) {
            List jsonObjects = groupMessage.jsonObjects.stream().filter(o -> !o.getString("type").contains("Gateway")).collect(Collectors.toList());
            result.add(jsonObjects);
        }
        return result;
    }

    private JSONArray getNodeRelationMessages(Map<String, NodeMessage> nodeMessages, JSONArray jsonArray) {
        if (nodeMessages.size() == 1) {
            jsonArray.getJSONObject(0).put("mustCheck", (Object)true);
            jsonArray.getJSONObject(0).put("relatedNodes", new ArrayList());
            return new JSONArray();
        }
        HashMap<String, JSONArray> mustCheckGroupMap = new HashMap<String, JSONArray>();
        JSONArray mustCheckGroups = new JSONArray();
        ArrayList<String> removeGroupIds = new ArrayList<String>();
        for (NodeMessage nodeMessage : nodeMessages.values()) {
            if (!"inclusiveGateway".equals(nodeMessage.getewayType)) continue;
            boolean isMustCheckGroup = true;
            for (String string : nodeMessage.childNodes) {
                if (nodeMessages.get((Object)string).conditionWithNextNode) continue;
                isMustCheckGroup = false;
            }
            if (isMustCheckGroup) {
                NodeMessage parent = nodeMessages.get(nodeMessage.parentNode);
                while (parent != null) {
                    if ("inclusiveGateway".equals(parent.getewayType)) {
                        for (String childNode : parent.childNodes) {
                            if (nodeMessages.get((Object)childNode).conditionWithNextNode) continue;
                            isMustCheckGroup = false;
                            break;
                        }
                        if (!isMustCheckGroup) break;
                    }
                    parent = nodeMessages.get(parent.parentNode);
                }
            }
            JSONArray mustCheckGroup = new JSONArray();
            if (!isMustCheckGroup) continue;
            ArrayList<String> arrayList = new ArrayList<String>(nodeMessage.childNodes);
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeMessage node = nodeMessages.get(arrayList.get(i));
                if (node.getewayType != null) {
                    removeGroupIds.add(node.nodeId);
                    arrayList.addAll(node.childNodes);
                    continue;
                }
                mustCheckGroup.add((Object)node.nodeId);
            }
            mustCheckGroupMap.put(nodeMessage.nodeId, mustCheckGroup);
        }
        for (Map.Entry entry : mustCheckGroupMap.entrySet()) {
            if (removeGroupIds.contains(entry.getKey())) continue;
            mustCheckGroups.add(entry.getValue());
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            NodeMessage parentNode;
            JSONObject jSONObject = jsonArray.getJSONObject(i);
            if (jSONObject.getString("type").contains("Gateway")) continue;
            String nodeId = jSONObject.getString("id");
            NodeMessage nodeMessage = nodeMessages.get(nodeId);
            boolean bl = true;
            ArrayList<String> relatedNodes = new ArrayList<String>();
            NodeMessage parent = parentNode = nodeMessages.get(nodeMessage.parentNode);
            NodeMessage child = nodeMessage;
            while (parent != null) {
                if ("inclusiveGateway".equals(parent.getewayType) && child.conditionWithNextNode) {
                    bl = false;
                    break;
                }
                child = parent;
                parent = nodeMessages.get(parent.parentNode);
            }
            ArrayList<String> relateGroupIds = new ArrayList<String>();
            String currentNodeId = nodeId;
            while (parentNode != null) {
                NodeMessage childNode;
                if ("inclusiveGateway".equals(parentNode.getewayType)) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                } else if (parentNode.getewayType != null) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                }
                currentNodeId = parentNode.nodeId;
                parentNode = nodeMessages.get(parentNode.parentNode);
            }
            jSONObject.put("mustCheck", (Object)bl);
            jSONObject.put("relatedNodes", relatedNodes);
            JSONArray relateGroups = new JSONArray();
            for (String relateGroupId : relateGroupIds) {
                relateGroups.add(mustCheckGroupMap.get(relateGroupId));
            }
            jSONObject.put("relateGroups", (Object)relateGroups);
        }
        return mustCheckGroups;
    }

    private void setNodeMessage(List<String> relatedNodes, NodeMessage parentNode, Map<String, NodeMessage> nodeMessages, List<String> relateGroupIds) {
        if ("inclusiveGateway".equals(parentNode.getewayType)) {
            boolean containsRelateNode = false;
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                containsRelateNode = true;
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
            if (!containsRelateNode) {
                relateGroupIds.add(parentNode.nodeId);
            }
        } else {
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
        }
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        if (HussarUtils.isNotEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            return this.queryNextNode(taskId, isGetRevokeNode, isGetWithGroup, lineCondition);
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String procDefId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(bpmnModel.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                if (bpmnModel.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), "", procDefId);
                }
                if (lineCondition != null) {
                    resultMap.putAll(lineCondition);
                }
                HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
                HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
                this.getUserTaskByCondition(jsonArray, bpmnModel, sequenceFlows, 0, userTask.getId(), HussarUtils.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
                if (isGetWithGroup) {
                    JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
                    JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("data", (Object)result);
                    jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)jsonObject);
                    continue;
                }
                JSONArray result = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                    result.add((Object)jsonArray.getJSONObject(i));
                }
                jsonArray = result;
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    private void getUserTaskByCondition(JSONArray jsonArray, BpmnModel bm, List<SequenceFlow> sfs, int sourceType, String superParentId, Map<String, Object> visitorMap, Map<String, NodeMessage> nodeMessages, Map<String, SimpleGroupMessage> simpleGroupMessages, SimpleGroupMessage oldSimpleGroupMessage) {
        if (sfs != null && !sfs.isEmpty()) {
            String parentId = sfs.get(0).getSourceRef();
            if (superParentId.equals(parentId)) {
                parentId = "";
            }
            for (SequenceFlow sequenceFlow : sfs) {
                boolean required = true;
                if (sfs.size() > 1) {
                    if (sourceType == 1) {
                        required = false;
                    } else if (sourceType == 2 && sequenceFlow.getConditionExpression() != null && sequenceFlow.getConditionExpression().contains("bpm_next_node")) {
                        required = false;
                    }
                }
                FlowElement flowElement = bm.getFlowElement(sequenceFlow.getTargetRef());
                SimpleGroupMessage simpleGroupMessage = oldSimpleGroupMessage;
                if (simpleGroupMessage == null) {
                    simpleGroupMessage = new SimpleGroupMessage();
                    simpleGroupMessage.jsonObjects = new ArrayList<JSONObject>();
                    simpleGroupMessage.childGroupIds = new ArrayList<List<String>>();
                    simpleGroupMessage.groupId = flowElement.getId();
                    simpleGroupMessages.put(simpleGroupMessage.groupId, simpleGroupMessage);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonObject.put("parentId", (Object)parentId);
                NodeMessage nodeMessage = new NodeMessage(sequenceFlow.getTargetRef(), sequenceFlow.getSourceRef(), !required, null, null);
                if (flowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)flowElement;
                    if (gateway instanceof ParallelGateway) {
                        this.getUserTaskByCondition(jsonArray, bm, gateway.getOutgoingFlows(), 3, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        jsonObject.put("type", (Object)"parallelGateway");
                        nodeMessage.getewayType = "parallelGateway";
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : gateway.getOutgoingFlows()) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                    } else {
                        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                        SimpleContext context = new SimpleContext();
                        if (visitorMap != null && !visitorMap.isEmpty()) {
                            SequenceFlow flow;
                            flow = visitorMap.keySet().iterator();
                            while (flow.hasNext()) {
                                String k = flow.next();
                                if (visitorMap.get(k.toString()) != null) {
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                    continue;
                                }
                                context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                            }
                        }
                        ArrayList<SequenceFlow> defaultList = new ArrayList<SequenceFlow>();
                        ArrayList<SequenceFlow> allList = new ArrayList<SequenceFlow>();
                        boolean flag = true;
                        List sequenceFlowsList = gateway.getOutgoingFlows();
                        for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                            if (sequenceFlows.getConditionExpression() != null) {
                                boolean isConditionWithNextNode = sequenceFlows.getConditionExpression().contains("bpm_next_node");
                                if (isConditionWithNextNode) {
                                    Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(sequenceFlows.getConditionExpression());
                                    String bpmNextNodeCondition = "";
                                    if (matcher.find()) {
                                        bpmNextNodeCondition = matcher.group();
                                    }
                                    String bpmNextNodeConditionValue = "";
                                    if (bpmNextNodeCondition.contains("==")) {
                                        bpmNextNodeConditionValue = bpmNextNodeCondition.split("'")[1];
                                    }
                                    context.setVariable("bpm_next_node", factory.createValueExpression((Object)bpmNextNodeConditionValue, Object.class));
                                }
                                ValueExpression valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE);
                                try {
                                    if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                    allList.add(sequenceFlows);
                                    if (isConditionWithNextNode) continue;
                                    flag = false;
                                }
                                catch (PropertyNotFoundException e) {
                                    allList.add(sequenceFlows);
                                }
                                continue;
                            }
                            defaultList.add(sequenceFlows);
                        }
                        int type = 1;
                        if (gateway instanceof ExclusiveGateway) {
                            jsonObject.put("type", (Object)"exclusiveGateway");
                            nodeMessage.getewayType = "exclusiveGateway";
                        } else if (gateway instanceof InclusiveGateway) {
                            flag = true;
                            type = 2;
                            jsonObject.put("type", (Object)"inclusiveGateway");
                            nodeMessage.getewayType = "inclusiveGateway";
                        }
                        if (flag) {
                            allList.addAll(defaultList);
                        }
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : allList) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                        if (gateway instanceof ExclusiveGateway) {
                            simpleGroupMessage.childGroupIds.add(childNode);
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, null);
                        } else {
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        }
                    }
                } else if (flowElement instanceof UserTask) {
                    UserTask u = (UserTask)flowElement;
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                } else if (flowElement instanceof EndEvent) {
                    jsonObject.put("type", (Object)"endEvent");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                } else if (flowElement instanceof ServiceTask) {
                    jsonObject.put("type", (Object)"serviceTask");
                } else if (flowElement instanceof ReceiveTask) {
                    jsonObject.put("type", (Object)"receiveTask");
                } else if (flowElement instanceof SubProcess) {
                    jsonObject.put("type", (Object)"subProcess");
                }
                simpleGroupMessage.jsonObjects.add(jsonObject);
                nodeMessages.put(sequenceFlow.getTargetRef(), nodeMessage);
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && !map.isEmpty()) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        if (HussarUtils.isEmpty((Object)historicTaskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        JSONArray json = new JSONArray();
        String msg = "";
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).queryChildTask()).singleResult();
        if (currTask == null) {
            logger.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (TaskType.isAssist((String)currTask.getTaskType()) || "4".equals(currTask.getTaskType())) {
            this.processEngine.getManagementService().executeCommand((Command)new AssistTaskRevokeAuthenticationCmd(currTask.getParentTaskId(), currTask.getTaskType()));
            json.add((Object)result);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        if ("5".equals(currTask.getTaskType())) {
            json.add((Object)result);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        String taskSourceFlag = currTask.getTaskSourceFlag();
        if (TaskSourceFlag.isRevoke((String)taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getWithdrawRecallTaskError(), null);
        }
        if ("assist_complete".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAssistFinishTaskWithErrorHandle(), null);
        }
        if ("complete_leap".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCompleteLeapTaskError(), null);
        }
        if ("CcTask".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCirculatedTaskError(), null);
        }
        if (HussarUtils.isEmpty((Object)currTask.getEndTime())) {
            logger.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        if ("skip".equals(taskSourceFlag)) {
            result = false;
            msg = this.bpmConstantProperties.getJumpTaskWithErrorHandle();
        }
        if ("5".equals(currTask.getTaskType())) {
            List taskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).taskParentTaskId(currTask.getParentTaskId()).taskOwner(currTask.getOwner())).taskCompletedAfter(currTask.getEndTime()).orderByHistoricTaskInstanceEndTime().asc()).list();
            for (HistoricTaskInstance historicTaskInstance : taskInstanceList) {
                if ("5".equals(historicTaskInstance.getTaskType())) {
                    result = false;
                    msg = this.bpmConstantProperties.getExitFinishTask();
                    break;
                }
                if (!"RevokeHistory".equals(historicTaskInstance.getDeleteReason())) continue;
                result = false;
                msg = this.bpmConstantProperties.getRevokeTaskError();
                break;
            }
            if (result) {
                Task task2 = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(currTask.getParentTaskId())).singleResult();
                if (task2 == null) {
                    result = false;
                    msg = this.bpmConstantProperties.getExitFinishTask();
                } else {
                    String receiver = currTask.getReceiver();
                    List identityLinks = this.taskService.getIdentityLinksType(currTask.getParentTaskId());
                    result = false;
                    for (IdentityLink identityLink : identityLinks) {
                        if (!currTask.getOwner().equals(identityLink.getMandator()) && (!currTask.getOwner().equals(receiver) || !currTask.getOwner().equals(identityLink.getUserId()) || identityLink.getMandator() != null)) continue;
                        result = true;
                    }
                    if (!result) {
                        msg = this.bpmConstantProperties.getExitFinishTask();
                    }
                }
            }
            json.add((Object)result);
            json.add((Object)msg);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
        if (instance == null) {
            logger.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessEnd(), null);
        }
        if (instance.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).orderByHistoricTaskInstanceEndTime().desc()).list();
        List callActivity = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(currTask.getProcessInstanceId()).list();
        List callActivityTask = null;
        if (callActivity != null && !callActivity.isEmpty()) {
            callActivityTask = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(callActivity.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList()))).list();
        }
        if (this.withdrawState(historicTaskInstances, currTask, true, callActivity, callActivityTask)) {
            result = false;
            msg = this.bpmConstantProperties.getExitFinishTask();
        }
        if (result && !this.withdrawState(historicTaskInstances, currTask, false, callActivity, callActivityTask)) {
            List taskInstanceList = historicTaskInstances.stream().filter(task -> Objects.equals(currTask.getSubProcessKey(), task.getSubProcessKey()) && Objects.equals(currTask.getTaskDefinitionKey(), task.getTaskDefinitionKey()) && TaskSourceFlag.isRevoke((String)task.getTaskSourceFlag())).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(taskInstanceList)) {
                HistoricTaskInstance historicTaskInstance;
                Iterator identityLink = taskInstanceList.iterator();
                while (identityLink.hasNext() && (historicTaskInstance = (HistoricTaskInstance)identityLink.next()).getEndTime().after(currTask.getEndTime())) {
                    if (!historicTaskInstance.getAssignee().equals(currTask.getAssignee())) continue;
                    result = false;
                    msg = this.bpmConstantProperties.getRevokeTaskError();
                    break;
                }
            }
            if (result) {
                List executions = this.runtimeService.createExecutionQuery().processInstanceId(currTask.getProcessInstanceId()).list();
                List executionList = executions.stream().filter(execution -> {
                    ExecutionEntity entity = (ExecutionEntity)execution;
                    if (entity.getAllPrevNode() == null) {
                        return false;
                    }
                    return Arrays.asList(entity.getAllPrevNode().split(",")).contains(currTask.getTaskDefinitionKey());
                }).collect(Collectors.toList());
                if (executionList.isEmpty()) {
                    HistoricTaskInstance lastComplete;
                    boolean revokeReject = false;
                    if (TaskSourceFlag.isReject((String)taskSourceFlag)) {
                        revokeReject = true;
                    }
                    HistoricTaskInstance historicTaskInstance = lastComplete = revokeReject ? (HistoricTaskInstance)historicTaskInstances.stream().filter(task -> {
                        if (currTask.getSubProcessKey() != null && !Objects.equals(currTask.getSubProcessKey(), task.getSubProcessKey())) {
                            return false;
                        }
                        if (TaskSourceFlag.isReject((String)task.getCompleteType())) {
                            JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)task.getJumpInfo());
                            if (jumpInfo == null) {
                                return false;
                            }
                            return jumpInfo.getJumpFrom().contains(currTask.getTaskDefinitionKey());
                        }
                        return false;
                    }).findFirst().orElse(null) : (HistoricTaskInstance)historicTaskInstances.stream().filter(task -> {
                        if (currTask.getSubProcessKey() != null && !Objects.equals(currTask.getSubProcessKey(), task.getSubProcessKey())) {
                            return false;
                        }
                        return task.getAllPrevNode() != null && Arrays.asList(task.getAllPrevNode().split(",")).contains(currTask.getTaskDefinitionKey());
                    }).findFirst().orElse(null);
                    if (lastComplete != null) {
                        BpmnModel bm = this.repositoryService.getBpmnModel(currTask.getProcessDefinitionId());
                        if (!TaskSourceFlag.isComplete((String)taskSourceFlag) && this.canNotRejectPrepare(bm, lastComplete.getTaskDefinitionKey(), currTask.getTaskDefinitionKey(), true) && this.canNotRejectPrepare(bm, lastComplete.getTaskDefinitionKey(), currTask.getTaskDefinitionKey(), false)) {
                            throw new PublicClientException(this.bpmConstantProperties.getNoCompleteRevokeError());
                        }
                    }
                    if (currTask.getSubProcessKey() != null && executions.stream().noneMatch(e -> currTask.getSubProcessKey().equals(e.getSubProcessKey()) && currTask.getCycleCount().equals(((ExecutionEntity)e).getCycleCount()))) {
                        result = false;
                        msg = "\u5185\u90e8\u5b50\u6d41\u7a0b\u5df2\u7ed3\u675f\uff01";
                    } else {
                        result = false;
                        msg = this.bpmConstantProperties.getCreatExecuteTheInstance();
                    }
                } else {
                    HistoricTaskInstance historicTaskInstance;
                    List list = historicTaskInstances.stream().filter(t -> Objects.equals(t.getSubProcessKey(), currTask.getSubProcessKey()) && Objects.equals(t.getTaskDefinitionKey(), currTask.getTaskDefinitionKey())).sorted((o1, o2) -> {
                        if (o1.getEndTime() == null) {
                            return -1;
                        }
                        if (o2.getEndTime() == null) {
                            return 1;
                        }
                        return o2.getEndTime().compareTo(o1.getEndTime());
                    }).collect(Collectors.toList());
                    Date date = ((HistoricTaskInstance)list.get(0)).getStartTime();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && ((historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime() == null || historicTaskInstance.getEndTime().compareTo(date) >= 0)) {
                        if (historicTaskInstance.getCreateTime().compareTo(date) >= 0) continue;
                        date = historicTaskInstance.getCreateTime();
                    }
                    if (currTask.getEndTime().before(date)) {
                        result = false;
                        msg = this.bpmConstantProperties.getNewExecuteTheInstance();
                    }
                }
            }
        }
        json.add((Object)result);
        json.add((Object)msg);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private boolean withdrawState(List<HistoricTaskInstance> taskInstances, HistoricTaskInstance currTask, boolean isEnd, List<HistoricProcessInstance> callActivity, List<HistoricTaskInstance> callActivityTask) {
        Predicate<HistoricTaskInstance> condition = task -> {
            if (task.getParentTaskId() != null) {
                return false;
            }
            if (task.getStartTime().before(currTask.getEndTime())) {
                return false;
            }
            if ("skip".equals(task.getTaskSourceFlag())) {
                return false;
            }
            return isEnd != (task.getEndTime() == null);
        };
        boolean isMatch = taskInstances.stream().anyMatch(condition.and(task -> {
            if (currTask.getSubProcessKey() != null && task.getSubProcessKey() != null && !Objects.equals(currTask.getSubProcessKey(), task.getSubProcessKey())) {
                return false;
            }
            if (TaskSourceFlag.isReject((String)currTask.getTaskSourceFlag())) {
                return TaskSourceFlag.isReject((String)task.getCompleteType()) && JumpInfo.toJumpInfo((String)task.getJumpInfo()).getJumpFrom().contains(currTask.getTaskDefinitionKey());
            }
            return task.getAllPrevNode() != null && Arrays.asList(task.getAllPrevNode().split(",")).contains(currTask.getTaskDefinitionKey());
        }));
        if (isMatch) {
            return true;
        }
        if (callActivity != null && !callActivity.isEmpty() && callActivityTask != null) {
            Set processSet = callActivity.stream().filter(process -> {
                if (TaskSourceFlag.isReject((String)currTask.getTaskSourceFlag())) {
                    return "main_reject".contains(process.getCompleteType()) && JumpInfo.toJumpInfo((String)process.getJumpInfo()).getJumpFrom().contains(currTask.getTaskDefinitionKey());
                }
                return process.getCompleteFrom() != null && Arrays.asList(process.getCompleteFrom().split(",")).contains(currTask.getTaskDefinitionKey());
            }).map(HistoricProcessInstance::getId).collect(Collectors.toSet());
            return callActivityTask.stream().anyMatch(condition.and(task -> processSet.contains(task.getProcessInstanceId())));
        }
        return false;
    }

    private boolean canNotRejectPrepare(BpmnModel bm, String startNodeId, String nodeId, boolean isPre) {
        Process process = bm.getMainProcess();
        if (process.getFlowElement(nodeId) != null && process.getFlowElement(startNodeId) == null) {
            for (FlowElement flowElement : process.getFlowElements()) {
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement obj : ((SubProcess)flowElement).getFlowElements()) {
                    if (!obj.getId().equals(startNodeId)) continue;
                    startNodeId = flowElement.getId();
                }
            }
        }
        return !this.canReject(bm, startNodeId, nodeId, null, null, isPre);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = bm.getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        if (historicTaskId == null || userId == null) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).queryChildTask()).singleResult();
        TaskEntity newTask = new TaskEntity();
        newTask.setProcessInstanceId(task.getProcessInstanceId());
        newTask.setTenantId(task.getTenantId());
        List<String> taskDefIds = this.backEffectNodeId((Task)newTask, task.getTaskDefinitionKey());
        TaskRejectModel taskRejectModel = new TaskRejectModel(userId, null, comment, isSubmit, null, null, Boolean.valueOf(false), map);
        taskRejectModel.setHistoryTaskId(historicTaskId);
        if (HussarUtils.isEmpty((Object)taskRejectModel.getHistoricTaskInstance())) {
            taskRejectModel.setHistoricTaskInstance((HistoricTaskInstanceEntity)task);
            taskRejectModel.setProcInsId(task.getProcessInstanceId());
            taskRejectModel.setStartUserId(task.getSendUser());
        }
        if (TaskType.isAssist((String)task.getTaskType()) || "4".equals(task.getTaskType())) {
            this.processEngine.getManagementService().executeCommand((Command)new AssistTaskRevokeCmd(task.getParentTaskId(), userId, comment, task.getId(), task.getTaskType()));
        } else {
            this.processEngine.getManagementService().executeCommand(new TaskRejectCmd(taskRejectModel).addSendUser(userId).addExecutionAttribute(map, "revoke"));
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), "revoke", taskRejectModel.getHistoricTaskInstance().getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            logger.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if ((taskId = RealTaskId.getRealTaskId(taskId)) == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TaskComment::getTaskId, (Object)Long.parseLong(taskId))).eq(TaskComment::getType, (Object)"complete")).eq(TaskComment::getAction, (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(Long.valueOf(Long.parseLong(taskId)), comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        Task task = this.getTask(taskId = RealTaskId.getRealTaskId(taskId), "0");
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiNode(), null);
        }
        if (assignees == null && task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId, assignees == null ? null : Arrays.asList(assignees.split(","))));
        this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult getOddAssigneesByNode(String bussinessId, String taskDefId) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{bussinessId, taskDefId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List list = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).taskDefinitionKey(taskDefId)).list();
        if (list.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        ArrayList<String> assignees = new ArrayList<String>();
        for (Task t : list) {
            assignees.add(((IdentityLink)this.taskService.getIdentityLinksType(t.getId()).get(0)).getUserId());
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(assignees);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public Map<String, Map<String, Set<String>>> updateRejectForm(Map<String, Object> map) {
        String procDefId = (String)map.get("procDefId");
        Set delNodeIds = (Set)map.get("delNodeIds");
        Set changeNodeIds = (Set)map.get("changeNodeIds");
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        HashMap del = new HashMap();
        HashMap change = new HashMap();
        HashSet<String> processAll = new HashSet<String>();
        result.put("delNode", del);
        result.put("changeNode", change);
        del.put("", processAll);
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        if (list.isEmpty()) {
            return result;
        }
        for (String delNode : delNodeIds) {
            del.put(delNode, new HashSet());
        }
        for (String changeNode : changeNodeIds) {
            change.put(changeNode, new HashSet());
        }
        for (Execution execution : list) {
            if (delNodeIds.contains(execution.getActivityId())) {
                Set nodeDelSet = (Set)del.get(execution.getActivityId());
                nodeDelSet.add(execution.getProcessInstanceId());
                processAll.add(execution.getProcessInstanceId());
                continue;
            }
            if (!changeNodeIds.contains(execution.getActivityId())) continue;
            Set nodeChangeSet = (Set)change.get(execution.getActivityId());
            nodeChangeSet.add(execution.getActivityId());
            processAll.add(execution.getProcessInstanceId());
        }
        for (String delNode : delNodeIds) {
            if (((Set)del.get(delNode)).size() != 0) continue;
            del.remove(delNode);
        }
        for (String changeNode : changeNodeIds) {
            if (((Set)change.get(changeNode)).size() != 0) continue;
            change.remove(changeNode);
        }
        return result;
    }

    public void reStartProcessUpdate(String processInsId, String businessId, String processDefinitionId) {
        this.taskEngineMapper.reStartProcessUpdate(Long.parseLong(processInsId));
        this.taskEngineMapper.reStartProcessInsert(Long.parseLong(processInsId), businessId, processDefinitionId);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        } else {
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
            throw new BpmException("\u672a\u627e\u5230\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b");
        }
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
            throw new BpmException("\u4e0d\u5141\u8bb8\u91cd\u542f\u5916\u90e8\u5b50\u6d41\u7a0b");
        }
        if (historicProcessInstance != null) {
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_NOT_END);
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    taskDefinitionKey = ((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination().getId();
                    break;
                }
            }
            if (HussarUtils.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("startUser", userId);
            if (isSubmit && HussarUtils.isEmpty((Object)assignee)) {
                assignee = this.getTaskCommitUser(historicProcessInstance.getId(), taskDefinitionKey);
            }
            if (HussarUtils.isNotEmpty((Object)assignee)) {
                HashMap<String, List<String>> appointAssignee = new HashMap<String, List<String>>();
                appointAssignee.put("static_appoint_assignee", Arrays.asList(assignee.split(",")));
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), historicProcessInstance.getBusinessKey(), historicProcessInstance.getProcessDefinitionId());
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setProcessKey(historicProcessInstance.getProcessDefinitionKey());
                dataPush.setProcessReStartTime(new Date());
                dataPush.setProcessState("reStartProcess");
                dataPush.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());
                dataPush.setProcessInsId(historicProcessInstance.getId());
                dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
                dataPush.setStartUserId(historicProcessInstance.getStartUserId());
                dataPush.setDueDate(historicProcessInstance.getDueDate());
                this.dataPushService.changeProcessStateDataPush(dataPush);
                DataPush dataPushTemp = new DataPush();
                dataPushTemp.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPushTemp.setProcessEndTime(null);
                dataPushTemp.setProcessInsId(historicProcessInstance.getId());
                this.dataPushService.changeProcessStateDataPush(dataPush);
            }
            this.processEngine.getManagementService().executeCommand(new ParallelJumpTaskCmd(null, userId, null, historicProcessInstance.getId(), new JumpModel(0).setJumpTo(taskDefinitionKey), null, null, map, null).setProcessEventType("process_restart").addSendUser(userId).addExecutionAttribute(map, "process_restart"));
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(historicProcessInstance.getId(), historicProcessInstance.getProcessDefinitionId(), null, null, map));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        List<SecurityLevelVo> multiTaskMessages = this.taskEngineMapper.getSecurityLevelMultiTask(userId, level);
        for (SecurityLevelVo map : multiTaskMessages) {
            if (map.getDueDate() != null) {
                this.activityRedisTimerService.delTimeOutModel(String.valueOf(map.getTaskId()));
            }
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(String.valueOf(map.getExecutionId()), String.valueOf(map.getTaskId()), null));
            this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(String.valueOf(map.getProcessInstanceId()), null, map.getTaskDefinitionKey(), map.getSubProcessKey(), new HashMap<String, Object>()));
        }
        this.taskEngineMapper.updateRuIdentityLink(userId, level);
        this.taskEngineMapper.updateRuTask(userId, level);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)businessId) || HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorReset(), null);
        }
        if (HussarUtils.isEmpty((Object)processInsId)) {
            processInsId = this.taskEngineMapper.getProcessInsIdByBusinessId(businessId);
        }
        this.taskEngineMapper.updateActHiProcinstStater(Long.parseLong(processInsId), userId);
        this.taskEngineMapper.updateActHiIdentitylinkStater(Long.parseLong(processInsId), userId);
        this.taskEngineMapper.updateActRuIdentitylinkStater(Long.parseLong(processInsId), userId);
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInsId));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CandidateUser::getTaskId, (Object)Long.parseLong(taskId));
        List candidateUserList = this.candidateUserService.list((Wrapper)ew);
        List users = candidateUserList.stream().map(CandidateUser::getAssignee).collect(Collectors.toList());
        if (HussarUtils.isEmpty(users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        ArrayList<String> entrustUser = new ArrayList<String>();
        Map entrustMap = this.sysActEntrustService.queryByUsers(users, task.getProcessDefinitionId().split(":")[0], task.getTaskDefinitionKey(), 0);
        for (String user : users) {
            if (!entrustMap.containsKey(user)) {
                entrustMap.put(user, null);
                entrustUser.add(user);
                continue;
            }
            entrustUser.add((String)entrustMap.get(user));
        }
        this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, entrustMap));
        this.candidateUserService.remove((Wrapper)ew);
        this.activityRedisTimerService.updateTimeOutModel(taskId, String.join((CharSequence)",", entrustUser), null, 0);
        this.dataPushService.addUserDataPush(task, String.join((CharSequence)",", entrustUser));
        this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(task.getProcessInstanceId()));
        return InstallResult.success((String)this.bpmConstantProperties.getAppointAssigneesSuccess());
    }

    public BpmResponseResult getExecutionByBusinessId(String businessId) {
        String processInsId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()).getId();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            JSONArray json = new JSONArray();
            if (HussarUtils.isEmpty((Object)historicActivityInstances)) {
                return InstallResult.getResult((String)"0", (String)"", null);
            }
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                JSONObject object = new JSONObject();
                object.put("activitiName", (Object)historicActivityInstance.getActivityName());
                object.put("activitiType", (Object)historicActivityInstance.getActivityType());
                object.put("activitiId", (Object)historicActivityInstance.getActivityId());
                object.put("executionId", (Object)historicActivityInstance.getExecutionId());
                object.put("subProcessKey", (Object)historicActivityInstance.getSubProcessKey());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
    }

    public BpmResponseResult receiveTaskSignalByProcessInfo(TaskReceiveDto taskReceiveDto) {
        if (HussarUtils.isEmpty((Object)taskReceiveDto.getTaskDefinitionKey())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{taskReceiveDto.getProcessInsId(), taskReceiveDto.getBusinessId()})) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        HistoricProcessInstance processInstance = HussarUtils.isEmpty((Object)taskReceiveDto.getProcessInsId()) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(taskReceiveDto.getBusinessId()).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskReceiveDto.getProcessInsId()).singleResult();
        if (processInstance == null) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
        }
        if (processInstance.getEndTime() != null) {
            throw new BpmException(BpmExceptionCodeEnum.PROCESS_END);
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityType("receiveTask").unfinished().list();
        if (historicActivityInstances == null || historicActivityInstances.isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessReceiveTaskNotFound());
        }
        String taskDefKey = taskReceiveDto.getTaskDefinitionKey();
        if ((historicActivityInstances = historicActivityInstances.stream().filter(o -> taskDefKey.equals(o.getActivityId())).collect(Collectors.toList())).isEmpty()) {
            throw new BpmException(BpmExceptionCodeEnum.RECEIVE_TASK_NOT_FOUND);
        }
        Map map = null;
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            String executionId = historicActivityInstance.getExecutionId();
            map = (Map)this.processEngine.getManagementService().executeCommand(new SignalCmd(executionId, taskReceiveDto.getVariableMap()).addExecutionAttribute(taskReceiveDto.getVariableMap(), "receive_signal"));
            this.activityRedisTimerService.delTimeOutModel(executionId);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd((String)map.get("processInsId"), (String)map.get("processDefinitionId"), null, null, null));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> variableMap) {
        Map map = (Map)this.processEngine.getManagementService().executeCommand(new SignalCmd(executionId, variableMap).addExecutionAttribute(variableMap, "receive_signal"));
        this.activityRedisTimerService.delTimeOutModel(executionId);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd((String)map.get("processInsId"), (String)map.get("processDefinitionId"), (String)map.get("backActivityId"), (String)map.get("sub_process_key"), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void rejectDataPush(Task task, String comment, String userId, String mandator, String taskState) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            this.dataPushService.rejectDataPush(dataPush);
        }
    }

    private void completeDataPush(Task task, String comment, String userId, String mandator, String taskState) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            long hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).count();
            if (hisTaskNum == 2L) {
                dataPush.setOperationType("submit");
            }
            this.dataPushService.completeDataPush(dataPush);
        }
    }

    private void claimDataPush(String taskId, String userId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.claimDataPush(dataPush);
        }
    }

    private void freeJumpDataPush(Task task, String comment, String userId, String taskIds, String mandator, String taskState) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState);
            if (HussarUtils.isNotEmpty((Object)taskIds)) {
                dataPush.setTaskIds(Arrays.asList(taskIds.split(",")));
            }
            this.dataPushService.freeJumpDataPush(dataPush);
        }
    }

    private void addUrgeTask(Task task, String userId) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.addUrgeTask(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId())).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(task.getSendUser());
        dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(historicTaskInstance.getEndTime());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        return dataPush;
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        if (HussarUtils.isEmpty((Object)preemptCommonDto.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        String userId = preemptCommonDto.getUserId();
        boolean isAuditAuthority = preemptCommonDto.getIsAuditAuthority();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId(), userId);
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new PreemptTaskCmd(taskId, userId, realTaskId.getMandatary(), isAuditAuthority));
        return InstallResult.success();
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        if (HussarUtils.isEmpty((Object)preemptCommonDto.getTaskId())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        String userId = preemptCommonDto.getUserId();
        boolean isAuditAuthority = preemptCommonDto.getIsAuditAuthority();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId());
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new UnPreemptTaskCmd(taskId, userId, realTaskId.getMandatary(), isAuditAuthority));
        return InstallResult.success();
    }

    public BpmResponseResult checkNextNodeAssignee(CheckNextNodeAssigneeDto checkNextNodeAssigneeDto) {
        Map<String, Object> map = new HashMap();
        if (checkNextNodeAssigneeDto.getMap() != null) {
            map = checkNextNodeAssigneeDto.getMap();
        }
        List sequenceFlows = null;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        UserTask userTask = null;
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        JSONArray nodeInfo = new JSONArray();
        BpmnModel bm = null;
        String taskDefinitionKey = null;
        String processInstanceId = null;
        String processDefinitionId = null;
        String subProcessKey = null;
        Task task = null;
        if (HussarUtils.isNotEmpty((Object)checkNextNodeAssigneeDto.getTaskId())) {
            String taskId = RealTaskId.getRealTaskId(checkNextNodeAssigneeDto.getTaskId());
            task = this.getTaskWithOutCheckSuspended(taskId, "2");
            taskDefinitionKey = task.getTaskDefinitionKey();
            processInstanceId = task.getProcessInstanceId();
            processDefinitionId = task.getProcessDefinitionId();
            subProcessKey = task.getSubProcessKey();
            bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            if (bm == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
            userTask = (UserTask)bm.getFlowElement(task.getTaskDefinitionKey());
            if (userTask == null) {
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)nodeInfo);
            }
            sequenceFlows = userTask.getOutgoingFlows();
            if (bm.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
            }
            if (task.getSubProcessKey() != null) {
                resultMap.put("sub_process_separate_variable", task.getSubProcessKey().split(":")[1]);
            }
        } else {
            processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(checkNextNodeAssigneeDto.getProcessKey(), null);
            bm = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = bm.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(bm.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask) || !(bm.getFlowElement(((SequenceFlow)(sequenceFlows = (userTask = (UserTask)bm.getFlowElement(firstUserTask)).getOutgoingFlows()).get(0)).getTargetRef()) instanceof Gateway)) continue;
                resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), "", processDefinitionId);
            }
        }
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        this.getUserTaskByCondition(nodeInfo, bm, sequenceFlows, 0, userTask.getId(), HussarUtils.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
        JSONArray result = new JSONArray();
        for (int i = 0; i < nodeInfo.size(); ++i) {
            Map newResult = (Map)nodeInfo.get(i);
            List assigneeList = new ArrayList();
            if (map == null) {
                map = new HashMap();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            if ("userTask".equals(((JSONObject)nodeInfo.get(i)).get((Object)"type"))) {
                List<String> users = AnalyticalModelUtil.getNextCandidateUser(processInstanceId, processDefinitionId, bm, (String)((JSONObject)nodeInfo.get(i)).get((Object)"id"), subProcessKey, map, task);
                if (!users.isEmpty()) {
                    assigneeList = this.iAssigneeChooseService.getUserListByUserIdWithSelect(users);
                }
                newResult.put("assignee", assigneeList);
            }
            result.add((Object)newResult);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)result);
    }

    private void completeTodoDataPush(Task task, String userId) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", processInstance.getStartUserId());
        map.put("start_time", processInstance.getStartTime().getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInstance.getProcessDefinitionName());
        map.put("title", task.getTodoConfiguration());
        HistoricTaskInstance hisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId())).singleResult();
        ArrayList previousTasks = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)hisTask)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", hisTask.getId());
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(hisTask.getProcessDefinitionId()).append(hisTask.getTaskDefinitionKey());
            String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
            String jumpUrl = null;
            String pcJumpUrl = null;
            if (HussarUtils.isNotEmpty((Object)formDetailKey)) {
                String webUrl;
                Map formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                String mobileUrl = (String)formKeyMap.get("mobile");
                if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                    jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), hisTask.getId(), processInstance.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
                if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                    pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), hisTask.getId(), processInstance.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", userId);
            taskMap.put("jump_url", jumpUrl);
            taskMap.put("pc_jump_url", pcJumpUrl);
            taskMap.put("task_status", 1);
            taskMap.put("assign_time", hisTask.getEndTime().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(task.getTenantId(), map);
    }

    public void taskCenterDataPush(Task task, String comment, String userId, String operationType) {
        block8: {
            try {
                if (!this.lcdpBpmProperties.isPushTaskCenter() && !this.lcdpBpmProperties.isPushRocketMq()) break block8;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", "update");
                data.put("taskId", task.getId());
                data.put("taskName", task.getName());
                data.put("userId", userId);
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                data.put("processDefinitionId", task.getProcessDefinitionId());
                data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                data.put("sendUser", task.getSendUser());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                data.put("startDate", simpleDateFormat.format(task.getCreateTime()));
                Date date = new Date();
                data.put("endDate", simpleDateFormat.format(date));
                data.put("url", task.getFormKey());
                data.put("description", task.getTodoConfiguration());
                data.put("formType", "1");
                data.put("category", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("category") : null);
                data.put("type", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("classify") : null);
                data.put("parentProcessInstanceId", this.getParentProcessInstanceId(task.getProcessInstanceId()).getId());
                data.put("parentProcessName", this.getParentProcessInstanceId(task.getProcessInstanceId()).getName());
                data.put("parentBusinessKey", this.getParentProcessInstanceId(task.getProcessInstanceId()).getBusinessKey());
                data.put("comment", comment);
                data.put("processInstanceId", task.getProcessInstanceId());
                data.put("company_code", task.getCompanyCode());
                if (HussarUtils.isNotEmpty((Object)operationType)) {
                    long hisTaskNum;
                    if ("complete".equals(operationType) && (hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).count()) == 2L) {
                        operationType = "submit";
                    }
                    data.put("operationType", operationType);
                }
                if (this.lcdpBpmProperties.isPushTaskCenter() && HussarUtils.isNotEmpty((Object)this.lcdpBpmProperties.getTaskCenterDatapushAddress()) && !this.lcdpBpmProperties.isPushRocketMq()) {
                    String dataPushAddress = this.lcdpBpmProperties.getTaskCenterDatapushAddress();
                    DataPushUtil.addData(data);
                    if (!"skip".equals(data.get("operationType"))) {
                        DataPushUtil.dataPushReal(dataPushAddress);
                    }
                    break block8;
                }
                if (this.lcdpBpmProperties.isPushRocketMq() && !this.lcdpBpmProperties.isPushTaskCenter()) {
                    DataPushUtil.addData(data);
                    if (!"skip".equals(data.get("operationType"))) {
                        DataPushUtil.dataPushMq();
                    }
                    break block8;
                }
                throw new BpmException("\u4efb\u52a1\u4e2d\u5fc3\u6570\u636e\u63a8\u9001\u6216mq\u6d88\u606f\u961f\u5217\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5f02\u5e38");
            }
            catch (Exception e) {
                throw new BpmException(e.getMessage());
            }
        }
    }

    public void dataPushRevoke(HistoricTaskInstance task, String comment, String userId, String operationType) {
        block8: {
            try {
                if (!this.lcdpBpmProperties.isPushTaskCenter() && !this.lcdpBpmProperties.isPushRocketMq()) break block8;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", "deleteRevoke");
                data.put("taskId", task.getId());
                data.put("taskName", task.getName());
                data.put("userId", userId);
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                data.put("processDefinitionId", task.getProcessDefinitionId());
                data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                data.put("sendUser", task.getSendUser());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                data.put("startDate", simpleDateFormat.format(task.getCreateTime()));
                Date date = new Date();
                data.put("endDate", simpleDateFormat.format(date));
                data.put("url", task.getFormKey());
                data.put("description", task.getTodoConfiguration());
                data.put("formType", "1");
                data.put("process_key", task.getProcessKey());
                data.put("category", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("category") : null);
                data.put("type", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("classify") : null);
                data.put("parentProcessInstanceId", this.getParentProcessInstanceId(task.getProcessInstanceId()).getId());
                data.put("parentProcessName", this.getParentProcessInstanceId(task.getProcessInstanceId()).getName());
                data.put("parentBusinessKey", this.getParentProcessInstanceId(task.getProcessInstanceId()).getBusinessKey());
                data.put("comment", comment);
                data.put("processInstanceId", task.getProcessInstanceId());
                data.put("company_code", task.getCompanyCode());
                if (HussarUtils.isNotEmpty((Object)operationType)) {
                    long hisTaskNum;
                    if ("complete".equals(operationType) && (hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).count()) == 2L) {
                        operationType = "submit";
                    }
                    data.put("operationType", operationType);
                }
                if (this.lcdpBpmProperties.isPushTaskCenter() && HussarUtils.isNotEmpty((Object)this.lcdpBpmProperties.getTaskCenterDatapushAddress()) && !this.lcdpBpmProperties.isPushRocketMq()) {
                    String dataPushAddress = this.lcdpBpmProperties.getTaskCenterDatapushAddress();
                    DataPushUtil.addData(data);
                    if (!"skip".equals(data.get("operationType"))) {
                        DataPushUtil.dataPushReal(dataPushAddress);
                    }
                    break block8;
                }
                if (this.lcdpBpmProperties.isPushRocketMq() && !this.lcdpBpmProperties.isPushTaskCenter()) {
                    DataPushUtil.addData(data);
                    if (!"skip".equals(data.get("operationType"))) {
                        DataPushUtil.dataPushMq();
                    }
                    break block8;
                }
                throw new BpmException("\u4efb\u52a1\u4e2d\u5fc3\u6570\u636e\u63a8\u9001\u6216mq\u6d88\u606f\u961f\u5217\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5f02\u5e38");
            }
            catch (Exception e) {
                throw new BpmException(e.getMessage());
            }
        }
    }

    public HistoricProcessInstance getMainProcessInstanceId(String processInstanceId) {
        if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
            return this.getParentProcessInstanceId(processInstanceId);
        }
        return null;
    }

    public Map<String, String> getModelByProcessKey(String processKey) {
        Map<String, String> map = this.taskEngineMapper.getModelByProcessKey(processKey);
        if (HussarUtils.isEmpty((Object)map.get("classify"))) {
            map.put("category", map.get("CATEGORY"));
            map.put("classify", map.get("CLASSIFY"));
        }
        return map;
    }

    private List<String> backEffectNodeId(Task task, String backActivityId) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> taskDefIds = new HashSet<String>();
        Map map1 = this.processDiagramService.list(task.getProcessInstanceId(), null, null, null);
        JSONArray json = (JSONArray)map1.get("data");
        if (HussarUtils.isNotEmpty((Object)json)) {
            for (int i = json.size() - 1; i >= 0; --i) {
                JSONObject map = JSONObject.parseObject((String)String.valueOf(json.get(i)));
                if (!HussarUtils.isNotEmpty((Object)map.get((Object)"taskDefinitionKey")) || !HussarUtils.isNotEmpty((Object)map.get((Object)"activityId"))) continue;
                if (map.get((Object)"taskDefinitionKey").toString().equals(backActivityId) && !map.getString("activityId").contains(CALL_REJECT_PREFIX)) break;
                taskDefIds.add(map.get((Object)"taskDefinitionKey").toString());
            }
        }
        result.addAll(taskDefIds);
        return result;
    }

    private void entrustDataPush(Task task, String userId, String consignee, String comment, Date startTime, Date endTime, String type, String operationType) {
        block6: {
            try {
                if (!this.lcdpBpmProperties.isPushTaskCenter() && !this.lcdpBpmProperties.isPushRocketMq()) break block6;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", type);
                data.put("taskId", task.getId());
                data.put("taskName", task.getName());
                data.put("userId", consignee);
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("startUserId", historicProcessInstance.getStartUserId());
                data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                data.put("processDefinitionId", task.getProcessDefinitionId());
                data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                data.put("startDate", simpleDateFormat.format(startTime));
                data.put("url", task.getFormKey());
                data.put("description", task.getTodoConfiguration());
                data.put("sendUser", task.getSendUser());
                data.put("processName", historicProcessInstance.getProcessDefinitionName());
                data.put("comment", comment);
                data.put("processInstanceId", task.getProcessInstanceId());
                data.put("company_code", task.getCompanyCode());
                data.put("category", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("category") : null);
                data.put("type", HussarUtils.isNotEmpty(this.getModelByProcessKey(task.getProcessKey())) ? this.getModelByProcessKey(task.getProcessKey()).get("classify") : null);
                data.put("parentProcessInstanceId", this.getParentProcessInstanceId(task.getProcessInstanceId()).getId());
                data.put("parentProcessName", this.getParentProcessInstanceId(task.getProcessInstanceId()).getName());
                data.put("parentBusinessKey", this.getParentProcessInstanceId(task.getProcessInstanceId()).getBusinessKey());
                if (userId != null) {
                    data.put("consignor", userId);
                    data.put("endDate", simpleDateFormat.format(endTime));
                }
                data.put("operationType", operationType);
                if (this.lcdpBpmProperties.isPushTaskCenter() && HussarUtils.isNotEmpty((Object)this.lcdpBpmProperties.getTaskCenterDatapushAddress()) && !this.lcdpBpmProperties.isPushRocketMq()) {
                    String dataPushAddress = this.lcdpBpmProperties.getTaskCenterDatapushAddress();
                    DataPushUtil.addData(data);
                    DataPushUtil.dataPushReal(dataPushAddress);
                    break block6;
                }
                if (this.lcdpBpmProperties.isPushRocketMq() && !this.lcdpBpmProperties.isPushTaskCenter()) {
                    DataPushUtil.addData(data);
                    if (!"skip".equals(data.get("operationType"))) {
                        DataPushUtil.dataPushMq();
                    }
                    break block6;
                }
                throw new BpmException("\u4efb\u52a1\u4e2d\u5fc3\u6570\u636e\u63a8\u9001\u6216mq\u6d88\u606f\u961f\u5217\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5f02\u5e38");
            }
            catch (Exception e) {
                logger.error("\u8f6c\u529e\u6570\u636e\u63a8\u9001\u51fa\u9519");
            }
        }
    }

    private HistoricProcessInstance getParentProcessInstanceId(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance)) {
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return historicProcessInstance;
            }
            return this.getParentProcessInstanceId(historicProcessInstance.getId());
        }
        return null;
    }

    private static class NodeMessage {
        String nodeId;
        String parentNode;
        boolean conditionWithNextNode;
        String getewayType;
        List<String> childNodes;

        public NodeMessage(String nodeId, String parentNode, boolean conditionWithNextNode, String gatewayType, List<String> childNodes) {
            this.nodeId = nodeId;
            this.parentNode = parentNode;
            this.conditionWithNextNode = conditionWithNextNode;
            this.getewayType = gatewayType;
            this.childNodes = childNodes;
        }
    }

    private static class SimpleGroupMessage {
        String groupId;
        List<JSONObject> jsonObjects;
        List<List<String>> childGroupIds;

        private SimpleGroupMessage() {
        }
    }
}

