/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserAccountModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeDSChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssignModeChooseServiceImpl
implements IAssigneeModeChooseService {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private IAssigneeDSChooseService assigneeDSChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    public static final String IMPORT = "import";
    public static final String REMOTE_INTERFACE = "remote-interface";
    public static final String REMOTE_DATA_SOURCE = "remote-datasource";

    private String connName() {
        return this.lcdpBpmProperties.getRemoteDBName();
    }

    private String getAssigneeMode() {
        return this.lcdpBpmProperties.getAssigneeMode();
    }

    private boolean getIdType() {
        String assigneeModel = this.getAssigneeMode();
        if (IMPORT.equals(assigneeModel)) {
            return false;
        }
        return this.lcdpBpmProperties.getTenantDBPrimaryKeyIsLong();
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userTree(id, isMainPost, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("isMainPost", JSON.toJSONString((Object)isMainPost));
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userTree(id, isMainPost, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> deptTree(String id, String organId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.deptTree(id, organId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/deptTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("organId", organId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.deptTree(id, organId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> roleTree() {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree();
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTreeWithOutId";
                url = this.dealPath(url);
                HashMap params = new HashMap();
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(this.connName());
    }

    public List<BpmTreeModel> roleTree(String id, String roleId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree(id, roleId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("roleId", roleId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(id, roleId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> userDeptDetail(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDeptDetail(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDeptDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDeptDetail(userId, this.connName(), this.getIdType());
    }

    public List<String> getCandidateUsers(String condition, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUser";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<String>();
                }
                return JSONArray.parseArray((String)result, String.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUser(condition, securityLevel, this.connName());
    }

    public List<BpmTreeModel> getCandidateUsersWithParent(String condition, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUserWithParent";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUserWithParent(condition, securityLevel, this.connName());
    }

    public String getParentDeptIdByUserId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserId(userId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> userDetail(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDetail(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDetail(userIds, this.connName(), this.getIdType());
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserId(userId, this.connName(), this.getIdType());
    }

    public String getDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public String getParentDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public Integer getSecurityLevel(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSecurityLevel(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSecurityLevel";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return Integer.parseInt(result);
            }
        }
        return this.assigneeDSChooseService.getSecurityLevel(userId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByDeptName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByDeptName(organName, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTreeByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeByUserName(organName, this.connName());
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserListByUserName(organName, this.connName());
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRoleTreeByRoleName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("roleName", roleName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryRoleTreeByRoleName(roleName, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTree(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result) || "[]".equals(result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTree(organName, this.connName());
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, String organId, String type) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return pages;
                }
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryUserListByPage(pages, organId, type, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByChildren";
                url = this.dealPath(url);
                Map params = new HashMap();
                params = (Map)JSON.parseObject((String)JSON.toJSONString((Object)bpmTreeModel), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByChildren(bpmTreeModel, this.connName());
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryAssigneeAndDept";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = users.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("users", newUserIds);
                params.put("organName", organName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryAssigneeAndDept(users, organName, this.connName(), this.getIdType());
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> userIds, String organId, String type) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, userIds, organId, type, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("userIds", String.join((CharSequence)",", userIds));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListByPage(pages, userIds, organId, type, this.connName(), this.getIdType());
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> userIds, String organId, String type) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, organId, type, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListWithParentByPageByPost";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("userIds", JSON.toJSONString(userIds));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doPost((String)url, (String)JSON.toJSONString(params));
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, organId, type, this.connName(), this.getIdType());
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserAndAccountListByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = "";
                if (HussarUtils.isNotEmpty(userIds)) {
                    newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, AssigneeChooseDto.class);
            }
        }
        return this.assigneeDSChooseService.getUserAndAccountListByUserId(userIds, this.connName(), this.getIdType());
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserMsgByUserIds(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserMsgByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmUserInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.getUserMsgByUserIds(userIds, this.connName(), this.getIdType());
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryList(page, getListDto, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/list";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String userName = getListDto.getUserName();
                String deptId = getListDto.getDeptId();
                String roleId = getListDto.getRoleId();
                String deptName = getListDto.getDeptName();
                String roleName = getListDto.getRoleName();
                params.put("size", String.valueOf(page.getSize()));
                params.put("current", String.valueOf(page.getCurrent()));
                params.put("userName", userName);
                params.put("deptId", deptId);
                params.put("roleId", roleId);
                params.put("deptName", deptName);
                params.put("roleName", roleName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryList(page, getListDto, this.connName(), this.getIdType());
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDept(name);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDept";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryDept(name, this.connName());
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRole(name);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRole";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryRole(name, this.connName());
    }

    public List<BpmUserAccountModel> getUserAccount(List<String> userIds) {
        try {
            String assigneeModel;
            switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
                case "import": {
                    return this.workflowAssigneeChooseService.getUserAccount(userIds);
                }
                case "remote-interface": {
                    String url = "/hussarBpm/assignee/obtain/getUserAccount";
                    url = this.dealPath(url);
                    HashMap<String, String> param = new HashMap<String, String>();
                    String newUserIds = userIds.stream().filter(HussarUtils::isNotEmpty).map(String::valueOf).collect(Collectors.joining(","));
                    param.put("userIds", newUserIds);
                    String result = HttpClient.doGet((String)url, param);
                    return JSONArray.parseArray((String)result, BpmUserAccountModel.class);
                }
            }
            return this.assigneeDSChooseService.getUserAccount(userIds, this.connName());
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }
}

