/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UrgeSaveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UrgeTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.vo.SysActUrgeTaskVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActUrgeTaskApiService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysActUrgeTaskWorkflowApiService
implements SysActUrgeTaskApiService {
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    public ApiResponse<Page<SysActUrgeTaskVo>> list(UrgeTaskQueryDto urgeTaskQueryDto) {
        Page pages = new Page((long)urgeTaskQueryDto.getPage().intValue(), (long)urgeTaskQueryDto.getSize().intValue());
        return this.sysActUrgeTaskService.query(pages, urgeTaskQueryDto.getUserId(), urgeTaskQueryDto.getProcessKey(), urgeTaskQueryDto.getSendUserId(), urgeTaskQueryDto.getStartTime(), urgeTaskQueryDto.getEndTime(), urgeTaskQueryDto.getTodoConfiguration());
    }

    public BpmResponseResult save(UrgeSaveDto urgeSaveDto) {
        String msg = this.sysActUrgeTaskService.urgeTask(urgeSaveDto.getProcessInsId(), urgeSaveDto.getBusinessId(), urgeSaveDto.getTaskId(), urgeSaveDto.getUserId());
        return InstallResult.getResult((String)"1", (String)msg, null);
    }

    public BpmResponseResult saveByProcessInsIdOrBusinessId(UrgeSaveDto urgeSaveDto) {
        String msg = this.sysActUrgeTaskService.urgeTask(urgeSaveDto.getProcessInsId(), urgeSaveDto.getBusinessId(), urgeSaveDto.getTaskId(), urgeSaveDto.getUserId());
        return InstallResult.getResult((String)"1", (String)msg, null);
    }

    public BpmResponseResult delete(String ids) {
        String[] sysActUrgeTaskId = ids.split(",");
        List list = Arrays.asList(sysActUrgeTaskId).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (this.sysActUrgeTaskService.removeByIds(list)) {
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getDeleteFail(), null);
    }
}

