/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ReTransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveBatchEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActEntrustApiService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysActEntrustWorkflowApiService
implements SysActEntrustApiService {
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IFlowTaskService iFlowTaskService;

    public BpmResponseResult list(EntrustQueryDto entrustQueryDto) {
        Page pages = new Page((long)entrustQueryDto.getPage().intValue(), (long)entrustQueryDto.getSize().intValue());
        return this.sysActEntrustService.list(pages, entrustQueryDto.getUserId(), entrustQueryDto.getProcessKey(), entrustQueryDto.getState());
    }

    public BpmResponseResult entrustHistoryList(EntrustQueryDto entrustQueryDto) {
        return this.iFlowTaskService.entrustHistoryList(entrustQueryDto.getUserId(), entrustQueryDto.getPage(), entrustQueryDto.getSize());
    }

    public BpmResponseResult add(EntrustAddDto entrustAddDto) {
        return this.sysActEntrustService.add(entrustAddDto.getProcessKey(), entrustAddDto.getTaskDefinitionKey(), entrustAddDto.getMandator(), entrustAddDto.getMandatary(), entrustAddDto.getState(), entrustAddDto.getStartTime(), entrustAddDto.getEndTime(), entrustAddDto.getIsTransferTask(), entrustAddDto.getMessageType());
    }

    public BpmResponseResult addBatch(SaveBatchEntrustDto entrustBatchAddDto) {
        return this.sysActEntrustService.addBatch(String.join((CharSequence)",", entrustBatchAddDto.getProcessKey()), entrustBatchAddDto.getMandator(), entrustBatchAddDto.getMandatary(), entrustBatchAddDto.getState(), entrustBatchAddDto.getStartTime(), entrustBatchAddDto.getEndTime(), entrustBatchAddDto.getIsTransferTask(), entrustBatchAddDto.getMessageType(), entrustBatchAddDto.getCompanyCode(), entrustBatchAddDto.getCompanyName(), entrustBatchAddDto.getMandatorName(), entrustBatchAddDto.getMandataryName());
    }

    public BpmResponseResult addBatchEntrust(SaveEntrustDto saveEntrustDto) {
        return this.sysActEntrustService.addBatchEntrust(saveEntrustDto);
    }

    public BpmResponseResult delete(String tEntrustId) {
        ArrayList<String> tEntrustIds = new ArrayList<String>(Arrays.asList(tEntrustId.split(",")));
        List longList = tEntrustIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        this.sysActEntrustService.removeByIds(longList);
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
    }

    public BpmResponseResult update(EntrustUpdateDto entrustUpdateDto) {
        return this.sysActEntrustService.update(entrustUpdateDto.getId(), entrustUpdateDto.getMandatary(), (Date)Timestamp.valueOf(entrustUpdateDto.getStartTime()), (Date)Timestamp.valueOf(entrustUpdateDto.getEndTime()), entrustUpdateDto.getMessageType());
    }

    public BpmResponseResult detail(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)this.sysActEntrustService.selectById(Long.valueOf(Long.parseLong(tEntrustId))));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult updateState(String tEntrustId, String state) {
        BpmResponseResult bpmResponseResult = this.sysActEntrustService.updateState(tEntrustId, state);
        if (bpmResponseResult.isSuccess()) {
            if ("1".equals(state)) {
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessStart(), null);
            }
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessStop(), null);
        }
        return bpmResponseResult;
    }

    public BpmResponseResult queryCommissionedInfo(EntrustQueryDto entrustQueryDto) {
        return this.sysActEntrustService.queryCommissionedInfo(entrustQueryDto.getUserId(), entrustQueryDto.getProcessKey(), entrustQueryDto.getMandator(), (Date)Timestamp.valueOf(entrustQueryDto.getStartTime()), (Date)Timestamp.valueOf(entrustQueryDto.getEndTime()), String.valueOf(entrustQueryDto.getPage()), String.valueOf(entrustQueryDto.getSize()));
    }

    public BpmResponseResult reTransferTask(ReTransferTaskDto reTransferTaskDto) {
        return this.sysActEntrustService.reTransferTask(reTransferTaskDto);
    }
}

