/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Autowired
    List<DataPushListener> dataPushListeners;
    private final LcdpBpmProperties lcdpBpmProperties;

    public DataPushService(LcdpBpmProperties lcdpBpmProperties) {
        this.lcdpBpmProperties = lcdpBpmProperties;
    }

    public boolean isDataPush(Set<String> processDefinitionIdList) {
        return this.lcdpBpmProperties.isUseDatapush() || this.dataPushListeners.size() > 4 || CommonCodeUtil.isBindTable(processDefinitionIdList) || CommonCodeUtil.isBackfill(processDefinitionIdList);
    }

    public void addDataPush(DataPush dataPush) {
        dataPush.setOperationType("add_process");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush.getOperationType())) {
            dataPush.setOperationType("complete");
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.completeTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        dataPush.setOperationType("deleteProcess");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        dataPush.setOperationType("entrust_process");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.entrustTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferDataPush(DataPush dataPush) {
        dataPush.setOperationType("transfer_process");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferUserTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        dataPush.setOperationType("reject");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.rejectTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        dataPush.setOperationType("revokeProcess");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.revokeTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        dataPush.setOperationType("free_jump");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.freeJumpTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        dataPush.setOperationType("add_user");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUser(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        dataPush.setOperationType("delete_multi_task");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteMultiTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(DataPush dataPush) {
        dataPush.setOperationType("add_cc_task");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
            if (dataPush.getEndDate() != null) {
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(List<DataPush> dataPushList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            for (DataPush dataPush : dataPushList) {
                dataPush.setOperationType("add_cc_task");
                dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
                if (dataPush.getEndDate() != null) {
                    dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
                }
                this.realDataPush(dataPush);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addCcTask(dataPushList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void readCcTask(DataPush dataPush) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataPush.setOperationType("read_cc_task");
        try {
            dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.readCcTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        dataPush.setOperationType("delete_cc_task");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteCcTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        dataPush.setOperationType("add_urge_task");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUrgeTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void endProcess(DataPush dataPush) {
        dataPush.setOperationType("endProcess");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.endProcess(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferTask(DataPush dataPush) {
        dataPush.setOperationType("transfer_task");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        dataPush.setOperationType("re_transfer_task");
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.reTransferTask(this.realDataPush(dataPush));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(Task task, String comment, String userId, String mandator, String taskState, String taskType) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState).setTaskType(taskType);
            dataPush.setOperationType(taskType);
            this.completeDataPush(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setTaskName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setProcessDefinitionKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(task.getSendUser());
        dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setProcessInstanceId(task.getProcessInstanceId());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee, List<Map<String, String>> userMapList) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setProcessDefinitionKey(task.getTaskDefinitionKey().split(":")[0]);
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setProcessInstanceId(task.getProcessInstanceId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setTaskType(task.getTaskType());
            dataPush.setUserMapList(userMapList);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            this.entrustDataPush(dataPush);
        }
    }

    public void transferDataPush(Task task, String userId, String consignee, String transferor, List<Map<String, String>> userMapList) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setProcessDefinitionKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setProcessInstanceId(task.getProcessInstanceId());
            dataPush.setUserMapList(userMapList);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            dataPush.setTransferor(transferor);
            this.transferDataPush(dataPush);
        }
    }

    public void addUserDataPush(Task task, String userId) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setTaskName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setProcessDefinitionKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setProcessInstanceId(task.getProcessInstanceId());
        this.addUserDataPush(dataPush);
    }

    public void changeProcessStateDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.changeProcessState(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public DataPush realDataPush(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush)) {
            return null;
        }
        dataPush.setTaskName(dataPush.getTaskDefinitionName());
        dataPush.setProcessDefinitionKey(dataPush.getProcessKey());
        dataPush.setProcessInstanceId(dataPush.getProcessInsId());
        return dataPush;
    }

    public void changeProcessNode(DataPush dataPush) {
    }
}

