/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.notice.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.dao.SysActTaskNoticeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.model.SysActTaskNotice;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.service.SysActTaskNoticeService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.DataPushUtil;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysActTaskNoticeServiceImpl
extends HussarServiceImpl<SysActTaskNoticeMapper, SysActTaskNotice>
implements SysActTaskNoticeService {
    private static Logger LOGGER = LoggerFactory.getLogger(SysActTaskNoticeServiceImpl.class);
    @Resource
    SysActTaskNoticeMapper sysActTaskNoticeMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    TaskService taskService;
    @Autowired
    HistoryService historyService;
    @Autowired
    private IBpmActRuIdentitylinkService bpmActRuIdentitylinkService;

    public BpmResponseResult save(String sendUserId, String userIds, String taskId, String nodeName) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        String realTaskId = RealTaskId.getRealTaskId(taskId);
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(realTaskId)).singleResult();
        if (taskInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        ArrayList<SysActTaskNotice> sysActTaskNoticeList = new ArrayList<SysActTaskNotice>();
        ArrayList<BpmActRuIdentitylink> bpmActRuIdentitylinks = new ArrayList<BpmActRuIdentitylink>();
        String[] userList = userIds.split(",");
        HashMap<String, Object> noticeMap = new HashMap<String, Object>();
        HashMap<String, Object> noticeIdMap = new HashMap<String, Object>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (String userId : userList) {
            SysActTaskNotice sysActTaskNotice = new SysActTaskNotice();
            sysActTaskNotice.setCreateTime(ts);
            sysActTaskNotice.setSendUser(sendUserId);
            sysActTaskNotice.setUserId(userId);
            sysActTaskNotice.setTaskId(Long.valueOf(Long.parseLong(realTaskId)));
            sysActTaskNotice.setTaskDefinitionKey(taskInstance.getTaskDefinitionKey());
            sysActTaskNotice.setProcessDefinitionId(taskInstance.getProcessDefinitionId());
            String name = ToolUtil.isEmpty((Object)nodeName) ? "\u9605\u77e5" : nodeName;
            sysActTaskNotice.setTaskDefinitionName(name);
            sysActTaskNotice.setProcessDefinitionKey(taskInstance.getProcessDefinitionId().split(":")[0]);
            sysActTaskNotice.setProcessInstId(taskInstance.getProcessInstanceId());
            sysActTaskNotice.setFormKey(taskInstance.getFormKey());
            sysActTaskNotice.setState("1");
            sysActTaskNotice.setKnowState("1");
            noticeMap.put(sysActTaskNotice.getUserId(), sysActTaskNotice.getCreateTime());
            noticeIdMap.put(sysActTaskNotice.getUserId(), sysActTaskNotice.getTaskId());
            sysActTaskNotice.setTodoConfiguration(taskInstance.getTodoConfiguration());
            sysActTaskNoticeList.add(sysActTaskNotice);
        }
        if (sysActTaskNoticeList.size() > 0) {
            this.saveBatch(sysActTaskNoticeList);
            for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
                BpmActRuIdentitylink bpmActRuIdentitylink = new BpmActRuIdentitylink();
                bpmActRuIdentitylink.setType("candidate");
                bpmActRuIdentitylink.setUserId(sysActTaskNotice.getUserId());
                bpmActRuIdentitylink.setTaskId(sysActTaskNotice.getId());
                bpmActRuIdentitylink.setBottomFlag("0");
                bpmActRuIdentitylinks.add(bpmActRuIdentitylink);
            }
            this.bpmActRuIdentitylinkService.saveBatch(bpmActRuIdentitylinks);
            this.dataPushWithTask(taskInstance, noticeMap, sendUserId, nodeName, noticeIdMap);
        }
        ArrayList<Long> readIds = new ArrayList<Long>();
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
            readIds.add(sysActTaskNotice.getId());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("readIds", readIds);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult saveWithMessage(String sendUserId, String userIds, String message, String nodeName, String processInstanceId, String formKey, String category, String type) {
        if (ToolUtil.isEmpty((Object)processInstanceId)) {
            throw new HussarException("\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<SysActTaskNotice> sysActTaskNoticeList = new ArrayList<SysActTaskNotice>();
        ArrayList<BpmActRuIdentitylink> bpmActRuIdentitylinks = new ArrayList<BpmActRuIdentitylink>();
        formKey = "{\"web\":\"" + formKey + "\",\"mobile\":\"\"}";
        Object[] userList = userIds.split(",");
        HistoricProcessInstance processInstance = null;
        if (ToolUtil.isNotEmpty((Object)processInstanceId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        }
        HashMap<String, Object> noticeMap = new HashMap<String, Object>();
        HashMap<String, Object> noticeIdMap = new HashMap<String, Object>();
        if (type == null) {
            type = "";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TYPE", (Object)type);
        queryWrapper.in((Object)"USER_ID", userList);
        queryWrapper.eq((Object)"STATE", (Object)1);
        List sysActTaskNotices = this.list((Wrapper)queryWrapper);
        HashMap<String, Long> sysActTaskNoticeIdMap = new HashMap<String, Long>();
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNotices) {
            sysActTaskNoticeIdMap.put(sysActTaskNotice.getUserId(), sysActTaskNotice.getId());
        }
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Object userId : userList) {
            SysActTaskNotice sysActTaskNotice = new SysActTaskNotice();
            Long taskId = (Long)sysActTaskNoticeIdMap.get(userId);
            if (taskId == null) {
                Random random = new Random();
                while ((taskId = Long.valueOf(random.nextLong())) <= 0L) {
                }
            }
            sysActTaskNotice.setTaskId(taskId);
            sysActTaskNotice.setCreateTime(ts);
            sysActTaskNotice.setSendUser(sendUserId);
            sysActTaskNotice.setUserId((String)userId);
            sysActTaskNotice.setTodoConfiguration(message);
            sysActTaskNotice.setState("1");
            sysActTaskNotice.setFormKey(formKey);
            sysActTaskNotice.setTaskDefinitionName(nodeName);
            sysActTaskNotice.setCategory(category);
            sysActTaskNotice.setTaskDefinitionKey("null");
            sysActTaskNotice.setKnowState("2");
            if (processInstance != null) {
                sysActTaskNotice.setProcessInstId(processInstanceId);
                sysActTaskNotice.setProcessDefinitionId(processInstance.getProcessDefinitionId());
                sysActTaskNotice.setProcessDefinitionKey(processInstance.getProcessDefinitionId().split(":")[0]);
            }
            noticeMap.put(sysActTaskNotice.getUserId(), sysActTaskNotice.getCreateTime());
            noticeIdMap.put(sysActTaskNotice.getUserId(), taskId);
            sysActTaskNoticeList.add(sysActTaskNotice);
        }
        if (sysActTaskNoticeList.size() > 0) {
            this.saveOrUpdateBatch(sysActTaskNoticeList);
            for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
                BpmActRuIdentitylink bpmActRuIdentitylink = new BpmActRuIdentitylink();
                bpmActRuIdentitylink.setType("candidate");
                bpmActRuIdentitylink.setUserId(sysActTaskNotice.getUserId());
                bpmActRuIdentitylink.setTaskId(sysActTaskNotice.getId());
                bpmActRuIdentitylink.setBottomFlag("0");
                bpmActRuIdentitylinks.add(bpmActRuIdentitylink);
            }
            this.bpmActRuIdentitylinkService.saveBatch(bpmActRuIdentitylinks);
            this.dataPushWithOutTask(noticeMap, sendUserId, message, nodeName, processInstance, noticeIdMap, category, type, formKey);
        }
        ArrayList<Long> readIds = new ArrayList<Long>();
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
            readIds.add(sysActTaskNotice.getId());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("readIds", readIds);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult read(String userId, String taskId, String comments) {
        comments = ToolUtil.isEmpty((Object)comments) ? "\u5df2\u9605" : comments;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TASK_ID", (Object)taskId);
        queryWrapper.eq((Object)"USER_ID", (Object)userId);
        List sysActTaskNotices = this.sysActTaskNoticeMapper.selectList((Wrapper)queryWrapper);
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNotices) {
            sysActTaskNotice.setState("0");
            sysActTaskNotice.setComments(comments);
            sysActTaskNotice.setUpdateTime(ts);
            this.sysActTaskNoticeMapper.updateById(sysActTaskNotice);
            this.finishDataPush(sysActTaskNotice, "1");
        }
        if (ToolUtil.isEmpty((Object)sysActTaskNotices)) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public void dataPushWithTask(HistoricTaskInstance task, Map<String, Object> noticeMap, String sendUser, String nodeName, Map<String, Object> noticeIdMap) {
        String dataPushAddress;
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (lcdpBpmProperties.isDataPush() && ToolUtil.isNotEmpty((Object)(dataPushAddress = lcdpBpmProperties.getDataPushAddress()))) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            for (String userId : noticeMap.keySet()) {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("action", "add");
                    data.put("taskId", noticeIdMap.get(userId));
                    data.put("taskName", nodeName);
                    data.put("userId", userId);
                    data.put("businessKey", historicProcessInstance.getBusinessKey());
                    data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                    data.put("processDefinitionId", task.getProcessDefinitionId());
                    data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                    data.put("sendUser", sendUser);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    data.put("startDate", noticeMap.get(userId));
                    Date date = new Date();
                    data.put("endDate", simpleDateFormat.format(date));
                    data.put("url", task.getFormKey());
                    data.put("description", task.getTodoConfiguration());
                    data.put("processName", ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getProcessDefinitionName());
                    data.put("processInstanceId", task.getProcessInstanceId());
                    DataPushUtil.addData(data);
                    DataPushUtil.dataPushReal(dataPushAddress);
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
                }
            }
        }
    }

    public void dataPushWithOutTask(Map<String, Object> noticeMap, String sendUser, String message, String nodeName, HistoricProcessInstance processInstance, Map<String, Object> noticeIdMap, String category, String type, String formKey) {
        String dataPushAddress;
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (lcdpBpmProperties.isDataPush() && ToolUtil.isNotEmpty((Object)(dataPushAddress = lcdpBpmProperties.getDataPushAddress()))) {
            for (String userId : noticeMap.keySet()) {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("action", "add");
                    data.put("taskId", noticeIdMap.get(userId));
                    data.put("taskName", nodeName);
                    data.put("userId", userId);
                    data.put("sendUser", sendUser);
                    data.put("startDate", noticeMap.get(userId));
                    data.put("description", message);
                    data.put("category", category);
                    data.put("type", type);
                    data.put("url", formKey);
                    if (processInstance != null) {
                        data.put("processInstanceId", processInstance.getId());
                        data.put("processDefinitionId", processInstance.getProcessDefinitionId());
                        data.put("processDefinitionKey", processInstance.getProcessDefinitionId().split(":")[0]);
                        data.put("processName", processInstance.getProcessDefinitionName());
                    }
                    DataPushUtil.addData(data);
                    DataPushUtil.dataPushReal(dataPushAddress);
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BpmResponseResult getTaskStatusById(String taskId, int taskType, String userId) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        String realTaskId = RealTaskId.getRealTaskId(taskId);
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        String status = "";
        if (taskType == 1) {
            HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(realTaskId)).singleResult();
            if (task == null) return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            status = ToolUtil.isEmpty((Object)task.getEndTime()) ? "unhandled" : "handled";
        } else {
            List sysActTaskNotices;
            if (ToolUtil.isEmpty((Object)userId)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNoticeAssigneeNotNull(), null);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TASK_ID", (Object)realTaskId);
            queryWrapper.eq((Object)"USER_ID", (Object)userId);
            if (taskType == 3) {
                queryWrapper.eq((Object)"TASK_DEFINITION_KEY", (Object)"null");
            }
            if ((sysActTaskNotices = this.list((Wrapper)queryWrapper)).isEmpty()) return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNoticeNotFound(), null);
            status = "1".equals(((SysActTaskNotice)sysActTaskNotices.get(0)).getState()) ? "unhandled" : "handled";
        }
        object.put("status", (Object)status);
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult flowNoticeWithOutProcess(String sendUserId, String userIds, String message, String nodeName, String formKey, String category, String type, String processName, String urlMap) {
        if (ToolUtil.isEmpty((Object)formKey)) {
            throw new HussarException("\u8bf7\u6dfb\u52a0\u8868\u5355\u5730\u5740");
        }
        ArrayList<SysActTaskNotice> sysActTaskNoticeList = new ArrayList<SysActTaskNotice>();
        ArrayList<BpmActRuIdentitylink> bpmActRuIdentitylinks = new ArrayList<BpmActRuIdentitylink>();
        formKey = "{\"web\":\"" + formKey + "\",\"mobile\":\"\"}";
        String[] userList = userIds.split(",");
        if (ToolUtil.isEmpty((Object)userList) || ToolUtil.isEmpty((Object)sendUserId)) {
            throw new HussarException("\u8bf7\u6dfb\u52a0\u4eba\u5458");
        }
        HashMap<String, Date> noticeMap = new HashMap<String, Date>();
        HashMap<String, Long> noticeIdMap = new HashMap<String, Long>();
        for (String userId : userList) {
            Long taskId;
            SysActTaskNotice sysActTaskNotice = new SysActTaskNotice();
            Random random = new Random();
            while ((taskId = Long.valueOf(random.nextLong())) <= 0L) {
            }
            sysActTaskNotice.setTaskId(taskId);
            Timestamp createTime = new Timestamp(new Date().getTime());
            sysActTaskNotice.setCreateTime(createTime);
            sysActTaskNotice.setSendUser(sendUserId);
            sysActTaskNotice.setUserId(userId);
            sysActTaskNotice.setTodoConfiguration(message);
            sysActTaskNotice.setState("1");
            sysActTaskNotice.setFormKey(formKey);
            sysActTaskNotice.setTaskDefinitionName(nodeName == null ? "\u9605\u77e5" : nodeName);
            sysActTaskNotice.setTaskDefinitionKey(nodeName == null ? "\u9605\u77e5" : nodeName);
            sysActTaskNotice.setCategory(category);
            sysActTaskNotice.setProcessName(ToolUtil.isEmpty((Object)processName) ? "\u9605\u77e5" : processName);
            sysActTaskNotice.setProcessDefinitionKey(ToolUtil.isEmpty((Object)processName) ? "\u9605\u77e5" : processName);
            sysActTaskNotice.setUrlParameter(ToolUtil.isEmpty((Object)urlMap) ? null : urlMap);
            sysActTaskNotice.setKnowState("3");
            noticeMap.put(sysActTaskNotice.getUserId(), sysActTaskNotice.getCreateTime());
            noticeIdMap.put(sysActTaskNotice.getUserId(), taskId);
            sysActTaskNoticeList.add(sysActTaskNotice);
        }
        if (sysActTaskNoticeList.size() > 0) {
            this.saveOrUpdateBatch(sysActTaskNoticeList);
            for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
                BpmActRuIdentitylink bpmActRuIdentitylink = new BpmActRuIdentitylink();
                bpmActRuIdentitylink.setType("candidate");
                bpmActRuIdentitylink.setUserId(sysActTaskNotice.getUserId());
                bpmActRuIdentitylink.setTaskId(sysActTaskNotice.getId());
                bpmActRuIdentitylink.setBottomFlag("0");
                bpmActRuIdentitylinks.add(bpmActRuIdentitylink);
            }
            this.bpmActRuIdentitylinkService.saveBatch(bpmActRuIdentitylinks);
            this.dataPushWithOutProcess(noticeMap, sendUserId, message, nodeName, noticeIdMap, category, type, formKey, processName, urlMap);
        }
        ArrayList<Long> readIds = new ArrayList<Long>();
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
            readIds.add(sysActTaskNotice.getId());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("readIds", readIds);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult delBatchRead(List<String> readList, boolean isDel) {
        if (ToolUtil.isEmpty(readList)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ArrayList<Long> readIdList = new ArrayList<Long>();
        List sysActTaskNoticeList = this.sysActTaskNoticeMapper.selectBatchIds(readList);
        if (readList.size() != sysActTaskNoticeList.size()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoExistTask(), null);
        }
        String msg = "success";
        if (!isDel) {
            for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
                if ("1".equals(sysActTaskNotice.getDelState())) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getHasDelRead(), null);
                }
                if (!"0".equals(sysActTaskNotice.getState())) continue;
                readIdList.add(sysActTaskNotice.getId());
                readList.remove(sysActTaskNotice.getId());
            }
            if (ToolUtil.isEmpty(readList)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAllTaskHadRead(), null);
            }
            if (ToolUtil.isNotEmpty(readIdList)) {
                msg = ((Object)readIdList).toString() + "\u5df2\u9605\u672a\u5220\u9664\uff0c\u5176\u4ed6\u5747\u5df2\u5220\u9664";
            }
        } else {
            for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
                if (!"1".equals(sysActTaskNotice.getDelState())) continue;
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getHasDelRead(), null);
            }
        }
        this.sysActTaskNoticeMapper.delBatchRead(readList, !isDel);
        List sysActTaskNotices = this.sysActTaskNoticeMapper.selectBatchIds(readList);
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNotices) {
            this.finishDataPush(sysActTaskNotice, "delete");
        }
        return InstallResult.getResult((String)"1", (String)msg, null);
    }

    public BpmResponseResult readBatch(List<String> readList) {
        if (ToolUtil.isEmpty(readList)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        this.sysActTaskNoticeMapper.readBatch(readList);
        List sysActTaskNoticeList = this.sysActTaskNoticeMapper.selectBatchIds(readList);
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNoticeList) {
            this.finishDataPush(sysActTaskNotice, "read");
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void dataPushWithOutProcess(Map<String, Date> noticeMap, String sendUserId, String message, String nodeName, Map<String, Long> noticeIdMap, String category, String type, String formKey, String processName, String urlMap) {
        String dataPushAddress;
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (lcdpBpmProperties.isDataPush() && ToolUtil.isNotEmpty((Object)(dataPushAddress = lcdpBpmProperties.getDataPushAddress()))) {
            for (String userId : noticeMap.keySet()) {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("action", "add");
                    data.put("taskId", noticeIdMap.get(userId));
                    data.put("taskName", nodeName);
                    data.put("userId", userId);
                    data.put("sendUser", sendUserId);
                    data.put("startDate", noticeMap.get(userId));
                    data.put("description", message);
                    data.put("category", category);
                    data.put("type", type);
                    data.put("url", formKey);
                    data.put("processName", processName);
                    data.put("urlParameter", urlMap);
                    DataPushUtil.addData(data);
                    DataPushUtil.dataPushReal(dataPushAddress);
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
                }
            }
        }
    }

    private void finishDataPush(SysActTaskNotice sysActTaskNotice, String operationType) {
        String dataPushAddress;
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        if (lcdpBpmProperties.isDataPush() && ToolUtil.isNotEmpty((Object)(dataPushAddress = lcdpBpmProperties.getDataPushAddress()))) {
            try {
                HistoricTaskInstance task;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", "update");
                data.put("userId", sysActTaskNotice.getUserId());
                data.put("endDate", sysActTaskNotice.getUpdateTime());
                data.put("comment", sysActTaskNotice.getComments());
                data.put("taskName", sysActTaskNotice.getTaskDefinitionName());
                data.put("description", sysActTaskNotice.getTodoConfiguration());
                data.put("taskId", sysActTaskNotice.getId());
                if (ToolUtil.isNotEmpty((Object)operationType)) {
                    data.put("operationType", operationType);
                }
                if ((task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(sysActTaskNotice.getTaskId().toString())).singleResult()) != null) {
                    HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                    data.put("businessKey", historicProcessInstance.getBusinessKey());
                    data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                    data.put("processDefinitionId", task.getProcessDefinitionId());
                    data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                    HashMap map = new HashMap();
                    map.putAll(task.getProcessVariables());
                    map.putAll(task.getTaskLocalVariables());
                    data.put("sendUser", task.getSendUser());
                    data.put("url", task.getFormKey());
                    data.put("processInstanceId", task.getProcessInstanceId());
                } else {
                    data.put("category", sysActTaskNotice.getCategory());
                    data.put("url", sysActTaskNotice.getFormKey());
                }
                DataPushUtil.addData(data);
                DataPushUtil.dataPushReal(dataPushAddress);
            }
            catch (Exception e) {
                LOGGER.error("\u9605\u8bfb\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
            }
        }
    }
}

