/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysBpmService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="sysBpmServiceImpl")
public class SysBpmServiceImpl
implements SysBpmService {
    @Resource
    private SysActFormAuthService sysActFormAuthService;
    @Resource
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private ModelService modelService;

    public Boolean actFormAuthBatchImport(List<SysActFormAuth> actFormAuths) {
        ArrayList<SysActFormAuth> insertOrUpdateList = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth actFormAuth : actFormAuths) {
            if (HussarUtils.isEmpty((Object)actFormAuth.getProcessKey())) continue;
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)actFormAuth.getProcessKey());
            if (HussarUtils.isNotEmpty((Object)actFormAuth.getTaskDefinitionKey())) {
                queryWrapper.eq(SysActFormAuth::getTaskDefinitionKey, (Object)actFormAuth.getTaskDefinitionKey());
            } else {
                queryWrapper.isNull(SysActFormAuth::getTaskDefinitionKey);
            }
            SysActFormAuth oldActAssignees = (SysActFormAuth)this.sysActFormAuthService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)oldActAssignees)) {
                actFormAuth.setId(null);
            } else {
                actFormAuth.setId(oldActAssignees.getId());
            }
            insertOrUpdateList.add(actFormAuth);
        }
        return this.sysActFormAuthService.saveOrUpdateBatch(insertOrUpdateList);
    }

    public Boolean actAssigneeBatchImport(List<SysActAssignee> actAssignees) {
        ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
        QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
        for (SysActAssignee sysActAssignee : actAssignees) {
            String procDefKey = sysActAssignee.getProcDefKey();
            String taskDefKey = sysActAssignee.getTaskDefKey();
            String contentType = sysActAssignee.getContentType();
            queryWrapper = (QueryChainWrapper)queryWrapper.or();
            queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey)).eq((Object)"CONTENT_TYPE", (Object)contentType);
        }
        List sameList = queryWrapper.list();
        ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
        for (SysActAssignee sysActAssignee : actAssignees) {
            boolean isadd = true;
            for (SysActAssignee actAssignee : sameList) {
                if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                sysActAssignee.setId(actAssignee.getId());
                updateList.add(sysActAssignee);
                isadd = false;
                break;
            }
            if (!isadd) continue;
            addList.add(sysActAssignee);
        }
        Boolean isSave = this.sysActAssigneeService.saveBatch(addList);
        Boolean isUpdate = this.sysActAssigneeService.updateBatchById(updateList);
        boolean result = false;
        if (isSave.booleanValue() && isUpdate.booleanValue()) {
            result = true;
        }
        return result;
    }

    public List<SysActFormAuth> actFormAuthExportData(List<String> keys) {
        return this.sysActFormAuthService.list((Wrapper)new LambdaQueryWrapper().in(SysActFormAuth::getProcessKey, keys));
    }

    public List<SysActAssignee> actAssigneeExportData(List<String> keys) {
        return this.sysActAssigneeService.list((Wrapper)new LambdaQueryWrapper().in(SysActAssignee::getProcDefKey, keys));
    }

    public Boolean importModel(File file, List<String> list) {
        return this.modelService.importModel(file, list);
    }

    public String exportAllFileModel(String keys, File file) {
        return this.modelService.exportAllFileModel(keys, file);
    }

    public void actExtendPropertiesImport(List<SysActExtendProperties> list) {
        for (SysActExtendProperties sysActExtendProperties : list) {
            sysActExtendProperties.insertOrUpdate();
        }
    }

    public List<SysActExtendProperties> actExtendPropertiesExportData(List<String> keys) {
        ArrayList<SysActExtendProperties> list = new ArrayList<SysActExtendProperties>();
        for (String key : keys) {
            List sysActExtendProperties = new SysActExtendProperties().selectList((Wrapper)new LambdaQueryWrapper().like(SysActExtendProperties::getProcDefId, (Object)key));
            if (!HussarUtils.isNotEmpty((Object)sysActExtendProperties)) continue;
            list.addAll(sysActExtendProperties);
        }
        return list;
    }
}

