/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowCallActivityListener;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.util.List;
import java.util.Map;

public class WorkflowListenerUtils {
    private static final LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);

    public static void executionListener(String listenerModel, String requestMethod, String beanId, Map<String, Object> map, String serviceName) {
        String deploymentModel = lcdpBpmProperties.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)listenerModel) || "local".equals(listenerModel)) {
            switch (deploymentModel) {
                case "single": {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                case "micro": {
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                    workflowListenerService.executeListener(map, serviceName);
                    break;
                }
                default: {
                    throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
                }
            }
        } else if ("remote".equals(listenerModel)) {
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                    break;
                }
                case "POST": {
                    HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    break;
                }
                default: {
                    throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
                }
            }
        } else {
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
        }
    }

    public static List<CallActivityInfo> executionCallActivityListener(String listenerModel, String requestMethod, String beanId, Map<String, Object> map, String serviceName) {
        String deploymentModel = lcdpBpmProperties.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)listenerModel) || "local".equals(listenerModel)) {
            switch (deploymentModel) {
                case "single": {
                    HussarWorkflowCallActivityListener workflowListenerVisitor = (HussarWorkflowCallActivityListener)SpringContextHolder.getBean((String)beanId);
                    return workflowListenerVisitor.notify(map);
                }
                case "micro": {
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                    return workflowListenerService.executeCallActivityListener(map, serviceName);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
        }
        if ("remote".equals(listenerModel)) {
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                    return JSONArray.parseArray((String)result, CallActivityInfo.class);
                }
                case "POST": {
                    String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    return JSONArray.parseArray((String)postResult, CallActivityInfo.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
    }
}

