/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private FlowEventsServiceMapper flowEventsServiceMapper;

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        Object variables2;
        if (HussarUtils.isEmpty((Object)flowTaskQueryModel.getDateTime())) {
            flowTaskQueryModel.setDateTime(new Date());
        }
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty(pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty(pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> todoList = this.flowTaskMapper.todoList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            if (HussarUtils.isNotEmpty((Object)flowTask.getTaskId())) {
                taskIds.add(Long.parseLong(flowTask.getTaskId()));
            }
            if (HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId())) {
                processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            }
            if (!HussarUtils.isNotEmpty((Object)flowTask.getBottomFlag())) continue;
            if (flowTask.getBottomFlag().equals("-1")) {
                flowTask.setType("concern");
                continue;
            }
            if (flowTask.getBottomFlag().equals("1")) {
                flowTask.setType("bottom");
                continue;
            }
            flowTask.setType("");
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            } else {
                processList = this.flowTaskMapper.getProcInstMsg(processInsIds, null);
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = todoList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            if (HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId()) && HussarUtils.isNotEmpty(processMap.get(flowTask.getProcessInsId()))) {
                FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
                flowTask.setBusinessId(flowProcess.getBusinessId());
                flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
                flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
                flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
                continue;
            }
            flowTask.setProcessStartUserId(flowTask.getSendUser());
            flowTask.setProcessStartTime(flowTask.getStartTime());
            flowTask.setProcessEndTime(flowTask.getEndTime());
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setSuspensionState(String.valueOf(flowTask.getSuspensionState()));
            taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            taskManagerQueryVo.setColorStyle(flowTask.getColorStyle());
            taskManagerQueryVo.setType(flowTask.getType());
            taskManagerQueryVo.setTypeName(flowTask.getTypeName());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            taskManagerQueryVo.setTaskSourceFlag(flowTask.getTaskSourceFlag());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getProcessStartUserId()));
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator<Object> iterator = resultData.iterator();
        while (iterator.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(finalUsers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setProcessStartUserName(finalUsers.get(taskManagerQueryVo.getProcessStartUserId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    /*
     * WARNING - void declaration
     */
    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        void var9_12;
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null);
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<Object> doneList = this.flowTaskMapper.doneList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            if (HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId())) {
                processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            }
            if (!HussarUtils.isNotEmpty((Object)flowTask.getBottomFlag())) continue;
            if (flowTask.getBottomFlag().equals("-1")) {
                flowTask.setType("concern");
                continue;
            }
            if (flowTask.getBottomFlag().equals("1")) {
                flowTask.setType("bottom");
                continue;
            }
            flowTask.setType("");
        }
        List<Object> allVariables = new ArrayList();
        ArrayList arrayList = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            } else {
                List<FlowProcess> list = this.flowTaskMapper.getProcInstMsg(processInsIds, flowTaskQueryModel.getAuditState());
            }
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, Iterator<Object>> taskVariablesMap = new HashMap<String, Iterator<Object>>();
        HashMap<String, Iterator<Object>> processVariablesMap = new HashMap<String, Iterator<Object>>();
        for (Variables variables : allVariables) {
            Object list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (Iterator<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (Iterator<Object>)list);
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        HashMap<String, FlowProcess> hashMap = new HashMap<String, FlowProcess>(16);
        if (HussarUtils.isNotEmpty((Object)var9_12)) {
            for (FlowProcess flowProcess : var9_12) {
                hashMap.put(flowProcess.getProcessInsId(), flowProcess);
            }
        }
        doneList = doneList.stream().filter(a -> processMap.containsKey(a.getProcessInsId()) || HussarUtils.isEmpty((Object)a.getProcessInsId())).collect(Collectors.toList());
        for (FlowTask flowTask : doneList) {
            if (HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId())) {
                flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
                flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
                FlowProcess flowProcess = (FlowProcess)hashMap.get(flowTask.getProcessInsId());
                flowTask.setBusinessId(flowProcess.getBusinessId());
                flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
                flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
                flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
                continue;
            }
            flowTask.setProcessStartUserId(flowTask.getSendUser());
            flowTask.setProcessStartTime(flowTask.getStartTime());
            if (!"3".equals(flowTask.getIsRead())) continue;
            flowTask.setProcessEndTime(flowTask.getEndTime());
        }
        List<TaskManagerQueryVo> result = this.hisTasksToVo(doneList);
        page.setRecords(result);
        return ApiResponse.success((Object)page);
    }

    public JSONArray getProcNodeName(String processDefinitonKey) {
        JSONArray result;
        block3: {
            block4: {
                result = new JSONArray();
                if (!ToolUtil.isNotEmpty((Object)processDefinitonKey)) break block3;
                DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processDefinitonKey);
                if (definitionModel == null) break block4;
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definitionModel.getId());
                for (FlowNode flowNode : bpmnModel.getMainProcess().findFlowElementsOfType(FlowNode.class)) {
                    if (!(flowNode instanceof UserTask)) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)flowNode.getId());
                    jsonObject.put("name", (Object)flowNode.getName());
                    result.add((Object)jsonObject);
                }
                break block3;
            }
            List<Map<String, String>> readNodeNameList = this.flowEventsServiceMapper.getReadNodeName(processDefinitonKey);
            if (!ToolUtil.isNotEmpty(readNodeNameList)) break block3;
            HashSet<String> ids = new HashSet<String>();
            for (Map<String, String> readNodeName : readNodeNameList) {
                ids.add(readNodeName.get("id"));
            }
            for (String id : ids) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", id);
                tmpMap.put("name", id);
                result.add(tmpMap);
            }
        }
        return result;
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                if (HussarUtils.isNotEmpty((Object)flowTask.getSendUser())) {
                    userIds.add(flowTask.getSendUser());
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map a;
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap() == null ? new HashMap() : flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap() == null ? new HashMap() : flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTypeName(flowTask.getTypeName());
                taskManagerQueryVo.setType(flowTask.getType());
                String taskSourceFlag = flowTask.getTaskSourceFlag();
                taskManagerQueryVo.setTaskSourceFlag(taskSourceFlag);
                String scope = taskSourceFlag;
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = TaskSourceFlag.isReject((String)scope) ? "\u5df2\u9a73\u56de" : "\u5df2\u5b8c\u6210";
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser(flowTask.getSendUser());
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(flowTask.getSendUser()));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                } else if ("1".equals(flowTask.getIsNoticeTask()) && HussarUtils.isNotEmpty((Object)(a = (Map)JSONObject.parse((String)flowTask.getFormKey())))) {
                    taskManagerQueryVo.setWeb((String)a.get("web"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }

    public BpmResponseResult entrustHistoryList(String userId, Integer page, Integer limit) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        List<FlowTask> datas = this.flowTaskMapper.getEntrustHistory(pages, userId);
        List userIds = datas.stream().map(FlowTask::getSendUser).distinct().collect(Collectors.toList());
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        for (FlowTask result : datas) {
            result.setSendUserName(finalUsers.get(result.getSendUser()) == null ? "\u65e0\u529e\u7406\u4eba" : (String)finalUsers.get(result.getSendUser()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", datas);
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public synchronized void removeAllEntrustHiByTaskId(String taskId) {
    }
}

