/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.concern.dao.SysActProcinstFollowerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.concern.model.SysProcinstFollower;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpNodeLeaveAddCcTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class MultiInstanceJumpTaskCmd
extends AddAttributeCmd<Void> {
    protected String userId;
    private String executionId;
    private JumpModel jumpModel;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String taskId;
    private String comment;
    private String type;
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)SpringContextHolder.getBean(SysActCcTaskMapper.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getApplicationContext().getBean(ITaskEngineService.class);
    private static SysActProcinstFollowerMapper sysActProcinstFollowerMapper = (SysActProcinstFollowerMapper)SpringContextHolder.getApplicationContext().getBean(SysActProcinstFollowerMapper.class);

    public Void execute(CommandContext commandContext) {
        LambdaQueryWrapper lambdaQueryWrapper;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        this.addExecutionAttribute(executionEntity);
        String type = BpmAttribute.getTaskSourceFlag((ActivityExecution)executionEntity);
        boolean needRemoveTask = TaskSourceFlag.isRevoke((String)type);
        boolean reject = TaskSourceFlag.isReject((String)type);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setExecutions(null);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ArrayList taskEntities = new ArrayList();
        ExecutionEntity scopeExecution = (ExecutionEntity)executionEntity.getExecutions().get(0);
        for (ExecutionEntity taskExecution : scopeExecution.getExecutions()) {
            taskEntities.addAll(taskExecution.getTasks());
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> longTaskIds = new ArrayList<Long>();
        String processKey = null;
        String processDefinitionId = "";
        for (Object taskEntity : taskEntities) {
            if (!taskEntity.getId().equals(this.taskId) || needRemoveTask) {
                taskIds.add(taskEntity.getId());
                longTaskIds.add(Long.parseLong(taskEntity.getId()));
                processKey = taskEntity.getProcessDefinitionId().split(":")[0];
                processDefinitionId = taskEntity.getProcessDefinitionId();
            }
            if (!TaskSourceFlag.isRevoke((String)type)) continue;
            this.deleteMultiTaskDataPush((TaskEntity)taskEntity);
        }
        if (HussarUtils.isNotEmpty(taskIds)) {
            List ccTasks;
            lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActCcTask::getTaskId, longTaskIds);
            this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
            for (String multiTaskId : taskIds) {
                TaskEntity task2 = commandContext.getTaskEntityManager().findTaskById(multiTaskId);
                this.taskEngineService.taskCenterDataPush((Task)task2, "", "", "reject");
            }
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(processDefinitionId);
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(taskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
            for (TaskEntity task2 : taskEntities) {
                if (this.taskId.equals(task2.getId()) || TaskSourceFlag.isRevoke((String)type)) continue;
                this.deleteMultiTaskDataPush(task2);
            }
            if (HussarUtils.isNotEmpty((Object)((TaskEntity)taskEntities.get(0)).getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            if (HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longTaskIds))))) {
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                    ArrayList dataPushList = new ArrayList();
                    for (SysActCcTask ccTask : ccTasks) {
                        DataPush dataPush = new DataPush();
                        dataPush.setUserId(ccTask.getReceiveUser());
                        dataPush.setTaskId(this.taskId);
                        dataPush.setStartDate((Date)ccTask.getSendTime());
                        dataPush.setEndDate((Date)ccTask.getEndTime());
                        dataPush.setCcMoment(ccTask.getCcMoment() == null ? "0" : ccTask.getCcMoment());
                        dataPushList.add(dataPush);
                    }
                    this.dataPushService.addCcTask(dataPushList);
                }
            }
        }
        lambdaQueryWrapper = new LambdaUpdateWrapper();
        lambdaQueryWrapper.eq(SysProcinstFollower::getProcInstId, (Object)((TaskEntity)taskEntities.get(0)).getProcessInstanceId());
        lambdaQueryWrapper.eq(SysProcinstFollower::getFollower, (Object)this.userId);
        List sysProcinstFollowers = sysActProcinstFollowerMapper.selectList((Wrapper)lambdaQueryWrapper);
        String bottomFlag = sysProcinstFollowers.isEmpty() ? "0" : "-1";
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            if (taskEntity.getId().equals(this.taskId)) {
                taskEntity.setAssignee(this.userId);
            }
            if (taskEntity.getParentTaskId() != null) {
                Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, null, bottomFlag, true);
                continue;
            }
            ParamModel paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "MultiInstanceJumpTaskCmd-Completed", !taskEntity.getId().equals(this.taskId) || needRemoveTask, this.mandator, bottomFlag);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getId());
        ExecutionEntity ee = new ExecutionEntity();
        for (ExecutionEntity executionEntity2 : list) {
            List parent = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity2.getId());
            for (ExecutionEntity executionEntity3 : parent) {
                executionEntity3.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
            }
            executionEntity2.remove();
            List tasks = executionEntity2.getTasks();
            if (tasks != null && !tasks.isEmpty() && HussarUtils.isNotEmpty((Object)this.userId)) {
                tasks.forEach(task -> {
                    if (task.getParentTaskId() != null) {
                        ((TaskEntity)tasks.get(0)).setAssignee(this.userId);
                    }
                });
            }
            ee = executionEntity2;
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        if (executionEntity.getActivityId() != null) {
            new JumpNodeLeaveAddCcTaskCmd(executionEntity).execute(commandContext);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.jumpModel, this.userId, type, this.taskRejectModel != null && this.taskRejectModel.isSubmit(), this.paramvar));
        return null;
    }

    public MultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String taskId, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = this.type;
        this.mandator = mandator;
    }

    public MultiInstanceJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String taskId, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = this.type;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
    }

    private static String joinStr(List<String> list) {
        return list == null ? null : String.join((CharSequence)",", list);
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setFrom(MultiInstanceJumpTaskCmd.joinStr(this.jumpModel.getJumpFrom()));
        paramModel.setTo(MultiInstanceJumpTaskCmd.joinStr(this.jumpModel.getJumpTo()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.mappingCompleteType(this.type);
            paramModel.setHandler(this.userId);
            paramModel.setSendUser(this.userId);
            paramModel.mappingToCreateReason(this.type);
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.mappingLastCompleteType(this.type);
            paramModel.setLastNodeHandler(this.userId);
            return paramModel;
        }
        paramModel.mappingCompleteType(this.type);
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.mappingToDeleteType(this.type);
            }
        } else {
            paramModel.mappingToDeleteType(this.type);
        }
        Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute(task, "appoint_assignee");
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler(taskRejectModel.getUserId());
        paramModel.setSendUser(taskRejectModel.getUserId());
        paramModel.mappingToCreateReason(this.type);
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.mappingLastCompleteType(this.type);
        paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        paramModel.setActivityType("userTask");
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }

    private void deleteMultiTaskDataPush(TaskEntity taskEntity) {
        String processInstanceId = taskEntity.getProcessInstanceId();
        ExecutionEntity processInstance = taskEntity.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isEmpty(starter) && HussarUtils.isNotEmpty((Object)processInst)) {
            starter = processInst.getStartUserId();
        }
        Date date = new Date();
        if (HussarUtils.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInst.getProcessDefinitionName());
        map.put("title", taskEntity.getTodoConfiguration());
        ArrayList previousTasks = new ArrayList();
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("taskid", taskEntity.getId());
        taskMap.put("touser", taskEntity.getAssignee());
        if (HussarUtils.isEmpty((Object)taskEntity.getAssignee())) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (IdentityLink identityLinkEntity : taskEntity.getCandidates()) {
                userIds.add(identityLinkEntity.getUserId());
            }
            taskMap.put("touser", String.join((CharSequence)",", userIds));
        }
        taskMap.put("jump_url", null);
        taskMap.put("pc_jump_url", null);
        taskMap.put("task_status", 5);
        taskMap.put("assign_time", new Date().getTime() / 1000L);
        previousTasks.add(taskMap);
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(processInstance.getTenantId(), map, false);
    }
}

