/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskStateType;

public class EntrustTaskAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private TaskManagerService taskManagerService = (TaskManagerService)SpringContextHolder.getBean(TaskManagerService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;
    protected String owner;

    public EntrustTaskAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame, String owner) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
        this.owner = owner;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        List identityLinks = taskEntity.getCandidates();
        IdentityLinkEntity newIdentityLink = null;
        if (taskEntity.getAssignee() != null) {
            if (this.mandatary.equals(this.userId)) {
                taskEntity.addCandidateUser(this.mandatary, null, "2");
            } else {
                taskEntity.addCandidateUser(this.mandatary, this.userId, "2");
            }
        } else {
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                if (HussarUtils.isNotEmpty((Object)this.owner)) {
                    if (!HussarUtils.isNotEmpty((Object)identityLinkEntity.getMandator()) || !identityLinkEntity.getMandator().equals(this.owner)) continue;
                    newIdentityLink = identityLinkEntity;
                    break;
                }
                if (!identityLinkEntity.getUserId().equals(this.userId) || !HussarUtils.isEmpty((Object)identityLinkEntity.getMandator())) continue;
                newIdentityLink = identityLinkEntity;
                break;
            }
            if (HussarUtils.isNotEmpty(newIdentityLink)) {
                ArrayList<Map<String, String>> userMapList;
                if (HussarUtils.isEmpty((Object)newIdentityLink.getMandator())) {
                    Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(newIdentityLink, true);
                    if (this.mandatary.equals(this.userId)) {
                        taskEntity.addCandidateUser(this.mandatary, null, "2");
                    } else {
                        taskEntity.addCandidateUser(this.mandatary, this.userId, "2");
                    }
                    userMapList = new ArrayList();
                    userMapList = this.getAssigneeMapByTaskId(taskEntity, newIdentityLink, null);
                    this.dataPushService.transferDataPush((Task)taskEntity, this.userId, this.mandatary, this.userId, userMapList);
                } else {
                    Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(newIdentityLink, true);
                    if (this.mandatary.equals(newIdentityLink.getMandator())) {
                        taskEntity.addCandidateUser(this.mandatary, null, "2");
                    } else {
                        taskEntity.addCandidateUser(this.mandatary, newIdentityLink.getMandator(), "2");
                    }
                    userMapList = new ArrayList();
                    userMapList = this.getAssigneeMapByTaskId(taskEntity, newIdentityLink, null);
                    this.dataPushService.transferDataPush((Task)taskEntity, newIdentityLink.getMandator(), this.mandatary, this.userId, userMapList);
                }
            }
            this.todoEntrustDataPush(taskEntity, this.userId, this.mandatary, new Date(), this.taskId);
            return null;
        }
        List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(taskEntity, null, Arrays.asList(this.userId));
        this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary, userMapList);
        this.todoEntrustDataPush(taskEntity, this.userId, this.mandatary, new Date(), this.taskId);
        return null;
    }

    private void todoEntrustDataPush(TaskEntity taskEntity, String userIds, String consignee, Date endTime, String entrustHisId) {
        String webUrl;
        String mobileUrl;
        Map formKeyMap;
        String pcJumpUrl;
        String jumpUrl;
        String webUrl2;
        String mobileUrl2;
        Map formKeyMap2;
        String pcJumpUrl2;
        String jumpUrl2;
        String processInstanceId = taskEntity.getProcessInstanceId();
        ExecutionEntity processInstance = taskEntity.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isEmpty(starter)) {
            starter = processInst.getStartUserId();
        }
        Date date = new Date();
        if (HussarUtils.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInst.getProcessDefinitionName());
        map.put("title", taskEntity.getTodoConfiguration());
        ArrayList previousTasks = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)entrustHisId)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", entrustHisId + "-6");
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(taskEntity.getProcessDefinitionId()).append(taskEntity.getTaskDefinitionKey());
            String formDetailKey = taskEntity.getFormKey();
            jumpUrl2 = null;
            pcJumpUrl2 = null;
            if (HussarUtils.isNotEmpty((Object)formDetailKey)) {
                formKeyMap2 = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                mobileUrl2 = (String)formKeyMap2.get("mobile");
                if (HussarUtils.isNotEmpty((Object)mobileUrl2)) {
                    jumpUrl2 = CommonCodeUtil.getUrl(mobileUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
                if (HussarUtils.isNotEmpty((Object)(webUrl2 = (String)formKeyMap2.get("web")))) {
                    pcJumpUrl2 = CommonCodeUtil.getUrl(webUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", userIds);
            taskMap.put("groupid", taskEntity.getId());
            taskMap.put("jump_url", jumpUrl2);
            taskMap.put("pc_jump_url", pcJumpUrl2);
            taskMap.put("task_status", 6);
            taskMap.put("assign_time", new Date().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
            if (HussarUtils.isNotEmpty((Object)consignee)) {
                ArrayList<String> consigneeList = new ArrayList<String>(Arrays.asList(consignee.split(",")));
                userIdList.removeAll(consigneeList);
            }
            if (HussarUtils.isNotEmpty(userIdList)) {
                for (String userId : userIdList) {
                    if (!HussarUtils.isNotEmpty((Object)userIds)) continue;
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("taskid", taskEntity.getId());
                    taskMap.put("touser", userId);
                    taskMap.put("groupid", taskEntity.getId());
                    StringBuilder formDetailId = new StringBuilder();
                    formDetailId.append(taskEntity.getProcessDefinitionId()).append(taskEntity.getTaskDefinitionKey());
                    String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
                    jumpUrl = null;
                    pcJumpUrl = null;
                    if (HussarUtils.isNotEmpty((Object)formDetailKey)) {
                        formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                        mobileUrl = (String)formKeyMap.get("mobile");
                        if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                            jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                        if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                            pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                    }
                    taskMap.put("jump_url", jumpUrl);
                    taskMap.put("pc_jump_url", pcJumpUrl);
                    taskMap.put("task_status", 5);
                    taskMap.put("assign_time", endTime.getTime() / 1000L);
                    previousTasks.add(taskMap);
                }
            }
        }
        map.put("previous_tasks", previousTasks);
        ArrayList tasks = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)consignee)) {
            ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(consignee.split(",")));
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                ArrayList<String> consigneeList = new ArrayList<String>(Arrays.asList(userIds.split(",")));
                userIdList.removeAll(consigneeList);
            }
            if (HussarUtils.isNotEmpty(userIdList)) {
                for (String id : userIdList) {
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("taskid", taskEntity.getId());
                    taskMap.put("task_name", taskEntity.getName());
                    taskMap.put("touser", id);
                    taskMap.put("groupid", taskEntity.getId());
                    String formKey = taskEntity.getFormKey();
                    jumpUrl = null;
                    pcJumpUrl = null;
                    if (HussarUtils.isNotEmpty((Object)formKey)) {
                        formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                        mobileUrl = (String)formKeyMap.get("mobile");
                        if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                            jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                        if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                            pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                    }
                    taskMap.put("jump_url", jumpUrl);
                    taskMap.put("pc_jump_url", pcJumpUrl);
                    taskMap.put("level", 0);
                    taskMap.put("isnotify", 1);
                    taskMap.put("task_status", 0);
                    if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                        taskMap.put("countersign", 0);
                    } else {
                        taskMap.put("countersign", null);
                    }
                    taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
                    tasks.add(taskMap);
                }
            }
        } else {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", taskEntity.getId());
            taskMap.put("task_name", taskEntity.getName());
            taskMap.put("touser", "noAssignee");
            taskMap.put("groupid", taskEntity.getId());
            String formKey = taskEntity.getFormKey();
            jumpUrl2 = null;
            pcJumpUrl2 = null;
            if (HussarUtils.isNotEmpty((Object)formKey)) {
                formKeyMap2 = (Map)JSON.parseObject((String)formKey, Map.class);
                mobileUrl2 = (String)formKeyMap2.get("mobile");
                if (HussarUtils.isNotEmpty((Object)mobileUrl2)) {
                    jumpUrl2 = CommonCodeUtil.getUrl(mobileUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
                if (HussarUtils.isNotEmpty((Object)(webUrl2 = (String)formKeyMap2.get("web")))) {
                    pcJumpUrl2 = CommonCodeUtil.getUrl(webUrl2, processInstance.getBusinessKey(), taskEntity.getId(), processInst.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                }
            }
            taskMap.put("jump_url", jumpUrl2);
            taskMap.put("pc_jump_url", pcJumpUrl2);
            taskMap.put("level", 0);
            taskMap.put("isnotify", 1);
            taskMap.put("task_status", 0);
            if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                taskMap.put("countersign", 0);
            } else {
                taskMap.put("countersign", null);
            }
            taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
            tasks.add(taskMap);
        }
        map.put("tasks", tasks);
        CommonCodeUtil.taskDataPush(taskEntity.getTenantId(), map);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity, List<String> userList) {
        List identityLinkList = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty((Object)identityLinkEntity)) {
            if (HussarUtils.isNotEmpty((Object)identityLinkEntity.getMandator())) {
                identityLinkList.removeIf(identityLink -> identityLinkEntity.getUserId().equals(identityLink.getUserId()) && identityLinkEntity.getMandator().equals(identityLink.getMandator()));
            } else {
                identityLinkList.removeIf(identityLink -> identityLinkEntity.getUserId().equals(identityLink.getUserId()));
            }
        }
        if (HussarUtils.isNotEmpty(userList)) {
            identityLinkList.removeIf(identityLink -> userList.contains(identityLink.getUserId()));
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink2 : identityLinkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink2.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink2)) {
                    map.put("mandator", identityLink2.getMandator());
                    map.put("taskState", identityLink2.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

