/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.upgrade;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExternalProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessDefinitionQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessCompleteStatusDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstBatchDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstFinishedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstSuspendDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.ActivityTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CommentQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class StandardInstanceEngineWorkflowApiService
implements StandardInstanceEngineApiService {
    @Lazy
    @Autowired
    private IInstanceEngineService instanceEngineService;

    public BpmResponseResult startProcessInstance(ProcessStartDto processStartDto) {
        return this.instanceEngineService.startProcessInstanceByKey(processStartDto.getProcessKey(), processStartDto.getUserId(), processStartDto.getBusinessId(), processStartDto.getVersion(), processStartDto.getVariables());
    }

    public BpmResponseResult startAndCompleteProcessInstanceByKey(ProcessStartDto processStartDto) {
        return this.instanceEngineService.startAndCompleteProcessInstanceByKey(processStartDto.getProcessKey(), processStartDto.getUserId(), processStartDto.getBusinessId(), processStartDto.getVariables());
    }

    public BpmResponseResult startProcessInstanceByKeyWithProcessCode(ProcessStartDto processStartDto) {
        return this.instanceEngineService.startProcessInstanceByKeyWithProcessCode(processStartDto.getProcessKey(), processStartDto.getUserId(), processStartDto.getBusinessId(), processStartDto.getVersion(), processStartDto.getVariables(), processStartDto.getProcessCode());
    }

    public BpmResponseResult queryActivityTask(ActivityTaskQueryDto activityTaskQueryDto) {
        return this.instanceEngineService.queryCallActivityTask(activityTaskQueryDto.getBusinessId(), activityTaskQueryDto.getProcessInsId(), activityTaskQueryDto.getType());
    }

    public BpmResponseResult queryAllComment(CommentQueryDto commentQueryDto) {
        if (HussarUtils.isNotEmpty((Object)commentQueryDto.getBusinessId()) && HussarUtils.isNotEmpty((Object)commentQueryDto.getProcessInsId())) {
            return this.instanceEngineService.queryCompletecomment(commentQueryDto.getBusinessId(), commentQueryDto.getProcessInsId());
        }
        if (HussarUtils.isNotEmpty((Object)commentQueryDto.getBusinessId())) {
            return this.instanceEngineService.queryAllCommentByBusinessId(commentQueryDto.getBusinessId());
        }
        throw new HussarException("\u53c2\u6570\u5f02\u5e38");
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        return this.instanceEngineService.checkProcessInstByBusinessId(businessId);
    }

    public BpmResponseResult queryProcessDefinition(ProcessDefinitionQueryDto processDefinitionQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefinitionQueryDto.getProcessInsId())) {
            return this.instanceEngineService.queryProcessDefinitionByInstanceId(processDefinitionQueryDto.getProcessInsId());
        }
        return this.instanceEngineService.queryProcessDefinitionByBusinessId(processDefinitionQueryDto.getBusinessId());
    }

    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto checkProcessStatus) {
        return this.instanceEngineService.checkProcessStatus(checkProcessStatus);
    }

    public BpmResponseResult queryAllProcessTrace(InstanceGetTraceDto processTraceQueryDto) {
        return this.instanceEngineService.getAllProcessTrace(processTraceQueryDto.getProcessInsId(), processTraceQueryDto.getSubProcessKey(), processTraceQueryDto.getCycleCount());
    }

    public BpmResponseResult suspendProcessInstance(ProcessInstSuspendDto processInstSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processInstSuspendDto.getProcessInsId())) {
            return this.instanceEngineService.suspendProcessInstanceById(processInstSuspendDto.getProcessInsId());
        }
        return this.instanceEngineService.suspendProcessInstanceByBusinessId(processInstSuspendDto.getBusinessId());
    }

    public BpmResponseResult activateProcessInstance(ProcessInstActivateDto processInstActivateDto) {
        if (HussarUtils.isNotEmpty((Object)processInstActivateDto.getProcessInsId())) {
            return this.instanceEngineService.activateProcessInstanceById(processInstActivateDto.getProcessInsId());
        }
        return this.instanceEngineService.activateProcessInstanceByBusinessId(processInstActivateDto.getBusinessId());
    }

    public BpmResponseResult deleteProcessInstance(ProcessInstDeleteDto processInstDeleteDto) {
        if (processInstDeleteDto.getIsFinish()) {
            if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getProcessInsId())) {
                return this.instanceEngineService.deleteFinishedProcessInstance(processInstDeleteDto.getProcessInsId());
            }
            return this.instanceEngineService.deleteFinishProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
        }
        if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getProcessInsId())) {
            return this.instanceEngineService.deleteProcessInstance(processInstDeleteDto.getProcessInsId(), processInstDeleteDto.getReason());
        }
        return this.instanceEngineService.deleteProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIds(ProcessInstBatchDeleteDto processInstBatchDeleteDto) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessIdList(String.join((CharSequence)",", processInstBatchDeleteDto.getBusinessIdList()), processInstBatchDeleteDto.getIsValidate());
    }

    public BpmResponseResult queryFinishedProcessInstance(ProcessInstFinishedQueryDto processInstFinishedQueryDto) {
        return this.instanceEngineService.queryFinishedProcessInstance(processInstFinishedQueryDto.getProcessKey(), processInstFinishedQueryDto.getBusinessId(), processInstFinishedQueryDto.getPage().intValue(), processInstFinishedQueryDto.getRows().intValue());
    }

    public BpmResponseResult queryProcessInstanceCompleteState(ProcessCompleteStatusDto processCompleteStatusDto) {
        if (HussarUtils.isNotEmpty((Object)processCompleteStatusDto.getProcessInsId())) {
            return this.instanceEngineService.queryProcessInstanceCompleteState(processCompleteStatusDto.getProcessInsId());
        }
        return this.instanceEngineService.queryProcessInstanceCompleteStateByBusinessId(processCompleteStatusDto.getBusinessId());
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        return this.instanceEngineService.getProcessTrace(processInsId);
    }

    public BpmResponseResult endProcess(ProcessInstEndDto processInstEndDto) {
        return this.instanceEngineService.endProcess(processInstEndDto.getTaskId(), processInstEndDto.getUserId(), processInstEndDto.getReason());
    }

    public BpmResponseResult queryProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        return this.instanceEngineService.queryProcessByStarter(new Page(processQueryByStarterDto.getCurrent(), processQueryByStarterDto.getSize()), processQueryByStarterDto);
    }

    public BpmResponseResult queryRevokeProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        processQueryByStarterDto.setIsRevoke(Boolean.TRUE.booleanValue());
        return this.instanceEngineService.queryProcessByStarter(new Page(processQueryByStarterDto.getCurrent(), processQueryByStarterDto.getSize()), processQueryByStarterDto);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return this.instanceEngineService.revokeProcess(processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return this.instanceEngineService.queryProcessInstance(processDto);
    }

    public BpmResponseResult queryAllCountersignNodes(CountersignNodesDto countersignNodesBean) {
        return this.instanceEngineService.queryAllCountersignNodes(countersignNodesBean.getTaskId(), countersignNodesBean.getProcessInsId(), countersignNodesBean.getBusinessId(), countersignNodesBean.getProcessKey(), countersignNodesBean.getVersion());
    }

    public BpmResponseResult externalMultiInstanceAddAssignee(ExternalProcessDto externalProcessDto) {
        return this.instanceEngineService.externalMultiInstanceAddAssignee(externalProcessDto.getProcessInstanceId(), externalProcessDto.getVariable());
    }

    public BpmResponseResult externalMultiInstanceAddAssigneeByBussinessId(ExternalProcessDto externalProcessDto) {
        return this.instanceEngineService.externalMultiInstanceAddAssigneeByBussinessId(externalProcessDto.getBussinessId(), externalProcessDto.getVariable());
    }

    public BpmResponseResult externalMultiInstanceDelAssignee(ExternalProcessDto externalProcessDto) {
        return this.instanceEngineService.externalMultiInstanceDelAssignee(externalProcessDto.getExternalProcessInstanceIds(), externalProcessDto.getProcessInstanceId(), externalProcessDto.getUserId(), externalProcessDto.getReason());
    }

    public BpmResponseResult externalMultiInstanceDelAssigneeByBussinessId(ExternalProcessDto externalProcessDto) {
        return this.instanceEngineService.externalMultiInstanceDelAssigneeByBussinessId(externalProcessDto.getExternalBussinessIds(), externalProcessDto.getBussinessId(), externalProcessDto.getUserId(), externalProcessDto.getReason());
    }

    public BpmResponseResult getSubprocessStarter(List<String> bussinessIds) {
        return this.instanceEngineService.getSubprocessStarter(bussinessIds);
    }
}

