/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeChatDataPush {
    private static final String TEXT = "text";
    public static final boolean IS_DATAPUSH = true;
    private static final String DATAPUSH_CACHE = "datapushCache";
    private static final long TOKEN_TIMEOUT = 40010L;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    private static Logger logger = LogManager.getLogger(WeChatDataPush.class);

    public void dataPush(String str) {
        try {
            if (this.lcdpBpmProperties.isIhnIsDataPush()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("touser", this.lcdpBpmProperties.getIhnDatapushTouser());
                map.put("toparty", null);
                map.put("totag", null);
                map.put("msgtype", TEXT);
                map.put("agentid", Long.valueOf(this.lcdpBpmProperties.getIhnDataPushAgentid()));
                HashMap<String, String> textMap = new HashMap<String, String>();
                textMap.put("content", str);
                map.put(TEXT, textMap);
                String url = (this.lcdpBpmProperties.getIhnDatapushUrl() != null && this.lcdpBpmProperties.getIhnDatapushUrl().startsWith(HTTPS) ? "" : HTTP) + this.lcdpBpmProperties.getIhnDatapushUrl() + "/cgi-bin/message/send?access_token=";
                logger.info("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u5f00\u59cb");
                logger.info("\u8def\u5f84\u4fe1\u606f" + url);
                logger.info("\u53c2\u6570\u4fe1\u606f" + JSON.toJSONString(map));
                System.out.println("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u5f00\u59cb");
                System.out.println("\u8def\u5f84\u4fe1\u606f" + url);
                System.out.println("\u53c2\u6570\u4fe1\u606f" + JSON.toJSONString(map));
                Long startTime = System.currentTimeMillis();
                JSONObject jsonObject = JSON.parseObject((String)HttpRequestUtil.post(url + this.getAccessToken(false), map));
                Long endTime = System.currentTimeMillis();
                logger.info("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u7ed3\u675f");
                logger.info("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u8017\u65f6" + (endTime - startTime));
                System.out.println("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u7ed3\u675f");
                System.out.println("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u8017\u65f6" + (endTime - startTime));
                if (jsonObject.getLongValue("errcode") == 40010L) {
                    jsonObject = JSON.parseObject((String)HttpRequestUtil.post(url + this.getAccessToken(true), map));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private String getAccessToken(boolean getnew) {
        AccessToken accessToken = (AccessToken)HussarCacheUtil.get((String)DATAPUSH_CACHE, (Object)this.lcdpBpmProperties.getIhnTenantId());
        if (accessToken != null && !accessToken.isTimeOut() && !getnew) {
            return accessToken.getAccessToken();
        }
        String url = (this.lcdpBpmProperties.getIhnDatapushUrl() != null && this.lcdpBpmProperties.getIhnDatapushUrl().startsWith(HTTPS) ? "" : HTTP) + this.lcdpBpmProperties.getIhnDatapushUrl() + "/cgi-bin/gettoken";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corpid", this.lcdpBpmProperties.getIhnDatapushCorpid());
        map.put("corpsecret", this.lcdpBpmProperties.getIhnDatapushCorpsecret());
        logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u5f00\u59cb");
        logger.info("\u8def\u5f84\u4fe1\u606f" + url);
        logger.info("\u53c2\u6570\u4fe1\u606f" + JSON.toJSONString(map));
        System.out.println("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u5f00\u59cb");
        System.out.println("\u8def\u5f84\u4fe1\u606f" + url);
        System.out.println("\u53c2\u6570\u4fe1\u606f" + JSON.toJSONString(map));
        Long startTime = System.currentTimeMillis();
        JSONObject jsonObject = JSONObject.parseObject((String)HttpRequestUtil.getRequestResult(url, map));
        Long endTime = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u7ed3\u675f");
        logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u8017\u65f6" + (endTime - startTime));
        System.out.println("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u7ed3\u675f");
        System.out.println("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001token\u8017\u65f6" + (endTime - startTime));
        HussarCacheUtil.put((String)DATAPUSH_CACHE, (Object)this.lcdpBpmProperties.getIhnTenantId(), (Object)new AccessToken(jsonObject.getString("access_token"), jsonObject.getLong("expires_in")));
        return jsonObject.getString("access_token");
    }

    private static class AccessToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String accessToken;
        private final long deadTime;

        AccessToken(String accessToken, long effectiveSecond) {
            this.accessToken = accessToken;
            this.deadTime = System.currentTimeMillis() + effectiveSecond * 1000L;
        }

        boolean isTimeOut() {
            return this.deadTime < System.currentTimeMillis();
        }

        String getAccessToken() {
            return this.accessToken;
        }
    }
}

