/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutSetListUtil;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutHandleUtil {
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("example-schedule-pool-%d").daemon(true).build());
    private static Logger logger = LogManager.getLogger(TimeOutHandleUtil.class);
    public static final String BPM_ACTIVITY_TIMER_SCORE_LIST = "bpm_activity:timer:score_list";
    public static final String BPM_ACTIVITY_TIMER_TASK_MESSAGE = "bpm_activity:timer:task_Message:";
    public static final String BPM_TIMER_ACTIVITY = "bpm_timer_activity";
    public static final String PROCESS_TIMEOUT_MODEL_PREFIX = "global-";
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private BpmTenantInfoUtils bpmTenantInfoUtils;
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    @Autowired
    private TimeOutSetListUtil timeOutSetListUtil;
    @Autowired
    private RedisTemplate redisTemplate;
    protected static boolean getList = true;
    protected static List<Long> timeOutList = new ArrayList<Long>();
    protected static Map<Long, String> timeOutMap = new HashMap<Long, String>();
    protected static List<Long> getListTimeAddModel = new ArrayList<Long>();
    protected static List<String> getListTimeDelModel = new ArrayList<String>();
    protected static boolean useRedis;
    @Resource
    private HussarCacheProperties hussarCacheProperties;

    public void init() {
        useRedis = "redis".equals(this.hussarCacheProperties.getCacheType());
        this.executorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TimeOutHandleUtil.this.handleAllTimeOutTask(System.currentTimeMillis());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void selectTimeOutModels() {
        if (useRedis) {
            try {
                List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                for (TimeOutModel timeOutModel : timeOutModels) {
                    timeOutModel.setDataSourceName("master");
                    String id = String.valueOf(timeOutModel.getTaskId());
                    if ("1".equals(timeOutModel.getMessageType())) {
                        id = PROCESS_TIMEOUT_MODEL_PREFIX + id;
                    }
                    this.redisTemplate.opsForValue().set((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + id + "&" + timeOutModel.getIsClose()), (Object)JSON.toJSONString((Object)timeOutModel));
                    Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                    if (HussarUtils.isEmpty((Object)oldTask)) {
                        this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)(id + "&" + timeOutModel.getIsClose()), (double)timeOutModel.getDueTime().getTime());
                        continue;
                    }
                    this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)((String)new ArrayList(oldTask).get(0) + "," + id + "&" + timeOutModel.getIsClose()), (double)timeOutModel.getDueTime().getTime());
                }
                this.activityRedisTimerMapper.delete(null);
            }
            catch (Exception e) {
                logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        List timeOutModels = this.activityRedisTimerMapper.selectList(null);
        for (TimeOutModel timeOutModel : timeOutModels) {
            timeOutModel.setDataSourceName("master");
            String id = String.valueOf(timeOutModel.getTaskId());
            if ("1".equals(timeOutModel.getMessageType())) {
                id = PROCESS_TIMEOUT_MODEL_PREFIX + id;
            }
            HussarCacheUtil.put((String)BPM_TIMER_ACTIVITY, (Object)(id + "&" + timeOutModel.getIsClose()), (Object)timeOutModel);
            Long time = timeOutModel.getDueTime().getTime();
            timeOutList.add(time);
            timeOutMap.put(time, timeOutMap.get(time) == null ? id + "&" + timeOutModel.getIsClose() : timeOutMap.get(time) + "," + id + "&" + timeOutModel.getIsClose());
        }
    }

    private void getList() {
        try {
            if (this.bpmTenantInfoUtils.isMultiTenant()) {
                List sysUserList = this.sysUserService.querySysTenantList();
                for (SysUser sysUser : sysUserList) {
                    this.timeOutSetListUtil.setList(sysUser.getConnName(), sysUser.getTcode());
                }
            } else {
                this.selectTimeOutModels();
            }
            if (useRedis) {
                getList = false;
                return;
            }
            if (!getListTimeDelModel.isEmpty()) {
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, getListTimeDelModel);
            }
            TimeOutHandleUtil.orderTime();
        }
        catch (Exception e) {
            logger.error("\u8d85\u65f6\u5904\u7406\u4fe1\u606f\u7f13\u5b58\u540c\u6b65\u5931\u8d25{}", (Object)e.getMessage());
        }
        getList = false;
    }

    public static void orderTime() {
        timeOutList.sort(Comparator.naturalOrder());
        while (!getListTimeAddModel.isEmpty()) {
            int index = 0;
            for (int i = 0; i < timeOutList.size() && timeOutList.get(i) < getListTimeAddModel.get(0); ++i) {
                index = i + 1;
            }
            timeOutList.add(index, getListTimeAddModel.get(0));
            getListTimeAddModel.remove(0);
        }
    }

    private void handleAllTimeOutTask(long time) {
        if (getList) {
            this.getList();
        }
        if (useRedis) {
            try {
                Set tasksList = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                if (HussarUtils.isNotEmpty((Object)tasksList)) {
                    for (String tasks : tasksList) {
                        for (String str : tasks.split(",")) {
                            Object model = this.redisTemplate.opsForValue().get((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                            if (HussarUtils.isNotEmpty((Object)model)) {
                                TimeOutModel timeOutModel = (TimeOutModel)JSON.parseObject((String)((String)model), TimeOutModel.class);
                                this.timeOutSetListUtil.timeOutTaskHandler(timeOutModel, false, timeOutModel.getDataSourceName());
                            }
                            this.redisTemplate.delete((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                        }
                    }
                    this.redisTemplate.opsForZSet().removeRangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                }
            }
            catch (Exception e) {
                logger.error("redis\u83b7\u53d6\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        timeOutList = timeOutList.stream().sorted().collect(Collectors.toList());
        while (!timeOutList.isEmpty() && time > timeOutList.get(0)) {
            String[] keys;
            if (timeOutMap.get(timeOutList.get(0)) == null) {
                timeOutList.remove(0);
                continue;
            }
            for (String key : keys = timeOutMap.get(timeOutList.get(0)).split(",")) {
                TimeOutModel timeOutModel = (TimeOutModel)HussarCacheUtil.get((String)BPM_TIMER_ACTIVITY, (Object)key);
                if (timeOutModel == null) continue;
                this.timeOutSetListUtil.timeOutTaskHandler(timeOutModel, true, timeOutModel.getDataSourceName());
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, (Object)key);
            }
            timeOutMap.remove(timeOutList.get(0));
            timeOutList.remove(0);
        }
    }

    public static List<Long> getTimeOutList() {
        timeOutList = timeOutList.stream().sorted().collect(Collectors.toList());
        return timeOutList;
    }

    public static Map<Long, String> getTimeOutMap() {
        return timeOutMap;
    }

    public static List<Long> getGetListTimeAddModel() {
        return getListTimeAddModel;
    }

    public static List<String> getGetListTimeDelModel() {
        return getListTimeDelModel;
    }

    public static boolean isGetList() {
        return getList;
    }

    public static boolean isUseRedis() {
        return useRedis;
    }

    public static class TimeOutModelMessageType {
        public static final String TASK_TIMEOUT_MODEL = "0";
        public static final String PROCESS_TIMEOUT_MODEL = "1";
    }
}

